/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.jdbc.wallet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import oracle.dbtools.jdbc.wallet.AutoLoginWallet;
import oracle.dbtools.jdbc.wallet.DatabaseToolsProperties;
import oracle.dbtools.jdbc.wallet.WalletException;
import oracle.dbtools.zip.ZipBuilder;
import oracle.dbtools.zip.ZipMutator;

public class ADWWalletArchiveMutator {
    public static String mutate(InputStream is, String serviceAlias, String user, char[] password) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ZipMutator.mutate(is, bos, new EntryMutator(serviceAlias, user, password));
        return Base64.getEncoder().encodeToString(bos.toByteArray());
    }

    private static class EntryMutator
    implements ZipMutator.EntryMutator {
        private final transient String serviceAlias;
        private final transient String user;
        private final transient char[] password;
        private final TreeSet<String> mutateEntries;

        public EntryMutator(String serviceAlias, String user, char[] password) throws WalletException {
            this.serviceAlias = serviceAlias;
            this.user = user;
            this.password = password;
            this.mutateEntries = new TreeSet();
            this.mutateEntries.add("cwallet.sso");
            this.mutateEntries.add("dbtools.properties");
        }

        @Override
        public boolean mutate(ZipBuilder builder, ZipEntry zipEntry, InputStream entryStream) throws IOException {
            String entryName = zipEntry != null ? zipEntry.getName() : (!this.mutateEntries.isEmpty() ? this.mutateEntries.pollFirst() : null);
            if (entryName != null) {
                if ("cwallet.sso".equals(entryName)) {
                    AutoLoginWallet.Builder walletBuilder = entryStream != null ? AutoLoginWallet.read(entryStream).modify() : AutoLoginWallet.builder();
                    walletBuilder.set(this.serviceAlias, this.user, this.password);
                    InputStream is = walletBuilder.build().asInputStream();
                    builder.addEntry(entryName, is);
                    is.close();
                } else if ("dbtools.properties".equals(entryName)) {
                    DatabaseToolsProperties.Builder propBuilder = entryStream != null ? DatabaseToolsProperties.read(entryStream).modify() : DatabaseToolsProperties.builder();
                    propBuilder.serviceAlias(this.serviceAlias);
                    InputStream is = propBuilder.build().asInputStream();
                    builder.addEntry(entryName, is);
                    is.close();
                } else {
                    builder.addEntry(zipEntry, entryStream);
                }
            }
            return zipEntry != null || !this.mutateEntries.isEmpty();
        }
    }
}

