/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.jdbc;

import java.io.IOException;
import java.sql.SQLException;
import javax.sql.DataSource;
import oracle.dbtools.jdbc.DataSourceBuilder;
import oracle.dbtools.jdbc.OracleDataSources;
import oracle.dbtools.ucp.PoolDataSources;
import oracle.jdbc.datasource.OracleDataSource;
import oracle.ucp.jdbc.PoolDataSource;

public interface DataSourceConfigurator {
    public void configure(DataSourceBuilder<?> var1) throws SQLException, IOException;

    default public void configure(DataSource dataSource) throws SQLException, IOException {
        if (dataSource instanceof OracleDataSource) {
            OracleDataSource ods = (OracleDataSource)dataSource;
            OracleDataSources.instance().builder().configure(ods);
        } else if (dataSource instanceof PoolDataSource) {
            PoolDataSource pds = (PoolDataSource)dataSource;
            PoolDataSources.instance().builder().configure(pds);
        } else {
            throw new IllegalArgumentException();
        }
    }
}

