/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.db;

import java.sql.Connection;
import oracle.dbtools.db.ConnectionIdentifier;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.util.Logger;

public final class DefaultConnectionIdentifier
implements ConnectionIdentifier {
    private final Connection conn;
    private final String name;

    public static ConnectionIdentifier createIdentifier(String name, Connection conn) {
        if (conn == null) {
            try {
                conn = ConnectionResolver.getConnection(name);
            }
            catch (Exception e) {
                Logger.severe(ConnectionIdentifier.class, e);
            }
        }
        return conn != null ? new DefaultConnectionIdentifier(conn, name) : null;
    }

    public static ConnectionIdentifier createIdentifier(Connection conn) {
        return new DefaultConnectionIdentifier(conn, null);
    }

    private DefaultConnectionIdentifier(Connection conn, String name) {
        if (conn == null) {
            throw new IllegalArgumentException("null connection not allowed");
        }
        this.conn = conn;
        this.name = name == null ? "" : name;
    }

    @Override
    public Connection getConnection() {
        return this.conn;
    }

    @Override
    public ConnectionIdentifier.Key getIdentifierKey() {
        return new ConnectionIdentifier.DefaultKey(this.conn);
    }

    public String toString() {
        return this.name != null ? this.name : this.conn.toString();
    }
}

