/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.data.formattors;

import oracle.dbtools.data.formattors.BaseFormattor;
import oracle.dbtools.data.model.Column;

public class CharFormattor
extends BaseFormattor {
    @Override
    public String formatColumn(Column col) {
        String result = null;
        result = this.addDoubleQuote(col.getName()) + " " + col.getType();
        if (col.getName() != null && col.getPrecision() > 0) {
            result = result + "(" + col.getPrecision() + ")";
        }
        if (col.getDefault() != null && col.getDefault().trim().length() > 0) {
            result = result + " DEFAULT " + col.getDefault();
        }
        if (!col.isNullable()) {
            result = result + " NOT NULL";
        }
        return result;
    }

    @Override
    public String formatData(Object data, Column c) {
        return this.formatData(data, c, true);
    }

    @Override
    public Object formatDataForJava(Object data, Column c) throws Exception {
        return data != null ? data.toString() : "NULL";
    }

    public String formatData(Object data, Column c, boolean addQuotes) {
        Object result = "NULL";
        if (data != null) {
            String val = data.toString();
            val = val.replaceAll("'", "''");
            result = addQuotes ? (c.getType().toUpperCase().equals("NCHAR") || c.getType().toUpperCase().equals("NVARCHAR2") ? "N'" + val + "'" : "'" + val + "'") : val;
        }
        return result;
    }

    @Override
    public int getSqlType(String type) {
        if (type.equals("VARCHAR2")) {
            return 12;
        }
        if (type.equals("CHAR")) {
            return 1;
        }
        if (type.equals("NCHAR")) {
            return -15;
        }
        if (type.equals("NVARCHAR2")) {
            return -9;
        }
        return 0;
    }
}

