/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.connections;

import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.connections.Location;
import oracle.dbtools.connections.Storage;
import oracle.dbtools.connections.StorageException;
import oracle.dbtools.connections.StorageManager;
import oracle.dbtools.connections.security.ReferenceWorker;

public abstract class StorageWrapper {
    private StorageManager mgr;
    private ReferenceWorker worker;

    protected final ReferenceWorker createReferenceWorker(String key) {
        ReferenceWorker<char[]> worker = null;
        worker = ModelUtil.hasLength(key) ? ReferenceWorker.createDefaultWorker(key) : ReferenceWorker.createNullWorker();
        return worker;
    }

    protected StorageWrapper(Location loc, String key) throws StorageException {
        this.worker = this.createReferenceWorker(key);
        this.mgr = StorageManager.builder().location(loc).autosave(true).addEnvValue(ReferenceWorker.KEY, this.worker).build();
    }

    public final ReferenceWorker getWorker() {
        return this.worker;
    }

    protected abstract String getType();

    public final <T> Storage<T> getStorage() {
        return this.mgr.getStorage(this.getType());
    }
}

