/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app.injection0;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import oracle.dbtools.app.injection0.DependencyLink;
import oracle.dbtools.app.injection0.FlowGraph;
import oracle.dbtools.app.injection0.PlsqlException;
import oracle.dbtools.app.injection0.PlsqlType;
import oracle.dbtools.app.injection0.Predefined;
import oracle.dbtools.app.injection0.SqlInjectionAnalysisFailure;
import oracle.dbtools.app.injection0.SymbolTable;
import oracle.dbtools.app.injection0.TypeConversion;
import oracle.dbtools.app.injection0.Usage;
import oracle.dbtools.app.injection0.ValueNode;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.util.Service;

public class SqlInjectionGraph {
    private final List<LexerToken> src;
    private final Parsed target;
    FlowGraph flowGraph = new FlowGraph();
    private static final PlsqlType FOR_IDX_TYPE = new PlsqlType.Scalar(PlsqlType.DataType.PLS_INTEGER);
    private static final boolean DEBUG = false;
    private static final EnumSet<Debug> debugMsgTypes = EnumSet.allOf(Debug.class);
    private final HashMap<String, PlsqlType.DataType> ScalarDataTypeMap = new HashMap();
    private final DispatchInfo[] dispatchInfoData = new DispatchInfo[]{new DispatchInfo("function_call", null, (cur, ch, symbols, depth) -> this.parse_function_call(cur, ch, symbols, depth)), new DispatchInfo("paren_expr_list", null, (cur, ch, symbols, depth) -> this.parse_paren_expr_list(cur, ch, symbols, depth)), new DispatchInfo("decl_id", null, (cur, ch, symbols, depth) -> this.parse_decl_id(cur, ch, symbols, depth)), new DispatchInfo("identifier", null, (cur, ch, symbols, depth) -> this.parse_identifier(cur, ch, symbols, depth)), new DispatchInfo("name", null, (cur, ch, symbols, depth) -> this.parse_name(cur, ch, symbols, depth)), new DispatchInfo("numeric_literal", null, (cur, ch, symbols, depth) -> this.parse_numeric_literal(cur, ch, symbols, depth)), new DispatchInfo("string_literal", null, (cur, ch, symbols, depth) -> this.parse_string_literal(cur, ch, symbols, depth)), new DispatchInfo("range", null, (cur, ch, symbols, depth) -> this.parse_range(cur, ch, symbols, depth)), new DispatchInfo("sim_expr_DBLDOT__sim_expr", "range", null), new DispatchInfo("return_stmt", null, (cur, ch, symbols, depth) -> this.parse_return(cur, ch, symbols, depth)), new DispatchInfo("'RETURN'", "return_stmt", null), new DispatchInfo("'CONTINUE'", "continue_stmt", null), new DispatchInfo("continue_stmt", null, (cur, ch, symbols, depth) -> this.parse_continue(cur, ch, symbols, depth)), new DispatchInfo("exit_stmt", null, (cur, ch, symbols, depth) -> this.parse_exit(cur, ch, symbols, depth)), new DispatchInfo("iteration_scheme", null, (cur, ch, symbols, depth) -> this.parse_iteration_scheme(cur, ch, symbols, depth)), new DispatchInfo("excptn_handler", null, null, (cur, ch, symbols, depth) -> this.preparse_excptn_handler(cur, ch, symbols, depth)), new DispatchInfo("excptn_handlers", null, (cur, ch, symbols, depth) -> this.parse_excptn_handlers(cur, ch, symbols, depth)), new DispatchInfo("if_stmt", null, null, (cur, ch, symbols, depth) -> this.preparse_if(cur, ch, symbols, depth)), new DispatchInfo("loop_stmt", null, null, (cur, ch, symbols, depth) -> this.preparse_loop(cur, ch, symbols, depth)), new DispatchInfo("subprg_spec", null, null, (cur, ch, symbols, depth) -> this.preparse_subprg_spec(cur, ch, symbols, depth)), new DispatchInfo("subprg_body", null, null, (cur, ch, symbols, depth) -> this.preparse_subprg_body(cur, ch, symbols, depth)), new DispatchInfo("block_stmt", null, null, (cur, ch, symbols, depth) -> this.preparse_block_stmt(cur, ch, symbols, depth)), new DispatchInfo("expr", null, (cur, ch, symbols, depth) -> this.parse_typical_expr(cur, ch, symbols, depth)), new DispatchInfo("and_expr", "expr", null), new DispatchInfo("arith_expr", "expr", null), new DispatchInfo("parm_list_opt", null, (cur, ch, symbols, depth) -> this.parse_parm_list_opt(cur, ch, symbols, depth)), new DispatchInfo("(divisionoperation)", null, (cur, ch, symbols, depth) -> this.parse_division(cur, ch, symbols, depth)), new DispatchInfo("'/'", "(divisionoperation)", null), new DispatchInfo("'MOD'", "(divisionoperation)", null), new DispatchInfo("'REMAINDER'", "(divisionoperation)", null), new DispatchInfo("'REM'", "(divisionoperation)", null), new DispatchInfo("parse_datetime_link_expanded_n", null, (cur, ch, symbols, depth) -> this.parse_constrained_type(cur, ch, symbols, depth)), new DispatchInfo("unconstrained_type", "type", null), new DispatchInfo("unconstrained_type_wo_datetime", "type", null), new DispatchInfo("constrained_type", null, (cur, ch, symbols, depth) -> this.parse_constrained_type(cur, ch, symbols, depth)), new DispatchInfo("object_d_rhs", null, (cur, ch, symbols, depth) -> this.parse_object_d_rhs(cur, ch, symbols, depth)), new DispatchInfo("type", null, (cur, ch, symbols, depth) -> this.parse_unconstrained_type_wo_datetime(cur, ch, symbols, depth)), new DispatchInfo("fml_part", null, (cur, ch, symbols, depth) -> this.parse_fml_part(cur, ch, symbols, depth)), new DispatchInfo("assignment_stmt", null, (cur, ch, symbols, depth) -> this.parse_assignment_stmt(cur, ch, symbols, depth)), new DispatchInfo("excptn_d", null, (cur, ch, symbols, depth) -> this.parse_excptn_d(cur, ch, symbols, depth)), new DispatchInfo("basic_d", null, (cur, ch, symbols, depth) -> this.parse_basic_d(cur, ch, symbols, depth)), new DispatchInfo("prm_spec", null, (cur, ch, symbols, depth) -> this.parse_prm_spec(cur, ch, symbols, depth)), new DispatchInfo("exec_immediate_statement", null, (cur, ch, symbols, depth) -> this.parse_exec_immediate_stmt(cur, ch, symbols, depth))};
    private final int DISPATCH_INFO_DEFAULT_PRIORITY = 100000;
    private final Map<String, DispatchInfo> dispatch = new HashMap<String, DispatchInfo>();
    Map<String, BiFunction<ValueNode, SymbolTable, ValueNode>> acceptableSubstitutions = new HashMap<String, BiFunction<ValueNode, SymbolTable, ValueNode>>();

    public SqlInjectionGraph(String input) throws Exception {
        this.initialize();
        this.src = Lexer.parse(input);
        this.target = new Parsed(input, this.src, (Earley)SqlEarley.getInstance(), new String[]{"parse with errors"});
        this.parse(this.target.getRoot(), new SymbolTable(new SymbolTable(Predefined.functions)), 0);
    }

    public SqlInjectionGraph(String input, List<LexerToken> src, ParseNode root) {
        this.initialize();
        this.src = src;
        this.target = new Parsed(input, src, root);
        this.parse(this.target.getRoot(), new SymbolTable(new SymbolTable(Predefined.functions)), 0);
    }

    public List<List<DependencyLink>> getInjections(String ignored) {
        return this.flowGraph.getInjections((Usage node) -> this.parseLinenum(node.getPos()));
    }

    public static String getEditorWarningText(List<DependencyLink> injection, boolean skipFinal) {
        StringBuffer sb = new StringBuffer("SQL injection " + SqlInjectionGraph.getEditorWarningOneLink(injection, 0));
        for (int i = 1; i < injection.size() - (skipFinal ? 1 : 0); ++i) {
            if (injection.get(i).getLine() < 0) continue;
            sb.append(" -> " + SqlInjectionGraph.getEditorWarningOneLink(injection, i));
        }
        return sb.toString();
    }

    public static String getEditorWarningText(List<DependencyLink> injection) {
        return SqlInjectionGraph.getEditorWarningText(injection, true);
    }

    private static String getEditorWarningOneLink(List<DependencyLink> injection, int i) {
        Object name = "";
        name = injection.get(i).getVar() + " ";
        if (((String)name).length() > 0 && ((String)name).startsWith("(")) {
            name = "(EXCEPTION) ";
        }
        return (String)name + "line " + injection.get(i).getLine();
    }

    private ValueNode parse(ParseNode cur, SymbolTable symbols, int depth) throws SqlInjectionAnalysisFailure {
        try {
            ArrayList<ParseNode> children = new ArrayList<ParseNode>(cur.children());
            this.print(cur, depth);
            int[] parses = cur.content();
            DispatchInfo best = null;
            int bestIdx = -1;
            for (int tokNum = 0; tokNum < parses.length; ++tokNum) {
                String grammarToken = cur.content(tokNum);
                DispatchInfo di = this.dispatch.get(grammarToken);
                if (di == null || best != null && di.priority >= best.priority) continue;
                best = di;
                bestIdx = tokNum;
            }
            ValueNode nodeValue = null;
            ArrayList<ValueNode> childValues = null;
            if (best != null && best.beforeChild != null) {
                SqlInjectionGraph.debugln(Debug.PARSE, "PRE dispatch " + best);
                nodeValue = best.beforeChild.parse(cur, null, symbols, depth);
            } else {
                childValues = new ArrayList<ValueNode>(children.size());
                for (ParseNode child : children) {
                    childValues.add(this.parse(child, symbols, depth + 1));
                }
            }
            if (best != null) {
                int[] content = cur.content();
                int temp = content[0];
                content[0] = content[bestIdx];
                content[bestIdx] = temp;
                if (best.beforeChild == null && (nodeValue = best.parser.parse(cur, childValues, symbols, depth)) != null && nodeValue.nonterm == null) {
                    nodeValue.nonterm = best.equiv;
                }
                SqlInjectionGraph.debugln(Debug.PARSE, "NodeValue " + best.nonterm + " = " + nodeValue + " @" + (Comparable)(nodeValue == null ? "NULL" : nodeValue.getPos()));
                return nodeValue;
            }
            return this.mergedValueNodes(childValues);
        }
        catch (Exception e) {
            SqlInjectionGraph.debugln(Debug.MISC, "Exception while parsing " + cur);
            this.print(cur, 0);
            System.out.flush();
            if (e instanceof SqlInjectionAnalysisFailure) {
                throw e;
            }
            throw new SqlInjectionAnalysisFailure("SQLInjection analysis failed while parsing line " + this.parseLinenum(cur) + " \"" + this.correspondingSource(cur) + "\"", e);
        }
    }

    private ValueNode mergedValueNodes(List<ValueNode> childValues) {
        ValueNode single = null;
        ValueNode.MultiNode<ValueNode> multi = null;
        for (ValueNode childvalue : childValues) {
            if (childvalue == null) continue;
            if (single == null) {
                single = childvalue;
                if (!(single instanceof ValueNode.MultiNode)) continue;
                ValueNode.MultiNode singleAsMulti = (ValueNode.MultiNode)single;
                multi = singleAsMulti;
                continue;
            }
            if (multi == null) {
                multi = new ValueNode.MultiNode<ValueNode>(single.nonterm, single.getPos());
                multi.add(single);
            }
            if (childvalue instanceof ValueNode.MultiNode) {
                ValueNode.MultiNode multichild = (ValueNode.MultiNode)childvalue;
                multi.getValues().addAll(multichild.getValues());
                continue;
            }
            multi.add(childvalue);
        }
        if (multi != null) {
            return multi;
        }
        return single;
    }

    private void print(ParseNode node, int depth) {
    }

    private String printableLine(ParseNode node, int depth) {
        StringBuffer sb = new StringBuffer(this.linePrefix(node, depth));
        for (int i = 0; i < node.content().length; ++i) {
            sb.append(node.content(i) + " ");
        }
        sb.append("## ");
        sb.append(this.correspondingSource(node));
        return sb.toString();
    }

    private String correspondingSource(ParseNode node) {
        StringBuffer sb = new StringBuffer();
        String space = "";
        for (int i = node.from; i < node.to; ++i) {
            String s = space + this.src.get((int)i).content;
            space = " ";
            if (sb.length() + s.length() > 80 && i - node.from > 3) {
                sb.append("...");
                break;
            }
            sb.append(s);
        }
        return sb.toString();
    }

    private String linePrefix(ParseNode node, int depth) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < depth; ++i) {
            sb.append("| ");
        }
        String line = "" + this.parseLinenum(node);
        String linePos = line + " $" + node.from;
        String lineRange = line + " $" + node.from + (String)(node.to > node.from + 1 ? "-" + node.to : "");
        int space = sb.length() - 2;
        Object prefix = "";
        if (space > lineRange.length()) {
            prefix = lineRange;
        } else if (space > linePos.length()) {
            prefix = linePos;
        } else if (space > line.length()) {
            prefix = line;
        }
        sb.replace(0, ((String)prefix).length(), (String)prefix);
        return sb.toString();
    }

    private String getText(List<ParseNode> children, int childIdx, String token) {
        ParseNode child = children.get(childIdx);
        if (token == null || child.content(0).equals(token)) {
            LexerToken t = this.src.get(child.from);
            return t.content;
        }
        throw new IllegalArgumentException("Expected token '" + token + "' but got '" + child.content(0) + "'");
    }

    private static <T> T call(Object target, String method, Object ... args) throws Exception {
        Class[] argTypes = new Class[args.length];
        for (int j = 0; j < args.length; ++j) {
            Class<Object> argClass = args[j].getClass();
            if (argClass == Double.class) {
                argClass = Double.TYPE;
            } else if (argClass == Integer.class) {
                argClass = Integer.TYPE;
            }
            argTypes[j] = argClass;
        }
        Class<?> type = target instanceof Class ? (Class<?>)target : target.getClass();
        Method handle = type.getDeclaredMethod(method, argTypes);
        try {
            return (T)handle.invoke(target, args);
        }
        catch (Exception targetEx) {
            Throwable cause = targetEx.getCause();
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw new IllegalArgumentException(cause);
        }
    }

    public static <T> T get(Object target, String fieldName) throws Exception {
        Class<?> type = target instanceof Class ? (Class<?>)target : target.getClass();
        Field handle = null;
        while (handle == null) {
            try {
                handle = type.getDeclaredField(fieldName);
                handle.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                if ((type = type.getSuperclass()) != null) continue;
                break;
            }
        }
        if (handle == null) {
            throw new NoSuchFieldException(target.getClass().getName() + "." + fieldName);
        }
        return (T)handle.get(target);
    }

    private boolean is(ParseNode cur, String generalType) {
        for (String nonterm : cur.contentAsStrings()) {
            if (generalType.equals(nonterm)) {
                return true;
            }
            if (!this.acceptableSubstitutions.containsKey(nonterm + ":" + generalType)) continue;
            return true;
        }
        return false;
    }

    private ValueNode[] orderedParse(ParseNode cur, List<ValueNode> values, String ... grammarTokens) {
        ArrayList<ParseNode> children = new ArrayList<ParseNode>(cur.children());
        ValueNode[] ret = new ValueNode[grammarTokens.length];
        int token = 0;
        for (int childIdx = 0; childIdx < children.size(); ++childIdx) {
            ParseNode child = (ParseNode)children.get(childIdx);
            if (grammarTokens[token] != null && !this.is(child, grammarTokens[token])) continue;
            ret[token] = values.get(childIdx);
            if (++token == grammarTokens.length) break;
        }
        return ret;
    }

    int parseLinenum(ParseNode cur) {
        int linenum = Service.charPos2LineNo(this.target.getInput(), this.target.getSrc().get((int)cur.from).begin);
        if (cur.to == Integer.MIN_VALUE) {
            linenum = -linenum;
        }
        return linenum;
    }

    static ParseNode fakeParseNode(int token) {
        return new ParseNode(token, Integer.MIN_VALUE, -1, -1, null);
    }

    static boolean isFake(ParseNode node) {
        return node.to == Integer.MIN_VALUE;
    }

    private ValueNode preparse_block_stmt(ParseNode cur, List<ValueNode> children, SymbolTable symbols, int depth) {
        SymbolTable localSymtab = new SymbolTable(symbols);
        HashSet varsAssigned = new HashSet();
        SymbolTable.AssignmentHook oldWrite = localSymtab.hookWrite(null);
        localSymtab.hookWrite((usage, node, symtab) -> {
            for (SymbolTable level = usage.getSymtab(); level != null && level != localSymtab; level = level.getEnclosingScope()) {
                if (level != symbols) continue;
                varsAssigned.add(usage.getName());
                break;
            }
            oldWrite.accept(usage, node, symtab);
        });
        ValueNode result = this.preparse_BEGIN_END(SubprgBodyState.SEEKING_BEGIN, cur, children, symbols, depth);
        for (String name : varsAssigned) {
            Usage blockUse = localSymtab.read(name);
            Usage endOfBlockFake = symbols.write(blockUse, SqlInjectionGraph.fakeParseNode(cur.to));
            endOfBlockFake.from(blockUse);
            SqlInjectionGraph.debugln(Debug.LOOP_AND_BLOCK, "End of block: " + name + " old=" + blockUse + " new (fake) =" + endOfBlockFake);
        }
        return result;
    }

    private ValueNode preparse_excptn_handler(ParseNode cur, List<ValueNode> children, SymbolTable symbols, int depth) {
        ArrayList<ParseNode> parseNodes = new ArrayList<ParseNode>(cur.children());
        EnumSet<PlsqlException> exceptions = EnumSet.noneOf(PlsqlException.class);
        boolean others = false;
        HashMap<String, Usage> varsRefed = new HashMap<String, Usage>();
        BiFunction<String, Usage, Usage> oldRead = symbols.hookRead(null);
        symbols.hookRead((name, ret) -> {
            if ((ret = (Usage)oldRead.apply((String)name, (Usage)ret)) == null) {
                SqlInjectionGraph.debugln(Debug.WARNING, "WARNING! Reference to unassigned variable " + name + " bug?!?!");
                return ret;
            }
            Usage virtualUsage = (Usage)varsRefed.get(name);
            if (virtualUsage != null) {
                return virtualUsage;
            }
            virtualUsage = new Usage((Usage)ret, SqlInjectionGraph.fakeParseNode(cur.from));
            varsRefed.put((String)name, virtualUsage);
            virtualUsage.from((Usage)ret);
            ret = virtualUsage;
            return ret;
        });
        SymbolTable localScope = new SymbolTable(symbols);
        for (ParseNode pn : parseNodes) {
            if (this.is(pn, "'OTHERS'")) {
                others = true;
                ValueNode n = this.parse(pn, localScope, depth + 1);
                continue;
            }
            if (this.is(pn, "excptn_choice")) {
                PlsqlException exception;
                ValueNode.IdentifierNode choice = this.parse(pn, localScope, depth + 1).asIdentifierNode();
                try {
                    exception = PlsqlException.valueOf(choice.getName());
                }
                catch (IllegalArgumentException ex) {
                    Usage u = symbols.getDeclaration(choice.getName());
                    if (u == null || !(u.getType() instanceof PlsqlType.Exception)) {
                        SqlInjectionGraph.debugln(Debug.WARNING, "Exception not previously declared: " + choice.getName());
                    }
                    exception = PlsqlException.USER_DECLARED;
                }
                exceptions.add(exception);
                continue;
            }
            ValueNode valueNode = this.parse(pn, localScope, depth + 1);
        }
        symbols.hookRead(oldRead);
        ValueNode.MultiNode<ExceptionHandler> retNode = new ValueNode.MultiNode<ExceptionHandler>("excptn_handler", cur);
        retNode.add(new ExceptionHandler(exceptions, others, varsRefed));
        return retNode;
    }

    private ValueNode preparse_if(ParseNode cur, List<ValueNode> emptyList, SymbolTable symbols, int depth) {
        SymbolTable elseScope = new SymbolTable(symbols);
        ArrayList<SymbolTable> thenScopes = new ArrayList<SymbolTable>();
        this.print(cur, depth);
        IfState state = IfState.SEEKING_IF;
        for (ParseNode child : cur.children()) {
            switch (state) {
                case SEEKING_IF: {
                    if (this.is(child, "'IF'")) {
                        this.print(child, depth + 1);
                        state = IfState.CONDITIONAL_EXPR;
                        break;
                    }
                    ValueNode n = this.parse(child, symbols, depth + 1);
                    break;
                }
                case CONDITIONAL_EXPR: {
                    state = IfState.SEEKING_THEN;
                    ValueNode n = this.parse(child, symbols, depth + 1);
                    ValueNode.ExprNode ifExpr = n == null ? null : n.asExprNode(symbols);
                    break;
                }
                case SEEKING_THEN: {
                    if (this.is(child, "'THEN'")) {
                        this.print(child, depth + 1);
                        state = IfState.THEN_STATEMENTS;
                        break;
                    }
                    ValueNode n = this.parse(child, symbols, depth + 1);
                    break;
                }
                case THEN_STATEMENTS: {
                    state = IfState.SEEKING_ELSIF_ELSE_END;
                    SymbolTable thenScope = new SymbolTable(symbols);
                    thenScopes.add(thenScope);
                    Object thenNode = this.parse(child, thenScope, depth + 1);
                    break;
                }
                case ELSE_STATEMENTS: {
                    state = IfState.SEEKING_ELSIF_ELSE_END;
                    Object thenNode = this.parse(child, elseScope, depth + 1);
                    break;
                }
                case SEEKING_ELSIF_ELSE_END: {
                    Object thenNode;
                    SymbolTable thenScope;
                    if (this.is(child, "else_clause_opt")) {
                        state = IfState.SEEKING_ELSIF_ELSE_END;
                        ValueNode elseNode = this.parse(child, elseScope, depth + 1);
                        break;
                    }
                    if (this.is(child, "elsif_clause_opt")) {
                        state = IfState.SEEKING_ELSIF_ELSE_END;
                        thenScope = new SymbolTable(symbols);
                        thenScopes.add(thenScope);
                        thenNode = this.parse(child, thenScope, depth + 1);
                        break;
                    }
                    ValueNode n = this.parse(child, symbols, depth + 1);
                }
            }
        }
        HashSet<String> ifAssigns = new HashSet<String>();
        for (SymbolTable thenScope : thenScopes) {
            ifAssigns.addAll(thenScope.getLocalNameSet());
        }
        ifAssigns.addAll(elseScope.getLocalNameSet());
        for (String var : ifAssigns) {
            ArrayList<Usage> usages = new ArrayList<Usage>();
            usages.add(elseScope.read(var));
            for (SymbolTable thenScope : thenScopes) {
                usages.add(thenScope.read(var));
            }
            Usage fakeAssignment = symbols.write(symbols.read(var), SqlInjectionGraph.fakeParseNode(cur.from));
            for (Usage u : usages) {
                fakeAssignment.from(u);
            }
            SqlInjectionGraph.debugln(Debug.IF_ENDIF, "Fake assignment: " + fakeAssignment.toString(true));
        }
        return null;
    }

    private ValueNode preparse_loop(ParseNode cur, List<ValueNode> emptyList, SymbolTable symbols, int depth) {
        this.print(cur, depth);
        SymbolTable loopScope = new SymbolTable(symbols);
        ParseNode fakeContPos = SqlInjectionGraph.fakeParseNode(cur.from);
        ParseNode fakeExitPos = SqlInjectionGraph.fakeParseNode(cur.to - 1);
        HashMap varsRefed = new HashMap();
        HashSet varsAssigned = new HashSet();
        SymbolTable.AssignmentHook oldWrite = loopScope.hookWrite(null);
        loopScope.hookWrite((usage, node, symtab) -> {
            String name = usage.getName();
            if (symtab.getDeclaration(name) == symbols.getDeclaration(name)) {
                varsAssigned.add(name);
                if (varsRefed.get(name) == null) {
                    symtab.read(name);
                }
            }
            oldWrite.accept(usage, node, symtab);
        });
        BiFunction<String, Usage, Usage> oldRead = loopScope.hookRead(null);
        loopScope.hookRead((name, ret) -> {
            if ((ret = (Usage)oldRead.apply((String)name, (Usage)ret)) == null) {
                SqlInjectionGraph.debugln(Debug.WARNING, "WARNING: Reference to unassigned variable. Is that legal?");
                return ret;
            }
            if (ret != null && symbols.read(ret.getName()) != ret) {
                return ret;
            }
            Usage fakeAss = new Usage((Usage)ret, fakeContPos);
            varsRefed.put(name, fakeAss);
            fakeAss.from((Usage)ret);
            ret = fakeAss;
            return ret;
        });
        loopScope.hookContinue(contScope -> {
            for (String name : varsAssigned) {
                Usage fakeAss = (Usage)varsRefed.get(name);
                Usage curUse = loopScope.read(name);
                if (curUse == fakeAss) continue;
                fakeAss.from(curUse);
            }
        });
        ArrayList exitStatements = new ArrayList();
        loopScope.hookExit(exitScope -> {
            HashSet<String> namesUsed = new HashSet<String>();
            for (SymbolTable scope = exitScope; scope != symbols; scope = scope.getEnclosingScope()) {
                namesUsed.addAll(scope.getLocalNameSet());
            }
            HashSet<Usage> scopeAtExit = new HashSet<Usage>();
            for (String name : namesUsed) {
                if (symbols.getDeclaration(name) != exitScope.getDeclaration(name)) continue;
                scopeAtExit.add(exitScope.read(name));
            }
            exitStatements.add(scopeAtExit);
        });
        LoopState state = LoopState.SEEKING_LOOP;
        for (ParseNode child : cur.children()) {
            switch (state) {
                case SEEKING_LOOP: {
                    ValueNode n;
                    if (this.is(child, "iteration_scheme")) {
                        n = this.parse(child, loopScope, depth + 1);
                        break;
                    }
                    if (this.is(child, "'LOOP'")) {
                        this.print(child, depth + 1);
                        state = LoopState.LOOP_BODY;
                        break;
                    }
                    n = this.parse(child, loopScope, depth + 1);
                    break;
                }
                case LOOP_BODY: {
                    state = LoopState.SEEKING_END;
                    ValueNode n = this.parse(child, loopScope, depth + 1);
                    break;
                }
                case SEEKING_END: {
                    ValueNode n = this.parse(child, loopScope, depth + 1);
                }
            }
        }
        for (Object name2 : varsAssigned) {
            Usage fakeAss = (Usage)varsRefed.get(name2);
            Usage usage2 = loopScope.read((String)name2);
            if (usage2 == fakeAss) continue;
            fakeAss.from(usage2);
        }
        HashMap<String, Usage> fakeExitAssigns = new HashMap<String, Usage>();
        for (String name3 : varsAssigned) {
            Usage usage3 = symbols.write(symbols.read(name3), fakeExitPos);
            fakeExitAssigns.put(name3, usage3);
        }
        HashMap<String, Integer> varsAssignedCount = new HashMap<String, Integer>();
        for (String string : varsAssigned) {
            varsAssignedCount.put(string, 0);
        }
        for (HashSet hashSet : exitStatements) {
            for (Usage use : hashSet) {
                String name5 = use.getName();
                if (!varsAssigned.contains(name5)) continue;
                Usage fakeAss = (Usage)fakeExitAssigns.get(name5);
                fakeAss.from(use);
                varsAssignedCount.put(name5, (Integer)varsAssignedCount.get(name5) + 1);
            }
        }
        for (String string : varsAssigned) {
            if ((Integer)varsAssignedCount.get(string) >= exitStatements.size()) continue;
            Usage fakeAss = (Usage)fakeExitAssigns.get(string);
            fakeAss.from((Usage)varsRefed.get(string));
        }
        for (Map.Entry entry : fakeExitAssigns.entrySet()) {
            SqlInjectionGraph.debugln(Debug.LOOP_AND_BLOCK, "Fake exit assignment: " + entry.getValue());
        }
        return null;
    }

    private ValueNode preparse_subprg_spec(ParseNode cur, List<ValueNode> children, SymbolTable symbols, int depth) {
        ValueNode.StringNode nameNode = null;
        ArrayList<ValueNode.IdentifierNode> parameters = new ArrayList<ValueNode.IdentifierNode>();
        PlsqlType returnType = null;
        SubprgState state = SubprgState.SEEKING_FUNC_PROC;
        for (ParseNode child : cur.children()) {
            switch (state) {
                case SEEKING_FUNC_PROC: {
                    if (this.is(child, "'CREATE'") || this.is(child, "'OR'") || this.is(child, "'REPLACE'")) {
                        this.print(child, depth + 1);
                        break;
                    }
                    if (this.is(child, "'FUNCTION'")) {
                        this.print(child, depth + 1);
                        state = SubprgState.SEEKING_NAME;
                        break;
                    }
                    if (this.is(child, "'PROCEDURE'")) {
                        this.print(child, depth + 1);
                        state = SubprgState.SEEKING_NAME;
                        break;
                    }
                    ValueNode n = this.parse(child, symbols, depth + 1);
                    break;
                }
                case SEEKING_NAME: {
                    nameNode = this.parse(child, symbols, depth + 1).asStringNode();
                    state = SubprgState.SEEKING_FML_PART;
                    break;
                }
                case SEEKING_FML_PART: {
                    if (this.is(child, "fml_part")) {
                        parameters.addAll(((ValueNode.ParametersNode)this.parse(child, symbols, depth + 1)).getParameters());
                        state = SubprgState.SEEKING_RETURN;
                        break;
                    }
                    ValueNode n = this.parse(child, symbols, depth + 1);
                    break;
                }
                case SEEKING_RETURN: {
                    if (this.is(child, "'RETURN'")) {
                        this.print(child, depth + 1);
                        break;
                    }
                    if (!this.is(child, "type")) break;
                    returnType = this.parse(child, symbols, depth + 1).asTypeNode().getType();
                    state = SubprgState.SEEKING_END;
                    break;
                }
                case SEEKING_END: {
                    ValueNode n = this.parse(child, symbols, depth + 1);
                }
            }
        }
        String name = nameNode.getName();
        PlsqlType.Function functionType = new PlsqlType.Function(name, returnType, parameters);
        Usage declaration = symbols.define(name + "()", functionType, cur);
        for (ValueNode.IdentifierNode parm : parameters) {
            PlsqlType type = parm.getType();
            Usage parmDef = symbols.define(parm.getName(), type, parm.getPos());
            if (!type.isInjectable()) continue;
            this.flowGraph.addSource(parmDef);
        }
        return new ValueNode.IdentifierNodeDeclared(new ValueNode.IdentifierNode(nameNode, nameNode.getName(), functionType), symbols, declaration);
    }

    private ValueNode preparse_subprg_body(ParseNode cur, List<ValueNode> children, SymbolTable symbols, int depth) {
        return this.preparse_BEGIN_END(SubprgBodyState.SEEKING_SUBPRG_SPEC, cur, children, symbols, depth);
    }

    private ValueNode preparse_BEGIN_END(SubprgBodyState state, ParseNode cur, List<ValueNode> children, SymbolTable symbols, int depth) {
        ValueNode.IdentifierNode declaration = null;
        ArrayList<ValueNode.IdentifierNode> parameters = new ArrayList<ValueNode.IdentifierNode>();
        PlsqlType returnType = null;
        ArrayList exceptionHandlers = new ArrayList();
        EnumSet<PlsqlException> allHandledExceptions = EnumSet.noneOf(PlsqlException.class);
        SqlInjectionGraph.debugln(Debug.PARSE, "preparse_subprg_body cur=" + cur);
        ArrayList<ParseNode> parseChildren = new ArrayList<ParseNode>(cur.children());
        int skippedParsing = parseChildren.size();
        block5: for (int childIdx = 0; childIdx < parseChildren.size(); ++childIdx) {
            ParseNode pnode = (ParseNode)parseChildren.get(childIdx);
            SqlInjectionGraph.debugln(Debug.PARSE, "preparse_subprg_body child=" + pnode);
            switch (state) {
                case SEEKING_SUBPRG_SPEC: {
                    if (!this.is(pnode, "subprg_spec")) {
                        throw new IllegalArgumentException("While parsing " + cur + " got " + pnode + " instead of expected subprg_spec");
                    }
                    declaration = this.parse(pnode, symbols, depth + 1).asIdentiferNodeDeclared();
                    state = SubprgBodyState.SEEKING_BEGIN;
                    continue block5;
                }
                case SEEKING_BEGIN: {
                    if (this.is(pnode, "'BEGIN'")) {
                        state = SubprgBodyState.SEEKING_EXCEPTION_HANDLERS;
                        skippedParsing = childIdx;
                        continue block5;
                    }
                    ValueNode n = this.parse(pnode, symbols, depth + 1);
                    continue block5;
                }
                case SEEKING_EXCEPTION_HANDLERS: {
                    if (!this.is(pnode, "exception_handlers_opt")) continue block5;
                    assert (exceptionHandlers.size() == 0);
                    state = SubprgBodyState.SKIP_TO_END;
                    ValueNode.MultiNode ehn = (ValueNode.MultiNode)this.parse(pnode, symbols, depth + 1);
                    exceptionHandlers.clear();
                    exceptionHandlers.addAll(ehn.getValues());
                    for (ExceptionHandler eh : exceptionHandlers) {
                        allHandledExceptions.addAll(eh.exceptions);
                    }
                    HashMap escapedValues = new HashMap();
                    SymbolTable.AssignmentHook oldWrite = symbols.hookWrite(null);
                    symbols.hookWrite((usage, node, symtab) -> {
                        String name = usage.getName();
                        if (symtab.getDeclaration(name) == symbols.getDeclaration(name)) {
                            escapedValues.put(name, usage);
                        }
                        oldWrite.accept(usage, node, symtab);
                    });
                    BiConsumer<EnumSet<PlsqlException>, ParseNode> oldExceptionHandler = symbols.hookExceptions(null);
                    symbols.hookExceptions((exceptSet, pos) -> {
                        SqlInjectionGraph.debugln(Debug.EXCEPTION, "...throws " + exceptSet + " at " + pos);
                        boolean othersHandler = false;
                        for (ExceptionHandler eh : exceptionHandlers) {
                            if (eh.isOthers()) {
                                othersHandler = true;
                            }
                            boolean handles = false;
                            String exceptionHandled = null;
                            for (PlsqlException ex : exceptSet) {
                                if (eh.getExceptions().contains((Object)ex)) {
                                    handles = true;
                                    exceptionHandled = ex.toString();
                                    SqlInjectionGraph.debugln(Debug.EXCEPTION, eh + " handles " + ex);
                                    break;
                                }
                                if (!eh.isOthers() || allHandledExceptions.contains((Object)ex)) continue;
                                handles = true;
                                exceptionHandled = ex.toString();
                                SqlInjectionGraph.debugln(Debug.EXCEPTION, eh + " OTHERS handles " + ex);
                                break;
                            }
                            if (!handles) continue;
                            HashMap<String, Usage> namesRefed = eh.getNamesRefed();
                            for (Map.Entry<String, Usage> nameUsage : namesRefed.entrySet()) {
                                String var = nameUsage.getKey();
                                Usage virtualUsage = nameUsage.getValue();
                                Usage mostRecentWrite = (Usage)escapedValues.get(var);
                                if (mostRecentWrite == null) {
                                    mostRecentWrite = symbols.read(var);
                                    assert (mostRecentWrite != null);
                                }
                                if (eh.flowedSources.add(mostRecentWrite)) {
                                    Usage exceptionPos = new Usage(null, "(" + exceptionHandled + ")", mostRecentWrite.getType(), (ParseNode)pos);
                                    exceptionPos.from(mostRecentWrite);
                                    virtualUsage.from(exceptionPos);
                                    continue;
                                }
                                SqlInjectionGraph.debugln(Debug.DATAFLOW, "   ignoring duplicate flow for " + mostRecentWrite + " into " + virtualUsage);
                            }
                        }
                        if (!othersHandler) {
                            EnumSet<PlsqlException> unhandled = EnumSet.noneOf(PlsqlException.class);
                            for (PlsqlException ex : exceptSet) {
                                if (allHandledExceptions.contains((Object)ex)) continue;
                                unhandled.add(ex);
                            }
                            if (!unhandled.isEmpty()) {
                                SqlInjectionGraph.debugln(Debug.EXCEPTION, "Unhandled exceptions " + unhandled);
                                oldExceptionHandler.accept(unhandled, (ParseNode)pos);
                            }
                        }
                    });
                    while (skippedParsing < childIdx) {
                        this.parse((ParseNode)parseChildren.get(skippedParsing), symbols, depth + 1);
                        ++skippedParsing;
                    }
                    ++skippedParsing;
                }
            }
        }
        while (skippedParsing < parseChildren.size()) {
            this.parse((ParseNode)parseChildren.get(skippedParsing), symbols, depth + 1);
            ++skippedParsing;
        }
        if (declaration != null) {
            String name = declaration.getName();
            PlsqlType.Function functionType = new PlsqlType.Function(name, returnType, parameters);
            symbols.define(name + "()", functionType, cur);
            for (ValueNode.IdentifierNode parm : parameters) {
                Usage parmDef = symbols.define(parm.getName(), parm.getType(), parm.getPos());
                this.flowGraph.addSource(parmDef);
            }
        }
        return null;
    }

    private ValueNode parse_assignment_stmt(ParseNode cur, List<ValueNode> children, SymbolTable symbols, int depth) {
        List<Object> propagatesFrom;
        ValueNode[] values = this.orderedParse(cur, children, "identifier", "':'", "expr", null);
        if (values[3] != null) {
            throw new IllegalArgumentException("Failed to parse assignment from " + cur + " (values[3]=" + values[3] + ")");
        }
        if (values[0] == null) {
            throw new IllegalArgumentException("Assignment statment: Null LHS " + cur);
        }
        String name = values[0].asIdentifierNode().getName();
        Usage declaration = symbols.getDeclaration(name);
        if (values[2] == null) {
            propagatesFrom = Collections.emptyList();
        } else {
            ValueNode.ExprNode exprN = values[2].asExprNode(symbols);
            propagatesFrom = exprN.getUsages();
            EnumSet<PlsqlException> exceptions = TypeConversion.conversionExceptions(exprN.getType(), declaration.getType());
            if (!exceptions.isEmpty()) {
                symbols.exceptions(exceptions, cur);
            }
        }
        Usage newUse = symbols.write(declaration, cur);
        if (declaration.getType().isInjectable()) {
            for (Usage usage : propagatesFrom) {
                newUse.from(usage);
            }
            SqlInjectionGraph.debug(Debug.ASSIGNMENT, "Assignment: " + newUse + " [" + newUse.getType() + "] from: ");
            for (Usage usage : propagatesFrom) {
                SqlInjectionGraph.debug(Debug.ASSIGNMENT, " " + usage);
            }
            SqlInjectionGraph.debugln(Debug.ASSIGNMENT, "");
        } else {
            SqlInjectionGraph.debug(Debug.ASSIGNMENT, name + " is safe: " + declaration.getType());
        }
        return null;
    }

    private ValueNode parse_basic_d(ParseNode cur, List<ValueNode> children, SymbolTable symbols, int depth) {
        ValueNode.StringNode nameNode = null;
        PlsqlType type = null;
        BasicDState state = BasicDState.IDENTIFIER;
        for (ValueNode node : children) {
            switch (state) {
                case IDENTIFIER: {
                    nameNode = node.asStringNode();
                    state = BasicDState.TYPE;
                    break;
                }
                case TYPE: {
                    if (node.nonterm.equals("type")) {
                        type = node.asTypeNode().getType();
                        state = BasicDState.DEFAULT;
                        break;
                    }
                    if (!node.nonterm.equals("object_d_rhs")) break;
                    type = node.asTypeNode().getType();
                    state = BasicDState.DEFAULT;
                    break;
                }
                case DEFAULT: {
                    throw new NullPointerException();
                }
            }
        }
        if (nameNode == null || type == null) {
            throw new IllegalArgumentException("Failed to parse basic_d from " + cur);
        }
        ValueNode.IdentifierNode id = new ValueNode.IdentifierNode(nameNode, nameNode.getName(), type);
        symbols.define(id.getName(), type, id.getPos());
        return null;
    }

    private ValueNode parse_excptn_d(ParseNode cur, List<ValueNode> children, SymbolTable symbols, int depth) {
        assert (children.size() == 2);
        ValueNode.StringNode nameNode = children.get(0).asStringNode();
        PlsqlType.Exception type = new PlsqlType.Exception();
        ValueNode.IdentifierNode id = new ValueNode.IdentifierNode(nameNode, nameNode.getName(), type);
        symbols.define(id.getName(), type, id.getPos());
        return null;
    }

    private ValueNode parse_continue(ParseNode cur, List<ValueNode> children, SymbolTable symbols, int depth) {
        symbols.cont();
        return null;
    }

    private ValueNode parse_excptn_handlers(ParseNode cur, List<ValueNode> children, SymbolTable symbols, int depth) {
        ValueNode.MultiNode ret = null;
        for (ValueNode child : children) {
            if (child == null) continue;
            ValueNode.MultiNode multiChild = (ValueNode.MultiNode)child;
            if (ret == null) {
                ret = multiChild;
                continue;
            }
            ret.addAll(multiChild.getValues());
        }
        return ret;
    }

    private ValueNode parse_exec_immediate_stmt(ParseNode cur, List<ValueNode> children, SymbolTable symbols, int depth) {
        ValueNode[] values = this.orderedParse(cur, children, "expr", "into_list", null);
        if (values[0] == null || values[2] != null) {
            throw new IllegalArgumentException("Failed to parse exec_immediate_stmt from " + cur);
        }
        for (Usage u : values[0].asExprNode(symbols).getUsages()) {
            Usage exec = new Usage(u, cur);
            exec.from(u);
            this.flowGraph.addSink(exec);
        }
        return null;
    }

    private ValueNode parse_exit(ParseNode cur, List<ValueNode> children, SymbolTable symbols, int depth) {
        symbols.exit();
        return null;
    }

    private ValueNode parse_fml_part(ParseNode cur, List<ValueNode> children, SymbolTable symbols, int depth) {
        ArrayList<ValueNode.IdentifierNode> parameters = new ArrayList<ValueNode.IdentifierNode>(children.size() - 2);
        for (ValueNode child : children) {
            if (child == null) continue;
            if (child instanceof ValueNode.IdentifierNode) {
                parameters.add((ValueNode.IdentifierNode)child);
                continue;
            }
            if (child instanceof ValueNode.MultiNode) {
                ValueNode.MultiNode multi = (ValueNode.MultiNode)child;
                for (ValueNode grandchild : multi.getValues()) {
                    parameters.add((ValueNode.IdentifierNode)grandchild);
                }
                continue;
            }
            throw new IllegalArgumentException("Unexpected child " + child + " while parsing " + cur);
        }
        return new ValueNode.ParametersNode("fml_part", cur, parameters);
    }

    private ValueNode parse_function_call(ParseNode cur, List<ValueNode> children, SymbolTable symbols, int depth) {
        ValueNode[] values = this.orderedParse(cur, children, "name", "paren_expr_list");
        if (values[0] == null || values[1] == null) {
            throw new IllegalArgumentException("Failed to parse function_call from " + cur);
        }
        String name = values[0].asStringNode().getName();
        List parms = ((ValueNode.MultiNode)values[1]).getValues();
        Usage func = symbols.getDeclaration(name);
        PlsqlType.Function funcType = func == null ? null : (PlsqlType.Function)func.getType();
        ArrayList<Usage> propagatesFrom = new ArrayList<Usage>();
        if (funcType == null || funcType.returnSafetyParmIndexes == null) {
            SqlInjectionGraph.debugln(Debug.SYM_READ, "Dependency proagation for function " + name + " unknown; propagating from all variables");
            for (int idx = 0; idx < parms.size(); ++idx) {
                ValueNode vn = (ValueNode)parms.get(idx);
                if (vn == null) continue;
                propagatesFrom.addAll(vn.asExprNode(symbols).getUsages());
            }
        } else {
            for (int idx : funcType.returnSafetyParmIndexes) {
                ValueNode vn = (ValueNode)parms.get(idx);
                if (vn == null) {
                    SqlInjectionGraph.debugln(Debug.SYM_READ, "Known func " + name + " attempted propagation from null parameter #" + idx + ", ignored");
                }
                propagatesFrom.addAll(vn.asExprNode(symbols).getUsages());
            }
        }
        PlsqlType exprType = funcType == null ? new PlsqlType.Scalar(PlsqlType.DataType.VARCHAR2) : funcType.returnType;
        return new ValueNode.ExprNode("function_call", cur, exprType, propagatesFrom);
    }

    private ValueNode.IdentifierNode parse_identifier(ParseNode cur, List<ValueNode> children, SymbolTable symbols, int depth) {
        String name = this.src.get((int)cur.from).content;
        Usage decl = symbols.getDeclaration(name);
        PlsqlType type = decl == null ? null : decl.getType();
        return new ValueNode.IdentifierNode("identifier", cur, name, type);
    }

    private ValueNode parse_iteration_scheme(ParseNode cur, List<ValueNode> children, SymbolTable symbols, int depth) {
        ArrayList<ParseNode> parseChildren = new ArrayList<ParseNode>(cur.children());
        ParseNode child = (ParseNode)parseChildren.get(0);
        if (this.is(child, "'FOR'")) {
            ValueNode.IdentifierNode idx = children.get(1).asIdentifierNode();
            if (!this.is((ParseNode)parseChildren.get(2), "'IN'")) {
                throw new IllegalArgumentException("Expecting IN after FOR");
            }
            if (!this.is((ParseNode)parseChildren.get(3), "loop_prm_spec")) {
                throw new IllegalArgumentException("Expecting loop_prm_spec after FOR <index> IN");
            }
            symbols.define(idx.getName(), FOR_IDX_TYPE, idx.getPos());
        } else if (!this.is(child, "'WHILE'")) {
            throw new NullPointerException();
        }
        return null;
    }

    private ValueNode.StringNode parse_decl_id(ParseNode cur, List<ValueNode> children, SymbolTable symbols, int depth) {
        return new ValueNode.StringNode("identifier", cur, this.src.get((int)cur.from).content);
    }

    private ValueNode parse_division(ParseNode cur, List<ValueNode> children, SymbolTable symbols, int depth) {
        symbols.exceptions(EnumSet.of(PlsqlException.ZERO_DIVIDE), cur);
        return null;
    }

    private ValueNode.StringNode parse_lexicalToken(ParseNode cur, List<ValueNode> children, SymbolTable symbols, int depth) {
        return new ValueNode.StringNode(cur.content(0), cur, this.src.get((int)cur.from).content);
    }

    private ValueNode.StringNode parse_lexicalTokensAll(ParseNode cur, List<ValueNode> children, SymbolTable symbols, int depth) {
        return new ValueNode.StringNode(cur.content(0), cur, cur.content(this.src));
    }

    private ValueNode.TypeNode parse_constrained_type(ParseNode cur, List<ValueNode> children, SymbolTable symbols, int depth) {
        ValueNode.TypeNode typeNode = children.get(0).asTypeNode();
        ValueNode constraint = children.get(1);
        return typeNode;
    }

    private ValueNode.TypeNode parse_datetime_link_expanded_n(ParseNode cur, List<ValueNode> children, SymbolTable symbols, int depth) {
        return new ValueNode.TypeNode("type", cur, new PlsqlType.Scalar(PlsqlType.DataType.DATE));
    }

    private ValueNode.TypeNode parse_unconstrained_type_wo_datetime(ParseNode cur, List<ValueNode> children, SymbolTable symbols, int depth) {
        ArrayList<ParseNode> nodes = new ArrayList<ParseNode>(cur.children());
        StringBuffer sb = new StringBuffer(cur.content(0));
        for (int i = 1; i < nodes.size(); ++i) {
            sb.append(" " + ((ParseNode)nodes.get(i)).content(0));
        }
        PlsqlType.DataType datatype = this.ScalarDataTypeMap.get(sb.toString());
        if (datatype != null) {
            return new ValueNode.TypeNode("type", cur, new PlsqlType.Scalar(datatype));
        }
        SqlInjectionGraph.debugln(Debug.PARSE, "Didn't recognize " + cur.content(0) + "(" + sb.toString() + ") as a type");
        throw new IllegalArgumentException("Failed to parse " + cur + " as 'type'");
    }

    private ValueNode parse_name(ParseNode cur, List<ValueNode> children, SymbolTable symbols, int depth) {
        if (children.size() == 1) {
            return children.get(0);
        }
        Object name = "";
        String separator = "";
        ValueNode sample = null;
        for (ValueNode child : children) {
            if (child == null) continue;
            name = (String)name + separator + child.asStringNode().getName();
            separator = ".";
            sample = child;
        }
        if (sample != null) {
            return new ValueNode.StringNode("name", sample.getPos(), (String)name);
        }
        return null;
    }

    private ValueNode.StringNode parse_null(ParseNode cur, List<ValueNode> children, SymbolTable symbols, int depth) {
        return null;
    }

    private ValueNode parse_numeric_literal(ParseNode cur, List<ValueNode> children, SymbolTable symbols, int depth) {
        assert (children.size() == 0);
        assert (cur.to == cur.from + 1);
        double val = Double.valueOf(this.src.get((int)cur.from).content);
        PlsqlType.Scalar type = val == Math.floor(val) && !Double.isInfinite(val) ? new PlsqlType.Scalar(PlsqlType.DataType.PLS_INTEGER) : new PlsqlType.Scalar(PlsqlType.DataType.BINARY_DOUBLE);
        return new ValueNode.ExprNode("expr", cur, type, Collections.emptyList());
    }

    private ValueNode.TypeNode parse_object_d_rhs(ParseNode cur, List<ValueNode> children, SymbolTable symbols, int depth) {
        return children.get(0).asTypeNode();
    }

    private ValueNode.StringNode parse_grammarToken(ParseNode cur, List<ValueNode> children, SymbolTable symbols, int depth) {
        return new ValueNode.StringNode(cur.content(0), cur, cur.content(0));
    }

    private ValueNode parse_paren_expr_list(ParseNode cur, List<ValueNode> children, SymbolTable symbols, int depth) {
        ValueNode.MultiNode<ValueNode> ret = new ValueNode.MultiNode<ValueNode>("paren_expr_list", cur);
        if (children.get(0) != null || children.get(children.size() - 1) != null) {
            throw new IllegalStateException("parse_paren_expr_list: Unexpected values " + children.get(0) + ", " + children.get(children.size() - 1) + " while parsing " + cur);
        }
        for (int i = 1; i < children.size() - 1; ++i) {
            ret.add(children.get(i));
        }
        return ret;
    }

    private ValueNode parse_parm_list_opt(ParseNode cur, List<ValueNode> children, SymbolTable symbols, int depth) {
        ValueNode firstChild = null;
        ValueNode.MultiNode<ValueNode> mergedChildren = null;
        for (ValueNode child : children) {
            if (child == null) continue;
            if (firstChild == null) {
                firstChild = child;
                continue;
            }
            if (mergedChildren == null) {
                if (firstChild instanceof ValueNode.MultiNode) {
                    mergedChildren = (ValueNode.MultiNode)firstChild;
                    mergedChildren.add(child);
                    continue;
                }
                if (child instanceof ValueNode.MultiNode) {
                    mergedChildren = (ValueNode.MultiNode)child;
                    mergedChildren.add(firstChild);
                    continue;
                }
                mergedChildren = new ValueNode.MultiNode<ValueNode>(firstChild.nonterm, firstChild.getPos());
                mergedChildren.add(firstChild);
                mergedChildren.add(child);
                continue;
            }
            mergedChildren.add(child);
        }
        if (mergedChildren != null) {
            return mergedChildren;
        }
        return firstChild;
    }

    private ValueNode parse_prm_spec(ParseNode cur, List<ValueNode> children, SymbolTable symbols, int depth) {
        this.print(cur, depth);
        ValueNode[] values = this.orderedParse(cur, children, "identifier", "type", null);
        if (values[0] == null || values[1] == null || values[2] != null) {
            throw new IllegalArgumentException("Failed to parse parse_prm_spec from " + cur);
        }
        EnumSet<ParameterMode> modes = EnumSet.noneOf(ParameterMode.class);
        for (ParseNode child : cur.children()) {
            String childString = child.content(0);
            switch (childString = childString.replaceAll("[']", "")) {
                case "IN": 
                case "OUT": 
                case "NOCOPY": {
                    modes.add(ParameterMode.valueOf(childString));
                    SqlInjectionGraph.debugln(Debug.PARSE, "Mode " + childString);
                    break;
                }
            }
        }
        ValueNode.StringNode declId = values[0].asStringNode();
        ValueNode.TypeNode typeNode = values[1].asTypeNode();
        PlsqlType type = typeNode.getType();
        ValueNode.IdentifierNode id = new ValueNode.IdentifierNode(declId, declId.getName(), type);
        id.setModes(modes);
        return id;
    }

    private ValueNode parse_return(ParseNode cur, List<ValueNode> children, SymbolTable symbols, int depth) {
        ValueNode.ExprNode exprNode = null;
        Iterator nodeItr = cur.children().iterator();
        for (ValueNode child : children) {
            ParseNode node = (ParseNode)nodeItr.next();
            if (child == null || this.is(node, "'RETURN'")) continue;
            if (this.is(node, "expr")) {
                exprNode = child.asExprNode(symbols);
                continue;
            }
            if (child.nonterm.equals("';'")) continue;
            throw new NullPointerException();
        }
        symbols.retrn(exprNode);
        return null;
    }

    private ValueNode parse_range(ParseNode cur, List<ValueNode> children, SymbolTable symbols, int depth) {
        return null;
    }

    private ValueNode parse_string_literal(ParseNode cur, List<ValueNode> children, SymbolTable symbols, int depth) {
        assert (children.size() == 0);
        assert (cur.to == cur.from + 1);
        int size = this.src.get((int)cur.from).content.length();
        PlsqlType.Scalar type = new PlsqlType.Scalar(PlsqlType.DataType.CHAR, size);
        return new ValueNode.ExprNode("expr", cur, type, Collections.emptyList());
    }

    private ValueNode parse_typical_expr(ParseNode cur, List<ValueNode> children, SymbolTable symbols, int depth) {
        ValueNode.ExprNode firstChild = null;
        ValueNode.ExprNode mergedChildren = null;
        for (ValueNode child : children) {
            EnumSet<PlsqlException> exceptions;
            if (child == null) continue;
            ValueNode.ExprNode exp = child.asExprNode(symbols);
            if (firstChild == null) {
                firstChild = exp;
                continue;
            }
            if (mergedChildren == null) {
                mergedChildren = new ValueNode.ExprNode("expr", cur, firstChild.getType(), new ArrayList<Usage>(firstChild.getUsages()));
            }
            if ((exceptions = mergedChildren.merge(exp)).isEmpty()) continue;
            symbols.exceptions(exceptions, cur);
        }
        if (mergedChildren != null) {
            return mergedChildren;
        }
        return firstChild;
    }

    private void initialize() {
        int priority = 0;
        for (DispatchInfo di : this.dispatchInfoData) {
            if (di.priority == 100000) {
                di.priority = priority++;
            }
            this.dispatch.put(di.nonterm, di);
        }
        for (DispatchInfo di : this.dispatch.values()) {
            if (di.parser == null) {
                DispatchInfo alt = this.dispatch.get(di.equiv);
                di.parser = alt.parser;
                di.beforeChild = alt.beforeChild;
            }
            if (di.equiv == null || di.nonterm.equals(di.equiv)) continue;
            this.acceptableSubstitutions.put(di.nonterm + ":" + di.equiv, (value, symbols) -> value.asExprNode((SymbolTable)symbols));
        }
        DispatchInfo typeDi = this.dispatch.get("unconstrained_type_wo_datetime");
        for (PlsqlType.DataType datatype : EnumSet.allOf(PlsqlType.DataType.class)) {
            String word = "'" + datatype.toString() + "'";
            this.ScalarDataTypeMap.put(word, datatype);
            DispatchInfo wordDi = new DispatchInfo(word, null, typeDi.parser, typeDi.beforeChild);
            wordDi.priority = 0;
            this.dispatch.put(word, wordDi);
        }
        this.acceptableSubstitutions.put("identifier:expr", (value, symbols) -> value.asExprNode((SymbolTable)symbols));
        this.acceptableSubstitutions.put("and_expr:expr", null);
        this.acceptableSubstitutions.put("arith_expr:expr", null);
        this.acceptableSubstitutions.put("term:expr", null);
        this.acceptableSubstitutions.put("prm_spec_unconstrained_type:type", null);
        this.acceptableSubstitutions.put("unconstrained_type_wo_datetime_wo_national:type", null);
        this.acceptableSubstitutions.put("unconstrained_type_wo_national:type", null);
    }

    private static void debugln(Debug msgType, String msg) {
    }

    private static void debug(Debug msgType, String msg) {
    }

    private static enum Debug {
        SYM_WRITE,
        SYM_READ,
        PARSE,
        DATAFLOW,
        LOOP_AND_BLOCK,
        IF_ENDIF,
        ASSIGNMENT,
        EXCEPTION,
        WARNING,
        MISC;

    }

    static enum ParameterMode {
        IN,
        OUT,
        NOCOPY;

    }

    private class DispatchInfo {
        String nonterm;
        String equiv;
        int priority;
        NodeParser parser;
        NodeParser beforeChild;

        private DispatchInfo(String nonterm, String equiv, int priority, NodeParser parser, NodeParser beforeChild) {
            this.nonterm = nonterm;
            this.equiv = equiv == null ? nonterm : equiv;
            this.priority = priority;
            this.parser = parser;
            this.beforeChild = beforeChild;
        }

        private DispatchInfo(String nonterm, String equiv, NodeParser parser) {
            this(nonterm, equiv, 100000, parser, null);
        }

        private DispatchInfo(String nonterm, String equiv, NodeParser parser, NodeParser beforeChild) {
            this(nonterm, equiv, 100000, parser, beforeChild);
        }

        public String toString() {
            return this.nonterm + (String)(this.equiv == null ? " " : " (= " + this.equiv + ") ") + this.beforeChild + " then " + this.parser;
        }
    }

    private static enum BasicDState {
        IDENTIFIER,
        TYPE,
        DEFAULT,
        END;

    }

    private static enum SubprgBodyState {
        SEEKING_SUBPRG_SPEC,
        SEEKING_BEGIN,
        SEEKING_EXCEPTION_HANDLERS,
        SKIP_TO_END;

    }

    private static enum SubprgState {
        SEEKING_FUNC_PROC,
        SEEKING_NAME,
        SEEKING_FML_PART,
        SEEKING_RETURN,
        SEEKING_END;

    }

    private static enum LoopState {
        SEEKING_LOOP,
        LOOP_BODY,
        SEEKING_END;

    }

    private static enum IfState {
        SEEKING_IF,
        CONDITIONAL_EXPR,
        SEEKING_THEN,
        THEN_STATEMENTS,
        ELSE_STATEMENTS,
        SEEKING_ELSIF_ELSE_END;

    }

    static class ExceptionHandler {
        private final EnumSet<PlsqlException> exceptions;
        private final boolean others;
        private final HashMap<String, Usage> namesRefed;
        private final HashSet<Usage> flowedSources;

        ExceptionHandler(EnumSet<PlsqlException> exceptions, boolean others, HashMap<String, Usage> namesRefed) {
            this.exceptions = exceptions;
            this.others = others;
            this.namesRefed = namesRefed;
            this.flowedSources = new HashSet();
        }

        EnumSet<PlsqlException> getExceptions() {
            return this.exceptions;
        }

        boolean isOthers() {
            return this.others;
        }

        HashMap<String, Usage> getNamesRefed() {
            return this.namesRefed;
        }

        public String toString() {
            return "{" + this.exceptions + " " + this.others + "}";
        }
    }

    @FunctionalInterface
    private static interface NodeParser {
        public ValueNode parse(ParseNode var1, List<ValueNode> var2, SymbolTable var3, int var4);
    }
}

