/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app.injection;

import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import oracle.dbtools.app.injection.Dotted;
import oracle.dbtools.app.injection.LoadDbRefs;
import oracle.dbtools.app.injection.Loc;
import oracle.dbtools.app.injection.PlsqlException;
import oracle.dbtools.app.injection.PlsqlType;
import oracle.dbtools.app.injection.PredefinedConstants;
import oracle.dbtools.app.injection.SqlInjectionAnalysisFailure;
import oracle.dbtools.app.injection.SqlInjectionGraph;
import oracle.dbtools.app.injection.Symbol;
import oracle.dbtools.app.injection.Usage;
import oracle.dbtools.app.injection.ValueNode;
import oracle.dbtools.parser.ParseNode;

class SymbolTable
extends Symbol {
    private static final List<String> collectionMethods = Arrays.asList("DELETE", "TRIM", "EXTEND", "EXISTS", "FIRST", "LAST", "COUNT", "LIMIT", "PRIOR", "NEXT");
    private final ScopeType scopeType;
    private final SymbolTable enclosingScope;
    private final Dotted dbPackage;
    private final SymbolTable topScope;
    private final HashMap<String, SymbolTable> schemas;
    private String currentUser;
    private SymbolTable currentUserScope;
    private final LinkedHashMap<String, Symbol> symbols;
    private LoadDbRefs loadDbRefs;
    private Metadata meta;
    private final Deque<Metadata> metadataStack;
    private int nSqlInjectionAnalysisFailures = 0;

    SymbolTable() {
        this("", null, ScopeType.TOPLEVEL, new Loc(new Dotted("<TOP LEVEL>")));
        this.loadDbRefs = null;
    }

    SymbolTable(String name, SymbolTable enclosingScope, ScopeType scopeType, Loc loc) {
        this(name, enclosingScope, scopeType, new PlsqlType.Scope(), loc);
    }

    SymbolTable(String name, SymbolTable enclosingScope, ScopeType scopeType, PlsqlType plsqlType, Loc loc) {
        this(null, null, name, enclosingScope, scopeType, plsqlType, loc);
    }

    SymbolTable(String owner, String packageName, String name, SymbolTable enclosingScope, ScopeType scopeType, PlsqlType plsqlType, Loc loc) {
        super(enclosingScope, name, plsqlType, loc == null ? new Loc(new Dotted("(?)")) : loc, null);
        this.dbPackage = owner != null && packageName != null && owner.length() > 0 && packageName.length() > 0 ? new Dotted(owner, packageName) : null;
        this.scopeType = scopeType;
        assert (name != null);
        assert (name.length() > 0 || scopeType != ScopeType.SCHEMA);
        this.enclosingScope = enclosingScope;
        if (enclosingScope == null) {
            this.schemas = new HashMap();
        } else {
            this.schemas = enclosingScope.schemas;
            this.loadDbRefs = enclosingScope.loadDbRefs;
        }
        this.symbols = new LinkedHashMap();
        this.metadataStack = new ArrayDeque<Metadata>();
        if (enclosingScope != null) {
            this.meta = new Metadata(enclosingScope.meta);
            this.topScope = enclosingScope.topScope == null ? enclosingScope : enclosingScope.topScope;
            this.currentUser = null;
            this.currentUserScope = null;
        } else {
            this.topScope = null;
            this.meta = new Metadata();
        }
        if (this.loadDbRefs == null && this.topScope != null) {
            this.loadDbRefs = this.topScope.loadDbRefs;
        }
        if (scopeType == ScopeType.SCHEMA && this.schemas.get(name) == null) {
            this.schemas.put(name, this);
        }
    }

    void setLoadDbRefs(LoadDbRefs loadDbRefs) {
        this.loadDbRefs = loadDbRefs;
        if (this.enclosingScope != null) {
            this.enclosingScope.setLoadDbRefs(loadDbRefs);
        }
        if (this.topScope != null) {
            this.enclosingScope.setLoadDbRefs(loadDbRefs);
        }
    }

    SymbolTable getMakeSchemaPackage(String schema, String packageName) {
        packageName = SymbolTable.canonicalize(packageName);
        SymbolTable ret = null;
        SymbolTable schemaTable = this.getMakeSchema(schema);
        Symbol packageSymbol = schemaTable.getLocalDeclaration(packageName);
        if (packageSymbol != null && !(packageSymbol instanceof SymbolTable)) {
            throw new SqlInjectionAnalysisFailure(schema + "." + packageName + " is not a package but " + packageSymbol);
        }
        ret = packageSymbol == null ? new SymbolTable(schema, packageName, packageName, schemaTable, ScopeType.PACKAGE, new PlsqlType.Scope(), null) : (SymbolTable)packageSymbol;
        return ret;
    }

    SymbolTable getMakeSchema(String schema) {
        SymbolTable ret = this.schemas.get(schema = SymbolTable.canonicalize(schema));
        if (ret == null) {
            SymbolTable top = this;
            while (top.enclosingScope != null) {
                top = top.enclosingScope;
            }
            ret = new SymbolTable(schema, top, ScopeType.SCHEMA, null);
            this.schemas.put(schema, ret);
        }
        return ret;
    }

    private SymbolTable getPackage(String schema, String pkg) {
        SymbolTable schemaScope = this.schemas.get(schema);
        if (this.schemas == null) {
            return schemaScope;
        }
        return (SymbolTable)schemaScope.symbols.get(pkg);
    }

    void setCurrentUser(String currentUser) {
        if (this.topScope != null) {
            this.topScope.setCurrentUser(currentUser);
            return;
        }
        if (currentUser == null || currentUser.length() == 0) {
            return;
        }
        this.currentUser = currentUser;
        this.currentUserScope = this.getMakeSchema(currentUser);
    }

    String getCurrentUser() {
        if (this.topScope == null) {
            return this.currentUser;
        }
        return this.topScope.getCurrentUser();
    }

    SymbolTable getCurrentUserScope() {
        if (this.topScope == null) {
            return this.currentUserScope;
        }
        return this.topScope.getCurrentUserScope();
    }

    SymbolTable getTopScope() {
        return this.topScope;
    }

    ScopeType getScopeType() {
        return this.scopeType;
    }

    Symbol define(Symbol symbol, Loc loc) {
        Symbol prev = this.symbols.put(symbol.name, symbol);
        if (SqlInjectionGraph.Debug.REDEFINITIONS.debug && prev != null) {
            System.out.println("Redefined " + prev + " -> " + symbol);
        }
        if (prev != null) {
            SqlInjectionGraph.Debug.REDEFINITIONS.outln("Redefined " + prev + " -> " + symbol);
        }
        SqlInjectionGraph.Debug.SYM_DEFINE.outln("SymbolTable.define(" + symbol.name + " (" + symbol.getType() + ")@" + loc);
        return symbol;
    }

    public void defineFullyQualified(Dotted dotted, Symbol symbol, Loc loc) {
        assert (dotted.size() == 3);
        assert (symbol.name.equalsIgnoreCase(dotted.get(dotted.size() - 1)));
        SymbolTable scope = this.schemas.get(dotted.get(0));
        scope = (SymbolTable)scope.symbols.get(dotted.get(1));
        scope.define(symbol, loc);
    }

    Usage read(Usage u) {
        Symbol sym = u.getSymbol();
        SymbolTable scope = this;
        while (scope != null) {
            u = scope.meta.read.apply(u);
            if (scope == sym.scope) break;
            scope = scope.enclosingScope;
        }
        return u;
    }

    void write(Usage u) {
        Symbol sym = u.getSymbol();
        SymbolTable scope = this;
        do {
            u = scope.meta.write.apply(u);
        } while (scope != sym.scope && u != null && (scope = scope.enclosingScope) != null);
        if (u != null) {
            sym.assignUsage(u);
        }
    }

    Symbol resolveWithDb(Dotted dotted) throws SqlInjectionAnalysisFailure {
        ResolvedSymbol rs = this.resolveDotted(dotted);
        if (rs == null) {
            throw new SqlInjectionAnalysisFailure("Could not resolve symbol " + dotted);
        }
        if (rs.resolved()) {
            return rs.symbol;
        }
        if (rs.symbol instanceof SymbolTable && rs.dotted.size() == 1) {
            SymbolTable scope = (SymbolTable)rs.symbol;
            String owner = "";
            String packageName = scope.name;
            if (scope.enclosingScope != null) {
                owner = scope.enclosingScope.name;
            }
            if (packageName.length() > 0 && owner.length() > 0) {
                try {
                    this.loadDbRefs.loadDbSymbol(this, owner, packageName, rs.dotted.get(0));
                    rs = this.resolveDotted(dotted);
                }
                catch (SQLException e) {
                    throw new SqlInjectionAnalysisFailure("SQL error", e);
                }
            }
        }
        if (!rs.resolved()) {
            throw new SqlInjectionAnalysisFailure(dotted + " not found in database");
        }
        return rs.symbol;
    }

    ResolvedSymbol resolveDotted(Dotted dotted) throws SqlInjectionAnalysisFailure {
        SymbolTable userScope;
        if (dotted.size() < 1) {
            return new ResolvedSymbol(dotted, this);
        }
        int deadman = 10000;
        String nextDot = dotted.get(0);
        SymbolTable scope = this;
        Symbol sym = scope.getLocalDeclaration(nextDot);
        while (sym == null && scope.enclosingScope != null) {
            if (--deadman < 0) {
                throw new InternalError("Scope loop detected");
            }
            scope = scope.enclosingScope;
            sym = scope.getLocalDeclaration(nextDot);
        }
        if (sym == null && (userScope = this.getCurrentUserScope()) != null) {
            scope = userScope;
            sym = userScope.getLocalDeclaration(nextDot);
        }
        if (sym == null && dotted.size() == 1) {
            ResolvedSymbol constSym = PredefinedConstants.constants.get(nextDot);
            if (constSym != null) {
                return constSym;
            }
            scope = this.getPackage("SYS", "STANDARD");
            if (scope != null) {
                sym = scope.getLocalDeclaration(nextDot);
            }
        }
        if (sym == null && !nextDot.equals("SYS")) {
            scope = this.schemas.get("SYS");
            sym = scope.getLocalDeclaration(nextDot);
        }
        if (sym == null) {
            scope = this;
            while (scope != null) {
                if (--deadman < 0) {
                    throw new InternalError("Scope loop");
                }
                if (scope.isDbPackage()) {
                    return new ResolvedSymbol(new Dotted(dotted, 1), Symbol.createSymbolForType(scope, nextDot, PlsqlType.dangerousType(), null, null));
                }
                scope = scope.enclosingScope;
            }
            throw new SqlInjectionAnalysisFailure(SqlInjectionAnalysisFailure.SqlInjectionFailureTypes.SAF_BAD_PARSE, dotted);
        }
        int dotIdx = 1;
        scope = null;
        block11: while (dotIdx < dotted.size()) {
            if (--deadman < 100 && deadman < 0) {
                throw new InternalError("Excessive looping");
            }
            nextDot = dotted.get(dotIdx);
            switch (sym.getType().getTypeClass()) {
                case FUNCTION: {
                    PlsqlType resultType;
                    Symbol.FunctionSym func = (Symbol.FunctionSym)sym;
                    PlsqlType.Function.FuncFormalResolved resolved = func.getType().resolveArguments(Collections.emptyList());
                    if (resolved == null || (sym = Symbol.createSymbolForType(null, "functionCall", resultType = resolved.getResultParm().getType(), null, null)).getType().getTypeClass() != PlsqlType.TYPECLASS.FUNCTION) continue block11;
                    break block11;
                }
                case COLLECTION: {
                    if (collectionMethods.contains(nextDot)) {
                        sym = new Symbol(null, nextDot, new PlsqlType.Scalar(PlsqlType.ScalarType.NUMBER), null, null);
                    }
                    ++dotIdx;
                    break block11;
                }
                case RECORD: {
                    SymbolTable record = (SymbolTable)sym;
                    Symbol field = record.getLocalDeclaration(nextDot);
                    if (field == null) break block11;
                    sym = field;
                    ++dotIdx;
                    continue block11;
                }
                case EXCEPTION: 
                case SCALAR: {
                    if (dotIdx >= dotted.size() - 1) break block11;
                    throw new SqlInjectionAnalysisFailure("Resolving " + dotted + " had left-over component(s) ");
                }
                case SCOPE: {
                    sym = ((SymbolTable)sym).getLocalDeclaration(nextDot);
                    if (sym != null) {
                        ++dotIdx;
                        continue block11;
                    }
                    SymbolTable newScope = (SymbolTable)sym;
                    String owner = "";
                    String packageName = newScope.name;
                    if (newScope.enclosingScope != null) {
                        owner = newScope.enclosingScope.name;
                    }
                    if (packageName.length() > 0 && owner.length() > 0) {
                        try {
                            sym = this.loadDbRefs.loadDbSymbol(this, owner, packageName, nextDot);
                        }
                        catch (SQLException e) {
                            throw new SqlInjectionAnalysisFailure("SQL error", e);
                        }
                    }
                    if (sym == null) {
                        throw new SqlInjectionAnalysisFailure(dotted + " not found in database");
                    }
                    ++dotIdx;
                    continue block11;
                }
                default: {
                    throw new IllegalStateException("Unexpected TypeClass " + sym.getType().getTypeClass());
                }
            }
        }
        assert (sym != null);
        return new ResolvedSymbol(new Dotted(dotted, dotIdx), sym);
    }

    Symbol getLocalDeclaration(String name) {
        Symbol symbol = this.symbols.get(name = SymbolTable.canonicalize(name));
        if (symbol == null && this.isDbPackage()) {
            try {
                this.loadDbRefs.loadDbSymbol(this, this.dbPackage.get(0), this.dbPackage.get(1), name);
                symbol = this.symbols.get(name);
            }
            catch (SQLException e) {
                throw new SqlInjectionAnalysisFailure("SQL error", e);
            }
        }
        return symbol;
    }

    Symbol getLocalDeclarationNoDB(String name) {
        Symbol symbol = this.symbols.get(name);
        return symbol;
    }

    void cont() {
        this.meta.cont.accept(this);
    }

    void exit() {
        this.meta.exit.accept(this);
    }

    void retrn(ValueNode.ExprNode expr) {
        this.meta.retrn.accept(expr, this);
    }

    public SymbolTable getEnclosingScope() {
        return this.enclosingScope;
    }

    public Dotted getDotted() {
        Dotted ret = this.enclosingScope == null ? new Dotted() : this.enclosingScope.getDotted();
        if (this.scopeType != ScopeType.TOPLEVEL && this.name.length() > 0) {
            ret.add(this.name);
        }
        return ret;
    }

    Map<String, Symbol> getSymbols() {
        return this.symbols;
    }

    Dotted getDbPackage() {
        return this.dbPackage;
    }

    boolean isDbPackage() {
        return this.dbPackage != null;
    }

    public BiConsumer<ValueNode.ExprNode, SymbolTable> hookRetrn(BiConsumer<ValueNode.ExprNode, SymbolTable> retrnHook) {
        BiConsumer<ValueNode.ExprNode, SymbolTable> old = this.meta.retrn;
        this.meta.retrn = retrnHook;
        return old;
    }

    public static String canonicalize(String name) {
        return name.toUpperCase();
    }

    public void setReadHook(Function<Usage, Usage> readHook) {
        this.meta.read = readHook;
    }

    public Function<Usage, Usage> getReadHook() {
        return this.meta.read;
    }

    public void setWriteHook(Function<Usage, Usage> writeHook) {
        this.meta.write = writeHook;
    }

    public Function<Usage, Usage> getWriteHook() {
        return this.meta.write;
    }

    public Consumer<SymbolTable> hookContinue(Consumer<SymbolTable> contHook) {
        Consumer<SymbolTable> old = this.meta.cont;
        this.meta.cont = contHook;
        return old;
    }

    public Consumer<SymbolTable> hookExit(Consumer<SymbolTable> exitHook) {
        Consumer<SymbolTable> old = this.meta.exit;
        this.meta.exit = exitHook;
        return old;
    }

    public BiConsumer<EnumSet<PlsqlException>, ParseNode> hookExceptions(BiConsumer<EnumSet<PlsqlException>, ParseNode> exceptionsHook) {
        BiConsumer<EnumSet<PlsqlException>, ParseNode> old = this.meta.exceptions;
        this.meta.exceptions = exceptionsHook;
        return old;
    }

    public void exceptions(EnumSet<PlsqlException> exceptions, ParseNode pos) {
        this.meta.exceptions.accept(exceptions, pos);
    }

    public void pushMetadata() {
        this.metadataStack.push(new Metadata(this.meta));
    }

    public void popMetadata() {
        this.meta = this.metadataStack.pop();
    }

    void dump(boolean global) {
        String ourName;
        if (this.enclosingScope == null) {
            ourName = "[Top]";
        } else {
            ourName = "[NOT FOUND in enclosing";
            for (Map.Entry<String, Symbol> e : this.enclosingScope.symbols.entrySet()) {
                if (!e.getValue().equals(this)) continue;
                ourName = e.getKey();
                break;
            }
        }
        System.out.println(ourName + " " + this.scopeType + " meta[" + this.metadataStack.size() + "]");
        for (Map.Entry<String, Symbol> nameEntry : this.symbols.entrySet()) {
            String name = nameEntry.getKey();
            Symbol symbol = nameEntry.getValue();
            System.out.println(name + ": " + symbol);
        }
        if (global && this.enclosingScope != null) {
            this.enclosingScope.dump(global);
        }
        if (this.enclosingScope == null) {
            System.out.println("Schemas:");
            for (String schema : this.schemas.keySet()) {
                System.out.print(" " + schema);
            }
            System.out.println();
        }
    }

    static class RecordSym
    extends SymbolTable {
        PlsqlType.Record record;

        RecordSym(String name, SymbolTable enclosingScope, LinkedHashMap<String, PlsqlType> fieldList, Loc loc) {
            this(name, enclosingScope, new PlsqlType.Record(fieldList), loc);
        }

        RecordSym(String name, SymbolTable enclosingScope, PlsqlType.Record record, Loc loc) {
            super(name, enclosingScope, ScopeType.RECORD, record, loc);
            this.record = record;
            if (record.fields == null) {
                return;
            }
            for (Map.Entry<String, PlsqlType> field : record.fields.entrySet()) {
                String fieldName = field.getKey();
                PlsqlType type = field.getValue();
                Symbol.createSymbolForType(this, fieldName, type, loc, null);
            }
        }
    }

    class Metadata {
        Usage loopContinue;
        Usage loopExit;
        Function<Usage, Usage> write;
        Function<Usage, Usage> read;
        Consumer<SymbolTable> cont;
        Consumer<SymbolTable> exit;
        BiConsumer<ValueNode.ExprNode, SymbolTable> retrn;
        BiConsumer<EnumSet<PlsqlException>, ParseNode> exceptions;

        private Metadata() {
            this.loopContinue = null;
            this.loopExit = null;
            this.write = usage -> usage;
            this.read = usage -> usage;
            this.cont = a -> {};
            this.exit = a -> {};
            this.retrn = (a, b) -> {};
            this.exceptions = (a, b) -> {};
        }

        private Metadata(Metadata meta) {
            this.loopContinue = meta.loopContinue;
            this.loopExit = meta.loopExit;
            this.write = meta.write;
            this.read = meta.read;
            this.cont = meta.cont;
            this.exit = meta.exit;
            this.retrn = meta.retrn;
            this.exceptions = meta.exceptions;
        }
    }

    static class ResolvedSymbol {
        Dotted dotted;
        Symbol symbol;

        public ResolvedSymbol(Dotted dotted, Symbol symbol) {
            this.dotted = dotted;
            this.symbol = symbol;
        }

        boolean resolved() {
            return this.symbol != null && (this.dotted == null || this.dotted.size() == 0);
        }

        public String toString() {
            return "(" + this.dotted + ": " + this.symbol + ")";
        }
    }

    static enum ScopeType {
        TOPLEVEL,
        SCHEMA,
        PACKAGE,
        RECORD,
        FUNCTION,
        BLOCK;

    }
}

