/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.bookmarks;

import java.net.URL;
import oracle.ide.Context;
import oracle.ide.bookmarks.Bookmark;
import oracle.ide.bookmarks.BookmarkConstants;
import oracle.ide.bookmarks.BookmarkManager;
import oracle.ide.bookmarks.URLBookmark;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Node;

final class BookmarkController
implements Controller {
    BookmarkController() {
    }

    public boolean update(IdeAction action, Context context) {
        int commandId = action.getCommandId();
        BookmarkManager bookmarkManager = BookmarkManager.getBookmarkManager();
        if (commandId == BookmarkConstants.NEXT_BOOKMARK_CMD_ID || commandId == BookmarkConstants.PREV_BOOKMARK_CMD_ID) {
            action.setEnabled(bookmarkManager.hasNextPrevious());
            return true;
        }
        if (commandId == BookmarkConstants.REMOVE_BOOKMARKS_FROM_FILE_CMD_ID) {
            Node node = context.getNode();
            if (node == null || node.getURL() == null) {
                action.setEnabled(false);
                return true;
            }
            URL url = node.getURL();
            boolean enabled = false;
            for (Bookmark bookmark : bookmarkManager.getAllBookmarks()) {
                if (!(bookmark instanceof URLBookmark) || !((URLBookmark)bookmark).getURL().equals(url)) continue;
                enabled = true;
            }
            action.setEnabled(enabled);
            return true;
        }
        if (commandId == BookmarkConstants.REMOVE_ALL_BOOKMARKS_CMD_ID) {
            action.setEnabled(BookmarkManager.getBookmarkManager().getAllBookmarks().size() > 0);
            return true;
        }
        if (commandId == BookmarkConstants.VIEW_BOOKMARKS_CMD_ID) {
            action.setEnabled(true);
            return true;
        }
        int number = BookmarkConstants.getCmdIDGotoBookmarkNumber(action.getCommandId());
        if (number > -1) {
            Bookmark bookmark = BookmarkManager.getBookmarkManager().getNumberedBookmark(number);
            action.setEnabled(bookmark != null);
            return true;
        }
        return false;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int commandId = action.getCommandId();
        if (commandId == BookmarkConstants.VIEW_BOOKMARKS_CMD_ID) {
            Dockable bookmarkDockable = DockStation.getDockStation().findDockable(new ViewId("BOOKMARKS_VIEW_TYPE", "BOOKMARK_VIEW_ID"));
            DockStation.getDockStation().setDockableVisible(bookmarkDockable, true);
            bookmarkDockable.getHostedComponent().requestFocus();
            return true;
        }
        if (commandId == BookmarkConstants.NEXT_BOOKMARK_CMD_ID || commandId == BookmarkConstants.PREV_BOOKMARK_CMD_ID) {
            BookmarkManager.getBookmarkManager().cycleBookmark(context, commandId == BookmarkConstants.NEXT_BOOKMARK_CMD_ID);
            return true;
        }
        if (commandId == BookmarkConstants.REMOVE_BOOKMARKS_FROM_FILE_CMD_ID) {
            Node node = context.getNode();
            if (node == null || node.getURL() == null) {
                return false;
            }
            URL url = node.getURL();
            BookmarkManager bookmarkManager = BookmarkManager.getBookmarkManager();
            for (Bookmark bookmark : bookmarkManager.getAllBookmarks()) {
                if (!(bookmark instanceof URLBookmark) || !((URLBookmark)bookmark).getURL().equals(url)) continue;
                bookmarkManager.removeBookmark(bookmark);
            }
            return true;
        }
        if (commandId == BookmarkConstants.REMOVE_ALL_BOOKMARKS_CMD_ID) {
            BookmarkManager.getBookmarkManager().removeAllBookmarks();
            return true;
        }
        int number = BookmarkConstants.getCmdIDGotoBookmarkNumber(action.getCommandId());
        if (number > -1) {
            BookmarkManager.getBookmarkManager().gotoNumberedBookmark(number);
            return true;
        }
        return false;
    }
}

