/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.bookmarks;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.Ide;
import oracle.ide.bookmarks.Bookmarks;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;

public final class BookmarkConstants {
    public static final int TOGGLE_BOOKMARK_CMD_ID = Ide.findOrCreateCmdID((String)"ojb.ToggleBookmarkCommand");
    public static final int VIEW_BOOKMARKS_CMD_ID = Ide.findOrCreateCmdID((String)"ojb.GotoBookmarkCommand");
    public static final int NEXT_BOOKMARK_CMD_ID = Ide.findOrCreateCmdID((String)"ojb.NextBookmarkCommand");
    public static final int PREV_BOOKMARK_CMD_ID = Ide.findOrCreateCmdID((String)"ojb.PreviousBookmarkCommand");
    public static final int REMOVE_BOOKMARKS_FROM_FILE_CMD_ID = Ide.findOrCreateCmdID((String)"ojb.RemoveBookmarksFromFileCommand");
    public static final int REMOVE_ALL_BOOKMARKS_CMD_ID = Ide.findOrCreateCmdID((String)"ojb.RemoveAllBookmarksCommand");
    public static final int NUMBER_OF_QUICK_BOOKMARKS = 10;
    public static final String QUICK_BOOKMARK_TOGGLE_PREFIX = "ojb.ToggleBookmarkCommand";
    public static final String QUICK_BOOKMARK_GOTO_PREFIX = "ojb.GotoBookmarkCommand";
    public static final HighlightStyle BOOKMARK_STYLE;
    private static final String BOOKMARK_STYLE_NAME = "bookmark-style";
    public static final String BOOKMARK_CATEGORY = "bookmark-category";
    private static final List<Integer> gotoNumberList;
    private static final List<Integer> toggleNumberList;

    public static final int getToggleNumberedBookmarkCmdId(int number) {
        return toggleNumberList.get(number);
    }

    public static final int getGoToNumberedBookmarkCmdId(int number) {
        return toggleNumberList.get(number);
    }

    public static final int getCmdIDToggleBookmarkNumber(int cmdID) {
        return toggleNumberList.indexOf(cmdID);
    }

    public static final int getCmdIDGotoBookmarkNumber(int cmdID) {
        return gotoNumberList.indexOf(cmdID);
    }

    static {
        EditorProperties properties = EditorProperties.getProperties();
        HighlightRegistry registry = properties.getHighlightRegistry();
        String translatedName = Bookmarks.get("HIGHLIGHT_NAME");
        BOOKMARK_STYLE = registry.createStyle(BOOKMARK_STYLE_NAME, translatedName, 20, Color.black, new Color(153, 255, 255));
        gotoNumberList = new ArrayList<Integer>();
        toggleNumberList = new ArrayList<Integer>();
        for (int i = 0; i < 10; ++i) {
            gotoNumberList.add(Ide.findOrCreateCmdID((String)(QUICK_BOOKMARK_GOTO_PREFIX + i)));
            toggleNumberList.add(Ide.findOrCreateCmdID((String)(QUICK_BOOKMARK_TOGGLE_PREFIX + i)));
        }
    }
}

