/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.thirdparty.db2;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import oracle.dbtools.connections.db.CustomConnectionCreator;
import oracle.dbtools.raptor.conntypes.RaptorClassLoader;
import oracle.jdbc.OracleDriver;

public class DMDB2ConnectionCreator
extends CustomConnectionCreator {
    public Connection getConnection(Properties props) throws SQLException {
        Connection conn;
        block14: {
            String url;
            String username = props.getProperty("user");
            String password = props.getProperty("password");
            if (!this.hasLength(password) && !this.allowNullPassword()) {
                throw new SQLException(this.getBundle().getString("ERROR_MISSING_PASS"), "");
            }
            String driverClassName = props.getProperty("driver");
            if (!this.hasLength(driverClassName)) {
                driverClassName = this.getDriverClassName(props);
            }
            if (!this.hasLength(url = props.getProperty("customUrl"))) {
                url = this.getConnectionURL(props);
            }
            Driver driver = null;
            try {
                ClassLoader cl = RaptorClassLoader.findClassLoader((String)driverClassName);
                Class<?> cls = Class.forName(driverClassName, true, cl);
                driver = (Driver)cls.newInstance();
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (ClassNotFoundException cne) {
                throw new SQLException(this.getBundle().getString("ERROR_DRIVER_CLASS_NOT_FOUND"));
            }
            catch (Throwable t) {
                SQLException ex = new SQLException(t.getLocalizedMessage());
                ex.initCause(t);
                throw ex;
            }
            Properties jdbcProps = new Properties();
            String role = props.getProperty("role");
            if (this.hasLength(role)) {
                jdbcProps.put("internal_logon", role);
            }
            if (this.hasLength(username)) {
                jdbcProps.put("user", username);
            }
            if (this.hasLength(password)) {
                jdbcProps.put("password", password);
            }
            this.setCustomProperties(props, jdbcProps);
            conn = null;
            try {
                conn = driver.connect(url, jdbcProps);
            }
            catch (UnsatisfiedLinkError e) {
                throw new SQLException(e.getMessage());
            }
            catch (ArrayIndexOutOfBoundsException aie) {
                if (!(driver instanceof OracleDriver)) break block14;
                throw new SQLException(this.getBundle().getString("ERROR_UNSUPPORTED_ORACLE_VERSION"));
            }
        }
        if (conn == null) {
            throw new SQLException(this.getBundle().getString("ERROR_INVALID_URL"));
        }
        return conn;
    }
}

