/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.tests;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBMExtractionController;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.AggrObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;
import oracle.dbtools.crest.swingui.wizards.metadata.DefaultDBMExtractionWizard;
import oracle.dbtools.crest.swingui.wizards.metadata.db2.DBMExtractionWizardDB2;
import oracle.dbtools.crest.swingui.wizards.metadata.db2.v80.DBMExtractionWizardDB2v80;
import oracle.dbtools.crest.swingui.wizards.metadata.odbc.DBMExtractionWizardODBC;
import oracle.dbtools.crest.swingui.wizards.metadata.oracle.DBMExtractionWizardOracle;
import oracle.dbtools.crest.swingui.wizards.metadata.sqlserver.DBMExtractionWizardSqlServer;
import oracle.dbtools.crest.swingui.wizards.metadata.udb.DBMExtractionWizardUDB;
import oracle.dbtools.crest.swingui.wizards.reports.ReportsGenerator;
import oracle.dbtools.crest.swingui.wizards.reports.StandardReportTemplate;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.ide.Ide;
import oracle.jdbc.OracleDriver;

public class Test_AppView {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws SQLException {
        ApplicationView app = ApplicationView.getInstance(false, "D:/Projects/Crest/ide/datamodeler/types");
        ApplicationView.debugMode = true;
        Design des = app.getCurrentDesign();
        RelationalDesign relModel = des.addRelationalDesign();
        des.setRelationalDesign(relModel);
        try {
            ApplicationView.dmInternalsDistDir = "D:/Projects/Crest/ide/datamodeler";
            des.setPropagatePKChahges(false);
            des.setDisableTreeUpdate(true);
            Ide.getProperty((String)"home");
            app.setImporting(true);
            app.getSettings().setDefaultReportsPath("D:/A_reports");
            ApplicationView.canLogging = false;
            DriverManager.registerDriver((Driver)new OracleDriver());
            Connection conn = DriverManager.getConnection("jdbc:oracle:thin:@localhost:1525:fdb11r21", "system", "system");
            DBMExtractionController controller = new DBMExtractionController(relModel.getAppView());
            AbstractDBMExtractionHandler handler = controller.getDBMExtractionHandler(1);
            System.out.println("Start schema tables - " + System.currentTimeMillis());
            ArrayList<DBObject> list = new ArrayList<DBObject>();
            DBObject dbo2 = new DBObject(true, "SH");
            list.add(dbo2);
            List objects = null;
            try {
                objects = handler.getDBObjects(conn, list, "TABLE");
                objects.addAll(handler.getDBObjects(conn, list, "OBJECT"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (objects != null) {
                for (DBObject dbo2 : objects) {
                    dbo2.setSelected(true);
                }
            }
            TimeLog.log("Start import of tables");
            ImportLogger importLog = new ImportLogger();
            try {
                handler.generateDesign(conn, objects, importLog, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            TimeLog.log("Ebd import of tables");
            FileOutputStream fs = new FileOutputStream(new File("d:/temp/A_list_of_objects.xml"));
            ArrayList<DesignObject> tables = new ArrayList<DesignObject>();
            relModel.getTableSet().addAllElementsTo(tables);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fs, "UTF-8");
            BufferedWriter bs = new BufferedWriter(osw, 8192);
            ArrayList<String> filter = null;
            filter = new ArrayList<String>();
            filter.add("");
            filter.add("directorySegmentName");
            filter.add("createdBy");
            filter.add("createdTime");
            filter.add("ownerDesignName");
            filter.add("allowColumnReorder");
            filter.add("existDependencyGenerateInDDl");
            filter.add("partitions");
            List<AggrObject> listAggr = AggrObject.getAggrObjects(tables, relModel.getStorageDesign());
            app.getXMLTransformationManager().transformObjectsToStreamXML(listAggr, fs, filter, true);
            TimeLog.log("End save of tables");
            DDLFileMaker fm = new DDLFileMaker(des, relModel);
            fm.setStorageDesign(relModel.getStorageDesign());
            fm.clearContent();
            ProgressDialog.NullProgressDialog np = new ProgressDialog.NullProgressDialog(app, " ", 0, 0);
            fm.generateDDLContent(np);
            String content = fm.getContent();
            TimeLog.log("End DDL generation of tables");
            System.out.println(content);
            ReportsGenerator g = new ReportsGenerator(app);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("cssFiles", "css/osddm_main.css css/osddm_vs.css");
            map.put("out_format", "html");
            map.put("reports_path", ApplicationView.dmInternalsDistDir + "/reports");
            map.put("subviews", new HashMap());
            map.put("reportCustomFilenName", "all_tables" + System.currentTimeMillis());
            map.put("reportCaption", "Tables report - generated by DM web");
            StandardReportTemplate rt = new StandardReportTemplate("", Table.class, null, false);
            rt.setUseDescriptionInfo(true);
            rt.setUseQuantitativeInfo(true);
            rt.setUseDiagrams(true);
            rt.setUseTableColumns(true);
            rt.setUseTableColumnsComments(true);
            rt.setUseTableConstraints(true);
            rt.setUseTableFKReferredFrom(true);
            rt.setUseTableFKReferringTo(true);
            rt.setUseTableIndexes(true);
            map.put("report_template", rt);
            g.createReport(Table.class, relModel, objects, map, null);
            conn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DefaultDBMExtractionWizard.clearInstance();
            DBMExtractionWizardDB2.clearInstance();
            DBMExtractionWizardDB2v80.clearInstance();
            DBMExtractionWizardODBC.clearInstance();
            DBMExtractionWizardOracle.clearInstance();
            DBMExtractionWizardSqlServer.clearInstance();
            DBMExtractionWizardUDB.clearInstance();
            app.setImporting(false);
            des.setPropagatePKChahges(true);
            des.setDisableTreeUpdate(false);
            ApplicationView.canLogging = true;
        }
    }
}

