/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.logging;

import java.util.ArrayList;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.Extension;
import oracle.dbtools.crest.util.Messages;

public class ImportLogger {
    private ArrayList warnings = new ArrayList();
    private ArrayList errors = new ArrayList();
    private ArrayList notRecognized = new ArrayList();
    private int importedStatemnets;
    private ArrayList failed = new ArrayList();
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String TAB = "\t";

    public ArrayList getErrors() {
        return this.errors;
    }

    public void addFailedStatement(String statement) {
        if (!"".equalsIgnoreCase(statement)) {
            this.failed.add(statement.trim());
        }
    }

    public void addError(String msg) {
        if (!"".equalsIgnoreCase(msg)) {
            this.errors.add(msg.trim());
        }
    }

    public void addWarning(String msg) {
        this.addWarning(msg, false);
    }

    public void addWarning(String msg, boolean ifNotExists) {
        if (!"".equalsIgnoreCase(msg)) {
            if (ifNotExists) {
                if (!this.warningExists(msg.trim())) {
                    this.warnings.add(msg.trim());
                }
            } else {
                this.warnings.add(msg);
            }
        }
    }

    public boolean warningExists(String warning) {
        for (String element : this.warnings) {
            if (!warning.equals(element)) continue;
            return true;
        }
        return false;
    }

    public void setErrors(ArrayList errors) {
        this.errors = errors;
    }

    public int getFailedStatements() {
        return this.failed.size();
    }

    public ArrayList getNotRecognized() {
        return this.notRecognized;
    }

    public void addNotRecognized(String statement) {
        this.notRecognized.add(statement);
    }

    public void setNotRecognized(ArrayList notRecognized) {
        this.notRecognized = notRecognized;
    }

    public int getImportedStatemnets() {
        return this.importedStatemnets;
    }

    public void setImportedStatemnets(int importedStatemnets) {
        this.importedStatemnets = importedStatemnets;
    }

    public void incrementImportedStatements() {
        ++this.importedStatemnets;
    }

    public ArrayList getWarnings() {
        return this.warnings;
    }

    public void setWarnings(ArrayList warnings) {
        this.warnings = warnings;
    }

    public String generateDDLReport(ApplicationView appView, int allStatementsCount) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(Extension.getExtensionVersion()).append(NEWLINE);
        buffer.append(MDConfiguration.getDefaultInstance().get("appName")).append(Messages.getString("ImportLogger.ImportLog")).append(NEWLINE);
        buffer.append(Messages.getString("ImportLogger.DateAndTime")).append(MDConfiguration.timeToString(System.currentTimeMillis())).append(NEWLINE);
        buffer.append(Messages.getString("ImportLogger.DesignName")).append(appView.getDesignName()).append(NEWLINE);
        buffer.append("RDBMS : ").append(appView.getCurrentDesign().getSelectedRDBMSSite()).append(NEWLINE).append(NEWLINE);
        buffer.append(TAB).append(TAB).append(Messages.getString("ImportLogger.AllStatements")).append('\t').append('\t').append(allStatementsCount).append(NEWLINE);
        buffer.append(TAB).append(TAB).append(Messages.getString("ImportLogger.ImportedStatements")).append('\t').append(this.getImportedStatemnets()).append(NEWLINE);
        buffer.append(TAB).append(TAB).append(Messages.getString("ImportLogger.FailedStatements")).append('\t').append('\t').append(this.getFailedStatements()).append(NEWLINE);
        for (int i = 0; i < this.failed.size(); ++i) {
            buffer.append(NEWLINE).append(TAB).append(TAB).append(TAB).append(this.failed.get(i)).append(NEWLINE).append(NEWLINE);
        }
        buffer.append(TAB).append(TAB).append(Messages.getString("ImportLogger.NotRecognizedStatements")).append('\t').append(allStatementsCount - this.getImportedStatemnets() - this.getFailedStatements()).append(NEWLINE);
        if (this.getErrors().size() > 0) {
            buffer.append(NEWLINE);
            buffer.append("<<<<< ERRORS >>>>>").append(NEWLINE);
            for (String error : this.getErrors()) {
                buffer.append(error).append(NEWLINE).append(NEWLINE);
            }
        }
        if (this.getWarnings().size() > 0) {
            buffer.append(NEWLINE);
            buffer.append("<<<<< WARNINGS >>>>>").append(NEWLINE);
            for (String warning : this.getWarnings()) {
                buffer.append(warning).append(NEWLINE).append(NEWLINE);
            }
        }
        if (this.getNotRecognized().size() > 0) {
            buffer.append(NEWLINE);
            buffer.append("<<<<< " + Messages.getString("ExportLogger.NOTRECOGNIZEDL") + " >>>>>").append(NEWLINE);
            for (String notRecognized : this.getNotRecognized()) {
                buffer.append(notRecognized).append(NEWLINE).append(NEWLINE);
            }
        }
        return buffer.toString();
    }

    public String generateVARReport(ApplicationView appView) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(Extension.getExtensionVersion()).append(NEWLINE);
        buffer.append(MDConfiguration.getDefaultInstance().get("appName")).append(Messages.getString("ImportLogger.ImportLog")).append(NEWLINE);
        buffer.append(Messages.getString("ImportLogger.DateAndTime")).append(MDConfiguration.timeToString(System.currentTimeMillis())).append(NEWLINE);
        buffer.append(Messages.getString("ImportLogger.DesignName")).append(appView.getDesignName()).append(NEWLINE);
        if (this.getErrors().size() > 0) {
            buffer.append(NEWLINE);
            buffer.append("<<<<< ERRORS >>>>>").append(NEWLINE);
            for (String error : this.getErrors()) {
                buffer.append(error).append(NEWLINE).append(NEWLINE);
            }
        }
        if (this.getWarnings().size() > 0) {
            buffer.append(NEWLINE);
            buffer.append("<<<<< WARNINGS >>>>>").append(NEWLINE);
            for (String warning : this.getWarnings()) {
                buffer.append(warning).append(NEWLINE).append(NEWLINE);
            }
        }
        if (this.getErrors().size() == 0 && this.getWarnings().size() == 0) {
            buffer.append(NEWLINE).append(Messages.getString("ImportLogger.ImportFinishedSuccess"));
        }
        return buffer.toString();
    }

    public String generateReport(ApplicationView appView) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(Extension.getExtensionVersion()).append(NEWLINE);
        buffer.append(MDConfiguration.getDefaultInstance().get("appName")).append(Messages.getString("ImportLogger.ImportLog")).append(NEWLINE);
        buffer.append(Messages.getString("ImportLogger.DateAndTime")).append(MDConfiguration.timeToString(System.currentTimeMillis())).append(NEWLINE);
        buffer.append(Messages.getString("ImportLogger.DesignName")).append(appView.getDesignName()).append(NEWLINE);
        buffer.append(NEWLINE).append(Messages.getString("ImportLogger.ImportFinished")).append(NEWLINE).append(NEWLINE);
        buffer.append(Messages.getString("ImportLogger.Errors")).append(this.getErrors().size()).append(NEWLINE);
        buffer.append(Messages.getString("ImportLogger.Warnings")).append(this.getWarnings().size()).append(NEWLINE);
        if (this.getErrors().size() > 0) {
            buffer.append(NEWLINE);
            buffer.append("<<<<< ERRORS >>>>>").append(NEWLINE);
            for (String error : this.getErrors()) {
                buffer.append(error).append(NEWLINE);
            }
        }
        if (this.getWarnings().size() > 0) {
            buffer.append(NEWLINE);
            buffer.append("<<<<< WARNINGS >>>>>").append(NEWLINE);
            for (String warning : this.getWarnings()) {
                buffer.append(warning).append(NEWLINE);
            }
        }
        return buffer.toString();
    }
}

