/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.logging;

import java.util.ArrayList;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.Extension;
import oracle.dbtools.crest.util.Messages;

public class ExportLogger {
    private ArrayList warnings = new ArrayList();
    private ArrayList errors = new ArrayList();
    private ArrayList notRecognized = new ArrayList();
    private int exportedStatemnets;
    private ArrayList failed = new ArrayList();
    private String modelName;
    private static final String NEWLINE = System.getProperty("line.separator");

    public ExportLogger() {
    }

    public ExportLogger(String modelName) {
        this.modelName = modelName;
    }

    public ArrayList getErrors() {
        return this.errors;
    }

    public void addFailedStatement(String statement) {
        if (!"".equalsIgnoreCase(statement)) {
            this.failed.add(statement.trim());
        }
    }

    public void addError(String msg) {
        if (!"".equalsIgnoreCase(msg)) {
            this.errors.add(msg.trim());
        }
    }

    public void addWarning(String msg) {
        this.addWarning(msg, false);
    }

    public void addWarning(String msg, boolean ifNotExists) {
        if (!"".equalsIgnoreCase(msg)) {
            if (ifNotExists) {
                if (!this.warningExists(msg.trim())) {
                    this.warnings.add(msg.trim());
                }
            } else {
                this.warnings.add(msg);
            }
        }
    }

    public boolean warningExists(String warning) {
        for (String element : this.warnings) {
            if (!warning.equals(element)) continue;
            return true;
        }
        return false;
    }

    public void setErrors(ArrayList errors) {
        this.errors = errors;
    }

    public int getFailedStatements() {
        return this.failed.size();
    }

    public ArrayList getNotRecognized() {
        return this.notRecognized;
    }

    public void addNotRecognized(String statement) {
        this.notRecognized.add(statement);
    }

    public void setNotRecognized(ArrayList notRecognized) {
        this.notRecognized = notRecognized;
    }

    public int getExportedStatemnets() {
        return this.exportedStatemnets;
    }

    public void setExportedStatemnets(int exportedStatemnets) {
        this.exportedStatemnets = exportedStatemnets;
    }

    public void incrementExportedStatemnets() {
        ++this.exportedStatemnets;
    }

    public ArrayList getWarnings() {
        return this.warnings;
    }

    public void setWarnings(ArrayList warnings) {
        this.warnings = warnings;
    }

    public String generateReport(ApplicationView appView) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(Extension.getExtensionVersion()).append(NEWLINE);
        buffer.append(MDConfiguration.getDefaultInstance().get("appName")).append(Messages.getString("ExportLogger.ExportLog")).append(NEWLINE);
        buffer.append(Messages.getString("ExportLogger.DateAndTime")).append(MDConfiguration.timeToString(System.currentTimeMillis())).append(NEWLINE);
        buffer.append(Messages.getString("ExportLogger.DesignName")).append(appView.getDesignName()).append(NEWLINE);
        buffer.append(Messages.getString("ExportLogger.ModelName")).append(this.modelName).append(NEWLINE);
        buffer.append(NEWLINE).append(Messages.getString("ExportLogger.ExportFinished")).append(NEWLINE).append(NEWLINE);
        buffer.append(Messages.getString("ExportLogger.Errors")).append(this.getErrors().size()).append(NEWLINE);
        buffer.append(Messages.getString("ExportLogger.Warnings")).append(this.getWarnings().size()).append(NEWLINE);
        if (this.getErrors().size() > 0) {
            buffer.append(NEWLINE);
            buffer.append("<<<<< ERRORS >>>>>").append(NEWLINE);
            for (String error : this.getErrors()) {
                buffer.append(error).append(NEWLINE);
            }
        }
        if (this.getWarnings().size() > 0) {
            buffer.append(NEWLINE);
            buffer.append("<<<<< WARNINGS >>>>>").append(NEWLINE);
            for (String warning : this.getWarnings()) {
                buffer.append(warning).append(NEWLINE);
            }
        }
        return buffer.toString();
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }
}

