/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.gui.swing;

import javax.swing.text.Segment;
import org.fife.ui.rsyntaxtextarea.AbstractTokenMaker;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenMap;

public class LogTokenMaker
extends AbstractTokenMaker {
    public static final String SYNTAX_STYLE_LOG = "SYNTAX_STYLE_LOG";
    private int currentTokenStart;
    private int currentTokenType;

    public TokenMap getWordsToHighlight() {
        TokenMap tokenMap = new TokenMap();
        tokenMap.put("INFO", 6);
        tokenMap.put("WARNING", 7);
        tokenMap.put("ERROR", 35);
        tokenMap.put("SEVERE", 35);
        tokenMap.put("java.lang.NullPointerException", 35);
        tokenMap.put("java.lang.NullPointerException:", 35);
        tokenMap.put("java.io.FileNotFoundException", 35);
        tokenMap.put("java.io.FileNotFoundException:", 35);
        return tokenMap;
    }

    public Token getTokenList(Segment text, int startTokenType, int startOffset) {
        this.resetTokenList();
        char[] array = text.array;
        int offset = text.offset;
        int count = text.count;
        int end = offset + count;
        int newStartOffset = startOffset - offset;
        this.currentTokenStart = offset;
        this.currentTokenType = startTokenType;
        block29: for (int i = offset; i < end; ++i) {
            char c = array[i];
            switch (this.currentTokenType) {
                case 0: {
                    this.currentTokenStart = i;
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            this.currentTokenType = 21;
                            continue block29;
                        }
                        case '\"': {
                            this.currentTokenType = 13;
                            continue block29;
                        }
                        case '#': {
                            this.currentTokenType = 1;
                            continue block29;
                        }
                    }
                    if (RSyntaxUtilities.isDigit((char)c)) {
                        this.currentTokenType = 10;
                        continue block29;
                    }
                    if (RSyntaxUtilities.isLetter((char)c) || c == '/' || c == '_') {
                        this.currentTokenType = 20;
                        continue block29;
                    }
                    this.currentTokenType = 20;
                    continue block29;
                }
                case 21: {
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            continue block29;
                        }
                        case '\"': {
                            this.addToken(text, this.currentTokenStart, i - 1, 21, newStartOffset + this.currentTokenStart);
                            this.currentTokenStart = i;
                            this.currentTokenType = 13;
                            continue block29;
                        }
                        case '#': {
                            this.addToken(text, this.currentTokenStart, i - 1, 21, newStartOffset + this.currentTokenStart);
                            this.currentTokenStart = i;
                            this.currentTokenType = 1;
                            continue block29;
                        }
                    }
                    this.addToken(text, this.currentTokenStart, i - 1, 21, newStartOffset + this.currentTokenStart);
                    this.currentTokenStart = i;
                    if (RSyntaxUtilities.isDigit((char)c)) {
                        this.currentTokenType = 10;
                        continue block29;
                    }
                    if (RSyntaxUtilities.isLetter((char)c) || c == '/' || c == '_') {
                        this.currentTokenType = 20;
                        continue block29;
                    }
                    this.currentTokenType = 20;
                    continue block29;
                }
                default: {
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            this.addToken(text, this.currentTokenStart, i - 1, 20, newStartOffset + this.currentTokenStart);
                            this.currentTokenStart = i;
                            this.currentTokenType = 21;
                            continue block29;
                        }
                        case '\"': {
                            this.addToken(text, this.currentTokenStart, i - 1, 20, newStartOffset + this.currentTokenStart);
                            this.currentTokenStart = i;
                            this.currentTokenType = 13;
                            continue block29;
                        }
                    }
                    if (RSyntaxUtilities.isLetterOrDigit((char)c) || c == '/' || c != '_') continue block29;
                    continue block29;
                }
                case 10: {
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            this.addToken(text, this.currentTokenStart, i - 1, 10, newStartOffset + this.currentTokenStart);
                            this.currentTokenStart = i;
                            this.currentTokenType = 21;
                            continue block29;
                        }
                        case '\"': {
                            this.addToken(text, this.currentTokenStart, i - 1, 10, newStartOffset + this.currentTokenStart);
                            this.currentTokenStart = i;
                            this.currentTokenType = 13;
                            continue block29;
                        }
                    }
                    if (RSyntaxUtilities.isDigit((char)c)) continue block29;
                    this.addToken(text, this.currentTokenStart, i - 1, 10, newStartOffset + this.currentTokenStart);
                    --i;
                    this.currentTokenType = 0;
                    continue block29;
                }
                case 1: {
                    i = end - 1;
                    this.addToken(text, this.currentTokenStart, i, this.currentTokenType, newStartOffset + this.currentTokenStart);
                    this.currentTokenType = 0;
                    continue block29;
                }
                case 13: {
                    if (c != '\"') continue block29;
                    this.addToken(text, this.currentTokenStart, i, 13, newStartOffset + this.currentTokenStart);
                    this.currentTokenType = 0;
                }
            }
        }
        switch (this.currentTokenType) {
            case 13: {
                this.addToken(text, this.currentTokenStart, end - 1, this.currentTokenType, newStartOffset + this.currentTokenStart);
                break;
            }
            case 0: {
                this.addNullToken();
                break;
            }
            default: {
                this.addToken(text, this.currentTokenStart, end - 1, this.currentTokenType, newStartOffset + this.currentTokenStart);
                this.addNullToken();
            }
        }
        return this.firstToken;
    }

    public void addToken(Segment segment, int start, int end, int tokenType, int startOffset) {
        int value;
        if (tokenType == 20 && (value = this.wordsToHighlight.get(segment, start, end)) != -1) {
            tokenType = value;
        }
        super.addToken(segment, start, end, tokenType, startOffset);
    }
}

