/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.gui.swing;

import java.awt.Toolkit;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.JFormattedTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class JDecimalField
extends JFormattedTextField {
    private DecimalFormat df;

    public JDecimalField() {
        NumberFormat nf = NumberFormat.getInstance();
        this.df = nf instanceof DecimalFormat ? (DecimalFormat)nf : new DecimalFormat("###.##");
        this.setDocument(new DecimalDocument());
    }

    public JDecimalField(double value, int columns) {
        this.df = new DecimalFormat("###.##");
        this.setDocument(new DecimalDocument());
        this.setColumns(columns);
        this.setValue(value);
    }

    public void setValue(double value) {
        try {
            this.setText(this.df.format(value));
        }
        catch (Exception e) {
            this.setText(Double.toString(value));
        }
    }

    public void setValue(float value) {
        try {
            String text = Float.toString(value);
            if (text.equalsIgnoreCase("0.0")) {
                this.setText("0");
            } else {
                this.setText(text);
            }
        }
        catch (Exception e) {
            this.setText("0");
        }
    }

    public double getDoubleValue() {
        try {
            return Double.parseDouble(this.getText());
        }
        catch (ClassCastException e) {
            return Long.parseLong(this.getText());
        }
    }

    public float getFloatValue() {
        try {
            return Float.parseFloat(this.getText());
        }
        catch (ClassCastException e) {
            return Long.parseLong(this.getText());
        }
    }

    static class DecimalDocument
    extends PlainDocument {
        DecimalDocument() {
        }

        @Override
        public void insertString(int offset, String string, AttributeSet attributes) throws BadLocationException {
            String newValue;
            if (string == null) {
                return;
            }
            int length = this.getLength();
            if (length == 0) {
                newValue = string;
            } else {
                String currentContent = this.getText(0, length);
                StringBuffer currentBuffer = new StringBuffer(currentContent);
                currentBuffer.insert(offset, string);
                newValue = currentBuffer.toString();
            }
            try {
                Double.parseDouble(newValue);
                super.insertString(offset, string, attributes);
            }
            catch (NumberFormatException exception) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }
}

