/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.gui.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public class FilterComboBox
extends JComboBox {
    public boolean filterUsed;

    public FilterComboBox(Object[] itemList) {
        FilterComboBoxModel model = new FilterComboBoxModel(itemList);
        this.setModel(model);
        model.addAllElements(itemList);
        KeyListener[] lis = this.getKeyListeners();
        for (int i = 0; i < lis.length; ++i) {
            this.removeKeyListener(lis[i]);
        }
        this.addKeyListener(model.getKeyListener());
        this.addActionListener(model.getActionListener());
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        this.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
            }
        });
    }

    public class FilterComboBoxModel
    extends DefaultComboBoxModel {
        private Object[] masterItemList;
        private Object masterSelectedItem;
        private StringBuilder filter = new StringBuilder(8);
        private int fidx = 0;
        private CustomKeyListener keylis = null;
        private CustomActionListener actionlis = null;
        private ActionListener[] actionLisList;
        private ItemListener[] itemLisList;

        public FilterComboBoxModel(Object[] itemList) {
            this.initComboBoxModel(itemList);
        }

        public void initComboBoxModel(Object[] itemList) {
            this.setMasterItemList(itemList);
        }

        public CustomKeyListener getKeyListener() {
            if (this.keylis == null) {
                this.keylis = new CustomKeyListener();
            }
            return this.keylis;
        }

        public CustomActionListener getActionListener() {
            if (this.actionlis == null) {
                this.actionlis = new CustomActionListener();
            }
            return this.actionlis;
        }

        public void setMasterItemList(Object[] items) {
            this.masterItemList = items;
            if (items.length > 0) {
                this.masterSelectedItem = items[0];
            }
            this.restoreItems();
        }

        public void addAllElements(Object[] items) {
            for (int i = 0; i < items.length; ++i) {
                FilterComboBox.this.addItem(items[i]);
            }
        }

        public Object[] getAllElements() {
            Object[] list = new Object[FilterComboBox.this.getItemCount()];
            for (int i = 0; i < list.length; ++i) {
                list[i] = this.getElementAt(i);
            }
            return list;
        }

        public void applyFIlter(String pattern) {
            ArrayList<Object> newList = new ArrayList<Object>();
            Object[] list = this.masterItemList;
            int patlen = pattern.length();
            if (patlen > 0) {
                for (int i = 0; i < list.length; ++i) {
                    String item = list[i].toString();
                    if (item.length() < patlen) continue;
                    int position = item.toUpperCase().indexOf(pattern.toUpperCase());
                    if (position > -1) {
                        newList.add(list[i]);
                    }
                    this.suspendAllListeners();
                    this.removeAllElements();
                    if (newList.isEmpty()) {
                        FilterComboBox.this.addItem("Your search did not match any items!");
                    } else {
                        this.addAllElements(newList.toArray());
                    }
                    if (this.fidx == 0) {
                        this.setSelectedItem(this.masterSelectedItem);
                    }
                    this.restoreAllListeners();
                    FilterComboBox.this.filterUsed = true;
                }
            } else {
                FilterComboBox.this.filterUsed = false;
            }
        }

        public void filterItems(String pat) {
            ArrayList<Object> newList = new ArrayList<Object>();
            Object[] list = this.masterItemList;
            int patlen = pat.length();
            for (int i = 0; i < list.length; ++i) {
                String tok;
                String item = list[i].toString();
                if (item.length() < patlen || !(tok = item.substring(0, patlen)).equalsIgnoreCase(pat)) continue;
                newList.add(list[i]);
            }
            this.suspendAllListeners();
            this.removeAllElements();
            if (newList.isEmpty()) {
                FilterComboBox.this.addItem("Your search did not match any items!");
            } else {
                this.addAllElements(newList.toArray());
            }
            if (this.fidx == 0) {
                this.setSelectedItem(this.masterSelectedItem);
            }
            this.restoreAllListeners();
        }

        private void suspendAllListeners() {
            this.actionLisList = FilterComboBox.this.getActionListeners();
            for (ActionListener actionListener : this.actionLisList) {
                FilterComboBox.this.removeActionListener(actionListener);
            }
            this.itemLisList = FilterComboBox.this.getItemListeners();
            for (EventListener eventListener : this.itemLisList) {
                FilterComboBox.this.removeItemListener((ItemListener)eventListener);
            }
        }

        private void restoreAllListeners() {
            for (ActionListener actionListener : this.actionLisList) {
                FilterComboBox.this.addActionListener(actionListener);
            }
            for (EventListener eventListener : this.itemLisList) {
                FilterComboBox.this.addItemListener((ItemListener)eventListener);
            }
        }

        public void restoreItems() {
            this.suspendAllListeners();
            this.removeAllElements();
            this.addAllElements(this.masterItemList);
            this.resetFilter();
            this.setSelectedItem(this.masterSelectedItem);
            this.restoreAllListeners();
        }

        private void resetFilter() {
            this.filter.setLength(0);
            this.fidx = 0;
        }

        public class CustomActionListener
        implements ActionListener {
            @Override
            public void actionPerformed(ActionEvent e) {
                FilterComboBoxModel.this.masterSelectedItem = FilterComboBoxModel.this.getSelectedItem();
            }
        }

        public class CustomKeyListener
        extends KeyAdapter {
            @Override
            public void keyPressed(KeyEvent e) {
                int keyCode = e.getKeyCode();
                if (keyCode == 37) {
                    FilterComboBoxModel.this.fidx = FilterComboBoxModel.this.fidx == 0 ? FilterComboBoxModel.this.fidx : FilterComboBoxModel.this.fidx - 1;
                    FilterComboBoxModel.this.applyFIlter(FilterComboBoxModel.this.filter.substring(0, FilterComboBoxModel.this.fidx));
                } else if (keyCode == 39) {
                    FilterComboBoxModel.this.fidx = FilterComboBoxModel.this.fidx == FilterComboBoxModel.this.filter.length() ? FilterComboBoxModel.this.fidx : FilterComboBoxModel.this.fidx + 1;
                    FilterComboBoxModel.this.applyFIlter(FilterComboBoxModel.this.filter.substring(0, FilterComboBoxModel.this.fidx));
                } else if (keyCode == 8 || keyCode == 127 || keyCode == 27) {
                    FilterComboBoxModel.this.restoreItems();
                    FilterComboBox.this.filterUsed = false;
                } else if (keyCode > 32) {
                    char letter = (char)keyCode;
                    FilterComboBoxModel.this.filter.insert(FilterComboBoxModel.this.fidx, letter);
                    ++FilterComboBoxModel.this.fidx;
                    FilterComboBoxModel.this.filter.setLength(FilterComboBoxModel.this.fidx);
                    FilterComboBoxModel.this.applyFIlter(FilterComboBoxModel.this.filter.toString());
                }
                FilterComboBox.this.setToolTipText("The current filter is : " + FilterComboBoxModel.this.filter.substring(0, FilterComboBoxModel.this.fidx));
            }
        }
    }
}

