/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.dmweb;

import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.imports.DBConnectionStamp;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ConnectionInterface;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.ImpliedForeignKey;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TVNote;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.dmw.CompareDBDiagramsDialog;
import oracle.dbtools.crest.swingui.relational.DPVRelational;
import oracle.dbtools.crest.util.dmweb.DiagramToSVG;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnections;

public class DiagramToJSON {
    public static String DIAGRAM_TYPE_MAIN_PRIMARY = "MDP";
    public static String DIAGRAM_TYPE_SUBVIEW_PRIMARY = "SVP";
    public static String DIAGRAM_TYPE_MAIN_DISPLAY = "MDD";
    public static String DIAGRAM_TYPE_SUBVIEW_DISPLAY = "SVD";
    private static final Logger LOGGER = new Logger(DiagramToJSON.class);

    public static void main(String[] args) {
    }

    private static void addAttribute(String name, String value, Writer sb) {
        DiagramToJSON.addAttribute(name, value, sb, false);
    }

    private static void addAttribute(String name, String value, Writer sb, boolean first) {
        DiagramToJSON.addAttribute(name, value, sb, first, false);
    }

    private static void addAttribute(String name, String value, Writer sb, boolean first, boolean numOrbool) {
        try {
            String code = name;
            if (!first) {
                sb.write(44);
            }
            sb.write("\n\"");
            sb.write(code);
            if (!numOrbool) {
                sb.write("\":\"");
                sb.write(value);
                sb.write("\"");
            } else {
                sb.write("\":");
                sb.write(value);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void addOpenTag(String tagname, Writer sb) {
        try {
            String code = tagname;
            sb.write("{\"");
            sb.write(code);
            sb.write("\":");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void addObjectTagAndOpen(String tagname, Writer sb, boolean first) {
        try {
            if (!first) {
                sb.write(44);
            }
            String code = tagname;
            sb.write("\n\"");
            sb.write(code);
            sb.write("\":{");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void addOpenObjectChar(Writer sb, boolean first) {
        try {
            if (!first) {
                sb.write(44);
            }
            sb.write("\n{");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void addObjectName(String tagname, Writer sb, boolean first) {
        try {
            String code = tagname;
            if (!first) {
                sb.write(44);
            }
            sb.write("\n");
            sb.write("\"");
            sb.write(code);
            sb.write("\":{");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void addKeyValueObject(String key, String value, Writer sb, boolean first) {
        try {
            if (!first) {
                sb.write(44);
            }
            sb.write("\n");
            sb.write("{\"");
            sb.write(StringUtilities.encodeAttributeValueJSON(key));
            sb.write("\":\"");
            sb.write(StringUtilities.encodeAttributeValueJSON(value));
            sb.write("\"}");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void addCollectionOpenTag(String tagname, Writer sb, boolean first) {
        try {
            String code = tagname;
            if (!first) {
                sb.write(44);
            }
            sb.write("\n\"");
            sb.write(code);
            sb.write("\":[");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void addCloseChar(Writer sb) {
        try {
            sb.write("}");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void addCollectionCloseChar(Writer sb) {
        try {
            sb.write("\n]");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void DPV_ToJSON(DPVRelational dpv, Writer sb) {
        RelationalDesign rd = (RelationalDesign)dpv.getDesignPart();
        DiagramToJSON.addOpenObjectChar(sb, true);
        DiagramToJSON.addCollectionOpenTag("items", sb, true);
        boolean first = !DiagramToJSON.processT_V_shapes(dpv, sb);
        DiagramToJSON.processTVConnector(dpv, sb, first);
        DiagramToJSON.addCollectionCloseChar(sb);
        try {
            sb.write("\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        DiagramToJSON.addCloseChar(sb);
    }

    public static boolean processT_V_shapes(DPVRelational dpv, Writer sb) {
        boolean processed = false;
        boolean first = true;
        try {
            Iterator it = dpv.getTVTablesAndTVViews().iterator();
            while (it.hasNext()) {
                boolean lfirst = true;
                TopView tv = (TopView)it.next();
                FKContainer fco = null;
                Table table = null;
                ContainerObject co = (ContainerObject)tv.getModel();
                DiagramToJSON.addOpenObjectChar(sb, first);
                first = false;
                String name = co.getName();
                String schema = co.getSchema();
                String type = "TABLE";
                if (co instanceof TableView) {
                    type = "VIEW";
                    fco = (FKContainer)co;
                } else if (co instanceof Table) {
                    table = (Table)co;
                    fco = table;
                }
                DiagramToJSON.addAttribute("name", name, sb, lfirst);
                lfirst = false;
                DiagramToJSON.addAttribute("schema", schema, sb, lfirst);
                DiagramToJSON.addAttribute("viewID", tv.getViewID(), sb, lfirst);
                DiagramToJSON.addAttribute("type", type, sb, lfirst);
                Rectangle bounds = null;
                bounds = tv.getCellView() != null ? tv.getCellView().getBounds().getBounds() : tv.getBounds();
                if (bounds != null) {
                    DiagramToJSON.addObjectTagAndOpen("bounds", sb, lfirst);
                    DiagramToJSON.addAttribute("x", String.valueOf((long)bounds.getX()), sb, true, true);
                    DiagramToJSON.addAttribute("y", String.valueOf((long)bounds.getY()), sb, false, true);
                    DiagramToJSON.addAttribute("width", String.valueOf((long)bounds.getWidth()), sb, false, true);
                    DiagramToJSON.addAttribute("height", String.valueOf((long)bounds.getHeight()), sb, false, true);
                    DiagramToJSON.addCloseChar(sb);
                }
                if (table != null) {
                    StorageDesign sd = table.getRelationalModel().getStorageDesign();
                    if (sd.isOpen() && sd instanceof StorageDesignOracle) {
                        TableProxyOracle tp = (TableProxyOracle)sd.getStorageObject(table.getObjectID());
                        if (tp != null && "EXTERNAL".equalsIgnoreCase(tp.getOrganization())) {
                            DiagramToJSON.addAttribute("externalTable", "true", sb, false, true);
                        } else {
                            DiagramToJSON.addAttribute("externalTable", "false", sb, false, true);
                        }
                    } else {
                        DiagramToJSON.addAttribute("externalTable", "false", sb, false, true);
                    }
                    if (table.isMaterializedQueryTable()) {
                        DiagramToJSON.addAttribute("materializedQueryTable", "true", sb, false, true);
                    } else {
                        DiagramToJSON.addAttribute("materializedQueryTable", "false", sb, false, true);
                    }
                }
                Color bgcol = DiagramToSVG.getBackgroundColor(co, tv, false);
                Color fgcol = DiagramToSVG.getTableForegroundColor(co, tv);
                DiagramToJSON.addAttribute("bgColor", String.valueOf(DiagramToJSON.getRGBColorNoAlpha(bgcol)), sb, false, true);
                DiagramToJSON.addAttribute("bgOpacity", DiagramToJSON.getOpacity(bgcol), sb, false, true);
                DiagramToJSON.addAttribute("fgColor", String.valueOf(DiagramToJSON.getRGBColorNoAlpha(fgcol)), sb, false, true);
                DiagramToJSON.addAttribute("fgOpacity", DiagramToJSON.getOpacity(fgcol), sb, false, true);
                DiagramToJSON.addImpliedFKs(dpv, fco, sb, false);
                DiagramToJSON.addCloseChar(sb);
                processed = true;
            }
            DiagramToJSON.addNotes(dpv, sb, first);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return processed;
    }

    private static void addImpliedFKs(DPVRelational dpv, FKContainer co, Writer sb, boolean first) {
        try {
            DiagramToJSON.addCollectionOpenTag("impliedForeignKeys", sb, first);
            List<ImpliedForeignKey> list = co.getImpliedForeignKeyList();
            boolean ifirst = true;
            for (ImpliedForeignKey ifk : list) {
                TVConnector tv = (TVConnector)ifk.getViewFor(dpv);
                if (tv == null) continue;
                DiagramToJSON.addOpenObjectChar(sb, ifirst);
                DiagramToJSON.addAttribute("class", ImpliedForeignKey.class.getName(), sb, true);
                DiagramToJSON.addAttribute("name", ifk.getName(), sb, false);
                DiagramToJSON.addAttribute("schema", co.getSchema(), sb, false);
                DiagramToJSON.addAttribute("tableName", co.getName(), sb, false);
                DiagramToJSON.addAttribute("longName", co.getLongName(), sb, false);
                if (ifk.getLocalColumn() != null) {
                    DiagramToJSON.addAttribute("columnName", ifk.getLocalColumn().getName(), sb, false);
                } else {
                    DiagramToJSON.addAttribute("columnName", "", sb, false);
                }
                DiagramToJSON.addAttribute("refSchema", ifk.getRemoteTable().getSchema(), sb, false);
                DiagramToJSON.addAttribute("refTable", ifk.getRemoteTable().getName(), sb, false);
                DiagramToJSON.addAttribute("refLongName", ifk.getRemoteTable().getLongName(), sb, false);
                if (ifk.getReferredColumnName() != null) {
                    DiagramToJSON.addAttribute("refColumnName", ifk.getReferredColumnName(), sb, false);
                } else {
                    DiagramToJSON.addAttribute("refColumnName", "", sb, false);
                }
                DiagramToJSON.addAttribute("discoverySource", ifk.getDiscoverySources(), sb, false);
                DiagramToJSON.addAttribute("sourceViewID", tv.getTargetTopView().getViewID(), sb, false);
                DiagramToJSON.addAttribute("targetViewID", tv.getSourceTopView().getViewID(), sb, false);
                DiagramToJSON.addCloseChar(sb);
                ifirst = false;
            }
            DiagramToJSON.addCollectionCloseChar(sb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getOpacity(Color color) {
        int alpha = color.getAlpha();
        if (alpha == 0) {
            return "0";
        }
        if (alpha == 255) {
            return "1";
        }
        return String.valueOf((double)alpha / 255.0);
    }

    public static boolean addNotes(DPVRelational dpv, Writer sb, boolean ofirst) {
        boolean processed = false;
        boolean first = ofirst;
        try {
            Iterator it = dpv.getTVShapes().iterator();
            while (it.hasNext()) {
                boolean lfirst = true;
                TopView tv = (TopView)it.next();
                if (!(tv instanceof TVNote)) continue;
                Note note = (Note)tv.getModel();
                Font font = DiagramToSVG.getTitleFont(note, tv);
                DiagramToJSON.addOpenObjectChar(sb, first);
                first = false;
                String name = "";
                String schema = "";
                String type = "NOTE";
                DiagramToJSON.addAttribute("name", name, sb, lfirst);
                lfirst = false;
                DiagramToJSON.addAttribute("schema", schema, sb, lfirst);
                DiagramToJSON.addAttribute("viewID", tv.getViewID(), sb, lfirst);
                DiagramToJSON.addAttribute("type", type, sb, lfirst);
                Color txcol = DiagramToSVG.getColor(null, tv, EditableFonts.FO_TITLE);
                DiagramToJSON.addAttribute("textColor", String.valueOf(DiagramToJSON.getRGBColorNoAlpha(txcol)), sb, false, true);
                DiagramToJSON.addAttribute("textOpacity", DiagramToJSON.getOpacity(txcol), sb, false, true);
                String comment = ((TVNote)tv).getComment();
                comment = comment != null ? StringUtilities.encodeAttributeValueJSON(comment) : "";
                DiagramToJSON.addAttribute("text", comment, sb, false, false);
                DiagramToJSON.addAttribute("fontSize", String.valueOf(font.getSize()), sb, false, true);
                Rectangle bounds = null;
                bounds = tv.getCellView() != null ? tv.getCellView().getBounds().getBounds() : tv.getBounds();
                if (bounds != null) {
                    DiagramToJSON.addObjectTagAndOpen("bounds", sb, lfirst);
                    DiagramToJSON.addAttribute("x", String.valueOf(bounds.getX()), sb, true, true);
                    DiagramToJSON.addAttribute("y", String.valueOf(bounds.getY()), sb, false, true);
                    DiagramToJSON.addAttribute("width", String.valueOf(bounds.getWidth()), sb, false, true);
                    DiagramToJSON.addAttribute("height", String.valueOf(bounds.getHeight()), sb, false, true);
                    DiagramToJSON.addCloseChar(sb);
                }
                Color bgcol = DiagramToSVG.getBackgroundColor("Note", tv, false);
                Color fgcol = DiagramToSVG.getForegroundColor("Note", tv);
                DiagramToJSON.addAttribute("bgColor", String.valueOf(DiagramToJSON.getRGBColorNoAlpha(bgcol)), sb, false, true);
                DiagramToJSON.addAttribute("bgOpacity", DiagramToJSON.getOpacity(bgcol), sb, false, true);
                DiagramToJSON.addAttribute("fgColor", String.valueOf(DiagramToJSON.getRGBColorNoAlpha(fgcol)), sb, false, true);
                DiagramToJSON.addAttribute("fgOpacity", DiagramToJSON.getOpacity(fgcol), sb, false, true);
                DiagramToJSON.addCloseChar(sb);
                processed = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return processed;
    }

    public static int getRGBColorNoAlpha(Color color) {
        return DiagramToSVG.ColorUtil.getIntColorNoAlpha(color.getRGB());
    }

    public static boolean processTVConnector(DPVRelational dpv, Writer sb, boolean first) {
        boolean processed = false;
        try {
            Iterator it = dpv.getTVConnectors().iterator();
            while (it.hasNext()) {
                List list;
                boolean lfirst = true;
                TVConnector tv = (TVConnector)it.next();
                ConnectionInterface ci = (ConnectionInterface)((Object)tv.getModel());
                DesignObject so = ci.getSourceObject();
                DesignObject to = ci.getTargetObject();
                if (so == null || to == null) continue;
                DesignObject co = tv.getModel();
                boolean ifk = co instanceof ImpliedForeignKey;
                TopView stv = tv.getSourceTopView();
                TopView ttv = tv.getTargetTopView();
                DiagramToJSON.addOpenObjectChar(sb, first);
                first = false;
                processed = true;
                String name = co.getName();
                String type = ifk ? "REFERENCE" : "RELATION";
                DiagramToJSON.addAttribute("type", type, sb, lfirst);
                lfirst = false;
                DiagramToJSON.addAttribute("name", name, sb, lfirst);
                if (!ifk) {
                    DiagramToJSON.addAttribute("sourceID", so.getLongName(), sb, lfirst);
                    DiagramToJSON.addAttribute("targetID", to.getLongName(), sb, lfirst);
                }
                DiagramToJSON.addAttribute("sourceViewID", stv.getViewID(), sb, lfirst);
                DiagramToJSON.addAttribute("targetViewID", ttv.getViewID(), sb, lfirst);
                Color bgcol = DiagramToSVG.getLineColor(co, tv);
                DiagramToJSON.addAttribute("color", String.valueOf(DiagramToJSON.getRGBColorNoAlpha(bgcol)), sb, false, true);
                DiagramToJSON.addAttribute("opacity", DiagramToJSON.getOpacity(bgcol), sb, false, true);
                int width = tv.getLineWidth();
                DiagramToJSON.addAttribute("width", String.valueOf(width), sb, false, true);
                if (ci instanceof FKIndexAssociation) {
                    boolean solid = ((FKIndexAssociation)ci).isMandatory();
                    DiagramToJSON.addAttribute("style", solid ? "solid" : "dash", sb, lfirst);
                }
                if ((list = tv.getActualPoints()).size() >= 2) {
                    Point2D p = (Point2D)list.get(0);
                    DiagramToJSON.addObjectTagAndOpen("sourcePort", sb, false);
                    DiagramToJSON.addAttribute("x", String.valueOf((int)p.getX()), sb, true, true);
                    DiagramToJSON.addAttribute("y", String.valueOf((int)p.getY()), sb, false, true);
                    DiagramToJSON.addCloseChar(sb);
                    p = (Point2D)list.get(list.size() - 1);
                    DiagramToJSON.addObjectTagAndOpen("targetPort", sb, false);
                    DiagramToJSON.addAttribute("x", String.valueOf((int)p.getX()), sb, true, true);
                    DiagramToJSON.addAttribute("y", String.valueOf((int)p.getY()), sb, false, true);
                    DiagramToJSON.addCloseChar(sb);
                }
                if (list.size() > 2) {
                    DiagramToJSON.addCollectionOpenTag("vertices", sb, false);
                    boolean pfirst = true;
                    for (int i = 1; i < list.size() - 1; ++i) {
                        Point2D p = (Point2D)list.get(i);
                        DiagramToJSON.addOpenObjectChar(sb, pfirst);
                        pfirst = false;
                        DiagramToJSON.addAttribute("x", String.valueOf((int)p.getX()), sb, true, true);
                        DiagramToJSON.addAttribute("y", String.valueOf((int)p.getY()), sb, false, true);
                        DiagramToJSON.addCloseChar(sb);
                    }
                    DiagramToJSON.addCollectionCloseChar(sb);
                }
                DiagramToJSON.addCloseChar(sb);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return processed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getNewID(Connection con) {
        Statement st = null;
        try {
            st = con.createStatement();
            String sql = "SELECT osddmw_diagrams_id_SEQAI.NEXTVAL from dual";
            ResultSet rs = st.executeQuery(sql);
            if (rs != null && rs.next()) {
                String val = rs.getString(1);
                rs.close();
                String string = val;
                return string;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            String string = e.getMessage();
            return string;
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean diagramsTableExists(Connection con) {
        String sql = "select 1 from user_tables where table_name = 'OSDDMW_DIAGRAMS'";
        Statement st = null;
        try {
            st = con.createStatement();
            ResultSet rs = null;
            rs = st.executeQuery(sql);
            if (rs != null && rs.next()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateDiagram(Connection con, DesignPartView dpv, String layout, PreparedStatement ps, boolean byGlobalID) {
        String upd_sql = "update osddmw_diagrams set last_update=systimestamp,design_name=?,model_name=?,subview_name=?, layout =? where design_id = ? and subview_id = ?";
        String upd_global_sql = "update osddmw_diagrams set last_update=systimestamp,design_name=?,model_name=?,subview_name=?, layout =? where global_id = ?";
        try {
            DesignPart dp = dpv.getDesignPart();
            Design des = dp.getDesign();
            String name = dpv.getName();
            String descr = dpv.getComment();
            if (descr != null && descr.length() > 3990) {
                descr = descr.substring(0, 3990);
            }
            if (dp.getMainView() == dpv && (descr = dp.getComment()) != null && descr.length() > 3990) {
                descr = descr.substring(0, 3990);
            }
            ps.setString(1, des.getName());
            ps.setString(2, dp.getName());
            ps.setString(3, dpv.getName());
            try {
                byte[] blayout = layout.getBytes("UTF-8");
                ByteArrayInputStream is = new ByteArrayInputStream(blayout);
                ps.setBinaryStream(4, (InputStream)is, blayout.length);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            if (byGlobalID) {
                ps.setString(5, dpv.getImportedId());
            } else {
                ps.setString(5, des.getObjectID());
                ps.setString(6, dpv.getDPVId());
            }
            ps.execute();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static String getDiagramType(DesignPartView dpv) {
        DesignPart dp = dpv.getDesignPart();
        if (dp.getMainView() == dpv) {
            return DIAGRAM_TYPE_MAIN_PRIMARY;
        }
        if (!dpv.isMasterDPV()) {
            if (dpv.getMasterDPV() == dp.getMainView()) {
                return DIAGRAM_TYPE_MAIN_DISPLAY;
            }
            return DIAGRAM_TYPE_SUBVIEW_DISPLAY;
        }
        return DIAGRAM_TYPE_SUBVIEW_PRIMARY;
    }

    public static String getDiagramComment(DesignPartView dpv) {
        DesignPart dp = dpv.getDesignPart();
        String descr = null;
        if (dp.getMainView() == dpv) {
            descr = dp.getComment();
            if (descr != null && descr.length() > 3990) {
                descr = descr.substring(0, 3990);
            }
        } else {
            descr = dpv.getComment();
            if (descr != null && descr.length() > 3990) {
                descr = descr.substring(0, 3990);
            }
        }
        return descr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String insertDiagram(Connection con, DesignPartView dpv, String id, String layout, PreparedStatement ps) {
        String res = null;
        try {
            DesignPart dp = dpv.getDesignPart();
            Design des = dp.getDesign();
            String pid = null;
            String type = DiagramToJSON.getDiagramType(dpv);
            String name = dpv.getName();
            String descr = DiagramToJSON.getDiagramComment(dpv);
            if (!dpv.isMasterDPV()) {
                pid = dpv.getMasterDPV().getDPVId();
            }
            long lid = Long.valueOf(id);
            ps.setLong(1, lid);
            ps.setString(2, name);
            ps.setString(3, descr);
            ps.setString(4, des.getObjectID());
            ps.setString(5, des.getName());
            ps.setString(6, dp.getObjectID());
            ps.setString(7, dp.getName());
            ps.setString(8, dpv.getDPVId());
            ps.setString(9, dpv.getName());
            ps.setString(10, pid);
            ps.setString(11, type);
            try {
                byte[] blayout = layout.getBytes("UTF-8");
                ByteArrayInputStream is = new ByteArrayInputStream(blayout);
                ps.setBinaryStream(12, (InputStream)is, blayout.length);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            ps.execute();
        }
        catch (SQLException e) {
            res = e.getMessage();
            e.printStackTrace();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String createDiagramsTable(Connection con) {
        String res = "ok";
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE TABLE osddmw_diagrams \n");
        sb.append("  ( \n");
        sb.append("    id          NUMBER NOT NULL , \n");
        sb.append("    name        VARCHAR2 (70) , \n");
        sb.append("    description VARCHAR2 (4000) , \n");
        sb.append("    last_update TIMESTAMP , \n");
        sb.append("    global_ID VARCHAR2 (70) , \n");
        sb.append("    Design_ID VARCHAR2 (70) , \n");
        sb.append("    Design_Name VARCHAR2 (256) , ");
        sb.append("    model_ID VARCHAR2 (70) , \n");
        sb.append("    model_Name VARCHAR2 (256) , ");
        sb.append("    subview_ID VARCHAR2 (70) , \n");
        sb.append("    subview_Name VARCHAR2 (256) , ");
        sb.append("    parent_ID VARCHAR2 (70) , \n");
        sb.append("    diagram_type VARCHAR2 (10) , \n");
        sb.append("    layout BLOB \n");
        sb.append("  ) ");
        String tsql = sb.toString();
        Statement st = null;
        try {
            try {
                st = con.createStatement();
            }
            catch (SQLException e) {
                e.printStackTrace();
                String string = e.getMessage();
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException e2) {
                        e2.printStackTrace();
                    }
                }
                return string;
            }
            try {
                st.execute(tsql);
            }
            catch (SQLException e) {
                e.printStackTrace();
                String string = e.getMessage();
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException e3) {
                        e3.printStackTrace();
                    }
                }
                return string;
            }
            String sql = new StringBuffer().append("ALTER TABLE osddmw_diagrams ADD CONSTRAINT osddmw_diagrams_PK PRIMARY KEY ( id )").toString();
            try {
                st.execute(sql);
            }
            catch (SQLException e) {
                e.printStackTrace();
                String string = e.getMessage();
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException e4) {
                        e4.printStackTrace();
                    }
                }
                return string;
            }
            sql = new StringBuffer().append("ALTER TABLE osddmw_diagrams ADD CONSTRAINT osddmw_diagrams_UK_guid UNIQUE( global_ID )").toString();
            try {
                st.execute(sql);
            }
            catch (SQLException e) {
                e.printStackTrace();
                String string = e.getMessage();
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException e5) {
                        e5.printStackTrace();
                    }
                }
                return string;
            }
            sql = new StringBuffer().append("ALTER TABLE osddmw_diagrams ADD CONSTRAINT osddmw_diagrams_desdix UNIQUE ( Design_ID, MODEL_ID, subview_ID )").toString();
            try {
                st.execute(sql);
            }
            catch (SQLException e) {
                e.printStackTrace();
                String string = e.getMessage();
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException e6) {
                        e6.printStackTrace();
                    }
                }
                return string;
            }
            sql = new StringBuffer().append("CREATE SEQUENCE osddmw_diagrams_id_SEQAI START WITH 1 NOCACHE ").toString();
            try {
                st.execute(sql);
            }
            catch (SQLException e) {
                e.printStackTrace();
                String string = e.getMessage();
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException e7) {
                        e7.printStackTrace();
                    }
                }
                return string;
            }
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return res;
    }

    public static void deleteDiagramsFromCloud(Connection con, List<CompareDBDiagramsDialog.SelectionPair> delete) {
        if (con != null && delete.size() > 0) {
            PreparedStatement del_ps = null;
            String sql = "delete from osddmw_diagrams where subview_id = ?";
            try {
                del_ps = con.prepareStatement(sql);
                for (CompareDBDiagramsDialog.SelectionPair sp : delete) {
                    if (sp.rdiagram.swID == null) continue;
                    del_ps.setString(1, sp.rdiagram.swID);
                    int rows = del_ps.executeUpdate();
                    if (rows != 0) continue;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.error("Delete diagrams from Database", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void wriiteDiagramsToCloud(Connection con, DesignPart dp, List<DPVRelational> insert, List<DPVRelational> update, List<DPVRelational> global) {
        if (insert.size() > 0 || update.size() > 0 || global.size() > 0) {
            if (con == null && dp != null) {
                con = DiagramToJSON.getConnection(dp);
            }
            if (con != null) {
                if (!DiagramToJSON.diagramsTableExists(con)) {
                    DiagramToJSON.createDiagramsTable(con);
                }
                Statement ins_ps = null;
                Statement upd_ps = null;
                Statement upd_global_ps = null;
                try {
                    String layout;
                    StringWriter sb;
                    String ins_sql = "insert into osddmw_diagrams (id, name, description, last_update,design_id,design_name,model_id,model_name,subview_id,subview_name,parent_id,diagram_type, layout) values(?,?,?,systimestamp,?,?,?,?,?,?,?,?,?)";
                    String upd_sql = "update osddmw_diagrams set last_update=systimestamp,design_name=?,model_name=?,subview_name=?, layout =? where design_id = ? and subview_id = ?";
                    String upd_global_sql = "update osddmw_diagrams set last_update=systimestamp,design_name=?,model_name=?,subview_name=?, layout =? where global_id = ?";
                    for (DPVRelational dpv : insert) {
                        String err;
                        sb = new StringWriter();
                        DiagramToJSON.DPV_ToJSON(dpv, sb);
                        layout = sb.toString();
                        String id = DiagramToJSON.getNewID(con);
                        if (ins_ps == null) {
                            ins_ps = con.prepareStatement(ins_sql);
                        }
                        if ((err = DiagramToJSON.insertDiagram(con, dpv, id, layout, (PreparedStatement)ins_ps)) == null || err.indexOf("ORA-00001") <= -1 || err.indexOf("OSDDMW_DIAGRAMS_DESDIX") <= -1) continue;
                        if (upd_ps == null) {
                            upd_ps = con.prepareStatement(upd_sql);
                        }
                        DiagramToJSON.updateDiagram(con, dpv, layout, (PreparedStatement)upd_ps, false);
                    }
                    for (DPVRelational dpv : update) {
                        sb = new StringWriter();
                        DiagramToJSON.DPV_ToJSON(dpv, sb);
                        layout = sb.toString();
                        if (upd_ps == null) {
                            upd_ps = con.prepareStatement(upd_sql);
                        }
                        DiagramToJSON.updateDiagram(con, dpv, layout, (PreparedStatement)upd_ps, false);
                    }
                    for (DPVRelational dpv : global) {
                        sb = new StringWriter();
                        DiagramToJSON.DPV_ToJSON(dpv, sb);
                        layout = sb.toString();
                        if (upd_global_ps == null) {
                            upd_global_ps = con.prepareStatement(upd_global_sql);
                        }
                        DiagramToJSON.updateDiagram(con, dpv, layout, (PreparedStatement)upd_global_ps, true);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (ins_ps != null) {
                        try {
                            ins_ps.close();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                    if (upd_ps != null) {
                        try {
                            upd_ps.close();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                    if (upd_global_ps != null) {
                        try {
                            upd_global_ps.close();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
    }

    public static Connection getConnection(ModelIDObject obj) {
        RelationalDesign rd;
        List<DBConnectionStamp> list;
        Connection conn = null;
        String cname = obj.getSourceConnName();
        if (cname != null && cname.isEmpty() && obj instanceof RelationalDesign && (list = (rd = (RelationalDesign)obj).getImportConnectionStamps()).size() > 0) {
            cname = list.get(0).getConnName();
        }
        if (cname != null && !cname.isEmpty()) {
            try {
                conn = DatabaseConnections.getInstance().getUniqueConnection(cname);
            }
            catch (ConnectionException e) {
                e.printStackTrace();
            }
        }
        return conn;
    }

    public static String blobToString(Blob blob) {
        try {
            StringBuffer result = new StringBuffer();
            if (blob != null) {
                int read = 0;
                InputStreamReader reader = null;
                char[] buffer = new char[4096];
                try {
                    reader = new InputStreamReader(blob.getBinaryStream(), "UTF-8");
                    while ((read = reader.read(buffer)) != -1) {
                        result.append(buffer, 0, read);
                    }
                }
                catch (SQLException ex) {
                    throw new RuntimeException("Unable to read layout data.", ex);
                }
                catch (IOException ex) {
                    throw new RuntimeException("Unable to read layout data.", ex);
                }
                finally {
                    try {
                        if (reader != null) {
                            ((Reader)reader).close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            return result.toString();
        }
        catch (Exception e) {
            LOGGER.error("DiagramToJSON - error in processing of BLOB ", e);
            return "";
        }
    }
}

