/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util;

import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.options.Settings;

public abstract class CustomDialogML
extends CustomDialog {
    private int dialogMinWidth = 300;
    private int dialogMinHeight = 300;

    public CustomDialogML(ApplicationView appView) {
        super(appView);
        super.setLayout((LayoutManager)new MigLayout(new LC().fill()));
        this.init();
    }

    public void init() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int w = CustomDialogML.this.getDialog().getWidth();
                int h = CustomDialogML.this.getDialog().getHeight();
                w = Math.max(CustomDialogML.this.getMinimumWidth(), w);
                h = Math.max(CustomDialogML.this.getMinimumHeight(), h);
                CustomDialogML.this.getDialog().setSize(new Dimension(w, h));
            }
        });
        Settings.DialogSettings ds = this.getApplicationView().getSettings().getDialogSettings(this.getClass().getName());
        if (ds == null) {
            int w = Math.max(this.getMinimumWidth(), this.dialogMinWidth);
            int h = Math.max(this.getMinimumHeight(), this.dialogMinHeight);
            this.getDialog().setSize(w, h);
            CommonUtil.centerOnScreen(this.getDialog());
        } else {
            int w = Math.max(this.getMinimumWidth(), (int)ds.rec.getSize().getWidth());
            int h = Math.max(this.getMinimumHeight(), (int)ds.rec.getSize().getHeight());
            this.getDialog().setSize(w, h);
            this.getDialog().setLocation(ds.rec.getLocation());
        }
    }

    @Override
    protected void close() {
        Rectangle rectangle = new Rectangle(this.getDialog().getLocation(), this.getDialog().getSize());
        this.getApplicationView().getSettings().setDialogSettings(this.getClass().getName(), rectangle);
        this.getDialog().dispose();
    }

    protected int getMinimumWidth() {
        return this.dialogMinWidth;
    }

    protected int getMinimumHeight() {
        return this.dialogMinHeight;
    }
}

