/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.reports;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.DefaultComboBoxModel;
import oracle.dbtools.crest.model.ElementSet;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.model.metadata.MetaDataManager;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.UserDefinedProperty;
import oracle.dbtools.crest.swingui.search.PropertyObject;
import oracle.dbtools.crest.swingui.search.SearchConstants;
import oracle.dbtools.crest.swingui.search.SearchPanel;
import oracle.dbtools.crest.swingui.search.SearchProfile;
import oracle.dbtools.crest.swingui.search.SearchResultObject;
import oracle.dbtools.crest.swingui.search.SearchSet;
import oracle.dbtools.crest.swingui.wizards.reports.ReportColumn;
import oracle.dbtools.crest.util.logging.Logger;

public class ReportUtils {
    private static final Logger LOGGER;
    private static Map searchProfilesProperties;
    public static String dateFormat;
    private static final List bValues;
    public static final String lightGreen = "0x638752";
    public static final String darkGreen = "0xc4a02c";
    public static final String red = "0xE42217";
    public static final String blue = "0x0041C2";

    public static String getDisplayName(String xmlName) {
        Map<String, String> s = SearchConstants.PROPERTIES_DISPLAY_NAMES_MAP;
        String displayString = s.get(xmlName);
        return displayString != null ? displayString : xmlName;
    }

    public static List getSearchableProperties(List collection, MetaDataManager metaDataManager, ApplicationView appView) {
        List<Object> list = new ArrayList();
        try {
            Iterator objectsIt = collection.iterator();
            if (objectsIt != null && objectsIt.hasNext()) {
                ModelIDObject obj = (ModelIDObject)objectsIt.next();
                Class<?> classObj = obj.getClass();
                ClassDescription cd = metaDataManager.getClassDescription(classObj.getName());
                if (searchProfilesProperties.entrySet().size() > 0) {
                    for (Map.Entry pairs : searchProfilesProperties.entrySet()) {
                        String clazzName = (String)pairs.getKey();
                        if (!classObj.getName().equals(clazzName)) continue;
                        List propertiesList = (List)pairs.getValue();
                        for (String property : propertiesList) {
                            ClassDescription.PropertyDescription pd = cd.getPropertyDescriptionByName(property);
                            if (pd == null) continue;
                            PropertyObject po = new PropertyObject(pd, "", false, false, true, false);
                            list.add(po);
                        }
                    }
                } else {
                    list = cd.getSearchablePropertyObjectsList();
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception in ReportUtils.getSearchableProperties() ", e);
        }
        return list;
    }

    public static List getSearchablePropertyObjects(Class cls, MetaDataManager metaDataManager) {
        List<Object> list = new ArrayList();
        if (cls != null) {
            ClassDescription cd = metaDataManager.getClassDescription(cls.getName());
            list = cd.getSearchablePropertyObjectsList();
        }
        return list;
    }

    public static List getUDPAndDynamicProperties(ModelIDObject currentModel, Class cls) {
        ArrayList<PropertyObject> list = new ArrayList<PropertyObject>();
        if (currentModel != null && cls != null) {
            Iterator setsIt = null;
            if (currentModel instanceof DesignPart) {
                setsIt = ((DesignPart)currentModel).getSearchableSets().iterator();
            } else if (currentModel instanceof StorageDesign) {
                setsIt = ((StorageDesign)currentModel).getSearchableSets().iterator();
            }
            ArrayList<ModelIDObject> objectsCollection = new ArrayList<ModelIDObject>();
            while (setsIt.hasNext()) {
                SearchSet ss = (SearchSet)setsIt.next();
                Iterator sIt = ((ElementSet)((Object)ss.getSet())).iterator();
                while (sIt.hasNext()) {
                    ModelIDObject o = (ModelIDObject)sIt.next();
                    if (o.getClass() != cls) continue;
                    objectsCollection.add(o);
                }
            }
            ArrayList<String> namesList = new ArrayList<String>();
            if (objectsCollection.size() > 0) {
                for (ModelIDObject o : objectsCollection) {
                    Iterator pNamesIt = o.getPropertyNames();
                    while (pNamesIt.hasNext()) {
                        String name = (String)pNamesIt.next();
                        if (namesList.contains(name)) continue;
                        String type = "";
                        for (UserDefinedProperty p : o.getDesign().getUserDefinedProperties()) {
                            if (!name.equals(p.getName())) continue;
                            type = p.getType();
                            break;
                        }
                        ClassDescription.PropertyDescription pd = new ClassDescription.PropertyDescription();
                        pd.name = name;
                        pd.className = o.getClass().getName();
                        if (type.equals(UserDefinedProperty.DATE)) {
                            pd.dateTime = true;
                        }
                        PropertyObject po = new PropertyObject(pd, "", false, false, true, false);
                        list.add(po);
                        namesList.add(name);
                    }
                }
            }
        }
        return list;
    }

    public static List getSearchablePropertyDescriptions(Class cls, MetaDataManager metaDataManager) {
        List<Object> list = new ArrayList();
        ClassDescription cd = metaDataManager.getClassDescription(cls.getName());
        list = cd.getSearchablePropertyDescriptionsList();
        return list;
    }

    public static List doSimpleSearch(List objectsCollection, Class clazz, String type, MetaDataManager metaDataManager, String searchPattern, boolean caseSensitive, boolean stopAtFirst, boolean useRegEx, boolean not, ApplicationView appView) {
        ArrayList<SearchResultObject> results = new ArrayList<SearchResultObject>();
        ArrayList searchableProperties = new ArrayList();
        searchableProperties.addAll(ReportUtils.getSearchableProperties(objectsCollection, metaDataManager, appView));
        Iterator objectsIt = objectsCollection.iterator();
        block0: while (objectsIt.hasNext()) {
            boolean braked = false;
            ModelIDObject obj = (ModelIDObject)objectsIt.next();
            for (PropertyObject po : searchableProperties) {
                SearchResultObject resObject = ReportUtils.search(obj, clazz, type, po, searchPattern, caseSensitive, useRegEx, not, false);
                if (resObject == null) continue;
                results.add(resObject);
                if (!searchPattern.equals("*") && !stopAtFirst) continue;
                braked = true;
                break;
            }
            if (braked) continue;
            Iterator it = obj.getPropertyNames();
            while (it.hasNext()) {
                String propName = (String)it.next();
                String propValue = obj.getProperty(propName);
                int idx = ReportUtils.match(propValue, searchPattern, caseSensitive, useRegEx, not);
                if (idx <= -1) continue;
                SearchResultObject ro = new SearchResultObject(obj, clazz, propName, type, ReportUtils.getContentToShow(searchPattern, propValue, caseSensitive, idx, useRegEx), propValue);
                results.add(ro);
                if (!stopAtFirst) continue;
                continue block0;
            }
        }
        return results;
    }

    public static SearchResultObject search(ModelIDObject obj, Class clazz, String type, PropertyObject po, String searchPattern, boolean caseSensitive, boolean useRegEx, boolean not, boolean advancedMode) {
        ClassDescription.PropertyDescription pd = po.getPropertyDescription();
        String value = "";
        if (pd.getter != null) {
            value = ReportUtils.getValue(obj, pd.getter, pd.className);
        } else {
            Iterator it = obj.getPropertyNames();
            while (it.hasNext()) {
                String propName = (String)it.next();
                if (!propName.equals(po.getName())) continue;
                value = obj.getProperty(propName);
                break;
            }
        }
        if (pd.isDateTime()) {
            String startDateSearchPattern;
            if (!value.equals("") && !(startDateSearchPattern = po.getStartDateSearchPattern()).equals("")) {
                try {
                    Date startDateSearch = new SimpleDateFormat(dateFormat).parse(startDateSearchPattern);
                    Date propertyDate = new SimpleDateFormat(dateFormat).parse(value);
                    if (po.getDateTimeSearchMode().equals(SearchPanel.ON)) {
                        boolean isTrue = propertyDate.equals(startDateSearch);
                        if (isTrue) {
                            SearchResultObject ro = new SearchResultObject(obj, clazz, pd.name, type, ReportUtils.getContentToShow(searchPattern, value, caseSensitive, 0, useRegEx), value);
                            return ro;
                        }
                    } else if (po.getDateTimeSearchMode().equals(SearchPanel.BEFORE)) {
                        boolean isTrue = propertyDate.before(startDateSearch);
                        if (isTrue) {
                            SearchResultObject ro = new SearchResultObject(obj, clazz, pd.name, type, ReportUtils.getContentToShow(searchPattern, value, caseSensitive, 0, useRegEx), value);
                            return ro;
                        }
                    } else if (po.getDateTimeSearchMode().equals(SearchPanel.AFTER)) {
                        boolean isTrue = propertyDate.after(startDateSearch);
                        if (isTrue) {
                            SearchResultObject ro = new SearchResultObject(obj, clazz, pd.name, type, ReportUtils.getContentToShow(searchPattern, value, caseSensitive, 0, useRegEx), value);
                            return ro;
                        }
                    } else if (po.getDateTimeSearchMode().equals(SearchPanel.BETWEEN)) {
                        boolean isTrueB2;
                        String endDateSearchPattern = po.getEndDateSearchPattern();
                        Date endDateSearch = new SimpleDateFormat(dateFormat).parse(endDateSearchPattern);
                        boolean isTrueB1 = propertyDate.after(startDateSearch);
                        if (isTrueB1 && (isTrueB2 = propertyDate.before(endDateSearch))) {
                            SearchResultObject ro = new SearchResultObject(obj, clazz, pd.name, type, ReportUtils.getContentToShow(searchPattern, value, caseSensitive, 0, useRegEx), value);
                            return ro;
                        }
                    }
                }
                catch (ParseException e) {
                    LOGGER.error("Exception in ReportUtils.search() date ", e);
                }
            }
        } else {
            int idx1;
            int idx = ReportUtils.match(value, searchPattern, caseSensitive, useRegEx, not, advancedMode);
            if (idx > -1) {
                SearchResultObject ro = new SearchResultObject(obj, clazz, pd.name, type, ReportUtils.getContentToShow(searchPattern, value, caseSensitive, idx, useRegEx), value);
                return ro;
            }
            if (!advancedMode && bValues.contains(value) && (idx1 = ReportUtils.match(pd.name, searchPattern, caseSensitive, useRegEx, not, false)) > -1) {
                SearchResultObject ro = new SearchResultObject(obj, clazz, pd.name, type, value, value);
                return ro;
            }
        }
        return null;
    }

    public static String getValue(ModelIDObject obj, Method method, String className) {
        String value = "";
        try {
            if (method != null) {
                Object object = method.invoke((Object)obj, new Object[0]);
                if (object != null && object instanceof List) {
                    value = ReportUtils.listToString((List)object);
                    return value;
                }
                if (className.indexOf("java.lang.String") > -1) {
                    if (object != null) {
                        value = (String)object;
                    }
                } else if (className.indexOf("java.lang.Integer") > -1) {
                    if (object != null) {
                        value = ((Integer)object).toString();
                    }
                } else if (className.indexOf("java.lang.Boolean") > -1) {
                    if (object != null) {
                        value = ((Boolean)object).toString();
                    }
                } else if (className.indexOf("boolean") > -1 || className.indexOf("float") > -1 || className.indexOf("short") > -1 || className.indexOf("long") > -1 || className.indexOf("double") > -1 || className.indexOf("int") > -1) {
                    if (object != null) {
                        value = object.toString();
                    }
                } else if (className.indexOf("java.util.Map") <= -1 && object != null) {
                    value = object instanceof ModelObject ? ((ModelObject)object).getName() : object.toString();
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception in ReportUtils.getValue() ", e);
        }
        return value;
    }

    public static String listToString(List list) {
        Iterator it = list.iterator();
        return ReportUtils.iteratorToString(it);
    }

    public static String iteratorToString(Iterator it) {
        Object res = null;
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj instanceof ModelIDObject) {
                ModelIDObject mobj = (ModelIDObject)obj;
                if (res == null) {
                    res = mobj.getLongName();
                    continue;
                }
                res = (String)res + "\n" + mobj.getLongName();
                continue;
            }
            if (res == null) {
                res = obj.toString();
                continue;
            }
            res = (String)res + "\n" + obj.toString();
        }
        if (res == null) {
            return "";
        }
        return res;
    }

    public static int match(String string, String searchString, boolean isCaseSensitive, boolean useRegEx, boolean not) {
        return ReportUtils.match(string, searchString, isCaseSensitive, useRegEx, not, false);
    }

    public static int match(String string, String searchString, boolean isCaseSensitive, boolean useRegEx, boolean not, boolean advancedMode) {
        if (string != null) {
            if (advancedMode && "".equals(searchString) && "".equals(string)) {
                if (not) {
                    return -1;
                }
                return 0;
            }
            if (advancedMode && "".equals(searchString) && !"".equals(string) && not) {
                return 0;
            }
            if (!"".equalsIgnoreCase(searchString)) {
                if ("*".equalsIgnoreCase(searchString)) {
                    return 0;
                }
                if (searchString.indexOf(42) > -1) {
                    searchString = searchString.replaceAll("\\*", "\\.*");
                }
                Pattern p = null;
                try {
                    if (useRegEx) {
                        p = isCaseSensitive ? Pattern.compile(searchString) : Pattern.compile(searchString, 2);
                        Matcher m = p.matcher(string);
                        if (not) {
                            return m.find() ? -1 : 0;
                        }
                        return m.find() ? 0 : -1;
                    }
                    if (isCaseSensitive) {
                        int position = string.indexOf(searchString);
                        if (not) {
                            if (position > -1) {
                                return -1;
                            }
                            if (position == -1) {
                                return 0;
                            }
                            return -1;
                        }
                        return position;
                    }
                    int position = string.toUpperCase().indexOf(searchString.toUpperCase());
                    if (not) {
                        if (position > -1) {
                            return -1;
                        }
                        if (position == -1) {
                            return 0;
                        }
                        return -1;
                    }
                    return position;
                }
                catch (PatternSyntaxException ex) {
                    return -1;
                }
            }
            return -1;
        }
        return -1;
    }

    public static String getContentToShow(String pattern, String content, boolean caseSensitive, int start, boolean useRegEx) {
        Object s;
        block13: {
            s = content;
            Pattern p = null;
            try {
                if ("".equals(content)) {
                    return content;
                }
                if ("*".equalsIgnoreCase(pattern)) {
                    if ("".equals(content)) {
                        return content;
                    }
                    if (20 > content.length()) {
                        return content;
                    }
                    return content.substring(0, 20);
                }
                if (content.length() < pattern.length()) break block13;
                Object strBefore = "";
                String strAfter = "";
                String actualFoundText = "";
                int sS = 0;
                int eE = 0;
                if (useRegEx) {
                    p = caseSensitive ? Pattern.compile(pattern) : Pattern.compile(pattern, 2);
                    Matcher m = p.matcher(content);
                    m.find();
                    sS = m.start();
                    eE = m.end() - 1;
                    if (eE > sS) {
                        actualFoundText = content.substring(sS, eE);
                    }
                } else {
                    sS = start;
                    eE = sS + pattern.length();
                    if (eE > sS) {
                        actualFoundText = content.substring(start, start + pattern.length());
                    }
                }
                try {
                    strBefore = "..." + content.substring(sS - 20, sS);
                }
                catch (StringIndexOutOfBoundsException e) {
                    strBefore = content.substring(0, sS);
                }
                if (eE < 0) {
                    eE = 0;
                }
                strAfter = content.substring(eE, content.length());
                s = (String)strBefore + "<b>" + actualFoundText + "</b>" + strAfter;
            }
            catch (PatternSyntaxException ex) {
                boolean bl = false;
            }
        }
        return s;
    }

    public static boolean isReadOnlyProperty(ClassDescription classDescription, String propertyId) {
        for (ClassDescription.PropertyDescription pd : classDescription.getROPropertiesList()) {
            if (!pd.name.equals(propertyId)) continue;
            return true;
        }
        return false;
    }

    public static boolean isObjectTypeProperty(ClassDescription classDescription, String propertyId) {
        for (PropertyObject po : classDescription.getSearchablePropertyObjectsList()) {
            ClassDescription.PropertyDescription pd = po.getPropertyDescription();
            String className = pd.className;
            if (!pd.name.equals(propertyId)) continue;
            return className.indexOf("java.lang.String") <= -1 && className.indexOf("java.lang.Integer") <= -1 && className.indexOf("java.lang.Boolean") <= -1 && className.indexOf("boolean") <= -1 && className.indexOf("float") <= -1 && className.indexOf("short") <= -1 && className.indexOf("long") <= -1 && className.indexOf("double") <= -1 && className.indexOf("int") <= -1;
        }
        return false;
    }

    public static String getReportFileName(String reportsPath, String reportName) {
        long lastUsedIdx = 0L;
        long currIdx = 0L;
        try {
            File[] listOfFiles;
            File folder = new File(reportsPath);
            if (!folder.exists()) {
                folder.mkdir();
            }
            if ((listOfFiles = folder.listFiles()) == null) {
                listOfFiles = new File(folder.getParent()).listFiles();
            }
            for (int i = 0; i < listOfFiles.length; ++i) {
                File currentFile = listOfFiles[i];
                String reportFileName = currentFile.getName();
                if (!currentFile.isFile() || !reportFileName.startsWith(reportName) || reportFileName.indexOf("_rs") != -1) continue;
                String currentIndex = reportFileName.substring(reportFileName.indexOf("_") + 1, reportFileName.indexOf("."));
                try {
                    currIdx = new Long(currentIndex);
                    if (currIdx <= lastUsedIdx) continue;
                    lastUsedIdx = currIdx;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("ReportUtils.getLastUsedFileIdx() Exception : " + e);
        }
        return reportName + "_" + (lastUsedIdx + 1L);
    }

    public static String getReportsPath(ApplicationView appView) {
        String reportsPath = "";
        reportsPath = appView.getSettings().getDefaultReportsPath();
        if (reportsPath.equals("") || reportsPath == null) {
            reportsPath = new File(ApplicationView.basePath, "reports").getAbsolutePath();
        }
        if (!ReportUtils.hasPermissions(reportsPath)) {
            reportsPath = new File(appView.getUserHomeDirectory().getFile()).getAbsolutePath();
        }
        return reportsPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasPermissions(String path) {
        PrintWriter out = null;
        try {
            File f = new File(path + "/test.log");
            FileWriter outFile = new FileWriter(f);
            out = new PrintWriter(outFile);
            out.write("test");
            out.flush();
            out.close();
            out = null;
            f.delete();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            LOGGER.error("ReportsGenerator.hasPermissions() " + e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
                out = null;
            }
        }
    }

    public static void reloadSearchProfilesMap(ApplicationView appView) {
        searchProfilesProperties.clear();
        try {
            for (SearchProfile sp : appView.getSearchProfiles()) {
                if (!sp.isActive()) continue;
                for (Map.Entry<SearchSet, List<SearchProfile.Property>> pairs : sp.getObjects().entrySet()) {
                    String clazzName = pairs.getKey().getClazz().getName();
                    ArrayList<String> tempList = new ArrayList<String>();
                    List<SearchProfile.Property> propertiesList = pairs.getValue();
                    for (SearchProfile.Property property : propertiesList) {
                        if (!property.isUsed()) continue;
                        tempList.add(property.getPd().name);
                    }
                    searchProfilesProperties.put(clazzName, tempList);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception in ReportUtils.reloadSearchProfilesMap() ", e);
        }
    }

    static {
        searchProfilesProperties = new HashMap();
        dateFormat = MDConfiguration.getDefaultInstance().get("dateonlyformat");
        bValues = Arrays.asList("true", "yes", "y", "TRUE", "YES", "Y");
        LOGGER = new Logger(ReportUtils.class);
    }

    public static class SearchSetsComparator
    implements Comparator {
        public int compare(Object one, Object two) {
            String v1 = "";
            String v2 = "";
            if (one instanceof SearchSet) {
                v1 = ((SearchSet)one).getTypeName();
                if (v1 == null) {
                    v1 = "";
                }
            } else {
                v1 = (String)one;
            }
            if (two instanceof SearchSet) {
                v2 = ((SearchSet)two).getTypeName();
                if (v2 == null) {
                    v2 = "";
                }
            } else {
                v2 = (String)two;
            }
            return v1.compareTo(v2);
        }
    }

    static class SortedComboBoxModel
    extends DefaultComboBoxModel {
        private Comparator comparator;

        protected static Vector sortVector(Vector items, Comparator comparator) {
            Collections.sort(items, comparator);
            return items;
        }

        protected static Object[] sortArray(Object[] items, Comparator comparator) {
            Arrays.sort(items, comparator);
            return items;
        }

        public SortedComboBoxModel() {
        }

        public SortedComboBoxModel(Comparator comparator) {
            this.comparator = comparator;
        }

        public SortedComboBoxModel(Object[] items) {
            super(SortedComboBoxModel.sortArray(items, null));
        }

        public SortedComboBoxModel(Object[] items, Comparator comparator) {
            super(SortedComboBoxModel.sortArray(items, comparator));
            this.comparator = comparator;
        }

        public SortedComboBoxModel(Vector items) {
            this(items, null);
        }

        public SortedComboBoxModel(Vector items, Comparator comparator) {
            super(SortedComboBoxModel.sortVector(items, comparator));
            this.comparator = comparator;
        }

        @Override
        public void addElement(Object element) {
            this.insertElementAt(element, 0);
        }

        @Override
        public void insertElementAt(Object element, int index) {
            Comparable c;
            Object o;
            int size = this.getSize();
            for (index = 0; index < size && !(this.comparator != null ? this.comparator.compare(o = this.getElementAt(index), element) > 0 : (c = (Comparable)this.getElementAt(index)).compareTo(element) > 0); ++index) {
            }
            super.insertElementAt(element, index);
        }
    }

    public static class ResultObjectsComparator
    implements Comparator {
        public int compare(Object one, Object two) {
            SearchResultObject s1 = (SearchResultObject)one;
            SearchResultObject s2 = (SearchResultObject)two;
            return ((ModelIDObject)s1.getObj()).getLongName().compareTo(((ModelIDObject)s2.getObj()).getLongName());
        }
    }

    static class ColumnsComparator
    implements Comparator {
        ColumnsComparator() {
        }

        public int compare(Object one, Object two) {
            ReportColumn s1 = (ReportColumn)one;
            ReportColumn s2 = (ReportColumn)two;
            if (s1.getColumnName().equalsIgnoreCase("name")) {
                return -1;
            }
            if (s2.getColumnName().equalsIgnoreCase("name")) {
                return 1;
            }
            return s1.getColumnName().compareTo(s2.getColumnName());
        }
    }
}

