/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.reports;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.SpringLayout;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.miginfocom.layout.CC;
import net.miginfocom.swing.MigLayout;
import oracle.dbtools.crest.model.ChangeRequest;
import oracle.dbtools.crest.model.ElementSet;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Measurement;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.model.metadata.MetaDataManager;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.UserDefinedProperty;
import oracle.dbtools.crest.swingui.search.JSearchTextField;
import oracle.dbtools.crest.swingui.search.SearchResultObject;
import oracle.dbtools.crest.swingui.wizards.reports.BaseReportsGenerationDialog;
import oracle.dbtools.crest.swingui.wizards.reports.CustomReportTemplate;
import oracle.dbtools.crest.swingui.wizards.reports.CustomReportTemplatesPersistence;
import oracle.dbtools.crest.swingui.wizards.reports.Messages;
import oracle.dbtools.crest.swingui.wizards.reports.ReportColumn;
import oracle.dbtools.crest.swingui.wizards.reports.ReportConstants;
import oracle.dbtools.crest.swingui.wizards.reports.ReportObject;
import oracle.dbtools.crest.swingui.wizards.reports.ReportSection;
import oracle.dbtools.crest.swingui.wizards.reports.ReportUtils;
import oracle.dbtools.crest.swingui.wizards.reports.ReportsGenerationDialog;
import oracle.dbtools.crest.util.CustomDialogML;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.MoveUpDownListJTable;
import oracle.dbtools.crest.util.logging.Logger;

public class CustomReportsTemplatesDialog
extends CustomDialogML {
    private final String ITEMS_DISABLED = Messages.getString("CustomReportsTemplatesDialog.LockedControlsMsg");
    private int countSelectedProperties;
    private int countSelectedCollections;
    private static final String TEMPLATE_NAME = "CRTemplate";
    private static GUIConfiguration conf = GUIConfiguration.getInstance();
    private JDialog dialog;
    private JPanel mainPanel;
    private JPanel templatesPanel;
    private JPanel templateDetailsPanel;
    private JPanel buttonsPanel;
    private JButton btnAdd;
    private JButton btnSave;
    private JButton btnCancel;
    private JButton btnEdit;
    private JButton btnRemove;
    private JTextField txtName;
    private JTextArea description;
    private DefaultListModel customReportTemplatesModel;
    private int cgCounter = 0;
    private JList reportTemplatesList;
    private boolean isSaved = true;
    private BaseReportsGenerationDialog parent;
    private CustomReportTemplatesPersistence crtPersistence;
    private JSearchTextField availablePropertiesFilter;
    private List currentAvailablePropertiesList;
    private JList availablePropertiesList;
    private LinkedList<ReportColumn> selectedPropertiesList;
    private JTable selectedPropertiesTable;
    private DefaultListModel availablePropertiesModel;
    private JScrollPane reportLayoutScrollPane;
    private JScrollPane selectedPropertiesScrollPane;
    private JButton btnPropertyAdd;
    private JButton btnPropertyRemove;
    private JButton btnPropertyMoveUp;
    private JButton btnPropertyMoveDown;
    private JButton btnSectionAdd;
    private JButton btnSectionRemove;
    private JButton btnSectionMoveUp;
    private JButton btnSectionMoveDown;
    private SelectedPropertiesModel selectedPropertiesModel;
    private List searchableProperties;
    private ArrayList currentCRTs;
    private ModelIDObject currentModel;
    private Class currentObjectClass;
    private MetaDataManager metaDataManager;
    private ClassDescription classDescription;
    private Class clazz;
    private GUIConfiguration configuration;
    private List currentAvailableCollectionsList;
    private JSearchTextField availableCollectionsFilter;
    private DefaultListModel availableCollectionsModel;
    private JList availableCollectionsList;
    private JTable reportLayoutTable;
    private List reportLayoutTableList;
    private ReportLayoutTableModel reportLayoutTableModel;
    private CustomReportTemplate selectedCustomReportTemplate;
    private CustomReportTemplate backupCustomReportTemplate;
    private ReportSection previousReportSection = null;
    private ReportSection currentSelectedReportSection = null;
    private JPanel jpSelectedP;
    private JPanel layoutPanel;
    private List objectsList;
    private int dialogMinWidth = 900;
    private int dialogMinHeight = 600;
    private static final Logger LOGGER = new Logger(CustomReportsTemplatesDialog.class);

    public CustomReportsTemplatesDialog(ApplicationView appView, Class clazz, BaseReportsGenerationDialog parent, CustomReportTemplatesPersistence crtPersistence, List searchableProperties, ModelIDObject currentModel, Class currentObjectClass, List objectsList) {
        super(appView);
        this.parent = parent;
        this.clazz = clazz;
        this.crtPersistence = crtPersistence;
        this.searchableProperties = searchableProperties;
        this.currentModel = currentModel;
        this.currentObjectClass = currentObjectClass;
        this.objectsList = objectsList;
        this.metaDataManager = appView.getXMLTransformationManager().getMetaDataManager();
        this.classDescription = this.metaDataManager.getClassDescription(currentObjectClass.getName());
        this.currentCRTs = appView.getCustomReportTemplates();
        this.mainPanel = new JPanel((LayoutManager)new MigLayout("", "0[150!]0[grow]0", "0[grow]0"));
        this.configuration = GUIConfiguration.getInstance();
        this.initTemplatesPanel();
        this.initTemplateDetailsPanel();
        this.initButtonsPanel();
        this.loadTemplates();
        this.mainPanel.add((Component)this.templatesPanel, new CC().grow());
        this.mainPanel.add((Component)this.templateDetailsPanel, new CC().grow().wrap());
        this.mainPanel.add((Component)this.buttonsPanel, new CC().spanX().alignX("right"));
        this.add((Component)this.mainPanel, new CC().grow());
    }

    private void initTemplatesPanel() {
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorder(null);
        this.templatesPanel = new JPanel(new BorderLayout());
        this.templatesPanel.setPreferredSize(new Dimension(150, 500));
        this.templatesPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ReportTemplatesDialog.ReportTemplates")));
        this.btnAdd = new JButton(GUIConfiguration.getInstance().getIcon("ADD_ICON", 16));
        this.btnAdd.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnAdd.setEnabled(true);
        this.btnAdd.addActionListener(new AddAction());
        this.btnAdd.setMnemonic(65);
        this.btnAdd.setToolTipText(Messages.getString("CustomizableReportsTemplatesDialog.Add"));
        this.btnEdit = new JButton(GUIConfiguration.getInstance().getIcon("EDIT_ICON", 16));
        this.btnEdit.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnEdit.setEnabled(false);
        this.btnEdit.addActionListener(new EditAction());
        this.btnEdit.setMnemonic(69);
        this.btnEdit.setToolTipText(Messages.getString("CustomReportsTemplatesDialog.Edit"));
        this.btnRemove = new JButton(GUIConfiguration.getInstance().getIcon("REMOVE_ICON", 16));
        this.btnRemove.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnRemove.setEnabled(false);
        this.btnRemove.addActionListener(new RemoveAction());
        this.btnRemove.setMnemonic(82);
        this.btnRemove.setToolTipText(Messages.getString("CustomizableReportsTemplatesDialog.Remove"));
        this.btnSave = new JButton(GUIConfiguration.getInstance().getIcon("SAVE_ICON", 16));
        this.btnSave.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnSave.setEnabled(false);
        this.btnSave.addActionListener(new SaveAction());
        this.btnSave.setMnemonic(83);
        this.btnSave.setToolTipText(Messages.getString("CustomReportsTemplatesDialog.Save"));
        this.btnCancel = new JButton(GUIConfiguration.getInstance().getIcon("CANCEL_ICON", 16));
        this.btnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnCancel.setEnabled(false);
        this.btnCancel.addActionListener(new CancelAction());
        this.btnCancel.setMnemonic(67);
        this.btnCancel.setToolTipText(Messages.getString("CustomReportsTemplatesDialog.CancelEdit"));
        toolBar.add(this.btnAdd);
        toolBar.add(this.btnEdit);
        toolBar.add(this.btnCancel);
        toolBar.add(this.btnRemove);
        toolBar.add(this.btnSave);
        this.customReportTemplatesModel = new DefaultListModel();
        this.reportTemplatesList = new JList(this.customReportTemplatesModel);
        this.reportTemplatesList.setCellRenderer(new TemplateReportRenderer());
        this.reportTemplatesList.setSelectionMode(0);
        JScrollPane reportTemplatesSP = new JScrollPane(this.reportTemplatesList);
        reportTemplatesSP.setPreferredSize(new Dimension(200, 500));
        this.reportTemplatesList.getSelectionModel().addListSelectionListener(new TemplateListSelectionListener());
        this.templatesPanel.add((Component)toolBar, "North");
        this.templatesPanel.add((Component)reportTemplatesSP, "Center");
    }

    private void initButtonsPanel() {
        this.buttonsPanel = new JPanel(new FlowLayout(2));
        JButton bnClose = new JButton(Messages.getString("CustomizableReportsTemplatesDialog.Close"));
        bnClose.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnClose.addActionListener(new CloseAction());
        bnClose.setMnemonic(67);
        JButton bnHelp = new JButton(this.getHelpAction());
        bnHelp.setMnemonic(72);
        bnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.buttonsPanel.add(bnClose);
        this.buttonsPanel.add(bnHelp);
    }

    private void initTemplateDetailsPanel() {
        this.templateDetailsPanel = new JPanel((LayoutManager)new MigLayout("", "0[grow]0[]0[grow]0", "0[]0[grow]0[grow]0"));
        this.templateDetailsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("CustomReportsTemplatesDialog.Template")));
        JPanel nameAndDecriptionPanel = new JPanel(new SpringLayout());
        nameAndDecriptionPanel.setMinimumSize(new Dimension(570, 110));
        JLabel lblName = new JLabel(Messages.getString("CustomizableReportsTemplatesDialog.Name"));
        lblName.setPreferredSize(new Dimension(80, 20));
        CommonUtil.setLabelConstraints((SpringLayout)nameAndDecriptionPanel.getLayout(), lblName, 5, 5);
        this.txtName = new JTextField();
        this.txtName.setEnabled(false);
        this.txtName.setPreferredSize(new Dimension(300, 20));
        CommonUtil.setObjectConstraints((SpringLayout)nameAndDecriptionPanel.getLayout(), this.txtName, 100, 5);
        JLabel lblComments = new JLabel(Messages.getString("CustomizableReportsTemplatesDialog.Description"));
        lblComments.setPreferredSize(new Dimension(80, 20));
        CommonUtil.setLabelConstraints((SpringLayout)nameAndDecriptionPanel.getLayout(), lblComments, 5, 35);
        this.description = new JTextArea();
        this.description.setEnabled(false);
        this.description.setLineWrap(true);
        this.description.setWrapStyleWord(true);
        JScrollPane commentsScrollPane = new JScrollPane(this.description);
        commentsScrollPane.setPreferredSize(new Dimension(300, 50));
        CommonUtil.setObjectConstraints((SpringLayout)nameAndDecriptionPanel.getLayout(), commentsScrollPane, 100, 35);
        nameAndDecriptionPanel.add(lblName);
        nameAndDecriptionPanel.add(this.txtName);
        nameAndDecriptionPanel.add(lblComments);
        nameAndDecriptionPanel.add(commentsScrollPane);
        JPanel availableCollectionsPanel = new JPanel((LayoutManager)new MigLayout("", "0[grow]0", "0[]2[grow]0"));
        availableCollectionsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("CustomReportsTemplatesDialog.AvailableCollections")));
        this.currentAvailableCollectionsList = new ArrayList();
        this.availableCollectionsFilter = new JSearchTextField(true, true, "Name");
        this.availableCollectionsFilter.setEnabled(false);
        this.availableCollectionsFilter.setPreferredSize(new Dimension(120, 20));
        this.availableCollectionsFilter.getDocument().addDocumentListener(new CollectionFilterListener());
        this.availableCollectionsModel = new DefaultListModel();
        this.availableCollectionsList = new JList(this.availableCollectionsModel);
        this.availableCollectionsList.setEnabled(false);
        this.availableCollectionsList.setCellRenderer(new CollectionRenderer());
        JScrollPane availableCollectionsScrollPane = new JScrollPane(this.availableCollectionsList);
        this.availableCollectionsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    if (!CustomReportsTemplatesDialog.this.isSaved) {
                        if (CustomReportsTemplatesDialog.this.availableCollectionsList.getSelectedIndex() == -1) {
                            CustomReportsTemplatesDialog.this.btnSectionAdd.setEnabled(false);
                        } else {
                            CustomReportsTemplatesDialog.this.btnSectionAdd.setEnabled(true);
                        }
                    } else {
                        CustomReportsTemplatesDialog.this.btnSectionAdd.setEnabled(false);
                    }
                }
            }
        });
        this.availableCollectionsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int index = CustomReportsTemplatesDialog.this.availableCollectionsList.locationToIndex(e.getPoint());
                    CustomReportsTemplatesDialog.this.btnSectionAdd.doClick();
                }
            }
        });
        availableCollectionsPanel.add((Component)this.availableCollectionsFilter, new CC().wrap());
        availableCollectionsPanel.add((Component)availableCollectionsScrollPane, new CC().grow());
        JPanel sectionAddRemovePanel = new JPanel((LayoutManager)new MigLayout("", "0[32!]0", "0[]0[]0"));
        this.btnSectionAdd = new JButton(this.configuration.getIcon("MOVE_RIGHT_ICON", 16));
        this.btnSectionAdd.addActionListener(new AddSectionActionListener());
        this.btnSectionAdd.setEnabled(false);
        this.btnSectionAdd.setMaximumSize(new Dimension(32, 32));
        this.btnSectionAdd.setToolTipText(Messages.getString("CustomReportsTemplatesDialog.AddSection"));
        this.btnSectionRemove = new JButton(this.configuration.getIcon("MOVE_LEFT_ICON", 16));
        this.btnSectionRemove.addActionListener(new RemoveSectionActionListener());
        this.btnSectionRemove.setEnabled(false);
        this.btnSectionRemove.setMaximumSize(new Dimension(32, 32));
        this.btnSectionRemove.setToolTipText(Messages.getString("CustomReportsTemplatesDialog.RemoveSection"));
        sectionAddRemovePanel.add((Component)this.btnSectionAdd, new CC().wrap());
        sectionAddRemovePanel.add(this.btnSectionRemove);
        JPanel sectionMoveUpDownPanel = new JPanel((LayoutManager)new MigLayout("", "0[32!]0", "0[]0[]0"));
        this.btnSectionMoveUp = new JButton(this.configuration.getIcon("MOVE_UP_ICON", 16));
        this.btnSectionMoveUp.setEnabled(false);
        this.btnSectionMoveUp.setMaximumSize(new Dimension(32, 32));
        this.btnSectionMoveUp.setToolTipText(Messages.getString("CustomReportsTemplatesDialog.MoveUpSection"));
        this.btnSectionMoveDown = new JButton(this.configuration.getIcon("MOVE_DOWN_ICON", 16));
        this.btnSectionMoveDown.setEnabled(false);
        this.btnSectionMoveDown.setMaximumSize(new Dimension(32, 32));
        this.btnSectionMoveDown.setToolTipText(Messages.getString("CustomReportsTemplatesDialog.MoveDownSection"));
        sectionMoveUpDownPanel.add((Component)this.btnSectionMoveUp, new CC().wrap());
        sectionMoveUpDownPanel.add(this.btnSectionMoveDown);
        this.reportLayoutTableList = new ArrayList();
        this.reportLayoutTableModel = new ReportLayoutTableModel();
        ClassDescription cd = this.metaDataManager.getClassDescription(this.clazz.getName());
        this.reportLayoutTable = new JTable(this.reportLayoutTableModel);
        this.reportLayoutTable.getTableHeader().setReorderingAllowed(false);
        this.reportLayoutTable.setSelectionMode(0);
        this.reportLayoutTable.setShowGrid(false);
        MultiLineHeaderRenderer renderer = new MultiLineHeaderRenderer();
        Enumeration<TableColumn> en = this.reportLayoutTable.getColumnModel().getColumns();
        while (en.hasMoreElements()) {
            en.nextElement().setHeaderRenderer(renderer);
        }
        MoveUpDownListJTable upDown = new MoveUpDownListJTable(this.reportLayoutTableList, this.reportLayoutTable);
        this.btnSectionMoveUp.addActionListener(new UpDownAction(new MoveUpDownListJTable.MoveUpAction(upDown)));
        this.btnSectionMoveDown.addActionListener(new UpDownAction(new MoveUpDownListJTable.MoveDownAction(upDown)));
        TableColumn tc0 = this.reportLayoutTable.getColumnModel().getColumn(0);
        tc0.setCellRenderer(new ReportSectionsRenderer());
        tc0.setPreferredWidth(120);
        tc0.setMinWidth(10);
        TableColumn tc1 = this.reportLayoutTable.getColumnModel().getColumn(1);
        tc1.setPreferredWidth(80);
        tc1.setMinWidth(10);
        tc1.setCellRenderer(new ReportLayoutCustomNameRenderer());
        tc1.setCellEditor(new SelectedSectionCustomNameCellEditor(new JTextField()));
        TableColumn tc2 = this.reportLayoutTable.getColumnModel().getColumn(2);
        this.reportLayoutTable.getColumnModel().removeColumn(tc2);
        this.reportLayoutTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                try {
                    CustomReportsTemplatesDialog.stopCellEditing(CustomReportsTemplatesDialog.this.selectedPropertiesTable);
                    CustomReportsTemplatesDialog.this.selectedPropertiesTable.clearSelection();
                    if (!e.getValueIsAdjusting()) {
                        if (CustomReportsTemplatesDialog.this.reportLayoutTable.getSelectedRow() == -1) {
                            CustomReportsTemplatesDialog.this.btnSectionRemove.setEnabled(false);
                            CustomReportsTemplatesDialog.this.btnSectionMoveUp.setEnabled(false);
                            CustomReportsTemplatesDialog.this.btnSectionMoveDown.setEnabled(false);
                            CustomReportsTemplatesDialog.this.availablePropertiesFilter.setText("");
                            CustomReportsTemplatesDialog.this.availablePropertiesModel.removeAllElements();
                            CustomReportsTemplatesDialog.this.selectedPropertiesList.clear();
                            CustomReportsTemplatesDialog.this.selectedPropertiesTable.updateUI();
                            CustomReportsTemplatesDialog.this.currentAvailablePropertiesList.clear();
                        } else {
                            CustomReportsTemplatesDialog.this.currentSelectedReportSection = (ReportSection)CustomReportsTemplatesDialog.this.reportLayoutTableList.get(CustomReportsTemplatesDialog.this.reportLayoutTable.convertRowIndexToModel(CustomReportsTemplatesDialog.this.reportLayoutTable.getSelectedRow()));
                            CustomReportsTemplatesDialog.this.savePeviousReportSection();
                            CustomReportsTemplatesDialog.this.currentAvailablePropertiesList.clear();
                            CustomReportsTemplatesDialog.this.previousReportSection = CustomReportsTemplatesDialog.this.currentSelectedReportSection;
                            CustomReportsTemplatesDialog.this.reloadCollectionsAndProperties(CustomReportsTemplatesDialog.this.currentSelectedReportSection);
                            CustomReportsTemplatesDialog.this.reloadUDPAndDynamicProperties(CustomReportsTemplatesDialog.this.currentSelectedReportSection);
                            CustomReportsTemplatesDialog.this.sort(CustomReportsTemplatesDialog.this.availablePropertiesModel);
                            CustomReportsTemplatesDialog.this.selectedPropertiesTable.updateUI();
                            if (!CustomReportsTemplatesDialog.this.isSaved) {
                                CustomReportsTemplatesDialog.this.btnSectionRemove.setEnabled(CustomReportsTemplatesDialog.this.currentSelectedReportSection.getLevel() > 0);
                                CustomReportsTemplatesDialog.this.btnSectionMoveUp.setEnabled(CustomReportsTemplatesDialog.this.currentSelectedReportSection.getLevel() > 0 && CustomReportsTemplatesDialog.this.reportLayoutTable.getSelectedRow() > 1);
                                CustomReportsTemplatesDialog.this.btnSectionMoveDown.setEnabled(CustomReportsTemplatesDialog.this.currentSelectedReportSection.getLevel() > 0);
                                CustomReportsTemplatesDialog.this.btnPropertyMoveDown.setEnabled(false);
                                CustomReportsTemplatesDialog.this.btnPropertyMoveUp.setEnabled(false);
                                CustomReportsTemplatesDialog.this.btnPropertyAdd.setEnabled(false);
                                CustomReportsTemplatesDialog.this.btnPropertyRemove.setEnabled(false);
                            }
                            CustomReportsTemplatesDialog.this.recalculateTotalColumnWidths();
                            CustomReportsTemplatesDialog.this.runAvailablePropertiesFilter();
                        }
                    }
                }
                catch (Exception ex) {
                    LOGGER.error("CustomReportsTemplatesDialog : Chaange section " + ex);
                }
            }
        });
        this.reportLayoutTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    CustomReportsTemplatesDialog.this.btnSectionRemove.doClick();
                }
            }
        });
        this.reportLayoutScrollPane = new JScrollPane(this.reportLayoutTable);
        JPanel availablePropertiesPanel = new JPanel((LayoutManager)new MigLayout("", "0[grow]0", "0[]2[grow]0"));
        availablePropertiesPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("CustomizableReportsTemplatesDialog.AvailableProperties")));
        this.availablePropertiesModel = new DefaultListModel();
        this.currentAvailablePropertiesList = new ArrayList();
        this.availablePropertiesFilter = new JSearchTextField(true, true, "Name");
        this.availablePropertiesFilter.setEnabled(false);
        this.availablePropertiesFilter.setPreferredSize(new Dimension(120, 20));
        this.availablePropertiesFilter.getDocument().addDocumentListener(new PropertyFilterListener());
        this.availablePropertiesList = new JList(this.availablePropertiesModel);
        this.availablePropertiesList.setEnabled(false);
        this.availablePropertiesList.setCellRenderer(new PObjectCellRenderer());
        JScrollPane availablePropertiesScrollPane = new JScrollPane(this.availablePropertiesList);
        availablePropertiesScrollPane.setPreferredSize(new Dimension(200, 350));
        this.availablePropertiesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (CustomReportsTemplatesDialog.this.availablePropertiesList.getSelectedIndex() == -1) {
                    CustomReportsTemplatesDialog.this.btnPropertyAdd.setEnabled(false);
                } else {
                    CustomReportsTemplatesDialog.this.btnPropertyAdd.setEnabled(true);
                }
            }
        });
        this.availablePropertiesList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int index = CustomReportsTemplatesDialog.this.availablePropertiesList.locationToIndex(e.getPoint());
                    CustomReportsTemplatesDialog.this.btnPropertyAdd.doClick();
                }
            }
        });
        this.availablePropertiesList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent ke) {
                CustomReportsTemplatesDialog.this.findAndSelectItem(ke.getKeyChar());
            }
        });
        availablePropertiesPanel.add((Component)this.availablePropertiesFilter, new CC().wrap());
        availablePropertiesPanel.add((Component)availablePropertiesScrollPane, new CC().grow());
        JPanel propertyAddRemovePanel = new JPanel((LayoutManager)new MigLayout("", "0[32!]0", "0[]0[]0"));
        this.btnPropertyAdd = new JButton(this.configuration.getIcon("MOVE_RIGHT_ICON", 16));
        this.btnPropertyAdd.addActionListener(new AddPropertyActionListener());
        this.btnPropertyAdd.setEnabled(false);
        this.btnPropertyAdd.setMaximumSize(new Dimension(32, 32));
        this.btnPropertyAdd.setToolTipText(Messages.getString("CustomReportsTemplatesDialog.AddColToReportSection"));
        this.btnPropertyRemove = new JButton(this.configuration.getIcon("MOVE_LEFT_ICON", 16));
        this.btnPropertyRemove.addActionListener(new RemovePropertyActionListener());
        this.btnPropertyRemove.setEnabled(false);
        this.btnPropertyRemove.setMaximumSize(new Dimension(32, 32));
        this.btnPropertyRemove.setToolTipText(Messages.getString("CustomReportsTemplatesDialog.RemoveColFromReportSection"));
        propertyAddRemovePanel.add((Component)this.btnPropertyAdd, new CC().wrap());
        propertyAddRemovePanel.add(this.btnPropertyRemove);
        this.selectedPropertiesList = new LinkedList();
        this.selectedPropertiesModel = new SelectedPropertiesModel();
        this.selectedPropertiesTable = new JTable(this.selectedPropertiesModel);
        this.selectedPropertiesTable.getTableHeader().setReorderingAllowed(false);
        this.selectedPropertiesTable.setDefaultRenderer(Object.class, new TableRowColorRenderer(this.selectedPropertiesList));
        this.selectedPropertiesTable.setEnabled(false);
        MultiLineHeaderRenderer renderer1 = new MultiLineHeaderRenderer();
        Enumeration<TableColumn> en1 = this.selectedPropertiesTable.getColumnModel().getColumns();
        while (en1.hasMoreElements()) {
            TableColumn col = en1.nextElement();
            col.setHeaderRenderer(renderer1);
        }
        this.selectedPropertiesScrollPane = new JScrollPane(this.selectedPropertiesTable);
        this.selectedPropertiesTable.setSelectionMode(2);
        TableColumn col0 = this.selectedPropertiesTable.getColumnModel().getColumn(0);
        col0.setCellRenderer(new SelectedPropertyNameCellRenderer());
        col0.setMinWidth(60);
        col0.setPreferredWidth(60);
        col0.setMaxWidth(60);
        TableColumn col1 = this.selectedPropertiesTable.getColumnModel().getColumn(1);
        col1.setPreferredWidth(170);
        col1.setMinWidth(10);
        TableColumn col2 = this.selectedPropertiesTable.getColumnModel().getColumn(2);
        col2.setCellEditor(new SelectedPropertyNameCellEditor(new JTextField()));
        col2.setPreferredWidth(210);
        col2.setMinWidth(10);
        TableColumn col3 = this.selectedPropertiesTable.getColumnModel().getColumn(3);
        col3.setCellEditor(new SelectedPropertyWidthCellEditor(new JTextField()));
        col3.setMinWidth(80);
        col3.setMaxWidth(80);
        col3.setPreferredWidth(80);
        col3.setCellRenderer(this.selectedPropertiesTable.getDefaultRenderer(Integer.class));
        TableColumn col4 = this.selectedPropertiesTable.getColumnModel().getColumn(4);
        ArrayList<Object> orderValues = new ArrayList<Object>();
        orderValues.add(" ");
        for (int j = 1; j <= 30; ++j) {
            orderValues.add(j);
        }
        col4.setCellEditor(new OrderComboBoxEditor(orderValues.toArray()));
        col4.setCellRenderer(new OrderComboBoxRenderer(orderValues.toArray()));
        col4.setMinWidth(50);
        col4.setMaxWidth(50);
        col4.setPreferredWidth(50);
        JTableHeader header = this.selectedPropertiesTable.getTableHeader();
        ColumnHeaderToolTips tips = new ColumnHeaderToolTips();
        tips.setToolTip(this.selectedPropertiesTable.getColumnModel().getColumn(2), Messages.getString("CustomizableReportsTemplatesDialog.CustomColumnName"));
        header.addMouseMotionListener(tips);
        this.selectedPropertiesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (CustomReportsTemplatesDialog.this.selectedPropertiesTable.getSelectedRowCount() >= 1) {
                    if (CustomReportsTemplatesDialog.this.selectedPropertiesTable.getRowCount() == 1) {
                        CustomReportsTemplatesDialog.this.btnPropertyMoveUp.setEnabled(false);
                        CustomReportsTemplatesDialog.this.btnPropertyMoveDown.setEnabled(false);
                    } else {
                        CustomReportsTemplatesDialog.this.btnPropertyMoveUp.setEnabled(true);
                        CustomReportsTemplatesDialog.this.btnPropertyMoveDown.setEnabled(true);
                    }
                    CustomReportsTemplatesDialog.this.btnPropertyRemove.setEnabled(true);
                } else {
                    CustomReportsTemplatesDialog.this.btnPropertyRemove.setEnabled(false);
                    CustomReportsTemplatesDialog.this.btnPropertyMoveUp.setEnabled(false);
                    CustomReportsTemplatesDialog.this.btnPropertyMoveDown.setEnabled(false);
                }
            }
        });
        this.selectedPropertiesTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    CustomReportsTemplatesDialog.this.btnPropertyRemove.doClick();
                }
            }
        });
        JPanel propertyMoveUpDownPanel = new JPanel((LayoutManager)new MigLayout("", "0[32!]0", "0[]0[]0"));
        this.btnPropertyMoveUp = new JButton(this.configuration.getIcon("MOVE_UP_ICON", 16));
        MoveUpDownListJTable upDownP = new MoveUpDownListJTable(this.selectedPropertiesList, this.selectedPropertiesTable);
        this.btnPropertyMoveUp.addActionListener(new UpDownAction(new MoveUpDownListJTable.MoveUpAction(upDownP)));
        this.btnPropertyMoveUp.setEnabled(false);
        this.btnPropertyMoveUp.setMaximumSize(new Dimension(32, 32));
        this.btnPropertyMoveUp.setToolTipText(Messages.getString("CustomReportsTemplatesDialog.MoveUpReportColumn"));
        this.btnPropertyMoveDown = new JButton(this.configuration.getIcon("MOVE_DOWN_ICON", 16));
        this.btnPropertyMoveDown.addActionListener(new UpDownAction(new MoveUpDownListJTable.MoveDownAction(upDownP)));
        this.btnPropertyMoveDown.setEnabled(false);
        this.btnPropertyMoveDown.setMaximumSize(new Dimension(32, 32));
        this.btnPropertyMoveDown.setToolTipText(Messages.getString("CustomReportsTemplatesDialog.MoveDownReportColumn"));
        propertyMoveUpDownPanel.add((Component)this.btnPropertyMoveUp, new CC().wrap());
        propertyMoveUpDownPanel.add(this.btnPropertyMoveDown);
        this.jpSelectedP = new JPanel((LayoutManager)new MigLayout("", "0[grow]2[]0", "0[grow]0"));
        this.jpSelectedP.setBorder(BorderFactory.createTitledBorder(MessageFormat.format(Messages.getString("CustomizableReportsTemplatesDialog.ReportColumns"), this.countSelectedProperties)));
        this.jpSelectedP.add((Component)this.selectedPropertiesScrollPane, new CC().grow());
        this.jpSelectedP.add(propertyMoveUpDownPanel);
        this.layoutPanel = new JPanel((LayoutManager)new MigLayout("", "0[grow]2[]0", "0[grow]0"));
        this.layoutPanel.setBorder(BorderFactory.createTitledBorder(MessageFormat.format(Messages.getString("CustomReportsTemplatesDialog.ReportLayout"), this.countSelectedCollections)));
        this.layoutPanel.add((Component)this.reportLayoutScrollPane, new CC().grow());
        this.layoutPanel.add(sectionMoveUpDownPanel);
        this.templateDetailsPanel.add((Component)nameAndDecriptionPanel, new CC().spanX(3).wrap());
        this.templateDetailsPanel.add((Component)availableCollectionsPanel, new CC().grow());
        this.templateDetailsPanel.add(sectionAddRemovePanel);
        this.templateDetailsPanel.add((Component)this.layoutPanel, new CC().grow().wrap());
        this.templateDetailsPanel.add((Component)availablePropertiesPanel, new CC().grow());
        this.templateDetailsPanel.add(propertyAddRemovePanel);
        this.templateDetailsPanel.add((Component)this.jpSelectedP, new CC().grow().wrap());
    }

    private void reloadCollectionsAndProperties(ReportSection selectedReportSection) {
        this.selectedPropertiesList.clear();
        this.selectedPropertiesTable.updateUI();
        this.countSelectedProperties = 0;
        if (selectedReportSection != null) {
            try {
                Object obj = selectedReportSection.getElement();
                String className = "";
                Object method = null;
                if (obj instanceof ClassDescription) {
                    className = ((ClassDescription)obj).getClassName();
                } else if (obj instanceof ClassDescription.CollectionDescription) {
                    ClassDescription.CollectionDescription g = (ClassDescription.CollectionDescription)obj;
                    className = g.itemClassName;
                } else if (obj instanceof ClassDescription.PropertyDescription) {
                    ClassDescription.PropertyDescription pd = (ClassDescription.PropertyDescription)obj;
                    className = pd.itemClassName;
                }
                if (className != null && !className.equals("")) {
                    Class<?> clazz = Class.forName(className);
                    for (ReportColumn rc : selectedReportSection.getReportColumns()) {
                        this.selectedPropertiesList.add(rc);
                        ++this.countSelectedProperties;
                    }
                    this.selectedPropertiesTable.updateUI();
                    this.jpSelectedP.setBorder(BorderFactory.createTitledBorder(MessageFormat.format(Messages.getString("CustomizableReportsTemplatesDialog.ReportColumns"), this.countSelectedProperties)));
                    List allPropertiesList = ReportUtils.getSearchablePropertyDescriptions(clazz, this.metaDataManager);
                    for (ClassDescription.PropertyDescription pd : allPropertiesList) {
                        ReportColumn rc0 = new ReportColumn(pd.name, ReportUtils.getDisplayName(pd.name), 0.0, "", "", ReportConstants.isPropertyMassUpdatable(pd, this.currentModel), false, false);
                        boolean found = false;
                        for (ReportColumn rc1 : this.selectedPropertiesList) {
                            if (!rc0.getPropertyName().equals(rc1.getPropertyName())) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        this.availablePropertiesModel.addElement(rc0);
                        this.currentAvailablePropertiesList.add(rc0);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("CustomizableReportsTemplatesDialog.reloadCollectionsAndProperties() " + e);
            }
        }
    }

    private void reloadUDPAndDynamicProperties(ReportSection selectedReportSection) {
        block24: {
            if (this.clazz != Measurement.class || this.clazz != ChangeRequest.class) {
                try {
                    Object obj = selectedReportSection.getElement();
                    String className = "";
                    Method method = null;
                    if (obj instanceof ClassDescription) {
                        ClassDescription cd = (ClassDescription)obj;
                        className = cd.getClassName();
                    } else if (obj instanceof ClassDescription.CollectionDescription) {
                        ClassDescription.CollectionDescription g = (ClassDescription.CollectionDescription)obj;
                        method = g.getter;
                        className = g.itemClassName;
                    } else if (obj instanceof ClassDescription.PropertyDescription) {
                        ClassDescription.PropertyDescription pd = (ClassDescription.PropertyDescription)obj;
                        className = pd.itemClassName;
                        method = pd.getter;
                    }
                    if (className == null || className.equals("")) break block24;
                    for (Object o : this.objectsList) {
                        List<Object> l;
                        ModelIDObject mObj = null;
                        if (o instanceof SearchResultObject) {
                            SearchResultObject sro = (SearchResultObject)o;
                            mObj = (ModelIDObject)sro.getObj();
                        } else if (o instanceof ReportObject) {
                            ReportObject ro = (ReportObject)o;
                            mObj = (ModelIDObject)ro.getObject();
                        }
                        ReportColumn rc = null;
                        if (method == null) {
                            Iterator mObjIt = mObj.getPropertyNames();
                            while (mObjIt.hasNext()) {
                                String name = (String)mObjIt.next();
                                boolean notUDP = false;
                                for (UserDefinedProperty p : this.getApplicationView().getCurrentDesign().getUserDefinedProperties()) {
                                    if (!name.equals(p.getName())) continue;
                                    notUDP = true;
                                    break;
                                }
                                rc = !notUDP ? new ReportColumn(name, name, 0.0, "", "", false, true, false) : new ReportColumn(name, name, 0.0, "", "", false, false, true);
                                boolean foundS = false;
                                for (ReportColumn rc1 : this.selectedPropertiesList) {
                                    if (!rc.getPropertyName().equals(rc1.getPropertyName())) continue;
                                    foundS = true;
                                    break;
                                }
                                if (foundS) continue;
                                boolean foundA = false;
                                for (int i = 0; i < this.availablePropertiesModel.getSize(); ++i) {
                                    ReportColumn rc1 = (ReportColumn)this.availablePropertiesModel.getElementAt(i);
                                    if (!rc.getPropertyName().equals(rc1.getPropertyName())) continue;
                                    foundA = true;
                                    break;
                                }
                                if (foundA) continue;
                                this.availablePropertiesModel.addElement(rc);
                                this.currentAvailablePropertiesList.add(rc);
                            }
                            continue;
                        }
                        Iterator<Object> itemsListIt = null;
                        Object col = method.invoke((Object)mObj, new Object[0]);
                        if (col instanceof Collection) {
                            l = new ArrayList((Collection)col);
                            itemsListIt = l.iterator();
                        } else if (col instanceof ElementSet) {
                            l = Arrays.asList(((ElementSet)col).toArray());
                            itemsListIt = l.iterator();
                        }
                        if (itemsListIt == null) continue;
                        while (itemsListIt.hasNext()) {
                            ModelIDObject mo = (ModelIDObject)itemsListIt.next();
                            Iterator pNamesIt = mo.getPropertyNames();
                            while (pNamesIt.hasNext()) {
                                String name = (String)pNamesIt.next();
                                rc = new ReportColumn(name, name, 0.0, "", "", false, true, false);
                                boolean foundS = false;
                                for (ReportColumn rc1 : this.selectedPropertiesList) {
                                    if (!rc.getPropertyName().equals(rc1.getPropertyName())) continue;
                                    foundS = true;
                                    break;
                                }
                                if (foundS) continue;
                                boolean foundA = false;
                                for (int i = 0; i < this.availablePropertiesModel.getSize(); ++i) {
                                    ReportColumn rc1 = (ReportColumn)this.availablePropertiesModel.getElementAt(i);
                                    if (!rc.getPropertyName().equals(rc1.getPropertyName())) continue;
                                    foundA = true;
                                    break;
                                }
                                if (foundA) continue;
                                this.availablePropertiesModel.addElement(rc);
                                this.currentAvailablePropertiesList.add(rc);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.error("CustomizableReportsTemplatesDialog.reloadUDPAndDynamicProperties() " + e);
                }
            }
        }
    }

    private void initCollections() {
        ReportSection rs;
        boolean found;
        Iterator it1;
        this.availableCollectionsModel.removeAllElements();
        ClassDescription cd = this.metaDataManager.getClassDescription(this.clazz.getName());
        for (ClassDescription.CollectionDescription colDescr : cd.getCollectionsList()) {
            if (!colDescr.isUseInReport()) continue;
            it1 = this.reportLayoutTableList.iterator();
            found = false;
            while (it1.hasNext()) {
                rs = (ReportSection)it1.next();
                if (rs.getElementClassName().equals("") || !rs.getPropertyName().equals(colDescr.name)) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.availableCollectionsModel.addElement(colDescr);
            this.currentAvailableCollectionsList.add(colDescr);
        }
        for (ClassDescription.PropertyDescription pd : cd.getROPropertiesList()) {
            if (!pd.className.equals("java.util.ArrayList") && !pd.className.equals("java.util.List") || !pd.isUseInReport()) continue;
            it1 = this.reportLayoutTableList.iterator();
            found = false;
            while (it1.hasNext()) {
                rs = (ReportSection)it1.next();
                if (rs.getElementClassName().equals("") || !rs.getPropertyName().equals(pd.name)) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.availableCollectionsModel.addElement(pd);
            this.currentAvailableCollectionsList.add(pd);
        }
        this.sort(this.availableCollectionsModel);
    }

    private void savePeviousReportSection() {
        if (!this.isSaved && this.previousReportSection != null) {
            LinkedList sectionColumns = this.previousReportSection.getReportColumns();
            sectionColumns.clear();
            Iterator it1 = this.selectedPropertiesList.iterator();
            while (it1.hasNext()) {
                sectionColumns.add(it1.next());
            }
        }
    }

    private void updateParentCombo() {
        this.parent.cmbCustomTemplates.removeAllItems();
        this.parent.cmbCustomTemplates.addItem(ReportsGenerationDialog.blankCRT);
        for (CustomReportTemplate rt : this.currentCRTs) {
            if (rt.getClazz() != this.clazz) continue;
            this.parent.cmbCustomTemplates.addItem(rt);
        }
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("CustomizableReportsTemplatesDialog.CustomizableReportTemplate"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setModal(true);
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "CUSTOMIZABLE_REPORT_TEMPLATES_DIALOG";
    }

    public void showDialog() {
        this.getDialog().setVisible(true);
    }

    private void showCustomReportTemplateDetails(CustomReportTemplate crt) {
        this.txtName.setText(crt.getName());
        this.description.setText(crt.getDescription());
        this.reportLayoutTable.getSelectionModel().clearSelection();
        this.reportLayoutTableList.clear();
        this.countSelectedCollections = 0;
        for (ReportSection rs : crt.getReportSections()) {
            this.reportLayoutTableList.add(rs);
            ++this.countSelectedCollections;
        }
        this.initCollections();
        this.reportLayoutTable.updateUI();
        this.reportLayoutTable.getSelectionModel().setSelectionInterval(0, 0);
        this.selectedPropertiesTable.updateUI();
        this.layoutPanel.setBorder(BorderFactory.createTitledBorder(MessageFormat.format(Messages.getString("CustomReportsTemplatesDialog.ReportLayout"), this.countSelectedCollections)));
        this.jpSelectedP.setBorder(BorderFactory.createTitledBorder(MessageFormat.format(Messages.getString("CustomizableReportsTemplatesDialog.ReportColumns"), this.countSelectedProperties)));
    }

    private String generateName() {
        String name = TEMPLATE_NAME;
        int newNumber = 0;
        int lastNumber = this.customReportTemplatesModel.size();
        if (lastNumber != 0) {
            newNumber = this.cgCounter = lastNumber + 1;
        } else {
            ++this.cgCounter;
            newNumber = this.cgCounter;
        }
        String nName = name.concat("_").concat(Integer.toString(newNumber));
        while (this.nameExistsInModel(nName, null)) {
            newNumber = ++this.cgCounter;
            nName = name.concat("_").concat(Integer.toString(newNumber));
        }
        return nName;
    }

    private boolean nameExistsInModel(String name, CustomReportTemplate current) {
        for (int i = 0; i < this.customReportTemplatesModel.size(); ++i) {
            CustomReportTemplate rt = (CustomReportTemplate)this.customReportTemplatesModel.get(i);
            if (rt == current || rt.getClazz() != this.clazz || !rt.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean canClose() {
        if (!this.isSaved) {
            String s1 = Messages.getString("ReportTemplatesDialog.Yes");
            String s2 = Messages.getString("ReportTemplatesDialog.No");
            Object[] options = new Object[]{s1, s2};
            int n = JOptionPane.showOptionDialog(this.dialog, Messages.getString("ReportTemplatesDialog.NotSavedErrMsg"), Messages.getString("ReportTemplatesDialog.NotSavedConfirm"), 0, 3, null, options, s1);
            return n == 0;
        }
        return true;
    }

    private void loadTemplates() {
        for (CustomReportTemplate rt : this.currentCRTs) {
            if (rt.getClazz() != this.clazz) continue;
            this.customReportTemplatesModel.addElement(rt);
        }
        this.sortCRTs(this.customReportTemplatesModel);
        if (this.customReportTemplatesModel.getSize() > 0) {
            this.reportTemplatesList.setSelectedIndex(0);
        }
    }

    private boolean hasNoArgument(Method method) {
        return method.getParameterTypes().length == 0;
    }

    public DefaultListModel sort(DefaultListModel list) {
        for (int k = 0; k < list.size() - 1; ++k) {
            boolean isSorted = true;
            for (int i = 1; i < list.size() - k; ++i) {
                Object o1 = list.get(i);
                Object o2 = list.get(i - 1);
                String s1 = "";
                String s2 = "";
                if (o1 instanceof ReportColumn) {
                    s1 = ((ReportColumn)o1).getPropertyName();
                } else if (o1 instanceof ClassDescription.CollectionDescription) {
                    s1 = ((ClassDescription.CollectionDescription)o1).name;
                } else if (o1 instanceof ClassDescription.PropertyDescription) {
                    s1 = ((ClassDescription.PropertyDescription)o1).name;
                }
                if (o2 instanceof ReportColumn) {
                    s2 = ((ReportColumn)o2).getPropertyName();
                } else if (o2 instanceof ClassDescription.CollectionDescription) {
                    s2 = ((ClassDescription.CollectionDescription)o2).name;
                } else if (o2 instanceof ClassDescription.PropertyDescription) {
                    s2 = ((ClassDescription.PropertyDescription)o2).name;
                }
                if (s1.compareTo(s2) >= 0) continue;
                Object tmpObj = list.get(i);
                list.remove(i);
                list.add(i, list.get(i - 1));
                list.remove(i - 1);
                list.add(i - 1, tmpObj);
                isSorted = false;
            }
            if (isSorted) break;
        }
        return list;
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    private int calcDefaultColumnWidth(int columnsCount) {
        return 100 / columnsCount;
    }

    private DefaultListModel sortCRTs(DefaultListModel list) {
        for (int k = 0; k < list.size() - 1; ++k) {
            boolean isSorted = true;
            for (int i = 1; i < list.size() - k; ++i) {
                String s1 = ((CustomReportTemplate)list.get(i)).getName().toString();
                String s2 = ((CustomReportTemplate)list.get(i - 1)).getName().toString();
                if (s1.toString().compareTo(s2.toString()) >= 0) continue;
                Object tmpObj = list.get(i);
                list.remove(i);
                list.add(i, list.get(i - 1));
                list.remove(i - 1);
                list.add(i - 1, tmpObj);
                isSorted = false;
            }
            if (isSorted) break;
        }
        return list;
    }

    private void clearCustomReportTemplateDetails() {
        this.availableCollectionsModel.clear();
        this.availablePropertiesModel.clear();
        this.selectedPropertiesList.clear();
        this.selectedPropertiesTable.updateUI();
        this.reportLayoutTableList.clear();
        this.reportLayoutTable.updateUI();
    }

    private void recalculateTotalColumnWidths() {
        double total = 0.0;
        int rows = this.selectedPropertiesModel.getRowCount();
        for (int i = 0; i < rows; ++i) {
            total += ((Double)this.selectedPropertiesTable.getValueAt(i, 3)).doubleValue();
        }
        total = Double.valueOf(new DecimalFormat("#.##").format(total));
        JTableHeader th = this.selectedPropertiesTable.getTableHeader();
        TableColumnModel tcm = th.getColumnModel();
        TableColumn tc = tcm.getColumn(3);
        tc.setHeaderValue(Messages.getString("CustomizableReportsTemplatesDialog.ColumnWidth") + "\n(" + total + "% used)");
        th.repaint();
    }

    private void findAndSelectItem(char firstLetter) {
        for (int i = 0; i < this.availablePropertiesList.getModel().getSize(); ++i) {
            ReportColumn rc = (ReportColumn)this.availablePropertiesList.getModel().getElementAt(i);
            if (!rc.getPropertyName().substring(0, 1).equalsIgnoreCase(String.valueOf(firstLetter))) continue;
            this.availablePropertiesList.setSelectedValue(rc, true);
        }
    }

    private void runAvailablePropertiesFilter() {
        String searchString = this.availablePropertiesFilter.getText();
        Iterator it = this.currentAvailablePropertiesList.iterator();
        this.availablePropertiesModel.removeAllElements();
        while (it.hasNext()) {
            Object obj = it.next();
            String name = ((ReportColumn)obj).getPropertyName();
            if (searchString.trim() != null && !searchString.trim().equals("")) {
                int idx = ReportUtils.match(name, searchString, false, false, false);
                if (idx > -1) {
                    if (this.availablePropertiesModel.contains(obj)) continue;
                    this.availablePropertiesModel.addElement(obj);
                    continue;
                }
                if (!this.availablePropertiesModel.contains(obj)) continue;
                this.availablePropertiesModel.removeElement(obj);
                continue;
            }
            this.availablePropertiesModel.addElement(obj);
        }
        this.sort(this.availablePropertiesModel);
    }

    private void runAvailableCollectionsFilter() {
        String searchString = this.availableCollectionsFilter.getText();
        Iterator it = this.currentAvailableCollectionsList.iterator();
        this.availableCollectionsModel.removeAllElements();
        while (it.hasNext()) {
            Object obj = it.next();
            String name = "";
            if (obj instanceof ClassDescription) {
                name = ((ClassDescription)obj).getClassName();
            } else if (obj instanceof ClassDescription.CollectionDescription) {
                name = ((ClassDescription.CollectionDescription)obj).name;
            } else if (obj instanceof ClassDescription.PropertyDescription) {
                name = ((ClassDescription.PropertyDescription)obj).name;
            }
            if (searchString.trim() != null && !searchString.trim().equals("")) {
                int idx = ReportUtils.match(name, searchString, false, false, false);
                if (idx > -1) {
                    if (this.availableCollectionsModel.contains(obj)) continue;
                    this.availableCollectionsModel.addElement(obj);
                    continue;
                }
                if (!this.availableCollectionsModel.contains(obj)) continue;
                this.availableCollectionsModel.removeElement(obj);
                continue;
            }
            this.availableCollectionsModel.addElement(obj);
        }
        this.sort(this.availableCollectionsModel);
    }

    @Override
    protected int getMinimumWidth() {
        return this.dialogMinWidth;
    }

    @Override
    protected int getMinimumHeight() {
        return this.dialogMinHeight;
    }

    class CollectionFilterListener
    implements DocumentListener {
        CollectionFilterListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            CustomReportsTemplatesDialog.this.runAvailableCollectionsFilter();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            CustomReportsTemplatesDialog.this.runAvailableCollectionsFilter();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            CustomReportsTemplatesDialog.this.runAvailableCollectionsFilter();
        }
    }

    class PropertyFilterListener
    implements DocumentListener {
        PropertyFilterListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            CustomReportsTemplatesDialog.this.runAvailablePropertiesFilter();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            CustomReportsTemplatesDialog.this.runAvailablePropertiesFilter();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            CustomReportsTemplatesDialog.this.runAvailablePropertiesFilter();
        }
    }

    class MultiLineHeaderRenderer
    extends JList
    implements TableCellRenderer {
        MultiLineHeaderRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setFont(table.getFont());
            this.setOpaque(true);
            this.setForeground(UIManager.getColor("TableHeader.foreground"));
            this.setBackground(table.getTableHeader().getBackground());
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            ListCellRenderer renderer = this.getCellRenderer();
            ((JLabel)((Object)renderer)).setHorizontalAlignment(0);
            this.setCellRenderer(renderer);
            String str = value == null ? "" : value.toString();
            BufferedReader br = new BufferedReader(new StringReader(str));
            Vector<String> v = new Vector<String>();
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    v.addElement(line);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.setListData(v);
            return this;
        }
    }

    class ReportLayoutCustomNameRenderer
    extends DefaultTableCellRenderer {
        ReportLayoutCustomNameRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel c = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            c.setToolTipText(Messages.getString("CustomReportsTemplatesDialog.ClickToEdit"));
            c.setToolTipText(Messages.getString("CustomizableReportsTemplatesDialog.ClickToEdit"));
            return c;
        }
    }

    class ReportSectionsRenderer
    extends JLabel
    implements TableCellRenderer {
        ReportSectionsRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            ReportSection rs = (ReportSection)CustomReportsTemplatesDialog.this.reportLayoutTableList.get(CustomReportsTemplatesDialog.this.reportLayoutTable.convertRowIndexToModel(row));
            int level = rs.getLevel();
            Object v = (String)value;
            if (level == 0) {
                v = "<html><b>" + (String)v + "</b></html>";
            }
            this.setText((String)v);
            this.setBorder(BorderFactory.createEmptyBorder(0, level * 5, 0, 0));
            this.setToolTipText(table.getValueAt(row, column).toString());
            return this;
        }
    }

    private class RemovePropertyActionListener
    implements ActionListener {
        private RemovePropertyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ReportSection selectedSection = (ReportSection)CustomReportsTemplatesDialog.this.reportLayoutTableList.get(CustomReportsTemplatesDialog.this.reportLayoutTable.convertRowIndexToModel(CustomReportsTemplatesDialog.this.reportLayoutTable.getSelectedRow()));
            ArrayList<ReportColumn> l = new ArrayList<ReportColumn>();
            int[] selected = CustomReportsTemplatesDialog.this.selectedPropertiesTable.getSelectedRows();
            for (int i = 0; i < selected.length; ++i) {
                ReportColumn rc = CustomReportsTemplatesDialog.this.selectedPropertiesList.get(selected[i]);
                if (CustomReportsTemplatesDialog.this.availablePropertiesModel.contains(rc)) continue;
                l.add(rc);
                CustomReportsTemplatesDialog.this.availablePropertiesModel.addElement(rc);
                selectedSection.getReportColumns().remove(rc);
                CustomReportsTemplatesDialog.this.currentAvailablePropertiesList.add(rc);
                --CustomReportsTemplatesDialog.this.countSelectedProperties;
            }
            CustomReportsTemplatesDialog.this.runAvailablePropertiesFilter();
            CustomReportsTemplatesDialog.this.availablePropertiesFilter.setEnabled(true);
            CustomReportsTemplatesDialog.this.selectedPropertiesList.removeAll(l);
            CustomReportsTemplatesDialog.this.sort(CustomReportsTemplatesDialog.this.availablePropertiesModel);
            CustomReportsTemplatesDialog.this.selectedPropertiesTable.updateUI();
            CustomReportsTemplatesDialog.this.selectedPropertiesTable.clearSelection();
            CustomReportsTemplatesDialog.this.jpSelectedP.setBorder(BorderFactory.createTitledBorder(MessageFormat.format(Messages.getString("CustomizableReportsTemplatesDialog.ReportColumns"), CustomReportsTemplatesDialog.this.countSelectedProperties)));
        }
    }

    private class RemoveSectionActionListener
    implements ActionListener {
        private RemoveSectionActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (CustomReportsTemplatesDialog.this.reportLayoutTable.getSelectedRow() > -1) {
                    Object d;
                    ReportSection rs = (ReportSection)CustomReportsTemplatesDialog.this.reportLayoutTableList.get(CustomReportsTemplatesDialog.this.reportLayoutTable.convertRowIndexToModel(CustomReportsTemplatesDialog.this.reportLayoutTable.getSelectedRow()));
                    CustomReportsTemplatesDialog.this.reportLayoutTableList.remove(rs);
                    if (rs.getType().equals("collection")) {
                        d = (ClassDescription.CollectionDescription)rs.getElement();
                        CustomReportsTemplatesDialog.this.availableCollectionsModel.addElement(d);
                    } else if (rs.getType().equals("roPropertiesList")) {
                        d = (ClassDescription.PropertyDescription)rs.getElement();
                        CustomReportsTemplatesDialog.this.availableCollectionsModel.addElement(d);
                    }
                    CustomReportsTemplatesDialog.this.sort(CustomReportsTemplatesDialog.this.availableCollectionsModel);
                    CustomReportsTemplatesDialog.this.reportLayoutTable.clearSelection();
                    CustomReportsTemplatesDialog.this.reportLayoutTable.updateUI();
                    int lastRow = CustomReportsTemplatesDialog.this.reportLayoutTable.convertRowIndexToView(CustomReportsTemplatesDialog.this.reportLayoutTable.getRowCount() - 1);
                    CustomReportsTemplatesDialog.this.reportLayoutTable.setRowSelectionInterval(lastRow, lastRow);
                    --CustomReportsTemplatesDialog.this.countSelectedCollections;
                    CustomReportsTemplatesDialog.this.currentAvailableCollectionsList.add(rs.getElement());
                    CustomReportsTemplatesDialog.this.runAvailableCollectionsFilter();
                    CustomReportsTemplatesDialog.this.availableCollectionsFilter.setEnabled(true);
                }
                CustomReportsTemplatesDialog.this.layoutPanel.setBorder(BorderFactory.createTitledBorder(MessageFormat.format(Messages.getString("CustomReportsTemplatesDialog.ReportLayout"), CustomReportsTemplatesDialog.this.countSelectedCollections)));
            }
            catch (Exception ex) {
                LOGGER.error("Remove Section : " + ex);
            }
        }
    }

    private class AddSectionActionListener
    implements ActionListener {
        private AddSectionActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                ArrayList<ReportSection> tempList = new ArrayList<ReportSection>();
                Iterator it = CustomReportsTemplatesDialog.this.availableCollectionsList.getSelectedValuesList().iterator();
                while (it.hasNext()) {
                    if (CustomReportsTemplatesDialog.this.countSelectedCollections < 30) {
                        Object obj = it.next();
                        String name = "";
                        boolean isCollection = true;
                        if (obj instanceof ClassDescription.CollectionDescription) {
                            ClassDescription.CollectionDescription cd = (ClassDescription.CollectionDescription)obj;
                            name = cd.name;
                        } else if (obj instanceof ClassDescription.PropertyDescription) {
                            ClassDescription.PropertyDescription cd = (ClassDescription.PropertyDescription)obj;
                            name = cd.name;
                            isCollection = false;
                        }
                        boolean found = false;
                        for (ReportSection rs : CustomReportsTemplatesDialog.this.reportLayoutTableList) {
                            if (!rs.getPropertyName().equals(name)) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        tempList.add(new ReportSection(obj, 1, isCollection ? "collection" : "roPropertiesList"));
                        continue;
                    }
                    JOptionPane.showMessageDialog(CustomReportsTemplatesDialog.this, Messages.getString("CustomizableReportsTemplatesDialog.Max30SelectedC"), Messages.getString("CustomizableReportsTemplatesDialog.Error"), 0);
                    break;
                }
                for (ReportSection rs : tempList) {
                    CustomReportsTemplatesDialog.this.reportLayoutTableList.add(rs);
                    CustomReportsTemplatesDialog.this.availableCollectionsModel.removeElement(rs.getElement());
                    CustomReportsTemplatesDialog.this.reportLayoutTable.updateUI();
                    ++CustomReportsTemplatesDialog.this.countSelectedCollections;
                    CustomReportsTemplatesDialog.this.currentAvailableCollectionsList.remove(rs.getElement());
                }
                if (CustomReportsTemplatesDialog.this.currentAvailableCollectionsList.size() == 0) {
                    CustomReportsTemplatesDialog.this.availableCollectionsFilter.setText("");
                    CustomReportsTemplatesDialog.this.availableCollectionsFilter.setEnabled(false);
                }
                CustomReportsTemplatesDialog.this.layoutPanel.setBorder(BorderFactory.createTitledBorder(MessageFormat.format(Messages.getString("CustomReportsTemplatesDialog.ReportLayout"), CustomReportsTemplatesDialog.this.countSelectedCollections)));
            }
            catch (Exception ex) {
                LOGGER.error("Add Section : " + ex);
            }
        }
    }

    class ColumnHeaderToolTips
    extends MouseMotionAdapter {
        TableColumn curCol;
        Map tips = new HashMap();

        ColumnHeaderToolTips() {
        }

        public void setToolTip(TableColumn col, String tooltip) {
            if (tooltip == null) {
                this.tips.remove(col);
            } else {
                this.tips.put(col, tooltip);
            }
        }

        @Override
        public void mouseMoved(MouseEvent evt) {
            JTableHeader header = (JTableHeader)evt.getSource();
            JTable table = header.getTable();
            TableColumnModel colModel = table.getColumnModel();
            int vColIndex = colModel.getColumnIndexAtX(evt.getX());
            TableColumn col = null;
            if (vColIndex >= 0) {
                col = colModel.getColumn(vColIndex);
            }
            if (col != this.curCol) {
                header.setToolTipText((String)this.tips.get(col));
                this.curCol = col;
            }
        }
    }

    class SelectedPropertyWidthCellEditor
    extends DefaultCellEditor {
        public SelectedPropertyWidthCellEditor(JTextField textField) {
            super(textField);
            super.setClickCountToStart(1);
        }
    }

    class SelectedPropertyColumnNameCellRenderer
    extends DefaultTableCellRenderer {
        SelectedPropertyColumnNameCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setToolTipText(Messages.getString("CustomizableReportsTemplatesDialog.ClickToEdit"));
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    class SelectedPropertyNameCellRenderer
    extends DefaultTableCellRenderer {
        SelectedPropertyNameCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    class SelectedSectionCustomNameCellEditor
    extends DefaultCellEditor {
        public SelectedSectionCustomNameCellEditor(JTextField textField) {
            super(textField);
            super.setClickCountToStart(1);
        }
    }

    class SelectedPropertyNameCellEditor
    extends DefaultCellEditor {
        public SelectedPropertyNameCellEditor(JTextField textField) {
            super(textField);
            super.setClickCountToStart(1);
        }
    }

    public class TableRowColorRenderer
    extends DefaultTableCellRenderer {
        private List list;

        public TableRowColorRenderer(List list) {
            this.setOpaque(true);
            this.list = list;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            ReportSection section = (ReportSection)CustomReportsTemplatesDialog.this.reportLayoutTableList.get(CustomReportsTemplatesDialog.this.reportLayoutTable.convertRowIndexToModel(CustomReportsTemplatesDialog.this.reportLayoutTable.getSelectedRow()));
            ClassDescription cd = CustomReportsTemplatesDialog.this.metaDataManager.getClassDescription(section.getElementClassName());
            ReportColumn rc = (ReportColumn)this.list.get(row);
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (ReportUtils.isReadOnlyProperty(cd, rc.getPropertyName())) {
                if (isSelected) {
                    comp.setForeground(Color.white);
                } else {
                    comp.setForeground(Color.decode("0xE42217"));
                }
            } else if (ReportUtils.isObjectTypeProperty(cd, rc.getPropertyName())) {
                if (isSelected) {
                    comp.setForeground(Color.white);
                } else {
                    comp.setForeground(Color.decode("0x0041C2"));
                }
            } else if (isSelected) {
                comp.setForeground(Color.white);
            } else {
                comp.setForeground(table.getForeground());
            }
            if (rc.isDynamicProperty()) {
                if (isSelected) {
                    comp.setForeground(Color.white);
                } else {
                    comp.setForeground(Color.decode("0x638752"));
                }
            } else if (rc.isUserDefinedProperty()) {
                if (isSelected) {
                    comp.setForeground(Color.white);
                } else {
                    this.setForeground(Color.decode("0xc4a02c"));
                }
            }
            return this;
        }
    }

    class OrderComboBoxEditor
    extends DefaultCellEditor {
        public OrderComboBoxEditor(Object[] items) {
            super(new JComboBox<Object>(items));
        }
    }

    class OrderComboBoxRenderer
    extends JComboBox
    implements TableCellRenderer {
        public OrderComboBoxRenderer(Object[] items) {
            super(items);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            this.setSelectedItem(value);
            return this;
        }
    }

    class UpDownAction
    implements ActionListener {
        ActionListener al;

        UpDownAction(ActionListener al) {
            this.al = al;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.al.actionPerformed(e);
        }
    }

    class CollectionRenderer
    extends JLabel
    implements ListCellRenderer {
        public CollectionRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String name = "";
            if (value instanceof ClassDescription.CollectionDescription) {
                ClassDescription.CollectionDescription cd = (ClassDescription.CollectionDescription)value;
                name = cd.name;
            } else if (value instanceof ClassDescription) {
                ClassDescription cd = (ClassDescription)value;
                name = cd.getClassName();
            } else if (value instanceof ClassDescription.PropertyDescription) {
                ClassDescription.PropertyDescription pd = (ClassDescription.PropertyDescription)value;
                name = pd.name;
            }
            this.setText(ReportUtils.getDisplayName(name));
            if (CustomReportsTemplatesDialog.this.isSaved) {
                this.setToolTipText(CustomReportsTemplatesDialog.this.ITEMS_DISABLED);
            } else {
                this.setToolTipText(null);
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(Color.white);
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }

    class PObjectCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public PObjectCellRenderer() {
            this.setOpaque(true);
            this.setIconTextGap(12);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ReportColumn po = (ReportColumn)value;
            String tText = "";
            ReportSection section = (ReportSection)CustomReportsTemplatesDialog.this.reportLayoutTableList.get(CustomReportsTemplatesDialog.this.reportLayoutTable.convertRowIndexToModel(CustomReportsTemplatesDialog.this.reportLayoutTable.getSelectedRow()));
            ClassDescription cd = CustomReportsTemplatesDialog.this.metaDataManager.getClassDescription(section.getElementClassName());
            if (ReportUtils.isReadOnlyProperty(cd, po.getPropertyName())) {
                if (isSelected) {
                    this.setForeground(Color.white);
                } else {
                    this.setForeground(Color.decode("0xE42217"));
                }
                tText = Messages.getString("CustomizableReportsTemplatesDialog.ROProperty");
            } else if (ReportUtils.isObjectTypeProperty(cd, po.getPropertyName())) {
                if (isSelected) {
                    this.setForeground(Color.white);
                } else {
                    this.setForeground(Color.decode("0x0041C2"));
                }
                tText = Messages.getString("CustomizableReportsTemplatesDialog.ObjTypeProperty");
            } else if (isSelected) {
                this.setForeground(Color.white);
            } else {
                this.setForeground(list.getForeground());
            }
            if (po.isDynamicProperty()) {
                if (isSelected) {
                    this.setForeground(Color.white);
                } else {
                    this.setForeground(Color.decode("0x638752"));
                }
                tText = Messages.getString("CustomReportsTemplatesDialog.DynamicProperty");
            } else if (po.isUserDefinedProperty()) {
                if (isSelected) {
                    this.setForeground(Color.white);
                } else {
                    this.setForeground(Color.decode("0xc4a02c"));
                }
                tText = Messages.getString("CustomReportsTemplatesDialog.UserDefinedProperty");
            }
            if (!tText.equals("")) {
                this.setToolTipText(tText);
            } else {
                this.setToolTipText(null);
            }
            this.setText(po.getColumnName());
            if (CustomReportsTemplatesDialog.this.isSaved) {
                this.setToolTipText(CustomReportsTemplatesDialog.this.ITEMS_DISABLED);
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
            } else {
                this.setBackground(list.getBackground());
            }
            return this;
        }
    }

    class TemplateReportRenderer
    extends JLabel
    implements ListCellRenderer {
        TemplateReportRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            CustomReportTemplate crt = (CustomReportTemplate)value;
            this.setText(crt.getName());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    private class TemplateListSelectionListener
    implements ListSelectionListener {
        private TemplateListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (CustomReportsTemplatesDialog.this.reportTemplatesList.getSelectedIndex() == -1) {
                CustomReportsTemplatesDialog.this.btnEdit.setEnabled(false);
                CustomReportsTemplatesDialog.this.btnRemove.setEnabled(false);
                CustomReportsTemplatesDialog.this.clearCustomReportTemplateDetails();
                CustomReportsTemplatesDialog.this.txtName.setText("");
                CustomReportsTemplatesDialog.this.description.setText("");
            } else {
                CustomReportsTemplatesDialog.this.selectedCustomReportTemplate = (CustomReportTemplate)CustomReportsTemplatesDialog.this.customReportTemplatesModel.get(CustomReportsTemplatesDialog.this.reportTemplatesList.getSelectedIndex());
                if (!e.getValueIsAdjusting()) {
                    CustomReportsTemplatesDialog.this.btnEdit.setEnabled(true);
                    CustomReportsTemplatesDialog.this.btnRemove.setEnabled(true);
                    CustomReportsTemplatesDialog.this.showCustomReportTemplateDetails(CustomReportsTemplatesDialog.this.selectedCustomReportTemplate);
                }
            }
        }
    }

    private class RemoveAction
    implements ActionListener {
        private RemoveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int result = JOptionPane.showConfirmDialog(CustomReportsTemplatesDialog.this, MessageFormat.format(Messages.getString("CustomizableReportsTemplatesDialog.AreYouSure"), CustomReportsTemplatesDialog.this.selectedCustomReportTemplate.getName()), Messages.getString("CustomizableReportsTemplatesDialog.SelectAnOption"), 0);
            if (result == 0) {
                CustomReportsTemplatesDialog.this.customReportTemplatesModel.remove(CustomReportsTemplatesDialog.this.reportTemplatesList.getSelectedIndex());
                for (CustomReportTemplate rt : CustomReportsTemplatesDialog.this.currentCRTs) {
                    if (rt.getReportTemplateId() != CustomReportsTemplatesDialog.this.selectedCustomReportTemplate.getReportTemplateId()) continue;
                    CustomReportsTemplatesDialog.this.currentCRTs.remove(rt);
                    CustomReportsTemplatesDialog.this.crtPersistence.saveReportTemplates();
                    CustomReportsTemplatesDialog.this.updateParentCombo();
                    break;
                }
                if (CustomReportsTemplatesDialog.this.reportTemplatesList.getModel().getSize() > 0) {
                    CustomReportsTemplatesDialog.this.reportTemplatesList.setSelectedIndex(0);
                } else {
                    CustomReportsTemplatesDialog.this.clearCustomReportTemplateDetails();
                    CustomReportsTemplatesDialog.this.btnRemove.setEnabled(false);
                    CustomReportsTemplatesDialog.this.btnEdit.setEnabled(false);
                }
            }
            CustomReportsTemplatesDialog.this.description.setEnabled(false);
            CustomReportsTemplatesDialog.this.txtName.setEnabled(false);
            CustomReportsTemplatesDialog.this.reportTemplatesList.setEnabled(true);
            CustomReportsTemplatesDialog.this.availablePropertiesList.setEnabled(false);
            CustomReportsTemplatesDialog.this.availablePropertiesFilter.setText("");
            CustomReportsTemplatesDialog.this.availablePropertiesFilter.setEnabled(false);
            CustomReportsTemplatesDialog.this.selectedPropertiesTable.clearSelection();
            CustomReportsTemplatesDialog.this.selectedPropertiesTable.setEnabled(false);
            CustomReportsTemplatesDialog.this.btnSave.setEnabled(false);
            CustomReportsTemplatesDialog.this.btnCancel.setEnabled(false);
            CustomReportsTemplatesDialog.this.btnAdd.setEnabled(true);
            CustomReportsTemplatesDialog.this.btnEdit.setEnabled(true);
            CustomReportsTemplatesDialog.this.btnRemove.setEnabled(true);
            CustomReportsTemplatesDialog.this.isSaved = true;
        }
    }

    private class EditAction
    implements ActionListener {
        private EditAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CustomReportsTemplatesDialog.this.backupCustomReportTemplate = new CustomReportTemplate(CustomReportsTemplatesDialog.this.selectedCustomReportTemplate.getName(), CustomReportsTemplatesDialog.this.selectedCustomReportTemplate.getClazz(), CustomReportsTemplatesDialog.this.selectedCustomReportTemplate.getDescription(), CustomReportsTemplatesDialog.this.selectedCustomReportTemplate.getReportTemplateId());
            for (ReportSection rs : CustomReportsTemplatesDialog.this.selectedCustomReportTemplate.getReportSections()) {
                CustomReportsTemplatesDialog.this.backupCustomReportTemplate.getReportSections().add(rs.copy());
            }
            CustomReportsTemplatesDialog.this.description.setEnabled(true);
            CustomReportsTemplatesDialog.this.txtName.setEnabled(true);
            CustomReportsTemplatesDialog.this.reportTemplatesList.setEnabled(false);
            CustomReportsTemplatesDialog.this.availableCollectionsList.setEnabled(true);
            CustomReportsTemplatesDialog.this.availableCollectionsFilter.setEnabled(true);
            CustomReportsTemplatesDialog.this.availablePropertiesList.setEnabled(true);
            CustomReportsTemplatesDialog.this.availablePropertiesFilter.setEnabled(true);
            CustomReportsTemplatesDialog.this.selectedPropertiesTable.setEnabled(true);
            CustomReportsTemplatesDialog.this.btnAdd.setEnabled(false);
            CustomReportsTemplatesDialog.this.btnEdit.setEnabled(false);
            CustomReportsTemplatesDialog.this.btnSave.setEnabled(true);
            CustomReportsTemplatesDialog.this.btnRemove.setEnabled(false);
            CustomReportsTemplatesDialog.this.btnCancel.setEnabled(true);
            CustomReportsTemplatesDialog.this.isSaved = false;
        }
    }

    private class AddAction
    implements ActionListener {
        private AddAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CustomReportsTemplatesDialog.this.reportLayoutTableList.clear();
            CustomReportTemplate crt = new CustomReportTemplate(CustomReportsTemplatesDialog.this.generateName(), CustomReportsTemplatesDialog.this.clazz, "", null);
            ClassDescription cd = CustomReportsTemplatesDialog.this.metaDataManager.getClassDescription(CustomReportsTemplatesDialog.this.clazz.getName());
            ReportSection rs = new ReportSection(cd, 0, "");
            crt.getReportSections().add(rs);
            CustomReportsTemplatesDialog.this.customReportTemplatesModel.addElement(crt);
            CustomReportsTemplatesDialog.this.reportTemplatesList.setSelectedValue(crt, true);
            CustomReportsTemplatesDialog.this.reportTemplatesList.setEnabled(false);
            CustomReportsTemplatesDialog.this.description.setEnabled(true);
            CustomReportsTemplatesDialog.this.txtName.setEnabled(true);
            CustomReportsTemplatesDialog.this.availablePropertiesList.setEnabled(true);
            CustomReportsTemplatesDialog.this.availablePropertiesFilter.setEnabled(true);
            CustomReportsTemplatesDialog.this.selectedPropertiesTable.setEnabled(true);
            CustomReportsTemplatesDialog.this.availableCollectionsFilter.setEnabled(true);
            CustomReportsTemplatesDialog.this.availableCollectionsList.setEnabled(true);
            CustomReportsTemplatesDialog.this.availablePropertiesList.setEnabled(true);
            CustomReportsTemplatesDialog.this.selectedPropertiesTable.setEnabled(true);
            CustomReportsTemplatesDialog.this.btnAdd.setEnabled(false);
            CustomReportsTemplatesDialog.this.btnEdit.setEnabled(false);
            CustomReportsTemplatesDialog.this.btnRemove.setEnabled(true);
            CustomReportsTemplatesDialog.this.btnSave.setEnabled(true);
            CustomReportsTemplatesDialog.this.btnCancel.setEnabled(false);
            CustomReportsTemplatesDialog.this.isSaved = false;
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CustomReportsTemplatesDialog.this.description.setEnabled(false);
            CustomReportsTemplatesDialog.this.txtName.setEnabled(false);
            CustomReportsTemplatesDialog.this.reportTemplatesList.setEnabled(true);
            CustomReportsTemplatesDialog.this.availablePropertiesList.setEnabled(false);
            CustomReportsTemplatesDialog.this.availablePropertiesFilter.setText("");
            CustomReportsTemplatesDialog.this.availablePropertiesFilter.setEnabled(false);
            CustomReportsTemplatesDialog.stopCellEditing(CustomReportsTemplatesDialog.this.selectedPropertiesTable);
            CustomReportsTemplatesDialog.stopCellEditing(CustomReportsTemplatesDialog.this.reportLayoutTable);
            CustomReportsTemplatesDialog.this.selectedPropertiesTable.clearSelection();
            CustomReportsTemplatesDialog.this.selectedPropertiesTable.setEnabled(false);
            CustomReportsTemplatesDialog.this.availableCollectionsList.setEnabled(false);
            CustomReportsTemplatesDialog.this.availableCollectionsFilter.setText("");
            CustomReportsTemplatesDialog.this.availableCollectionsFilter.setEnabled(false);
            CustomReportsTemplatesDialog.this.btnSave.setEnabled(false);
            CustomReportsTemplatesDialog.this.btnCancel.setEnabled(false);
            CustomReportsTemplatesDialog.this.btnAdd.setEnabled(true);
            CustomReportsTemplatesDialog.this.btnEdit.setEnabled(true);
            CustomReportsTemplatesDialog.this.btnRemove.setEnabled(true);
            CustomReportsTemplatesDialog.this.selectedCustomReportTemplate.setName(CustomReportsTemplatesDialog.this.backupCustomReportTemplate.getName());
            CustomReportsTemplatesDialog.this.selectedCustomReportTemplate.setDescription(CustomReportsTemplatesDialog.this.backupCustomReportTemplate.getDescription());
            CustomReportsTemplatesDialog.this.selectedCustomReportTemplate.getReportSections().clear();
            ReportSection rsForNewSelection = null;
            for (ReportSection rs : CustomReportsTemplatesDialog.this.backupCustomReportTemplate.getReportSections()) {
                if (rs.getLevel() == 0) {
                    rsForNewSelection = rs;
                }
                CustomReportsTemplatesDialog.this.selectedCustomReportTemplate.getReportSections().add(rs.copy());
            }
            CustomReportsTemplatesDialog.this.reportTemplatesList.clearSelection();
            CustomReportsTemplatesDialog.this.reportLayoutTable.clearSelection();
            CustomReportsTemplatesDialog.this.reportTemplatesList.setSelectedValue(CustomReportsTemplatesDialog.this.selectedCustomReportTemplate, true);
            CustomReportsTemplatesDialog.this.reloadCollectionsAndProperties(rsForNewSelection);
            CustomReportsTemplatesDialog.this.reloadUDPAndDynamicProperties(rsForNewSelection);
            CustomReportsTemplatesDialog.this.reportLayoutTable.getSelectionModel().setSelectionInterval(0, 0);
            CustomReportsTemplatesDialog.this.reportLayoutTable.updateUI();
            CustomReportsTemplatesDialog.this.backupCustomReportTemplate = null;
            CustomReportsTemplatesDialog.this.isSaved = true;
        }
    }

    private class SaveAction
    implements ActionListener {
        private SaveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (CustomReportsTemplatesDialog.this.txtName.getText().equals("")) {
                JOptionPane.showMessageDialog(CustomReportsTemplatesDialog.this, Messages.getString("StandardReportsConfigurationDialog.NameCanNotBeEmpty"), Messages.getString("StandardReportsConfigurationDialog.Error"), 0);
                CustomReportsTemplatesDialog.this.txtName.requestFocus();
            } else {
                CustomReportsTemplatesDialog.this.savePeviousReportSection();
                CustomReportsTemplatesDialog.stopCellEditing(CustomReportsTemplatesDialog.this.selectedPropertiesTable);
                CustomReportsTemplatesDialog.stopCellEditing(CustomReportsTemplatesDialog.this.reportLayoutTable);
                String name = CustomReportsTemplatesDialog.this.txtName.getText();
                int counter = 0;
                while (CustomReportsTemplatesDialog.this.nameExistsInModel(name, CustomReportsTemplatesDialog.this.selectedCustomReportTemplate)) {
                    name = CustomReportsTemplatesDialog.this.txtName.getText().concat("_").concat(Integer.toString(++counter));
                }
                CustomReportsTemplatesDialog.this.selectedCustomReportTemplate.setName(name);
                CustomReportsTemplatesDialog.this.selectedCustomReportTemplate.setDescription(CustomReportsTemplatesDialog.this.description.getText());
                CustomReportsTemplatesDialog.this.selectedCustomReportTemplate.getReportSections().clear();
                for (ReportSection rs : CustomReportsTemplatesDialog.this.reportLayoutTableList) {
                    double totalWidth = 0.0;
                    for (ReportColumn col : rs.getReportColumns()) {
                        totalWidth += col.getColumnSize();
                    }
                    if (totalWidth > 100.0) {
                        JOptionPane.showMessageDialog(CustomReportsTemplatesDialog.this, MessageFormat.format(Messages.getString("CustomReportsTemplatesDialog.ColumnsWidthMoreThan100"), ReportUtils.getDisplayName(rs.getPropertyName())), Messages.getString("StandardReportsConfigurationDialog.Error"), 0);
                        return;
                    }
                    if (rs.getReportColumns().size() == 0) {
                        JOptionPane.showMessageDialog(CustomReportsTemplatesDialog.this, MessageFormat.format(Messages.getString("CustomReportsTemplatesDialog.ReportSectionIsEmpty"), ReportUtils.getDisplayName(rs.getPropertyName())), Messages.getString("StandardReportsConfigurationDialog.Error"), 2);
                        for (int i = 0; i < CustomReportsTemplatesDialog.this.availablePropertiesList.getModel().getSize(); ++i) {
                            ReportColumn rc = (ReportColumn)CustomReportsTemplatesDialog.this.availablePropertiesList.getModel().getElementAt(i);
                            if (!rc.getPropertyName().equals("name")) continue;
                            CustomReportsTemplatesDialog.this.availablePropertiesModel.removeElement(rc);
                            rs.getReportColumns().add(rc);
                            break;
                        }
                        ++CustomReportsTemplatesDialog.this.countSelectedProperties;
                        CustomReportsTemplatesDialog.this.selectedPropertiesTable.updateUI();
                        CustomReportsTemplatesDialog.this.selectedPropertiesTable.getSelectionModel().setSelectionInterval(CustomReportsTemplatesDialog.this.selectedPropertiesTable.getRowCount() - 1, CustomReportsTemplatesDialog.this.selectedPropertiesTable.getRowCount() - 1);
                    }
                    CustomReportsTemplatesDialog.this.selectedCustomReportTemplate.getReportSections().add(rs);
                }
                CustomReportTemplate rt2 = null;
                boolean found = false;
                for (CustomReportTemplate rt2 : CustomReportsTemplatesDialog.this.currentCRTs) {
                    if (rt2.getClazz() != CustomReportsTemplatesDialog.this.clazz || !rt2.getReportTemplateId().equals(CustomReportsTemplatesDialog.this.selectedCustomReportTemplate.getReportTemplateId())) continue;
                    found = true;
                    break;
                }
                if (found) {
                    CustomReportsTemplatesDialog.this.currentCRTs.remove(rt2);
                }
                CustomReportsTemplatesDialog.this.currentCRTs.add(CustomReportsTemplatesDialog.this.selectedCustomReportTemplate);
                CustomReportsTemplatesDialog.this.reportLayoutTable.getSelectionModel().setSelectionInterval(0, 0);
                CustomReportsTemplatesDialog.this.crtPersistence.saveReportTemplates();
                CustomReportsTemplatesDialog.this.updateParentCombo();
                CustomReportsTemplatesDialog.this.sortCRTs(CustomReportsTemplatesDialog.this.customReportTemplatesModel);
                CustomReportsTemplatesDialog.this.description.setEnabled(false);
                CustomReportsTemplatesDialog.this.txtName.setEnabled(false);
                CustomReportsTemplatesDialog.this.reportTemplatesList.setEnabled(true);
                CustomReportsTemplatesDialog.this.availablePropertiesList.setEnabled(false);
                CustomReportsTemplatesDialog.this.availablePropertiesFilter.setText("");
                CustomReportsTemplatesDialog.this.availablePropertiesFilter.setEnabled(false);
                CustomReportsTemplatesDialog.stopCellEditing(CustomReportsTemplatesDialog.this.selectedPropertiesTable);
                CustomReportsTemplatesDialog.stopCellEditing(CustomReportsTemplatesDialog.this.reportLayoutTable);
                CustomReportsTemplatesDialog.this.selectedPropertiesTable.clearSelection();
                CustomReportsTemplatesDialog.this.selectedPropertiesTable.setEnabled(false);
                CustomReportsTemplatesDialog.this.availableCollectionsList.setEnabled(false);
                CustomReportsTemplatesDialog.this.availableCollectionsFilter.setText("");
                CustomReportsTemplatesDialog.this.availableCollectionsFilter.setEnabled(false);
                CustomReportsTemplatesDialog.this.btnSave.setEnabled(false);
                CustomReportsTemplatesDialog.this.btnCancel.setEnabled(false);
                CustomReportsTemplatesDialog.this.btnAdd.setEnabled(true);
                CustomReportsTemplatesDialog.this.btnEdit.setEnabled(true);
                CustomReportsTemplatesDialog.this.btnRemove.setEnabled(true);
                CustomReportsTemplatesDialog.this.backupCustomReportTemplate = null;
                CustomReportsTemplatesDialog.this.isSaved = true;
                CustomReportsTemplatesDialog.this.reportTemplatesList.setSelectedValue(CustomReportsTemplatesDialog.this.selectedCustomReportTemplate, true);
            }
        }
    }

    private class SelectedPropertiesModel
    extends AbstractTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("CustomReportsTemplatesDialog.ColumnNumber"), Messages.getString("CustomizableReportsTemplatesDialog.PropertyName"), Messages.getString("CustomizableReportsTemplatesDialog.ColumnName"), Messages.getString("CustomizableReportsTemplatesDialog.ColumnWidth"), Messages.getString("CustomizableReportsTemplatesDialog.Order")};

        private SelectedPropertiesModel() {
        }

        @Override
        public int getRowCount() {
            return CustomReportsTemplatesDialog.this.selectedPropertiesList.size();
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex != 0 && columnIndex != 1;
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            ReportColumn po = CustomReportsTemplatesDialog.this.selectedPropertiesList.get(row);
            if (col == 1) {
                po.setRowNumber(Integer.parseInt((String)value));
            } else if (col == 2) {
                po.setColumnName((String)value);
            } else if (col == 3) {
                if (value.equals("")) {
                    value = "0";
                }
                try {
                    po.setColumnSize(Double.parseDouble((String)value));
                    CustomReportsTemplatesDialog.this.recalculateTotalColumnWidths();
                }
                catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(CustomReportsTemplatesDialog.this, "Invalid number!", Messages.getString("StandardReportsConfigurationDialog.Error"), 0);
                }
            } else if (col == 4) {
                if (value == " ") {
                    po.setColumnOrder("");
                } else {
                    po.setColumnOrder(((Integer)value).toString());
                }
            }
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ReportColumn po = CustomReportsTemplatesDialog.this.selectedPropertiesList.get(rowIndex);
            if (columnIndex == 0) {
                int c = po.getRowNumber();
                if (c == 0) {
                    return new Integer(rowIndex + 1);
                }
                return c;
            }
            if (columnIndex == 1) {
                if (po.isDynamicProperty() || po.isUserDefinedProperty()) {
                    return po.getPropertyName();
                }
                return ReportUtils.getDisplayName(po.getPropertyName());
            }
            if (columnIndex == 2) {
                return po.getColumnName();
            }
            if (columnIndex == 3) {
                double size = po.getColumnSize();
                return po.getColumnSize();
            }
            if (columnIndex == 4) {
                String order = po.getColumnOrder();
                if (order.equals("")) {
                    return " ";
                }
                return Integer.parseInt(po.getColumnOrder());
            }
            return "";
        }
    }

    private class ReportLayoutTableModel
    extends AbstractTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("CustomReportsTemplatesDialog.Section"), Messages.getString("CustomReportsTemplatesDialog.CustomName"), Messages.getString("CustomReportsTemplatesDialog.Level")};

        private ReportLayoutTableModel() {
        }

        @Override
        public int getRowCount() {
            return CustomReportsTemplatesDialog.this.reportLayoutTableList.size();
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1 && !CustomReportsTemplatesDialog.this.isSaved;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ReportSection rs = (ReportSection)CustomReportsTemplatesDialog.this.reportLayoutTableList.get(rowIndex);
            if (columnIndex == 0) {
                return ReportUtils.getDisplayName(rs.getPropertyName());
            }
            if (columnIndex == 1) {
                return rs.getCustomName();
            }
            if (columnIndex == 2) {
                return rs.getLevel();
            }
            return "";
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            ReportSection rs = (ReportSection)CustomReportsTemplatesDialog.this.reportLayoutTableList.get(row);
            if (col == 1) {
                rs.setCustomName((String)value);
            }
        }
    }

    private class AddPropertyActionListener
    implements ActionListener {
        private AddPropertyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ReportSection selectedSection = (ReportSection)CustomReportsTemplatesDialog.this.reportLayoutTableList.get(CustomReportsTemplatesDialog.this.reportLayoutTable.convertRowIndexToModel(CustomReportsTemplatesDialog.this.reportLayoutTable.getSelectedRow()));
            Iterator it = CustomReportsTemplatesDialog.this.availablePropertiesList.getSelectedValuesList().iterator();
            while (it.hasNext()) {
                if (CustomReportsTemplatesDialog.this.countSelectedProperties < 30) {
                    ReportColumn rc = (ReportColumn)it.next();
                    if (CustomReportsTemplatesDialog.this.selectedPropertiesList.contains(rc)) continue;
                    CustomReportsTemplatesDialog.this.selectedPropertiesList.add(rc);
                    CustomReportsTemplatesDialog.this.availablePropertiesModel.removeElement(rc);
                    selectedSection.getReportColumns().add(rc);
                    CustomReportsTemplatesDialog.this.currentAvailablePropertiesList.remove(rc);
                    ++CustomReportsTemplatesDialog.this.countSelectedProperties;
                    continue;
                }
                JOptionPane.showMessageDialog(CustomReportsTemplatesDialog.this, Messages.getString("CustomizableReportsTemplatesDialog.Max30Selected"), Messages.getString("CustomizableReportsTemplatesDialog.Error"), 0);
                break;
            }
            if (CustomReportsTemplatesDialog.this.currentAvailablePropertiesList.size() == 0) {
                CustomReportsTemplatesDialog.this.availablePropertiesFilter.setText("");
                CustomReportsTemplatesDialog.this.availablePropertiesFilter.setEnabled(false);
            }
            CustomReportsTemplatesDialog.this.selectedPropertiesTable.updateUI();
            CustomReportsTemplatesDialog.this.selectedPropertiesTable.getSelectionModel().setSelectionInterval(CustomReportsTemplatesDialog.this.selectedPropertiesTable.getRowCount() - 1, CustomReportsTemplatesDialog.this.selectedPropertiesTable.getRowCount() - 1);
            CustomReportsTemplatesDialog.this.jpSelectedP.setBorder(BorderFactory.createTitledBorder(MessageFormat.format(Messages.getString("CustomizableReportsTemplatesDialog.ReportColumns"), CustomReportsTemplatesDialog.this.countSelectedProperties)));
        }
    }

    private class CloseAction
    implements ActionListener {
        private CloseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (CustomReportsTemplatesDialog.this.canClose()) {
                CustomReportsTemplatesDialog.this.close();
            }
        }
    }
}

