/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.oracledesigner;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.imports.oracledesigner.ODExtractionController;
import oracle.dbtools.crest.imports.oracledesigner.ODExtractionHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.WindowsTableHeader;
import oracle.dbtools.crest.swingui.wizards.CustomWizard;
import oracle.dbtools.crest.swingui.wizards.Messages;
import oracle.dbtools.crest.swingui.wizards.metadata.ColorTableCellRenderer;
import oracle.dbtools.crest.swingui.wizards.metadata.DMConnectionModel;
import oracle.dbtools.crest.swingui.wizards.metadata.connection.ConnectionInfo;
import oracle.dbtools.crest.swingui.wizards.metadata.connection.FCPConnectionDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnections;

public class ODExtractionWizard
extends CustomWizard {
    public static final String DATABASE = "DATABASE";
    public static final String TABLE = "TABLE";
    public static final String VIEW = "VIEW";
    public static final String LOGIN = "LOGIN";
    public static final String USER = "USER";
    public static final String ROLE = "ROLE";
    public static final String RULE = "RULE";
    public static final String DEFAULT = "DEFAULT";
    public static final String PROCEDURE = "PROCEDURE";
    public static final String TRIGGER = "TRIGGER";
    public static final String DATATYPE = "DATATYPE";
    public static final String ALIAS = "ALIAS";
    public static final String BUFFERPOOL = "BUFFERPOOL";
    public static final String NODEGROUP = "NODEGROUP";
    public static final String OWNER = "OWNER";
    public static final String SEQUENCE = "SEQUENCE";
    public static final String USERGROUP = "USERGROUP";
    public static final String TABLESPACE = "TABLESPACE";
    public static final String AUX_TABLE = "AUX TABLE";
    public static final String STORAGE_GROUP = "STORAGE GROUP";
    public static final String VCAT = "VCAT";
    public static final String VOLUME = "VOLUME";
    private static final Font fontGrey = new Font("Dialog", 2, 12);
    private static final Font fontBlue = new Font("Dialog", 1, 12);
    private static final String DESCRIPTION_1 = Messages.getString("ODExtractionWizard.SelectDBConnection");
    private static final String DESCRIPTION_2 = Messages.getString("ODExtractionWizard.SelectWorkArea");
    private static final String DESCRIPTION_3 = Messages.getString("ODExtractionWizard.SelectApplicationSystems");
    private static final String DESCRIPTION_4 = Messages.getString("ODExtractionWizard.SelectObjectsToImport");
    private static final String DESCRIPTION_5 = Messages.getString("ODExtractionWizard.ViewSummaryGenerateDesign");
    private static final String FIRST_PAGE = "FIRST_PAGE";
    private static final String SECOND_PAGE = "SECOND_PAGE";
    private static final String THIRD_PAGE = "THIRD_PAGE";
    private static final String FOURTH_PAGE = "FOURTH_PAGE";
    private static final String FIFTH_PAGE = "FIFTH_PAGE";
    protected JTabbedPane tpane;
    protected JTable tbWorkAreas;
    protected List lsWorkAreas;
    protected JTable tbAppSys;
    protected List<ODObject> lsAppSys;
    protected JTable tbTableSpaces;
    protected JTable tbTempTableSpaces;
    protected JTable tbUndoTableSpaces;
    protected JTable tbUsers;
    protected JTable tbRoles;
    protected JTable tbDirectories;
    protected JTable tbExternalTables;
    protected JTable tbContexts;
    protected JTable tbClusters;
    protected JTable tbSequence;
    protected JTable tbSnapshots;
    protected JTable tbDimensions;
    protected JTable tbCollectionTypes;
    protected JTable tbStructuredTypes;
    protected List lsTableSpaces = new ArrayList();
    protected List lsTempTableSpaces = new ArrayList();
    protected List lsUndoTableSpaces = new ArrayList();
    protected List lsUsers = new ArrayList();
    protected List lsRoles = new ArrayList();
    protected List lsDirectories = new ArrayList();
    protected List lsExternalTables = new ArrayList();
    protected List lsContexts = new ArrayList();
    protected List lsClusters = new ArrayList();
    protected List lsSequence = new ArrayList();
    protected List lsSnapshots = new ArrayList();
    protected List lsDimensions = new ArrayList();
    protected List lsCollectionTypes = new ArrayList();
    protected List lsStructuredTypes = new ArrayList();
    protected JTable tbDomains;
    protected JTable tbEntities;
    protected JTable tbTables;
    protected JTable tbViews;
    protected List lsDomains = new ArrayList();
    protected List lsEntities = new ArrayList();
    protected List lsTables = new ArrayList();
    protected List lsViews = new ArrayList();
    private CardLayout cardLayout = new CardLayout();
    private JPanel pnMain;
    private JTextArea taDescription;
    private JLabel lbTask1;
    private JLabel lbTask2;
    private JLabel lbTask3;
    private JLabel lbTask4;
    private JLabel lbTask5;
    private int taskNbr = 1;
    private JTable tbConnections;
    private ODExtractionController controller;
    private JButton bnRemove;
    private JButton bnProperties;
    private JButton bnTestConnection;
    private JLabel taSummary;
    private JButton bnImport;
    private JButton bnExport;
    protected JPanel firstPanel;
    protected JPanel secondPanel;
    protected JPanel thirdPanel;
    protected JPanel fourthPanel;
    protected JPanel fifthPanel;
    private Connection connection = null;
    private JPanel pnWarning;
    private boolean inExistingDesign;
    private static final Logger LOGGER = new Logger(ODExtractionWizard.class);

    public ODExtractionWizard(ApplicationView view, boolean inExistingDesign) {
        super(view);
        ODExtractionHandler.clearInstance();
        this.inExistingDesign = inExistingDesign;
        this.pnMain.setLayout(this.cardLayout);
        this.firstPanel = this.initFirstTab();
        this.pnMain.add((Component)this.firstPanel, FIRST_PAGE);
        this.secondPanel = this.initSecondTab();
        this.pnMain.add((Component)this.secondPanel, SECOND_PAGE);
        this.thirdPanel = this.initThirdTab();
        this.pnMain.add((Component)this.thirdPanel, THIRD_PAGE);
        this.fourthPanel = this.initFourthTab();
        this.pnMain.add((Component)this.fourthPanel, FOURTH_PAGE);
        this.fifthPanel = this.initFifthTab();
        this.pnMain.add((Component)this.fifthPanel, FIFTH_PAGE);
        this.handleButtons();
    }

    @Override
    protected String getCaption() {
        return Messages.getString("ODExtractionWizard.OracleDesignerImportWizard");
    }

    public ODExtractionController getController() {
        if (this.controller == null) {
            this.controller = new ODExtractionController(this.view);
        }
        return this.controller;
    }

    @Override
    protected JPanel initMainPanel() {
        JPanel jpanel = new JPanel(new BorderLayout());
        JPanel pnBanner = new JPanel(new BorderLayout());
        pnBanner.setBackground(Color.WHITE);
        ImageIcon imageIcon = (ImageIcon)GUIConfiguration.getInstance().getIcon("DBM_WIZARD_BANNER");
        pnBanner.add((Component)new JLabel(imageIcon), "West");
        this.taDescription = new JTextArea();
        this.taDescription.setEditable(false);
        this.taDescription.setFont(fontBlue);
        this.taDescription.setBackground(Color.WHITE);
        JPanel pnRight = new JPanel(new FlowLayout(1, 0, 25));
        pnRight.setBackground(Color.WHITE);
        pnRight.add(this.taDescription);
        pnBanner.add((Component)pnRight, "Center");
        jpanel.add((Component)pnBanner, "North");
        JPanel pnTasks = new JPanel(new GridLayout(0, 1));
        pnTasks.setBackground(Color.WHITE);
        pnTasks.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.lbTask1 = new JLabel(Messages.getString("ODExtractionWizard.ConnectDB"));
        this.lbTask2 = new JLabel(Messages.getString("ODExtractionWizard.SelectWorkAreaPar"));
        this.lbTask3 = new JLabel(Messages.getString("ODExtractionWizard.SelectApplicationSystemsPar"));
        this.lbTask4 = new JLabel(Messages.getString("ODExtractionWizard.SelectObjectsToImportPar"));
        this.lbTask5 = new JLabel(Messages.getString("ODExtractionWizard.GenerateDesignPar"));
        pnTasks.add(this.lbTask1);
        pnTasks.add(this.lbTask2);
        pnTasks.add(this.lbTask3);
        pnTasks.add(this.lbTask4);
        pnTasks.add(this.lbTask5);
        pnTasks.add(new JLabel());
        pnTasks.add(new JLabel());
        pnTasks.add(new JLabel());
        pnTasks.add(new JLabel());
        pnTasks.add(new JLabel());
        pnTasks.add(new JLabel());
        pnTasks.setPreferredSize(new Dimension(280, 350));
        jpanel.add((Component)pnTasks, "West");
        this.pnMain = new JPanel();
        this.pnMain.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.pnMain.setPreferredSize(new Dimension(680, 450));
        jpanel.add((Component)this.pnMain, "Center");
        return jpanel;
    }

    private void updateConnections() {
        ((DMConnectionModel)this.tbConnections.getModel()).reReadConnections();
        this.bnExport.setEnabled(this.tbConnections.getRowCount() > 0);
    }

    private Properties getSelectedConnectionProperties() {
        Properties cd = null;
        try {
            cd = ((DMConnectionModel)this.tbConnections.getModel()).getRowData(this.tbConnections.getSelectedRow());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cd;
    }

    private void showConnectionProperties() {
        Properties cd = this.getSelectedConnectionProperties();
        if (cd != null) {
            String connName = ConnectionInfo.getConnectionName(cd);
            FCPConnectionDialog.showConnectionDialog(connName, true);
            this.updateConnections();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initConnection() {
        block5: {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                this.closeConnection();
                Properties cd = this.getSelectedConnectionProperties();
                if (cd == null) break block5;
                try {
                    this.connection = DatabaseConnections.getInstance().getConnection(cd);
                }
                catch (Exception e) {
                    MessageDialogs.showErrorMessage(e.getLocalizedMessage());
                    boolean bl = false;
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    return bl;
                }
            }
            finally {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        return this.connection != null;
    }

    public void closeConnection() {
        if (this.connection != null) {
            try {
                if (!this.connection.isClosed()) {
                    this.connection.close();
                }
                this.connection = null;
            }
            catch (Exception e) {
                LOGGER.error("Unable to close the connection", e);
            }
        }
    }

    public int getSelectedConnectionType() {
        return ConnectionInfo.getConnectionType(this.getSelectedConnectionProperties());
    }

    private JPanel initFirstTab() {
        JPanel jpanel = new JPanel(new BorderLayout());
        this.tbConnections = new JTable(new DMConnectionModel(DatabaseConnections.getInstance(), true));
        this.tbConnections.setSelectionMode(0);
        this.tbConnections.setDefaultRenderer(Object.class, new ColorTableCellRenderer());
        this.tbConnections.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ODExtractionWizard.this.showConnectionProperties();
                } else {
                    boolean enabled = ODExtractionWizard.this.tbConnections.getSelectedRow() > -1;
                    ODExtractionWizard.this.bnNext.setEnabled(enabled);
                    ODExtractionWizard.this.bnRemove.setEnabled(enabled);
                    ODExtractionWizard.this.bnProperties.setEnabled(enabled);
                    ODExtractionWizard.this.bnTestConnection.setEnabled(enabled);
                }
            }
        });
        this.tbConnections.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    ODExtractionWizard.this.showConnectionProperties();
                }
                boolean enabled = ODExtractionWizard.this.tbConnections.getSelectedRow() > -1;
                ODExtractionWizard.this.bnNext.setEnabled(enabled);
                ODExtractionWizard.this.bnRemove.setEnabled(enabled);
                ODExtractionWizard.this.bnProperties.setEnabled(enabled);
                ODExtractionWizard.this.bnTestConnection.setEnabled(enabled);
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        JScrollPane sp = new JScrollPane(this.tbConnections);
        jpanel.add((Component)sp, "Center");
        JPanel pnButtons = new JPanel(new FlowLayout(0));
        JButton bnAdd = new JButton(Messages.getString("ODExtractionWizard.Add"));
        bnAdd.setMnemonic(65);
        bnAdd.addActionListener(new AddAction());
        this.bnRemove = new JButton(Messages.getString("ODExtractionWizard.Remove"));
        this.bnRemove.setMnemonic(82);
        this.bnRemove.addActionListener(new RemoveAction());
        this.bnRemove.setEnabled(false);
        this.bnImport = new JButton(Messages.getString("ODExtractionWizard.Import"));
        this.bnImport.setToolTipText(Messages.getString("ODExtractionWizard.ImportSQLDevDBConnection"));
        this.bnImport.setMnemonic(73);
        this.bnImport.addActionListener(new ImportAction());
        this.bnExport = new JButton(Messages.getString("ODExtractionWizard.Export"));
        this.bnExport.setToolTipText(Messages.getString("ODExtractionWizard.ExportDBConnection"));
        this.bnExport.setMnemonic(69);
        this.bnExport.addActionListener(new ExportAction());
        this.bnProperties = new JButton(Messages.getString("ODExtractionWizard.Properties"));
        this.bnProperties.setMnemonic(80);
        this.bnProperties.addActionListener(new PropertiesAction());
        this.bnProperties.setEnabled(false);
        this.bnTestConnection = new JButton(Messages.getString("ODExtractionWizard.TestConnection"));
        this.bnTestConnection.setMnemonic(84);
        this.bnTestConnection.addActionListener(new TestAction());
        this.bnTestConnection.setEnabled(false);
        bnAdd.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnRemove.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnImport.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnExport.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnProperties.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        this.bnTestConnection.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        pnButtons.add(bnAdd);
        pnButtons.add(this.bnRemove);
        pnButtons.add(this.bnImport);
        pnButtons.add(this.bnExport);
        pnButtons.add(this.bnProperties);
        pnButtons.add(this.bnTestConnection);
        jpanel.add((Component)pnButtons, "South");
        this.updateConnections();
        return jpanel;
    }

    public boolean initWorkAreas(boolean next) {
        return this.getWorkAreas(next);
    }

    public boolean initAppSys(boolean next) {
        return this.getAppSys(next);
    }

    public boolean initDBObjects(boolean next) {
        return this.getODObjects(next);
    }

    protected JPanel initFifthTab() {
        JPanel jpanel = new JPanel(new BorderLayout());
        this.taSummary = new JLabel();
        this.taSummary.setFont(this.taSummary.getFont().deriveFont(0));
        this.taSummary.setVerticalAlignment(1);
        jpanel.add((Component)this.taSummary, "Center");
        jpanel.add((Component)new JPanel(), "East");
        jpanel.add((Component)new JPanel(), "West");
        jpanel.add((Component)new JPanel(), "North");
        jpanel.add((Component)new JPanel(), "South");
        return jpanel;
    }

    private boolean performTask(boolean next) {
        switch (this.taskNbr) {
            case 1: {
                this.closeConnection();
            }
            case 2: {
                if (!this.initConnection()) {
                    return false;
                }
                return this.initWorkAreas(next);
            }
            case 3: {
                int i = this.tbAppSys.getEditingRow();
                int j = this.tbAppSys.getEditingColumn();
                if (i > -1 && j > -1) {
                    this.tbAppSys.getCellEditor(i, j).stopCellEditing();
                }
                return this.initAppSys(next);
            }
            case 4: {
                return this.initDBObjects(next);
            }
            case 5: {
                return this.getSummary();
            }
        }
        return true;
    }

    private Map getSummaryList() {
        TreeMap<String, Integer> map = new TreeMap<String, Integer>();
        for (ODObject odObject : this.getSelectedObjects()) {
            if (!odObject.isSelected()) continue;
            if (map.containsKey(odObject.getType())) {
                Integer value = (Integer)map.get(odObject.getType());
                int count = value;
                map.put(odObject.getType(), new Integer(++count));
                continue;
            }
            map.put(odObject.getType(), new Integer(1));
        }
        return map;
    }

    @Override
    protected String getHelpIndex() {
        return "IMPORT_ORACLE_DESIGNER_MODELS_WIZARD";
    }

    private String addTableRow(String col1, String col2) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<tr>");
        buffer.append("<td width=\"150\">");
        buffer.append("<p>");
        buffer.append(col1);
        buffer.append("</p>");
        buffer.append("</td>");
        buffer.append("<td width=\"60\" align=\"right\">");
        buffer.append("<p>");
        buffer.append(col2);
        buffer.append("</p>");
        buffer.append("</td>");
        buffer.append("</tr>");
        return buffer.toString();
    }

    private boolean getSummary() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html>");
        buffer.append("<body>");
        buffer.append("<p>");
        buffer.append("<b>");
        buffer.append(Messages.getString("ODExtractionWizard.DatabaseName"));
        buffer.append("</b>");
        buffer.append(ConnectionInfo.getConnectionName(this.getSelectedConnectionProperties()));
        buffer.append("</p>");
        buffer.append("<p>");
        buffer.append("<b>");
        buffer.append(Messages.getString("ODExtractionWizard.DatabaseVersion"));
        buffer.append("</b>");
        buffer.append(this.getController().getDBProductVersion());
        buffer.append("</p>");
        buffer.append("<p></p>");
        buffer.append("<p>");
        buffer.append("<b>");
        buffer.append(Messages.getString("ODExtractionWizard.DBObjectsImported"));
        buffer.append("</b>");
        buffer.append("</p>");
        buffer.append("<table border=\"0\" width=\"170\">");
        Map map = this.getSummaryList();
        Object[] keys = map.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            String objType = (String)keys[i];
            Integer count = (Integer)map.get(keys[i]);
            buffer.append(this.addTableRow(objType, count.toString()));
        }
        buffer.append("</table>");
        buffer.append("</body>");
        buffer.append("</html>");
        this.taSummary.setText(buffer.toString());
        return true;
    }

    @Override
    protected void doBack() {
        --this.taskNbr;
        try {
            if (this.performTask(false)) {
                this.handleButtons();
                switch (this.taskNbr) {
                    case 1: {
                        this.cardLayout.show(this.pnMain, FIRST_PAGE);
                        break;
                    }
                    case 2: {
                        this.cardLayout.show(this.pnMain, SECOND_PAGE);
                        break;
                    }
                    case 3: {
                        this.cardLayout.show(this.pnMain, THIRD_PAGE);
                        break;
                    }
                    case 4: {
                        this.cardLayout.show(this.pnMain, FOURTH_PAGE);
                    }
                }
            } else {
                ++this.taskNbr;
            }
        }
        catch (Throwable e) {
            ++this.taskNbr;
            JOptionPane.showMessageDialog(this, e.getMessage(), Messages.getString("ODExtractionWizard.Error"), 0);
            LOGGER.error(e);
        }
    }

    @Override
    protected void doNext() {
        ++this.taskNbr;
        try {
            if (this.performTask(true)) {
                this.handleButtons();
                switch (this.taskNbr) {
                    case 2: {
                        this.cardLayout.show(this.pnMain, SECOND_PAGE);
                        break;
                    }
                    case 3: {
                        this.cardLayout.show(this.pnMain, THIRD_PAGE);
                        break;
                    }
                    case 4: {
                        this.cardLayout.show(this.pnMain, FOURTH_PAGE);
                        break;
                    }
                    case 5: {
                        this.cardLayout.show(this.pnMain, FIFTH_PAGE);
                    }
                }
            } else {
                --this.taskNbr;
            }
        }
        catch (Throwable e) {
            --this.taskNbr;
            JOptionPane.showMessageDialog(this, e.getMessage(), Messages.getString("ODExtractionWizard.Error"), 0);
            LOGGER.error(e);
        }
    }

    @Override
    protected void doFinish() {
        try {
            this.getController().generateDesign(this.connection, this.getSelectedConnectionProperties(), this.getSelectedObjects(), this.inExistingDesign);
        }
        catch (Throwable e) {
            MessageDialogs.showErrorMessage(this, e.getMessage());
            LOGGER.error(e);
        }
        this.dispose();
    }

    @Override
    protected void doCancel() {
        this.closeConnection();
        this.dispose();
    }

    @Override
    protected void doClosing() {
        this.closeConnection();
    }

    private void handleButtons() {
        this.handleLabels();
        this.handleDescription();
        switch (this.taskNbr) {
            case 1: {
                this.bnBack.setEnabled(false);
                this.bnNext.setEnabled(this.tbConnections.getSelectedRow() > -1);
                this.bnFinish.setEnabled(false);
                this.bnCancel.setEnabled(true);
                break;
            }
            case 2: {
                this.bnBack.setEnabled(true);
                this.bnNext.setEnabled(this.tbWorkAreas.getSelectedRow() > -1);
                this.bnFinish.setEnabled(false);
                this.bnCancel.setEnabled(true);
                break;
            }
            case 3: {
                this.bnBack.setEnabled(true);
                this.bnNext.setEnabled(this.hasAppSystemSelected());
                this.bnFinish.setEnabled(false);
                this.bnCancel.setEnabled(true);
                break;
            }
            case 4: {
                this.bnBack.setEnabled(true);
                this.bnNext.setEnabled(true);
                this.bnFinish.setEnabled(false);
                this.bnCancel.setEnabled(true);
                break;
            }
            case 5: {
                this.bnBack.setEnabled(true);
                this.bnNext.setEnabled(false);
                this.bnFinish.setEnabled(true);
                this.bnCancel.setEnabled(true);
            }
        }
    }

    private void handleLabels() {
        switch (this.taskNbr) {
            case 1: {
                this.setBlueLabel(this.lbTask1);
                this.setGreyLabel(this.lbTask2);
                this.setGreyLabel(this.lbTask3);
                this.setGreyLabel(this.lbTask4);
                this.setGreyLabel(this.lbTask5);
                break;
            }
            case 2: {
                this.setBlackLabel(this.lbTask1);
                this.setBlueLabel(this.lbTask2);
                this.setGreyLabel(this.lbTask3);
                this.setGreyLabel(this.lbTask4);
                this.setGreyLabel(this.lbTask5);
                break;
            }
            case 3: {
                this.setBlackLabel(this.lbTask1);
                this.setBlackLabel(this.lbTask2);
                this.setBlueLabel(this.lbTask3);
                this.setGreyLabel(this.lbTask4);
                this.setGreyLabel(this.lbTask5);
                break;
            }
            case 4: {
                this.setBlackLabel(this.lbTask1);
                this.setBlackLabel(this.lbTask2);
                this.setBlackLabel(this.lbTask3);
                this.setBlueLabel(this.lbTask4);
                this.setGreyLabel(this.lbTask5);
                break;
            }
            case 5: {
                this.setBlackLabel(this.lbTask1);
                this.setBlackLabel(this.lbTask2);
                this.setBlackLabel(this.lbTask3);
                this.setBlackLabel(this.lbTask4);
                this.setBlueLabel(this.lbTask5);
                break;
            }
            default: {
                this.setBlueLabel(this.lbTask1);
                this.setGreyLabel(this.lbTask2);
                this.setGreyLabel(this.lbTask3);
                this.setGreyLabel(this.lbTask4);
                this.setGreyLabel(this.lbTask5);
            }
        }
    }

    private void setGreyLabel(JLabel label) {
        label.setForeground(Color.LIGHT_GRAY);
        label.setFont(fontGrey);
    }

    private void setBlueLabel(JLabel label) {
        label.setForeground(Color.BLUE);
        label.setFont(fontBlue);
    }

    private void setBlackLabel(JLabel label) {
        label.setForeground(Color.BLACK);
        label.setFont(fontBlue);
    }

    private void handleDescription() {
        switch (this.taskNbr) {
            case 1: {
                this.taDescription.setText(DESCRIPTION_1);
                break;
            }
            case 2: {
                this.taDescription.setText(DESCRIPTION_2);
                break;
            }
            case 3: {
                this.taDescription.setText(DESCRIPTION_3);
                break;
            }
            case 4: {
                this.taDescription.setText(DESCRIPTION_4);
                break;
            }
            case 5: {
                this.taDescription.setText(DESCRIPTION_5);
                break;
            }
            default: {
                this.taDescription.setText(DESCRIPTION_1);
            }
        }
    }

    protected JTabbedPane getTabbedPane() {
        if (this.tpane == null) {
            this.tpane = new JTabbedPane(3);
        }
        return this.tpane;
    }

    public JPanel initSecondTab() {
        JPanel jpanel = new JPanel(new BorderLayout());
        this.lsWorkAreas = new ArrayList();
        this.tbWorkAreas = new JTable(new WorkAreaModel());
        this.tbWorkAreas.setSelectionMode(0);
        this.tbWorkAreas.setAutoCreateRowSorter(true);
        WindowsTableHeader.setSortedHeader(this.tbWorkAreas);
        TableColumn column = this.tbWorkAreas.getColumnModel().getColumn(1);
        column.setPreferredWidth(200);
        JScrollPane sp = new JScrollPane(this.tbWorkAreas);
        jpanel.add((Component)sp, "Center");
        this.tbWorkAreas.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                boolean enabled = ODExtractionWizard.this.tbWorkAreas.getSelectedRow() > -1;
                ODExtractionWizard.this.bnNext.setEnabled(enabled);
            }
        });
        return jpanel;
    }

    public JPanel initThirdTab() {
        JPanel jpanel = new JPanel(new BorderLayout());
        this.lsAppSys = new ArrayList<ODObject>();
        this.tbAppSys = new JTable(new AppSysModel());
        this.tbAppSys.setAutoCreateRowSorter(true);
        WindowsTableHeader.setSortedHeader(this.tbAppSys);
        TableColumn column = this.tbAppSys.getColumnModel().getColumn(0);
        column.setPreferredWidth(5);
        column = this.tbAppSys.getColumnModel().getColumn(1);
        column.setPreferredWidth(100);
        column = this.tbAppSys.getColumnModel().getColumn(2);
        column.setPreferredWidth(100);
        column = this.tbAppSys.getColumnModel().getColumn(3);
        column.setPreferredWidth(100);
        column.setCellEditor(new BranchCB());
        JScrollPane sp = new JScrollPane(this.tbAppSys);
        jpanel.add((Component)sp, "Center");
        JPanel pn1 = new JPanel(new FlowLayout(0));
        JButton bnSelectAll = this.createSelectAllButton();
        bnSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ODExtractionWizard.this.checkAll(ODExtractionWizard.this.tbAppSys, ODExtractionWizard.this.lsAppSys, true);
                ODExtractionWizard.this.bnNext.setEnabled(ODExtractionWizard.this.hasAppSystemSelected());
            }
        });
        JButton bnDeselectAll = this.createDeselectAllButton();
        bnDeselectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ODExtractionWizard.this.checkAll(ODExtractionWizard.this.tbAppSys, ODExtractionWizard.this.lsAppSys, false);
                ODExtractionWizard.this.bnNext.setEnabled(false);
            }
        });
        pn1.add(bnSelectAll);
        pn1.add(bnDeselectAll);
        jpanel.add((Component)pn1, "South");
        return jpanel;
    }

    private void checkAll(JTable table, List<ODObject> objects, boolean checked) {
        ListSelectionModel selectionModel = table.getSelectionModel();
        if (selectionModel.isSelectionEmpty()) {
            for (ODObject object : objects) {
                object.setSelected(checked);
            }
        } else {
            for (int i = 0; i < objects.size(); ++i) {
                if (!selectionModel.isSelectedIndex(table.convertRowIndexToView(i))) continue;
                objects.get(i).setSelected(checked);
            }
        }
        table.updateUI();
    }

    public JPanel initFourthTab() {
        JPanel jpanel = new JPanel(new BorderLayout());
        jpanel.add((Component)this.getTabbedPane(), "Center");
        this.addTabs();
        JPanel pn1 = new JPanel(new FlowLayout(0));
        JButton bnSelectAll = this.createSelectAllButton();
        bnSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ODExtractionWizard.this.checkAll(ODExtractionWizard.this.getCurrentTable(), ODExtractionWizard.this.getCurrentList(), true);
            }
        });
        JButton bnDeselectAll = this.createDeselectAllButton();
        bnDeselectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ODExtractionWizard.this.checkAll(ODExtractionWizard.this.getCurrentTable(), ODExtractionWizard.this.getCurrentList(), false);
            }
        });
        pn1.add(bnSelectAll);
        pn1.add(bnDeselectAll);
        jpanel.add((Component)pn1, "South");
        return jpanel;
    }

    protected JTable createTabContents(List list) {
        JTable table = new JTable(new ObjectModel(list));
        table.setAutoCreateRowSorter(true);
        WindowsTableHeader.setSortedHeader(table);
        TableColumn column = table.getColumnModel().getColumn(0);
        column.setPreferredWidth(5);
        column = table.getColumnModel().getColumn(1);
        column.setPreferredWidth(150);
        column = table.getColumnModel().getColumn(2);
        column.setPreferredWidth(150);
        return table;
    }

    protected JTable addTab(List list, String name) {
        JTable table = this.createTabContents(list);
        this.getTabbedPane().addTab(name, new JScrollPane(table));
        return table;
    }

    /*
     * Exception decompiling
     */
    protected boolean getWorkAreas(boolean next) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getAppSys(boolean next) {
        if (next) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                this.resetWorkAreas();
                this.lsAppSys.clear();
                try {
                    List appSystems = this.getController().getApplicationSystems(this.connection, this.lsWorkAreas);
                    if (appSystems.size() > 0) {
                        this.lsAppSys.addAll(appSystems);
                        this.createPrefixes();
                    }
                    this.tbAppSys.updateUI();
                    boolean bl = true;
                    return bl;
                }
                catch (Exception e) {
                    MessageDialogs.showErrorMessage(this, e.getMessage());
                    LOGGER.error(e);
                    this.tbAppSys.updateUI();
                    boolean bl = false;
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    return bl;
                }
            }
            finally {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        return true;
    }

    private void resetWorkAreas() {
        if (this.tbWorkAreas.getSelectedRow() > -1) {
            ODObject odObject = (ODObject)this.lsWorkAreas.get(this.tbWorkAreas.convertRowIndexToModel(this.tbWorkAreas.getSelectedRow()));
            for (ODObject odNext : this.lsWorkAreas) {
                if (odNext != odObject) {
                    odNext.setSelected(false);
                    continue;
                }
                odNext.setSelected(true);
            }
        }
    }

    private void createPrefixes() {
        for (ODObject item : this.lsAppSys) {
            if (item.parentAPP != null) continue;
            this.createPrefixes(item, 1);
        }
    }

    private void createPrefixes(ODObject odObject, int level) {
        for (ODObject item : this.lsAppSys) {
            if (item.parentAPP == null || !item.parentAPP.equals(odObject.getIrid())) continue;
            item.prefix = this.makePrefix(level);
            this.createPrefixes(item, level + 1);
        }
    }

    private String makePrefix(int level) {
        Object result = "";
        for (int i = 0; i < level; ++i) {
            result = (String)result + "  ";
        }
        return result;
    }

    private boolean hasAppSystemSelected() {
        for (ODObject odObj : this.lsAppSys) {
            if (!odObj.isSelected()) continue;
            return true;
        }
        return false;
    }

    protected List getCurrentList() {
        int tab = this.getTabbedPane().getSelectedIndex();
        switch (tab) {
            case 0: {
                return this.lsEntities;
            }
            case 1: {
                return this.lsTables;
            }
            case 2: {
                return this.lsViews;
            }
            case 3: {
                return this.lsClusters;
            }
            case 4: {
                return this.lsSequence;
            }
            case 5: {
                return this.lsSnapshots;
            }
            case 6: {
                return this.lsCollectionTypes;
            }
            case 7: {
                return this.lsStructuredTypes;
            }
            case 8: {
                return this.lsDomains;
            }
        }
        return this.lsEntities;
    }

    protected JTable getCurrentTable() {
        int tab = this.getTabbedPane().getSelectedIndex();
        switch (tab) {
            case 0: {
                return this.tbEntities;
            }
            case 1: {
                return this.tbTables;
            }
            case 2: {
                return this.tbViews;
            }
            case 3: {
                return this.tbClusters;
            }
            case 4: {
                return this.tbSequence;
            }
            case 5: {
                return this.tbSnapshots;
            }
            case 6: {
                return this.tbCollectionTypes;
            }
            case 7: {
                return this.tbStructuredTypes;
            }
            case 8: {
                return this.tbDomains;
            }
        }
        return this.tbEntities;
    }

    protected void addTabs() {
        if (this.tbEntities == null) {
            this.tbEntities = this.addTab(this.lsEntities, Messages.getString("ODExtractionWizard.Entities"));
            this.tbTables = this.addTab(this.lsTables, Messages.getString("ODExtractionWizard.Tables"));
            this.tbViews = this.addTab(this.lsViews, Messages.getString("ODExtractionWizard.Views"));
            this.tbClusters = this.addTab(this.lsClusters, Messages.getString("ODExtractionWizard.Clusters"));
            this.tbSequence = this.addTab(this.lsSequence, Messages.getString("ODExtractionWizard.Sequences"));
            this.tbSnapshots = this.addTab(this.lsSnapshots, Messages.getString("ODExtractionWizard.Snapshots"));
            this.tbCollectionTypes = this.addTab(this.lsCollectionTypes, Messages.getString("ODExtractionWizard.CollectionTypes"));
            this.tbStructuredTypes = this.addTab(this.lsStructuredTypes, Messages.getString("ODExtractionWizard.StructuredTypes"));
            this.tbDomains = this.addDomainsTab();
        }
    }

    private JTable addDomainsTab() {
        this.tbDomains = this.createTabContents(this.lsDomains);
        this.tbDomains.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if ("Name exist".equals(((ODObject)ODExtractionWizard.this.lsDomains.get(row)).getStatus())) {
                    comp.setForeground(Color.RED);
                } else {
                    comp.setForeground(Color.BLACK);
                }
                return comp;
            }
        });
        this.pnWarning = new JPanel(new BorderLayout());
        TitledBorder border = BorderFactory.createTitledBorder("");
        this.pnWarning.setBorder(BorderFactory.createTitledBorder(border, Messages.getString("ODExtractionWizard.Warning"), 1, 2, null, Color.RED));
        JLabel label = new JLabel();
        label.setText(Messages.getString("ODExtractionWizard.ExistingTypeOverridden"));
        label.setForeground(Color.RED);
        this.pnWarning.add((Component)label, "North");
        this.pnWarning.setVisible(false);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JScrollPane(this.tbDomains), "Center");
        panel.add((Component)this.pnWarning, "South");
        this.getTabbedPane().addTab(Messages.getString("ODExtractionWizard.Domains"), panel);
        return this.tbDomains;
    }

    protected JTable addSimpleTab(JTable table, List list, String name) {
        table = new JTable(new SimpleModel(list));
        table.setSelectionMode(0);
        TableColumn column = table.getColumnModel().getColumn(0);
        column.setPreferredWidth(50);
        column = table.getColumnModel().getColumn(1);
        column.setPreferredWidth(300);
        JScrollPane sp = new JScrollPane(table);
        this.getTabbedPane().addTab(name, sp);
        return table;
    }

    protected void updateTables() {
        this.tbEntities.updateUI();
        this.tbTables.updateUI();
        this.tbViews.updateUI();
        this.tbClusters.updateUI();
        this.tbSequence.updateUI();
        this.tbSnapshots.updateUI();
        this.tbCollectionTypes.updateUI();
        this.tbStructuredTypes.updateUI();
        this.tbDomains.updateUI();
    }

    protected void clearAll() {
        this.lsDomains.clear();
        this.lsEntities.clear();
        this.lsTables.clear();
        this.lsViews.clear();
        this.lsTableSpaces.clear();
        this.lsTempTableSpaces.clear();
        this.lsUndoTableSpaces.clear();
        this.lsUsers.clear();
        this.lsRoles.clear();
        this.lsDirectories.clear();
        this.lsExternalTables.clear();
        this.lsContexts.clear();
        this.lsClusters.clear();
        this.lsSequence.clear();
        this.lsSnapshots.clear();
        this.lsDimensions.clear();
        this.lsCollectionTypes.clear();
        this.lsStructuredTypes.clear();
    }

    private void addAditionalTabs() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getODObjects(boolean next) {
        if (next) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                this.clearAll();
                this.addAditionalTabs();
                try {
                    List dbObjects = this.getController().getODObjects(this.connection, this.lsAppSys);
                    if (dbObjects.size() > 0) {
                        this.initSpecificObjects(dbObjects);
                    }
                    this.updateTables();
                    boolean bl = true;
                    return bl;
                }
                catch (Exception e) {
                    MessageDialogs.showErrorMessage(this, e.getMessage());
                    LOGGER.error(e);
                    this.updateTables();
                    boolean bl = false;
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    return bl;
                }
            }
            finally {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        return true;
    }

    protected void initSpecificObjects(List dbObjects) {
        this.clearAll();
        for (ODObject odObject : dbObjects) {
            String type = odObject.getType();
            if (type.equalsIgnoreCase("DOMAIN")) {
                this.lsDomains.add(odObject);
                continue;
            }
            if (type.equalsIgnoreCase("ENTITY")) {
                this.lsEntities.add(odObject);
                continue;
            }
            if (type.equalsIgnoreCase(TABLE)) {
                this.lsTables.add(odObject);
                continue;
            }
            if (type.equalsIgnoreCase(VIEW)) {
                this.lsViews.add(odObject);
                continue;
            }
            if (type.equalsIgnoreCase("CLUSTER")) {
                this.lsClusters.add(odObject);
                continue;
            }
            if (type.equalsIgnoreCase(SEQUENCE)) {
                this.lsSequence.add(odObject);
                continue;
            }
            if (type.equalsIgnoreCase("SNAPSHOT")) {
                this.lsSnapshots.add(odObject);
                continue;
            }
            if (type.equalsIgnoreCase("COLLECTION TYPE")) {
                this.lsCollectionTypes.add(odObject);
                continue;
            }
            if (!type.equalsIgnoreCase("STRUCTURED TYPE")) continue;
            this.lsStructuredTypes.add(odObject);
        }
        this.pnWarning.setVisible(!this.lsDomains.isEmpty() && "Name exist".equals(((ODObject)this.lsDomains.get(0)).getStatus()));
    }

    public List getSelectedObjects() {
        ArrayList<ODObject> list = new ArrayList<ODObject>();
        for (ODObject odObject : this.lsDomains) {
            if (!odObject.isSelected()) continue;
            list.add(odObject);
        }
        for (ODObject odObject : this.lsEntities) {
            if (!odObject.isSelected()) continue;
            list.add(odObject);
        }
        for (ODObject odObject : this.lsTables) {
            if (!odObject.isSelected()) continue;
            list.add(odObject);
        }
        for (ODObject odObject : this.lsViews) {
            if (!odObject.isSelected()) continue;
            list.add(odObject);
        }
        for (ODObject odObject : this.lsTableSpaces) {
            if (!odObject.isSelected()) continue;
            list.add(odObject);
        }
        for (ODObject odObject : this.lsTempTableSpaces) {
            if (!odObject.isSelected()) continue;
            list.add(odObject);
        }
        if (this.tbUndoTableSpaces != null) {
            for (ODObject odObject : this.lsUndoTableSpaces) {
                if (!odObject.isSelected()) continue;
                list.add(odObject);
            }
        }
        for (ODObject odObject : this.lsUsers) {
            if (!odObject.isSelected()) continue;
            list.add(odObject);
        }
        for (ODObject odObject : this.lsRoles) {
            if (!odObject.isSelected()) continue;
            list.add(odObject);
        }
        for (ODObject odObject : this.lsDirectories) {
            if (!odObject.isSelected()) continue;
            list.add(odObject);
        }
        for (ODObject odObject : this.lsExternalTables) {
            if (!odObject.isSelected()) continue;
            list.add(odObject);
        }
        for (ODObject odObject : this.lsContexts) {
            if (!odObject.isSelected()) continue;
            list.add(odObject);
        }
        for (ODObject odObject : this.lsClusters) {
            if (!odObject.isSelected()) continue;
            list.add(odObject);
        }
        for (ODObject odObject : this.lsSequence) {
            if (!odObject.isSelected()) continue;
            list.add(odObject);
        }
        for (ODObject odObject : this.lsSnapshots) {
            if (!odObject.isSelected()) continue;
            list.add(odObject);
        }
        for (ODObject odObject : this.lsDimensions) {
            if (!odObject.isSelected()) continue;
            list.add(odObject);
        }
        for (ODObject odObject : this.lsCollectionTypes) {
            if (!odObject.isSelected()) continue;
            list.add(odObject);
        }
        for (ODObject odObject : this.lsStructuredTypes) {
            if (!odObject.isSelected()) continue;
            list.add(odObject);
        }
        return list;
    }

    private JButton createSelectAllButton() {
        JButton bnSelectAll = new JButton(GUIConfiguration.getInstance().getIcon("SELECT_ALL"));
        bnSelectAll.setMnemonic(83);
        bnSelectAll.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        bnSelectAll.setToolTipText(Messages.getString("ODExtractionWizard.SelectAll"));
        return bnSelectAll;
    }

    private JButton createDeselectAllButton() {
        JButton bnDeselectAll = new JButton(GUIConfiguration.getInstance().getIcon("DESELECT_ALL"));
        bnDeselectAll.setMnemonic(68);
        bnDeselectAll.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        bnDeselectAll.setToolTipText(Messages.getString("ODExtractionWizard.DeselectAll"));
        return bnDeselectAll;
    }

    class BranchCB
    extends DefaultCellEditor {
        JComboBox cbox;

        BranchCB() {
            super(new JComboBox());
            this.cbox = (JComboBox)this.getComponent();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            ODObject odObject = ODExtractionWizard.this.lsAppSys.get(row);
            this.cbox.setModel(new DefaultComboBoxModel<Object>(odObject.branches.toArray()));
            this.cbox.setSelectedItem(odObject.branch);
            return this.cbox;
        }
    }

    class SimpleModel
    extends AbstractTableModel {
        List list;

        public SimpleModel(List list) {
            this.list = list;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.list.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("ODExtractionWizard.Selected");
            }
            if (column == 1) {
                return Messages.getString("ODExtractionWizard.Name");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            ODObject odObject = (ODObject)this.list.get(row);
            switch (col) {
                case 0: {
                    return odObject.isSelected();
                }
                case 1: {
                    return odObject.getName();
                }
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                ODObject odObject = (ODObject)this.list.get(rowIndex);
                odObject.setSelected((Boolean)aValue);
            }
        }
    }

    class ObjectModel
    extends AbstractTableModel {
        List list;

        public ObjectModel(List list) {
            this.list = list;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return this.list.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("ODExtractionWizard.Selected");
            }
            if (column == 1) {
                return Messages.getString("ODExtractionWizard.ApplicationSystem");
            }
            if (column == 2) {
                return Messages.getString("ODExtractionWizard.ObjectName");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            ODObject odObject = (ODObject)this.list.get(row);
            switch (col) {
                case 0: {
                    return odObject.isSelected();
                }
                case 1: {
                    return odObject.getParentName();
                }
                case 2: {
                    return odObject.getName();
                }
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                ODObject odObject = (ODObject)this.list.get(rowIndex);
                odObject.setSelected((Boolean)aValue);
            }
        }
    }

    class AppSysModel
    extends AbstractTableModel {
        AppSysModel() {
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return ODExtractionWizard.this.lsAppSys.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("ODExtractionWizard.Selected");
            }
            if (column == 1) {
                return Messages.getString("ODExtractionWizard.WorkArea");
            }
            if (column == 2) {
                return Messages.getString("ODExtractionWizard.ApplicationSystem");
            }
            if (column == 3) {
                return Messages.getString("ODExtractionWizard.Branch");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (columnIndex == 3) {
                ODObject odObject = ODExtractionWizard.this.lsAppSys.get(rowIndex);
                return odObject.branches.size() > 1;
            }
            return columnIndex == 0;
        }

        public Class getColumnClass(int c) {
            if (c == 3) {
                return ODExtractionHandler.Branch.class;
            }
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            ODObject odObject = ODExtractionWizard.this.lsAppSys.get(row);
            switch (col) {
                case 0: {
                    return odObject.isSelected();
                }
                case 1: {
                    return odObject.getParentName();
                }
                case 2: {
                    if (odObject.sourceBranch != null && !"MAIN".equalsIgnoreCase(odObject.sourceBranch.getName())) {
                        return odObject.prefix + odObject.getName() + " (" + odObject.sourceBranch.getName() + ")";
                    }
                    return odObject.prefix + odObject.getName();
                }
                case 3: {
                    return odObject.branch;
                }
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                ODObject odObject = ODExtractionWizard.this.lsAppSys.get(rowIndex);
                odObject.setSelected((Boolean)aValue);
                this.setChildren(odObject, (Boolean)aValue);
                this.fireTableDataChanged();
                ODExtractionWizard.this.bnNext.setEnabled(ODExtractionWizard.this.hasAppSystemSelected());
            } else if (columnIndex == 3) {
                ODObject odObject = ODExtractionWizard.this.lsAppSys.get(rowIndex);
                odObject.branch = (ODExtractionHandler.Branch)aValue;
            }
        }

        private void setChildren(ODObject odObject, boolean value) {
            for (ODObject item : ODExtractionWizard.this.lsAppSys) {
                if (item.parentAPP == null || !item.parentAPP.equals(odObject.getIrid())) continue;
                item.setSelected(value);
                this.setChildren(item, value);
            }
        }
    }

    class WorkAreaModel
    extends AbstractTableModel {
        WorkAreaModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return ODExtractionWizard.this.lsWorkAreas.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("ODExtractionWizard.WorkArea");
            }
            if (column == 1) {
                return Messages.getString("ODExtractionWizard.Description");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            if (this.getValueAt(0, c) != null) {
                return this.getValueAt(0, c).getClass();
            }
            return String.class;
        }

        @Override
        public Object getValueAt(int row, int col) {
            ODObject odObject = (ODObject)ODExtractionWizard.this.lsWorkAreas.get(row);
            switch (col) {
                case 0: {
                    return odObject.getName();
                }
                case 1: {
                    return odObject.getDescription();
                }
            }
            return new Integer(row * col);
        }
    }

    private class TestAction
    implements ActionListener {
        private TestAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FCPConnectionDialog.testConnection(ODExtractionWizard.this.getSelectedConnectionProperties());
        }
    }

    private class PropertiesAction
    implements ActionListener {
        private PropertiesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ODExtractionWizard.this.showConnectionProperties();
        }
    }

    private class ExportAction
    implements ActionListener {
        private ExportAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FCPConnectionDialog.exportConnections();
        }
    }

    private class ImportAction
    implements ActionListener {
        private ImportAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FCPConnectionDialog.importConnections();
            ODExtractionWizard.this.updateConnections();
        }
    }

    private class RemoveAction
    implements ActionListener {
        private RemoveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Properties cd = ODExtractionWizard.this.getSelectedConnectionProperties();
            if (cd != null) {
                try {
                    String connName = ConnectionInfo.getConnectionName(cd);
                    int result = JOptionPane.showConfirmDialog(ODExtractionWizard.this, MessageFormat.format(Messages.getString("ODExtractionWizard.AreYouSure"), connName), Messages.getString("ODExtractionWizard.SelectOption"), 0);
                    if (result == 0) {
                        DatabaseConnections.getInstance().removeConnection(connName);
                        ODExtractionWizard.this.updateConnections();
                        ODExtractionWizard.this.tbConnections.clearSelection();
                        ODExtractionWizard.this.bnNext.setEnabled(false);
                        ODExtractionWizard.this.bnRemove.setEnabled(false);
                        ODExtractionWizard.this.bnProperties.setEnabled(false);
                        ODExtractionWizard.this.bnTestConnection.setEnabled(false);
                    }
                }
                catch (ConnectionException e1) {
                    LOGGER.error("Unable to delete connection", e1);
                    MessageDialogs.showMessage(ApplicationView.frame, "Unable to delete connection");
                }
            }
        }
    }

    private class AddAction
    implements ActionListener {
        private AddAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                FCPConnectionDialog.showConnectionDialog(true);
                ODExtractionWizard.this.updateConnections();
            }
            catch (Exception e1) {
                LOGGER.error(e1);
            }
        }
    }
}

