/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.metadata;

import java.text.MessageFormat;
import java.util.List;
import java.util.Properties;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.swingui.wizards.metadata.connection.ConnectionInfo;
import oracle.dbtools.raptor.explorer.dt.dialog.ConnectionDialogArb;
import oracle.jdeveloper.db.DatabaseConnections;

public class DMConnectionModel
extends AbstractTableModel {
    List<Properties> data = null;
    DatabaseConnections m_store;
    boolean oracleOnly;

    public DMConnectionModel(DatabaseConnections store, boolean oracleOnly) {
        this.m_store = store;
        this.oracleOnly = oracleOnly;
        this.data = ConnectionInfo.getAllConnections(this.m_store, oracleOnly);
    }

    public void reReadConnections() {
        this.data = ConnectionInfo.getAllConnections(this.m_store, this.oracleOnly);
        this.fireTableStructureChanged();
        this.fireTableDataChanged();
    }

    @Override
    public String getColumnName(int column) {
        String o = null;
        switch (column) {
            case 0: {
                o = ConnectionDialogArb.getString((String)"CONNECTION_DIALOG_LIST_HEADER_NAME");
                break;
            }
            case 1: {
                o = ConnectionDialogArb.getString((String)"CONNECTION_DIALOG_LIST_HEADER_DETAIL");
            }
        }
        return o;
    }

    @Override
    public int getRowCount() {
        return this.data != null ? this.data.size() : 0;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Properties cd = this.getRowData(row);
        Object o = null;
        switch (column) {
            case 0: {
                o = cd.getProperty("ConnName");
                break;
            }
            case 1: {
                String hostname = cd.getProperty("hostname");
                if (hostname != null) {
                    String port = cd.getProperty("port");
                    Object dest = cd.getProperty("sid");
                    String svc = cd.getProperty("serviceName");
                    dest = dest != null ? dest : svc;
                    dest = dest != null && ((String)dest).length() > 0 ? "/" + (String)dest : "";
                    o = MessageFormat.format("//{0}:{1}{2}", hostname, port != null ? port : "1521", dest);
                } else {
                    String url = cd.getProperty("customUrl");
                    if (url != null) {
                        o = url.substring(url.lastIndexOf(64) + 1);
                    }
                }
                String uname = cd.getProperty("user");
                if (uname == null) {
                    uname = "";
                }
                o = uname + "@" + o;
            }
        }
        return o;
    }

    public Properties getRowData(int row) {
        return this.data.get(row);
    }
}

