/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.relational;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.design.ConnectionInterface;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.FKConnection;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.ImpliedForeignKey;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.TVNote;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.relational.DPVRelational;

public class StarLayout {
    private int maxTableWidth = 310;
    private int maxTableHeight = 230;
    private DPVRelational dpv;

    public StarLayout(DPVRelational dpv) {
        this.dpv = dpv;
    }

    public void rearrangeDiagram(String name) {
        this.dpv.startAutoLayoutEdit(name);
        ArrayList<FactTableHelper> factTables = new ArrayList<FactTableHelper>();
        ArrayList<TopView> singles = new ArrayList<TopView>();
        ArrayList<TopView> notes = new ArrayList<TopView>();
        Collection allObjects = this.dpv.getTVTablesAndTVViews();
        this.resetFDProperties(allObjects);
        for (Iterator tv : allObjects) {
            FKContainer container = (FKContainer)((TopView)((Object)tv)).getModel();
            boolean isFactTable = false;
            List<FKIndexAssociation> fkList = container.getFKAssociationsList();
            for (FKIndexAssociation fk : fkList) {
                if (fk.getSourceTopView(this.dpv) == null || tv != fk.getTargetTopView(this.dpv)) continue;
                isFactTable = true;
                break;
            }
            if (!isFactTable) {
                List<ImpliedForeignKey> ifkList = container.getImpliedForeignKeyList();
                for (ImpliedForeignKey impliedForeignKey : ifkList) {
                    if (impliedForeignKey.getSourceTopView(this.dpv) == null || tv != impliedForeignKey.getTargetTopView(this.dpv)) continue;
                    isFactTable = true;
                    break;
                }
            }
            if (!isFactTable) continue;
            ((TopView)((Object)tv)).setFactTable(true);
            this.resizeTopView((TopView)((Object)tv));
            factTables.add(new FactTableHelper((TopView)((Object)tv)));
        }
        ArrayList allConnList = new ArrayList();
        for (FactTableHelper fth : factTables) {
            TopView factTable = fth.getFactTable();
            FKContainer container = (FKContainer)factTable.getModel();
            ArrayList<DesignObject> connList = new ArrayList<DesignObject>();
            connList.addAll(container.getFKAssociationsList());
            connList.addAll(container.getImpliedForeignKeyList());
            allConnList.addAll(connList);
            for (ImpliedForeignKey impliedForeignKey : connList) {
                ContainerView synonym;
                ConnectionInterface fkConn = impliedForeignKey;
                TopView sourceTV = fkConn.getSourceTopView(this.dpv);
                if (sourceTV == null) continue;
                if (!sourceTV.isFactTable()) {
                    if (!sourceTV.isDimensionTable()) {
                        sourceTV.setDimensionTable(true);
                        this.resizeTopView(sourceTV);
                        fth.getDimensions().add(sourceTV);
                        continue;
                    }
                    if (fth.dimensionExists(sourceTV)) continue;
                    synonym = sourceTV.createViewSynonim(this.dpv);
                    if (synonym.getCellView() != null) {
                        synonym.getCellView().setNewBounds(sourceTV.getBounds());
                    } else {
                        synonym.setBounds(sourceTV.getBounds());
                    }
                    fkConn.setSourceTopView(synonym);
                    synonym.setDimensionTable(true);
                    this.resizeTopView(synonym);
                    fth.getDimensions().add(synonym);
                    continue;
                }
                if (fth.dimensionExists(sourceTV)) continue;
                synonym = sourceTV.createViewSynonim(this.dpv);
                if (synonym.getCellView() != null) {
                    synonym.getCellView().setNewBounds(sourceTV.getBounds());
                } else {
                    synonym.setBounds(sourceTV.getBounds());
                }
                fkConn.setSourceTopView(synonym);
                synonym.setDimensionTable(true);
                this.resizeTopView(synonym);
                fth.getDimensions().add(synonym);
            }
        }
        for (TopView tv : allObjects) {
            if (tv.isFactTable() || tv.isDimensionTable()) continue;
            singles.add(tv);
        }
        List allTVs = this.dpv.getTopviewsList();
        for (TopView tv : allTVs) {
            if (!(tv instanceof TVNote)) continue;
            notes.add(tv);
        }
        this.doLayout(factTables, singles, notes, allConnList);
        this.dpv.stopAutoLayoutEdit();
    }

    private void resetFDProperties(Collection<TopView> allObjects) {
        for (TopView tv : allObjects) {
            tv.setFactTable(false);
            tv.setDimensionTable(false);
        }
    }

    private void resizeTopView(TopView tv) {
        Dimension size = this.getSize(tv);
        int width = size.width;
        int height = size.height;
        if (width > this.maxTableWidth || height > this.maxTableHeight) {
            int newWidth = Math.min(width, this.maxTableWidth);
            int newHeight = Math.min(height, this.maxTableHeight);
            Rectangle newBounds = new Rectangle(tv.getLocation(), new Dimension(newWidth, newHeight));
            if (tv.getCellView() != null) {
                tv.getCellView().setNewBounds(newBounds);
            } else {
                tv.setBounds(newBounds);
            }
        }
    }

    private void doLayout(List<FactTableHelper> factTables, List<TopView> singles, List<TopView> notes, List connList) {
        Rectangle newBounds;
        int th;
        int tw;
        Dimension size;
        int fx = 0;
        int fy = 0;
        int colCount = 0;
        double square = factTables.size() > 2 ? Math.sqrt(factTables.size()) : 2.0;
        double colMax = Math.ceil(square);
        int maxR = 0;
        for (FactTableHelper fth : factTables) {
            int radius = this.getRadius(fth);
            fth.setRadius(radius);
            maxR = Math.max(maxR, radius);
        }
        fx = maxR + this.maxTableWidth;
        fy = maxR + this.maxTableHeight;
        for (FactTableHelper fth : factTables) {
            if ((double)(++colCount) > colMax) {
                fx = maxR + this.maxTableWidth;
                fy += maxR * 3;
                colCount = 0;
            }
            this.setPositions(fth, fx, fy);
            fx += maxR * 3;
        }
        double maxFieldWidth = (double)(2 * maxR) * colMax + (colMax - 1.0) * (double)maxR + (double)this.maxTableWidth;
        int maxHeight = 0;
        fx = this.maxTableWidth / 2;
        fy += maxR * 2;
        maxFieldWidth = (double)fx + maxFieldWidth;
        for (TopView single : singles) {
            if ((double)fx > maxFieldWidth) {
                fx = this.maxTableWidth / 2;
                fy = fy + maxHeight + 100;
            }
            size = this.getSize(single);
            tw = size.width;
            th = size.height;
            maxHeight = Math.max(maxHeight, th);
            newBounds = new Rectangle(new Point(fx, fy), new Dimension(tw, th));
            if (single.getCellView() != null) {
                single.getCellView().setNewBounds(newBounds);
            } else {
                single.setBounds(newBounds);
            }
            fx = fx + tw + 100;
        }
        fx = this.maxTableWidth / 2;
        fy = fy + maxHeight + 100;
        maxHeight = 0;
        for (TopView note : notes) {
            if ((double)fx > maxFieldWidth) {
                fx = this.maxTableWidth / 2;
                fy = fy + maxHeight + 100;
            }
            size = this.getSize(note);
            tw = size.width;
            th = size.height;
            maxHeight = Math.max(maxHeight, th);
            newBounds = new Rectangle(new Point(fx, fy), new Dimension(tw, th));
            if (note.getCellView() != null) {
                note.getCellView().setNewBounds(newBounds);
            } else {
                note.setBounds(newBounds);
            }
            fx = fx + tw + 100;
        }
        if (!this.dpv.isAutoRoute()) {
            this.straightenLines(connList);
        }
    }

    public void straightenLines(List list) {
        for (FKConnection fk : list) {
            TopView tv = fk.getViewFor(this.dpv);
            if (tv == null || tv.getCellView() == null) continue;
            DefaultEdge edge = (DefaultEdge)tv.getCellView().getCell();
            edge.straightLine(false);
        }
    }

    private void setPositions(FactTableHelper fth, int fx, int fy) {
        TopView factTable = fth.getFactTable();
        Dimension size = this.getSize(factTable);
        int tw = size.width;
        int th = size.height;
        Rectangle newBounds = new Rectangle(new Point(fx - tw / 2, fy - th / 2), new Dimension(tw, th));
        if (factTable.getCellView() != null) {
            factTable.getCellView().setNewBounds(newBounds);
        } else {
            factTable.setBounds(newBounds);
        }
        List<TopView> dimensions = fth.getDimensions();
        int radius = fth.getRadius();
        double offset = 360 / dimensions.size();
        int i = 0;
        for (TopView tvDim : dimensions) {
            double angle = (double)i * offset;
            double x = (double)radius * Math.cos(Math.toRadians(angle)) + (double)fx;
            double y = (double)radius * Math.sin(Math.toRadians(angle)) + (double)fy;
            Dimension dimSize = this.getSize(tvDim);
            int dw = dimSize.width;
            int dh = dimSize.height;
            newBounds = new Rectangle(new Point((int)x - dw / 2, (int)y - dh / 2), new Dimension(dw, dh));
            if (tvDim.getCellView() != null) {
                tvDim.getCellView().setNewBounds(newBounds);
            } else {
                tvDim.setBounds(newBounds);
            }
            ++i;
        }
    }

    private Dimension getSize(TopView tv) {
        int width = 0;
        int height = 0;
        if (tv.getCellView() != null) {
            width = Math.round((float)tv.getCellView().getBounds().getWidth());
            height = Math.round((float)tv.getCellView().getBounds().getHeight());
        } else {
            width = tv.getSize().width;
            height = tv.getSize().height;
        }
        return new Dimension(width, height);
    }

    private int getRadius(FactTableHelper fth) {
        int maxW = 0;
        int maxH = 0;
        for (TopView tv : fth.getDimensions()) {
            Dimension size = this.getSize(tv);
            int width = size.width;
            int height = size.height;
            maxW = Math.max(maxW, width);
            maxH = Math.max(maxH, height);
        }
        Dimension size = this.getSize(fth.getFactTable());
        int ftWidth = size.width;
        int ftHeight = size.height;
        int mftd = Math.max(ftWidth / 2, ftHeight / 2);
        int maxDim = Math.max(maxW / 2, maxH / 2);
        int idx = fth.getDimensions().size() * (maxDim / 3);
        return mftd + idx + maxDim;
    }

    class FactTableHelper {
        private TopView factTable;
        private List<TopView> dimensions = new ArrayList<TopView>();
        private int radius = 0;

        public FactTableHelper(TopView factTable) {
            this.factTable = factTable;
        }

        public TopView getFactTable() {
            return this.factTable;
        }

        public List<TopView> getDimensions() {
            return this.dimensions;
        }

        public int getRadius() {
            return this.radius;
        }

        public void setRadius(int radius) {
            this.radius = radius;
        }

        public boolean dimensionExists(TopView tv) {
            for (TopView dim : this.dimensions) {
                if (!dim.getViewID().equalsIgnoreCase(tv.getViewID())) continue;
                return true;
            }
            return false;
        }
    }
}

