/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.process;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.fcp.SearchDockable;
import oracle.dbtools.crest.model.MultiShapedDesignObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.ImageObject;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.ExternalAgent;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.swingui.AbstractController;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GlassComponent;
import oracle.dbtools.crest.swingui.MDBAction;
import oracle.dbtools.crest.swingui.MenuUtils;
import oracle.dbtools.crest.swingui.PointsEnteredCallback;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.diagram.process.DFDiagramCell;
import oracle.dbtools.crest.swingui.process.AbstractDataFlowTV;
import oracle.dbtools.crest.swingui.process.Messages;
import oracle.dbtools.crest.swingui.process.TVFlow;
import oracle.dbtools.crest.swingui.search.SearchPanel;
import oracle.dbtools.crest.util.GUID;
import oracle.ide.Ide;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.layout.ViewId;

public class ControllerProcess
extends AbstractController {
    private DockStation dockStation = null;
    private DesignPartView designPV = null;
    private Select select;
    private ZoomIn zoomIn;
    private ZoomOut zoomOut;
    private FitScreen fitScreen;
    private ActualSize actualSize;
    private Search search;
    private ProcessObjectCollector poCollector = null;
    private NewProcess newProcess;
    private NewAgent newAgent;
    private NewInfoStore newInfoStore;
    private NewFlow newFlow;
    private NewNote newNote;
    private NewImage newImage;
    private Delete delete;
    private final String[] OBJECT_PROCESS_PATH = new String[]{AbstractController.OBJECT_CAPTION, AbstractController.DATAFLOW_CAPTION};

    public ControllerProcess(ApplicationView applicationView) {
        super(applicationView);
    }

    public JMenu getObjectProcessMenu() {
        return this.getApplicationView().getControllerSet().getMenuStructure().get(this.OBJECT_PROCESS_PATH);
    }

    @Override
    public void initializeActions() {
        if (this.isEditable()) {
            this.select = new Select();
            this.newProcess = new NewProcess();
            this.newAgent = new NewAgent();
            this.newInfoStore = new NewInfoStore();
            this.newFlow = new NewFlow();
            this.newNote = new NewNote();
            this.newImage = new NewImage();
            this.delete = new Delete();
            this.add(this.select);
            this.add(this.newProcess);
            this.add(this.newAgent);
            this.add(this.newInfoStore);
            this.add(this.newFlow);
            this.add(this.newNote);
            this.add(this.newImage);
            this.add(this.delete);
        }
        this.zoomIn = new ZoomIn();
        this.add(this.zoomIn);
        this.zoomOut = new ZoomOut();
        this.add(this.zoomOut);
        this.fitScreen = new FitScreen();
        this.add(this.fitScreen);
        this.actualSize = new ActualSize();
        this.add(this.actualSize);
        this.search = new Search();
        this.add(this.search);
    }

    @Override
    public String getToolBarName() {
        return Messages.getString("ControllerProcess.DataFlow");
    }

    @Override
    public DesignPartView getDesignPartView() {
        return this.designPV;
    }

    @Override
    public void setDesignPartView(DesignPartView dpv) {
        this.designPV = dpv;
    }

    @Override
    public boolean canPaste() {
        for (Object obj : this.getApplicationView().getCopiedObjects()) {
            if (obj == null || !(obj instanceof Process) && !(obj instanceof ExternalAgent) && !(obj instanceof InfoStore) && !(obj instanceof Note) && !(obj instanceof ImageObject)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paste(Point pt) {
        if (this.canPaste()) {
            try {
                ApplicationView.canLogging = false;
                int xx = 0;
                int yy = 0;
                HashMap<String, Process> copiedMap = null;
                for (Object obj : this.getApplicationView().getCopiedObjects()) {
                    Point2D pp;
                    Rectangle r;
                    TopView ctv;
                    TopView topView;
                    DesignObject copied;
                    if (!(obj instanceof DesignObject)) continue;
                    if (obj instanceof Process) {
                        ApplicationView.log(Messages.getString("ControllerProcess.CreateProcess"));
                        copied = (Process)obj;
                        Process process = ((DataFlowDesign)this.getDesignPartView().getDesignPart()).createProcess();
                        ((Process)copied).copy(process);
                        if (copiedMap == null) {
                            copiedMap = new HashMap<String, Process>();
                        }
                        copiedMap.put(copied.getObjectID(), process);
                        topView = this.getDesignPartView().getViewFor(process);
                        if (topView == null || topView.getCellView() == null || (ctv = ((AbstractProcessObject)copied).getTopView()) == null || ctv.getCellView() == null) continue;
                        Point2D pp2 = null;
                        if (pt != null) {
                            pp2 = this.getDesignPartView().getWorkSpace().fromScreen(new Point2D.Double(pt.x, pt.y));
                        }
                        Rectangle r2 = new Rectangle(ctv.getCellView().getBounds().getBounds());
                        if (pp2 != null) {
                            r2.x = (int)pp2.getX() + xx;
                            r2.y = (int)pp2.getY() + yy;
                        } else {
                            r2.x += 30 + xx;
                            r2.y += 30 + yy;
                        }
                        topView.getCellView().setNewBounds(r2);
                        xx += 20;
                        yy += 20;
                        continue;
                    }
                    if (obj instanceof ExternalAgent) {
                        ApplicationView.log(Messages.getString("ControllerProcess.CreateExternalAgent"));
                        copied = (ExternalAgent)obj;
                        ExternalAgent agent = ((DataFlowDesign)this.getDesignPartView().getDesignPart()).createExternalAgent();
                        ((ExternalAgent)copied).copy(agent);
                        if (copiedMap == null) {
                            copiedMap = new HashMap();
                        }
                        copiedMap.put(copied.getObjectID(), (Process)((Object)agent));
                        topView = this.getDesignPartView().getViewFor(agent);
                        if (topView == null || topView.getCellView() == null || (ctv = ((AbstractProcessObject)copied).getTopView()) == null || ctv.getCellView() == null) continue;
                        r = new Rectangle(ctv.getCellView().getBounds().getBounds());
                        pp = null;
                        if (pt != null) {
                            pp = this.getDesignPartView().getWorkSpace().fromScreen(new Point2D.Double(pt.x, pt.y));
                        }
                        if (pp != null) {
                            r.x = (int)pp.getX() + xx;
                            r.y = (int)pp.getY() + yy;
                        } else {
                            r.x += 30 + xx;
                            r.y += 30 + yy;
                        }
                        topView.getCellView().setNewBounds(r);
                        xx += 20;
                        yy += 20;
                        continue;
                    }
                    if (obj instanceof InfoStore) {
                        ApplicationView.log(Messages.getString("ControllerProcess.CreateInformationStore"));
                        copied = (InfoStore)obj;
                        InfoStore store = ((DataFlowDesign)this.getDesignPartView().getDesignPart()).createInfoStore();
                        ((InfoStore)copied).copy(store);
                        if (copiedMap == null) {
                            copiedMap = new HashMap();
                        }
                        copiedMap.put(copied.getObjectID(), (Process)((Object)store));
                        topView = this.getDesignPartView().getViewFor(store);
                        if (topView == null || topView.getCellView() == null || (ctv = ((AbstractProcessObject)copied).getTopView()) == null || ctv.getCellView() == null) continue;
                        r = new Rectangle(ctv.getCellView().getBounds().getBounds());
                        pp = null;
                        if (pt != null) {
                            pp = this.getDesignPartView().getWorkSpace().fromScreen(new Point2D.Double(pt.x, pt.y));
                        }
                        if (pp != null) {
                            r.x = (int)pp.getX() + xx;
                            r.y = (int)pp.getY() + yy;
                        } else {
                            r.x += 30 + xx;
                            r.y += 30 + yy;
                        }
                        topView.getCellView().setNewBounds(r);
                        xx += 20;
                        yy += 20;
                        continue;
                    }
                    if (obj instanceof Note) {
                        ApplicationView.log(Messages.getString("ControllerProcess.CreateNote"));
                        copied = (Note)obj;
                        Note note = ((DataFlowDesign)this.getDesignPartView().getDesignPart()).createNote();
                        copied.copy(note);
                        topView = this.getDesignPartView().getViewFor(note);
                        if (topView == null || topView.getCellView() == null || (ctv = ((MultiShapedDesignObject)copied).getTopView()) == null || ctv.getCellView() == null) continue;
                        r = new Rectangle(ctv.getCellView().getBounds().getBounds());
                        pp = null;
                        if (pt != null) {
                            pp = this.getDesignPartView().getWorkSpace().fromScreen(new Point2D.Double(pt.x, pt.y));
                        }
                        if (pp != null) {
                            r.x = (int)pp.getX() + xx;
                            r.y = (int)pp.getY() + yy;
                        } else {
                            r.x += 30 + xx;
                            r.y += 30 + yy;
                        }
                        topView.getCellView().setNewBounds(r);
                        xx += 20;
                        yy += 20;
                        ctv.copy(topView);
                        continue;
                    }
                    if (!(obj instanceof ImageObject)) continue;
                    ApplicationView.log(Messages.getString("ControllerProcess.CreateImage"));
                    copied = (ImageObject)obj;
                    ImageObject image = ((DataFlowDesign)this.getDesignPartView().getDesignPart()).createImage();
                    ((ImageObject)copied).copy(image);
                    topView = this.getDesignPartView().getViewFor(image);
                    if (topView == null || topView.getCellView() == null || (ctv = ((MultiShapedDesignObject)copied).getTopView()) == null || ctv.getCellView() == null) continue;
                    r = new Rectangle(ctv.getCellView().getBounds().getBounds());
                    pp = null;
                    if (pt != null) {
                        pp = this.getDesignPartView().getWorkSpace().fromScreen(new Point2D.Double(pt.x, pt.y));
                    }
                    if (pp != null) {
                        r.x = (int)pp.getX() + xx;
                        r.y = (int)pp.getY() + yy;
                    } else {
                        r.x += 30 + xx;
                        r.y += 30 + yy;
                    }
                    topView.getCellView().setNewBounds(r);
                    xx += 20;
                    yy += 20;
                }
                if (copiedMap != null) {
                    HashMap<CallSite, String> flowMap = new HashMap<CallSite, String>();
                    for (Object obj : this.getApplicationView().getCopiedObjects()) {
                        if (!(obj instanceof AbstractProcessObject)) continue;
                        AbstractProcessObject copied = (AbstractProcessObject)obj;
                        AbstractProcessObject apo = (AbstractProcessObject)copiedMap.get(copied.getObjectID());
                        for (Flow flow : copied.getIncomingFlows()) {
                            DesignObject source = flow.getSourceObject();
                            DesignObject newSource = (DesignObject)copiedMap.get(source.getObjectID());
                            TopView sourceTopView = null;
                            sourceTopView = newSource != null ? this.getDesignPartView().getFirstViewFor(newSource) : this.getDesignPartView().getFirstViewFor(source);
                            TopView targetTopView = this.getDesignPartView().getFirstViewFor(apo);
                            if (sourceTopView == null || targetTopView == null || flowMap.get(sourceTopView.getViewID() + targetTopView.getViewID()) != null) continue;
                            Flow newFlow = ((DataFlowDesign)this.getDesignPartView().getDesignPart()).createFlow();
                            newFlow.setSourceTV((AbstractDataFlowTV)sourceTopView);
                            newFlow.setTargetTV((AbstractDataFlowTV)targetTopView);
                            ((TVFlow)newFlow.getViewFor(this.getDesignPartView())).addConnection();
                            newFlow.addToAllDPVs(this.getDesignPartView());
                            flowMap.put((CallSite)((Object)(sourceTopView.getViewID() + targetTopView.getViewID())), targetTopView.getViewID());
                        }
                        for (Flow flow : copied.getOutgoingFlows()) {
                            DesignObject target = flow.getTargetObject();
                            DesignObject newTarget = (DesignObject)copiedMap.get(target.getObjectID());
                            TopView sourceTopView = this.getDesignPartView().getFirstViewFor(apo);
                            TopView targetTopView = null;
                            targetTopView = newTarget != null ? this.getDesignPartView().getFirstViewFor(newTarget) : this.getDesignPartView().getFirstViewFor(target);
                            if (sourceTopView == null || targetTopView == null || flowMap.get(sourceTopView.getViewID() + targetTopView.getViewID()) != null) continue;
                            Flow newFlow = ((DataFlowDesign)this.getDesignPartView().getDesignPart()).createFlow();
                            newFlow.setSourceTV((AbstractDataFlowTV)sourceTopView);
                            newFlow.setTargetTV((AbstractDataFlowTV)targetTopView);
                            ((TVFlow)newFlow.getViewFor(this.getDesignPartView())).addConnection();
                            newFlow.addToAllDPVs(this.getDesignPartView());
                            flowMap.put((CallSite)((Object)(sourceTopView.getViewID() + targetTopView.getViewID())), targetTopView.getViewID());
                        }
                    }
                }
                this.getDesign().setDirty(true);
            }
            finally {
                ApplicationView.canLogging = true;
                this.getDesignPartView().getDesignPart().sortCollections();
            }
        }
    }

    @Override
    public void select_SelectAction() {
        if (this.poCollector != null) {
            this.poCollector.stopWaiting();
        }
        this.getDesignPartView().getWorkSpace().setDrawnObjectID(-1);
        this.getDesignPartView().getWorkSpace().setCursor(new Cursor(0));
    }

    public Select getSelectAction() {
        return this.select;
    }

    public NewProcess getNewProcessAction() {
        return this.newProcess;
    }

    public NewAgent getNewAgentAction() {
        return this.newAgent;
    }

    public NewInfoStore getNewInfoStoreAction() {
        return this.newInfoStore;
    }

    public NewFlow getNewFlowAction() {
        return this.newFlow;
    }

    public NewNote getNewNoteAction() {
        return this.newNote;
    }

    public NewImage getNewImageAction() {
        return this.newImage;
    }

    public Delete getDeleteAction() {
        return this.delete;
    }

    public ZoomIn getZoomInAction() {
        return this.zoomIn;
    }

    public ZoomOut getZoomOutAction() {
        return this.zoomOut;
    }

    public FitScreen getFitScreenAction() {
        return this.fitScreen;
    }

    public ActualSize getDefaultSizeAction() {
        return this.actualSize;
    }

    @Override
    public MDBAction getFindAction() {
        return this.search;
    }

    @Override
    public void updateActions() {
        boolean enabled = true;
        if (this.getDesign().isLoadFromDB() && this.getDesignPartView().getDesignPart().getRepositoryOID() != null) {
            enabled = this.getDesignPartView().getDesignPart().isCheckedOutByMe();
        }
        this.getDesignPartView().getWorkSpace().updateReadOnlyStatus();
        this.setEnabled(this.newProcess, enabled);
        this.setEnabled(this.newAgent, enabled);
        this.setEnabled(this.newInfoStore, enabled);
        this.setEnabled(this.newFlow, enabled);
        this.setEnabled(this.newNote, enabled);
        this.setEnabled(this.newImage, enabled);
        this.setEnabled(this.delete, enabled);
    }

    public DockStation getDockStation() {
        if (this.dockStation == null) {
            this.dockStation = DockStation.getDockStation();
        }
        return this.dockStation;
    }

    public class ProcessObjectCollector
    implements PointsEnteredCallback {
        private GlassComponent glassComp = null;

        public ProcessObjectCollector() {
            this.startCollecting();
        }

        public void startCollecting() {
            ControllerProcess.this.getDesignPartView().getWorkSpace().clearSelection();
            this.collect();
        }

        private void collect() {
            this.glassComp = ControllerProcess.this.getDesignPartView().getGlassPane();
            this.glassComp.getPoints(this, 2);
        }

        public void stopWaiting() {
            if (this.glassComp != null) {
                this.glassComp.stopAll();
            }
        }

        @Override
        public void rectangleSelected(Rectangle rectangle) {
        }

        @Override
        public void pointSelected(Point point) {
        }

        @Override
        public void pointsSelected(Point[] points) {
            AbstractDataFlowTV sourceTV = this.getTVEntityFor(points[0]);
            AbstractDataFlowTV targetTV = this.getTVEntityFor(points[1]);
            ArrayList<String> errors = new ArrayList<String>();
            if (sourceTV == null) {
                errors.add(Messages.getString("ControllerProcess.NoSourceObjectSelected"));
            }
            if (targetTV == null) {
                errors.add(Messages.getString("ControllerProcess.NoDestinationObjectSelected"));
            }
            if (sourceTV != null && sourceTV == targetTV) {
                errors.add(Messages.getString("ControllerProcess.SourceTargetEquals"));
            }
            if (errors.size() == 0) {
                AbstractProcessObject spo = (AbstractProcessObject)sourceTV.getModel();
                AbstractProcessObject tpo = (AbstractProcessObject)targetTV.getModel();
                if (!(spo instanceof Process) && !(tpo instanceof Process)) {
                    errors.add(Messages.getString("ControllerProcess.OneObjectShouldBeProcess"));
                }
                DesignPart dp = ControllerProcess.this.getApplicationView().getCurrentDPV().getDesignPart();
                if (spo instanceof Process && tpo instanceof Process && spo.getDesignPart() != dp && tpo.getDesignPart() != dp) {
                    errors.add(Messages.getString("ControllerProcess.SourceDestinationObjectNotInCurrentLevel"));
                }
                if (errors.size() == 0) {
                    this.createFlow(sourceTV, targetTV);
                } else {
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), errors.toArray(), Messages.getString("ControllerProcess.NewFlow"), 0);
                }
            } else {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), errors.toArray(), Messages.getString("ControllerProcess.NewFlow"), 0);
            }
            ControllerProcess.this.select_SelectAction();
        }

        private AbstractDataFlowTV getTVEntityFor(Point point) {
            Object cell = ControllerProcess.this.getDesignPartView().getWorkSpace().getFirstCellForLocation(point.getX(), point.getY());
            if (cell != null && cell instanceof DFDiagramCell) {
                return (AbstractDataFlowTV)((DFDiagramCell)cell).getTopView();
            }
            return null;
        }

        private void createFlow(AbstractDataFlowTV sourceTV, AbstractDataFlowTV targetTV) {
            ApplicationView.log(Messages.getString("ControllerProcess.CreateFlow"));
            Flow flow = ControllerProcess.this.getDesign().getProcessModel().getDataFlowDesign().createFlow();
            flow.setSourceTV(sourceTV);
            flow.setTargetTV(targetTV);
            ((TVFlow)flow.getViewFor(sourceTV.getDesignPartView())).addConnection();
            flow.addToAllDPVs(ControllerProcess.this.getApplicationView().getCurrentDPV());
        }

        @Override
        public Component getTargetCoordinateSpace() {
            return ControllerProcess.this.getDesignPartView().getWorkSpace();
        }
    }

    class Search
    extends MDBAction {
        private Search() {
            super(MenuUtils.getMnemonicStr(AbstractController.SEARCH_CAPTION), ControllerProcess.this.getConfiguration().getIcon("SEARCH_ICON", ControllerProcess.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.SEARCH_CAPTION));
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public boolean addToolbarSeparator() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            DesignPart dp = ControllerProcess.this.getDesignPartView().getDesignPart();
            SearchDockable lastNonPinnedView = dp.getLastNonPinnedSearchDockable();
            if (lastNonPinnedView == null) {
                ViewId vId = new ViewId(new GUID().toString(), Integer.toString(dp.getSearchDockableIdSequence()));
                SearchDockable sdNew = new SearchDockable(vId);
                dp.addSearchDockable(sdNew);
                ((SearchPanel)sdNew.getGUI()).resetItems(dp);
                sdNew.show();
            } else {
                ControllerProcess.this.getDockStation().activateDockable((Dockable)lastNonPinnedView);
            }
        }
    }

    class ActualSize
    extends MDBAction {
        private ActualSize() {
            super(MenuUtils.getMnemonicStr(AbstractController.ACTUAL_SIZE_CAPTION), ControllerProcess.this.getConfiguration().getIcon("ACTUAL_SIZE_ICON", ControllerProcess.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.ACTUAL_SIZE_CAPTION));
            this.setAllowedInToolbar(true);
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            DesignPartView dpv = ControllerProcess.this.getApplicationView().getCurrentDPV();
            dpv.actualSize();
        }
    }

    class FitScreen
    extends MDBAction {
        private FitScreen() {
            super(MenuUtils.getMnemonicStr(AbstractController.FIT_SCREEN_CAPTION), ControllerProcess.this.getConfiguration().getIcon("FIT_SCREEN_ICON", ControllerProcess.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.FIT_SCREEN_CAPTION));
            this.setAllowedInToolbar(true);
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            DesignPartView dpv = ControllerProcess.this.getApplicationView().getCurrentDPV();
            dpv.fitScreen();
        }
    }

    class ZoomOut
    extends MDBAction {
        private ZoomOut() {
            super(MenuUtils.getMnemonicStr(AbstractController.ZOOM_OUT_CAPTION), ControllerProcess.this.getConfiguration().getIcon("ZOOM_OUT_ICON", ControllerProcess.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.ZOOM_OUT_CAPTION));
            this.setAllowedInToolbar(true);
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            DesignPartView dpv = ControllerProcess.this.getApplicationView().getCurrentDPV();
            dpv.zoomOut();
        }
    }

    class ZoomIn
    extends MDBAction {
        private ZoomIn() {
            super(MenuUtils.getMnemonicStr(AbstractController.ZOOM_IN_CAPTION), ControllerProcess.this.getConfiguration().getIcon("ZOOM_IN_ICON", ControllerProcess.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.ZOOM_IN_CAPTION));
            this.setAllowedInToolbar(true);
        }

        @Override
        public boolean addToolbarSeparator() {
            return ControllerProcess.this.isEditable();
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            DesignPartView dpv = ControllerProcess.this.getApplicationView().getCurrentDPV();
            dpv.zoomIn();
        }
    }

    class Delete
    extends MDBAction {
        private Delete() {
            super(MenuUtils.getMnemonicStr(AbstractController.DELETE_CAPTION), ControllerProcess.this.getConfiguration().getIcon("DELETE_ICON", ControllerProcess.this.getPreferredIconSize()));
            this.setMenuPath(ControllerProcess.this.OBJECT_PROCESS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.DELETE_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            if (ControllerProcess.this.poCollector != null) {
                ControllerProcess.this.poCollector.stopWaiting();
            }
            ControllerProcess.this.getDesignPartView().getWorkSpace().setDrawnObjectID(6);
            ControllerProcess.this.getDesignPartView().getWorkSpace().setCursor(Diagram.DELETE_CURSOR);
            ControllerProcess.this.updateToolbar(this);
        }
    }

    class NewImage
    extends MDBAction {
        private NewImage() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_IMAGE_CAPTION), ControllerProcess.this.getConfiguration().getIcon("IMAGE_ICON", ControllerProcess.this.getPreferredIconSize()));
            this.setMenuPath(ControllerProcess.this.OBJECT_PROCESS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_IMAGE_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            if (ControllerProcess.this.poCollector != null) {
                ControllerProcess.this.poCollector.stopWaiting();
            }
            ControllerProcess.this.getDesignPartView().getWorkSpace().setDrawnObjectID(25);
            ControllerProcess.this.getDesignPartView().getWorkSpace().setCursor(new Cursor(1));
            ControllerProcess.this.updateToolbar(this);
        }
    }

    class NewNote
    extends MDBAction {
        private NewNote() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_NOTE_CAPTION), ControllerProcess.this.getConfiguration().getIcon("NOTE_ICON", ControllerProcess.this.getPreferredIconSize()));
            this.setMenuPath(ControllerProcess.this.OBJECT_PROCESS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_NOTE_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            if (ControllerProcess.this.poCollector != null) {
                ControllerProcess.this.poCollector.stopWaiting();
            }
            ControllerProcess.this.getDesignPartView().getWorkSpace().setDrawnObjectID(5);
            ControllerProcess.this.getDesignPartView().getWorkSpace().setCursor(new Cursor(1));
            ControllerProcess.this.updateToolbar(this);
        }
    }

    class NewInfoStore
    extends MDBAction {
        private NewInfoStore() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_STORE_CAPTION), ControllerProcess.this.getConfiguration().getIcon("INFO_STORE_ICON", ControllerProcess.this.getPreferredIconSize()));
            this.setMenuPath(ControllerProcess.this.OBJECT_PROCESS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_STORE_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            if (ControllerProcess.this.poCollector != null) {
                ControllerProcess.this.poCollector.stopWaiting();
            }
            ControllerProcess.this.getDesignPartView().getWorkSpace().setDrawnObjectID(9);
            ControllerProcess.this.getDesignPartView().getWorkSpace().setCursor(new Cursor(1));
            ControllerProcess.this.updateToolbar(this);
        }
    }

    class NewAgent
    extends MDBAction {
        private NewAgent() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_AGENT_CAPTION), ControllerProcess.this.getConfiguration().getIcon("AGENT_ICON", ControllerProcess.this.getPreferredIconSize()));
            this.setMenuPath(ControllerProcess.this.OBJECT_PROCESS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_AGENT_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            if (ControllerProcess.this.poCollector != null) {
                ControllerProcess.this.poCollector.stopWaiting();
            }
            ControllerProcess.this.getDesignPartView().getWorkSpace().setDrawnObjectID(8);
            ControllerProcess.this.getDesignPartView().getWorkSpace().setCursor(new Cursor(1));
            ControllerProcess.this.updateToolbar(this);
        }
    }

    class NewFlow
    extends MDBAction {
        private NewFlow() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_FLOW_CAPTION), ControllerProcess.this.getConfiguration().getIcon("FLOW_ICON", ControllerProcess.this.getPreferredIconSize()));
            this.setMenuPath(ControllerProcess.this.OBJECT_PROCESS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_FLOW_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            ControllerProcess.this.getDesignPartView().getWorkSpace().setDrawnObjectID(10);
            ControllerProcess.this.getDesignPartView().getWorkSpace().setCursor(Diagram.LINE_CURSOR);
            ControllerProcess.this.updateToolbar(this);
            if (ControllerProcess.this.poCollector != null) {
                ControllerProcess.this.poCollector.stopWaiting();
            }
            ControllerProcess.this.poCollector = new ProcessObjectCollector();
        }
    }

    class NewProcess
    extends MDBAction {
        private NewProcess() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_PROCESS_CAPTION), ControllerProcess.this.getConfiguration().getIcon("PROCESS_ICON", ControllerProcess.this.getPreferredIconSize()));
            this.setMenuPath(ControllerProcess.this.OBJECT_PROCESS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_PROCESS_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            if (ControllerProcess.this.poCollector != null) {
                ControllerProcess.this.poCollector.stopWaiting();
            }
            ControllerProcess.this.getDesignPartView().getWorkSpace().setDrawnObjectID(7);
            ControllerProcess.this.getDesignPartView().getWorkSpace().setCursor(new Cursor(1));
            ControllerProcess.this.updateToolbar(this);
        }
    }

    class Select
    extends MDBAction {
        private Select() {
            super(MenuUtils.getMnemonicStr(AbstractController.SELECT_CAPTION), ControllerProcess.this.getConfiguration().getIcon("SELECT_ICON", ControllerProcess.this.getPreferredIconSize()));
            this.setMenuPath(ControllerProcess.this.OBJECT_PROCESS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.SELECT_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            if (ControllerProcess.this.poCollector != null) {
                ControllerProcess.this.poCollector.stopWaiting();
            }
            ControllerProcess.this.getDesignPartView().getWorkSpace().setDrawnObjectID(-1);
            ControllerProcess.this.getDesignPartView().getWorkSpace().setCursor(new Cursor(0));
            ControllerProcess.this.updateToolbar(this);
        }
    }
}

