/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.printing;

import com.itextpdf.awt.DefaultFontMapper;
import com.itextpdf.awt.FontMapper;
import com.itextpdf.text.pdf.BaseFont;
import java.awt.Font;
import java.io.File;
import oracle.dbtools.crest.util.OSEnvironment;
import oracle.dbtools.crest.util.logging.Logger;

public class UnicodeFontMapper
implements FontMapper {
    private DefaultFontMapper dfm = new DefaultFontMapper();
    private BaseFont baseFont = null;
    private static final Logger LOGGER = new Logger(UnicodeFontMapper.class);

    public UnicodeFontMapper() {
        try {
            String pdfFont = System.getProperty("datamodeler.pdf.font");
            if (pdfFont != null && pdfFont.trim().length() > 0) {
                this.baseFont = BaseFont.createFont((String)pdfFont, (String)"Identity-H", (boolean)true);
            }
            if (this.baseFont == null) {
                if (OSEnvironment.isWindows()) {
                    File font = new File("C:/Windows/Fonts/Arial.ttf");
                    if (font.exists()) {
                        this.baseFont = BaseFont.createFont((String)font.getAbsolutePath(), (String)"Identity-H", (boolean)true);
                    }
                } else if (OSEnvironment.isMacOS()) {
                    File font = new File("/Library/Fonts/Arial Unicode.ttf");
                    if (font.exists()) {
                        this.baseFont = BaseFont.createFont((String)font.getAbsolutePath(), (String)"Identity-H", (boolean)true);
                    }
                } else if (OSEnvironment.isLinux()) {
                    File font = new File("/usr/share/fonts/dejavu/DejaVuSans.ttf");
                    if (font.exists()) {
                        this.baseFont = BaseFont.createFont((String)font.getAbsolutePath(), (String)"Identity-H", (boolean)true);
                    } else {
                        font = new File("/usr/share/fonts/truetype/dejavu/DejaVuSans.ttf");
                        if (font.exists()) {
                            this.baseFont = BaseFont.createFont((String)font.getAbsolutePath(), (String)"Identity-H", (boolean)true);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error in UnicodeFontMapper:", e);
        }
    }

    public BaseFont awtToPdf(Font font) {
        if (this.baseFont != null) {
            return this.baseFont;
        }
        return this.dfm.awtToPdf(font);
    }

    public Font pdfToAwt(BaseFont font, int size) {
        if (this.baseFont != null) {
            return null;
        }
        return this.dfm.pdfToAwt(font, size);
    }
}

