/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.multidimensional;

import java.awt.Color;
import java.awt.event.MouseEvent;
import java.util.Map;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Label;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.SelectableObject;
import oracle.dbtools.crest.swingui.SelectableObjectMultiple;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.diagram.multidimensional.DimensionDiagramCell;
import oracle.dbtools.crest.swingui.diagram.multidimensional.LinkView;
import oracle.dbtools.crest.swingui.diagram.multidimensional.MDDiagramCell;
import oracle.dbtools.crest.swingui.multidimensional.AbstractMDTV;

public class TVLink
extends TVConnector {
    private LinkSelection selectionWrapper = new LinkSelection();

    public TVLink(ApplicationView appView, DesignPartView dpv) {
        super(appView, dpv);
    }

    @Override
    public boolean isConnection() {
        return true;
    }

    @Override
    public DesignPartView getDesignPartView() {
        if (this.dpv == null) {
            return this.getApplicationView().getCurrentDPV();
        }
        return this.dpv;
    }

    public void remove() {
        this.remove(true);
    }

    public void remove(boolean removeModel) {
        if (removeModel) {
            RollupLink rollupLink = this.getLink().getRollupLink();
            this.getModel().remove();
            if (rollupLink != null) {
                rollupLink.remove();
            }
            this.getDesignPartView().getWorkSpace().repaint();
            if (this.getCellView() != null) {
                Object[] cells = new Object[]{this.getCellView().getCell()};
                this.getDesignPartView().getWorkSpace().removeCells(cells);
                this.getDesignPartView().getWorkSpace().repaint();
            }
        }
    }

    public Link getLink() {
        return (Link)this.getModel();
    }

    public DefaultEdge addConnection() {
        if (this.edge == null) {
            AbstractMDTV sourceTV = this.getLink().getSourceTV(this.getDesignPartView());
            AbstractMDTV targetTV = this.getLink().getTargetTV(this.getDesignPartView());
            if (sourceTV.getCellView() != null && targetTV.getCellView() != null) {
                MDDiagramCell source = (MDDiagramCell)sourceTV.getCellView().getCell();
                MDDiagramCell target = (MDDiagramCell)targetTV.getCellView().getCell();
                Color color = source instanceof DimensionDiagramCell ? new Color(0, 200, 20) : new Color(0, 100, 240);
                this.edge = this.getDesignPartView().getWorkSpace().addConnection(source, target, color);
                this.edge.setTopView(this);
                this.setCellView(this.edge.getCellView());
                this.getLink().addRollupLink();
                this.resetEdgeParams(this.edge, false);
                this.displayLabels();
                if (!ApplicationView.loading && source != target) {
                    this.edge.straightLine();
                }
            }
        }
        return this.edge;
    }

    public boolean isSelected() {
        return this.selectionWrapper == this.getDesignPartView().getCurrentSelection();
    }

    @Override
    public SelectableObject getSelectableObject() {
        return this.selectionWrapper;
    }

    @Override
    public Object getLayerConstraint() {
        return RELATION_LAYER;
    }

    @Override
    public String toString() {
        return this.getModel().getName();
    }

    public void oneClick(MouseEvent e) {
        this.getDesignPartView().setCurrentSelection(this.selectionWrapper, this);
    }

    public LinkView getLinkView() {
        return (LinkView)this.getCellView();
    }

    @Override
    public DefaultEdge getEdge() {
        return this.edge;
    }

    @Override
    public void changed(DesignObject object, ObjectChangeEvent event) {
    }

    @Override
    public Color getDefaultLineColor() {
        return this.getDesign().getDesignLevelSettings().getDefaultLWCObject("Multidimentional Link").getColor();
    }

    @Override
    public int getDefaultLineWidth() {
        return this.getDesign().getDesignLevelSettings().getDefaultLWCObject("Multidimentional Link").getWidth();
    }

    @Override
    public void displayLabels() {
        Link link = (Link)this.getModel();
        RollupLink rlink = link.getRollupLink();
        if (rlink != null) {
            if (link.getRollupLink().isRolePlaying()) {
                if (this.edge != null && this.edge.getTopView() != null) {
                    if (!"".equalsIgnoreCase(rlink.getName())) {
                        this.displayLabel(rlink.getName(), this.getLabelBounds(), 1);
                    } else {
                        this.removeLabel(1);
                    }
                }
            } else {
                this.removeLabel(1);
            }
        }
    }

    @Override
    public void resetEdgeParams() {
        if (this.edge != null) {
            Label label = this.getLabel(1);
            if (label != null) {
                label.setText(this.getModel().getName());
            }
            this.resetEdgeParams(this.edge, true);
        }
    }

    public void resetEdgeParams(boolean repaint) {
        if (this.edge != null) {
            this.resetEdgeParams(this.edge, repaint);
        }
    }

    private void resetEdgeParams(DefaultEdge edge, boolean repaint) {
        Map edgeAttributes = edge.getAttributes();
        Link link = this.getLink();
        if (link != null) {
            if (link.getSourceObject() instanceof Level && link.getTargetObject() instanceof Level) {
                DiagramConstants.setLineBegin(edgeAttributes, 16);
            } else if (link.getSourceObject() instanceof Dimension) {
                DiagramConstants.setLineBegin(edgeAttributes, 0);
            } else {
                DiagramConstants.setLineBegin(edgeAttributes, 8);
            }
        }
        DiagramConstants.setBeginFill(edgeAttributes, false);
        EdgeView cv = (EdgeView)edge.getDiagram().getDiagramLayoutCache().getMapping(edge, false);
        if (cv != null) {
            cv.update();
        }
        if (repaint && cv != null) {
            cv.getDiagram().repaint();
        }
    }

    class LinkSelection
    implements SelectableObject {
        LinkSelection() {
        }

        @Override
        public Object[] getSelectedContainedObject() {
            return null;
        }

        @Override
        public Object getSelectedObject() {
            return this.getSelectedDesignObject();
        }

        @Override
        public DesignObject getSelectedDesignObject() {
            return TVLink.this.getModel();
        }

        @Override
        public boolean hasContainedArray() {
            return false;
        }

        @Override
        public boolean isMultiple() {
            return false;
        }

        @Override
        public SelectableObjectMultiple asMultiple() {
            throw new ClassCastException("Not a SelectableObjectMultiple");
        }
    }
}

