/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.logical;

import java.awt.Color;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Map;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.InheritanceRelation;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.SelectableObject;
import oracle.dbtools.crest.swingui.SelectableObjectMultiple;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.diagram.graph.ContainerDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.diagram.logical.EntityView;
import oracle.dbtools.crest.swingui.diagram.logical.RelationEdge;
import oracle.dbtools.crest.swingui.logical.DPVLogical;
import oracle.dbtools.crest.swingui.logical.TVEntity;

public class TVRelation
extends TVConnector {
    private RelationSelection selectionWrapper = new RelationSelection();
    private Color pathColorSelected = Color.red;
    private Color pathColorNormal = Color.black;
    private static final float[] dashpattern = new float[]{8.0f, 8.0f};

    public TVRelation(ApplicationView appView, DesignPartView dpv) {
        super(appView, dpv);
    }

    @Override
    public boolean isConnection() {
        return true;
    }

    public DPVLogical getLogicalView() {
        return this.getApplicationView().getDPVLogical();
    }

    @Override
    public DesignPartView getDesignPartView() {
        if (this.dpv == null) {
            if (ApplicationView.loading) {
                return this.getApplicationView().getDPVLogical();
            }
            return this.getApplicationView().getCurrentDPV();
        }
        return this.dpv;
    }

    public Relation getRelation() {
        return (Relation)this.getModel();
    }

    @Override
    public void changed(DesignObject object, ObjectChangeEvent event) {
        if (ObjectChangeEvent.OBJECT_REMOVED.equals(event)) {
            this.removeLabel(0);
            this.removeLabel(2);
        }
    }

    public void addConnection() {
        if (this.edge == null) {
            TVEntity sourceTV = this.getRelation().getSourceTV(this.getDesignPartView());
            TVEntity targetTV = this.getRelation().getTargetTV(this.getDesignPartView());
            if (sourceTV != null && sourceTV.getCellView() != null && targetTV != null && targetTV.getCellView() != null) {
                ContainerDiagramCell source = (ContainerDiagramCell)sourceTV.getCellView().getCell();
                ContainerDiagramCell target = (ContainerDiagramCell)targetTV.getCellView().getCell();
                this.edge = this.getDesignPartView().getWorkSpace().addConnection(source, target, Color.BLACK);
                this.edge.setTopView(this);
                this.setCellView(this.edge.getCellView());
                this.getDesignPartView().getWorkSpace().addPoints(this.edge, this.getEdgePoints(), true);
                this.edge.getCellView().update();
                this.resetEdgeParams(this.edge, false);
                ((EntityView)sourceTV.getCellView()).updateParent();
                ((EntityView)targetTV.getCellView()).updateParent();
                this.displayLabels();
                if (!ApplicationView.loading) {
                    this.edge.straightLine();
                }
            }
        }
    }

    @Override
    public void displayLabels() {
        if (this.edge != null && this.edge.getDiagram().getDesignPartView().showLabels()) {
            if (this.edge != null && this.edge.getTopView() != null) {
                if (!"".equalsIgnoreCase(((RelationEdge)this.edge).getSourceLabel()) && !"".equalsIgnoreCase(((RelationEdge)this.edge).getTargetLabel())) {
                    this.displayLabel(((RelationEdge)this.edge).getSourceLabel(), this.getSourceLabelBounds(), 0);
                    this.displayLabel(((RelationEdge)this.edge).getTargetLabel(), this.getTargetLabelBounds(), 2);
                    this.getEdgeView().refreshLabels();
                } else {
                    this.removeLabel(0);
                    this.removeLabel(2);
                }
            }
        } else {
            this.removeLabel(0);
            this.removeLabel(2);
        }
        this.displayRelationAttributes();
    }

    public void displayRelationAttributes() {
        if (this.edge != null && this.edge.getDiagram().getDesignPartView().showRelAttributes()) {
            String attributes = ((RelationEdge)this.edge).getAttributesAsString();
            if (attributes != null) {
                this.displayLabel(attributes, this.getLabelBounds(), 1);
            } else {
                this.removeLabel(1);
            }
        } else {
            this.removeLabel(1);
        }
    }

    public Collection getRelationshipAttributes() {
        if (this.edge != null) {
            return ((RelationEdge)this.edge).getRelation().getAttributesCollection();
        }
        return null;
    }

    public void updateParents() {
        TVEntity sourceTV = this.getRelation().getSourceTV(this.getDesignPartView());
        TVEntity targetTV = this.getRelation().getTargetTV(this.getDesignPartView());
        if (sourceTV != null && sourceTV.getCellView() != null && targetTV != null && targetTV.getCellView() != null && this.getDesignPartView().isBoxInBox()) {
            ((EntityView)sourceTV.getCellView()).updateParent();
            ((EntityView)targetTV.getCellView()).updateParent();
        }
    }

    @Override
    public void resetEdgeParams() {
        if (this.edge != null) {
            this.resetEdgeParams(this.edge, true);
        }
    }

    public void resetEdgeParams(boolean repaint) {
        if (this.edge != null) {
            this.resetEdgeParams(this.edge, repaint);
        }
    }

    private void resetEdgeParams(DefaultEdge edge, boolean repaint) {
        EdgeView cv;
        Map edgeAttributes = edge.getAttributes();
        Relation rel = (Relation)this.getModel();
        if (rel.getClass() == Relation.class) {
            edgeAttributes.remove("dashPattern");
            Relation.Cardinality scar = (Relation.Cardinality)rel.getSourceCardinality();
            Relation.Cardinality tcar = (Relation.Cardinality)rel.getTargetCardinality();
            int notation = this.getApplicationView().getSettings().getNotation();
            notation = this.getDesignPartView().getNotation();
            if (notation == 0) {
                DiagramConstants.setBeginDashed(edgeAttributes, false);
                DiagramConstants.setEndDashed(edgeAttributes, false);
                if (rel.isIdentifying()) {
                    if (scar.getValue() == 1 && tcar.getValue() == 1) {
                        Entity dominantEntity = rel.getDominantRole();
                        if (rel.getSourceEntity() == dominantEntity) {
                            DiagramConstants.setLineBegin(edgeAttributes, 5);
                            DiagramConstants.setLineEnd(edgeAttributes, 15);
                        } else {
                            DiagramConstants.setLineBegin(edgeAttributes, 15);
                            DiagramConstants.setLineEnd(edgeAttributes, 5);
                        }
                    } else if (tcar.getValue() == 0) {
                        DiagramConstants.setLineBegin(edgeAttributes, 5);
                        DiagramConstants.setLineEnd(edgeAttributes, 14);
                    } else {
                        DiagramConstants.setLineBegin(edgeAttributes, 14);
                        DiagramConstants.setLineEnd(edgeAttributes, 5);
                    }
                } else {
                    if (tcar.getValue() == 0) {
                        DiagramConstants.setLineEnd(edgeAttributes, 2);
                    } else {
                        DiagramConstants.setLineEnd(edgeAttributes, 5);
                    }
                    if (scar.getValue() == 0) {
                        DiagramConstants.setLineBegin(edgeAttributes, 2);
                    } else {
                        DiagramConstants.setLineBegin(edgeAttributes, 5);
                    }
                }
                if (rel.getOptional(0).booleanValue()) {
                    DiagramConstants.setBeginFill(edgeAttributes, false);
                } else {
                    DiagramConstants.setBeginFill(edgeAttributes, true);
                }
                if (rel.getOptional(1).booleanValue()) {
                    DiagramConstants.setEndFill(edgeAttributes, false);
                } else {
                    DiagramConstants.setEndFill(edgeAttributes, true);
                }
            } else if (notation == 1) {
                DiagramConstants.setBeginFill(edgeAttributes, false);
                DiagramConstants.setEndFill(edgeAttributes, false);
                DiagramConstants.setBeginSize(edgeAttributes, 6);
                DiagramConstants.setEndSize(edgeAttributes, 6);
                if (rel.isIdentifying()) {
                    if (scar.getValue() == 1 && tcar.getValue() == 1) {
                        Entity dominantEntity = rel.getDominantRole();
                        if (rel.getSourceEntity() == dominantEntity) {
                            DiagramConstants.setLineBegin(edgeAttributes, 0);
                            DiagramConstants.setLineEnd(edgeAttributes, 7);
                        } else if (rel.getTargetEntity() == dominantEntity) {
                            DiagramConstants.setLineBegin(edgeAttributes, 7);
                            DiagramConstants.setLineEnd(edgeAttributes, 0);
                        } else if (rel.isOptionalSource() && !rel.isOptionalTarget()) {
                            DiagramConstants.setLineBegin(edgeAttributes, 0);
                            DiagramConstants.setLineEnd(edgeAttributes, 7);
                        } else if (!rel.isOptionalSource() && rel.isOptionalTarget()) {
                            DiagramConstants.setLineBegin(edgeAttributes, 7);
                            DiagramConstants.setLineEnd(edgeAttributes, 0);
                        }
                    } else if (tcar.getValue() == 0) {
                        DiagramConstants.setLineBegin(edgeAttributes, 0);
                        DiagramConstants.setLineEnd(edgeAttributes, 17);
                    } else {
                        DiagramConstants.setLineBegin(edgeAttributes, 17);
                        DiagramConstants.setLineEnd(edgeAttributes, 0);
                    }
                } else {
                    if (tcar.getValue() == 0) {
                        DiagramConstants.setLineEnd(edgeAttributes, 16);
                    } else {
                        DiagramConstants.setLineEnd(edgeAttributes, 0);
                    }
                    if (scar.getValue() == 0) {
                        DiagramConstants.setLineBegin(edgeAttributes, 16);
                    } else {
                        DiagramConstants.setLineBegin(edgeAttributes, 0);
                    }
                }
                if (rel.getOptional(0).booleanValue()) {
                    DiagramConstants.setBeginDashed(edgeAttributes, true);
                } else {
                    DiagramConstants.setBeginDashed(edgeAttributes, false);
                }
                if (rel.getOptional(1).booleanValue()) {
                    DiagramConstants.setEndDashed(edgeAttributes, true);
                } else {
                    DiagramConstants.setEndDashed(edgeAttributes, false);
                }
            } else if (notation == 2) {
                DiagramConstants.setBeginFill(edgeAttributes, false);
                DiagramConstants.setEndFill(edgeAttributes, false);
                DiagramConstants.setBeginSize(edgeAttributes, 6);
                DiagramConstants.setEndSize(edgeAttributes, 6);
                if (!rel.isIdentifying()) {
                    DiagramConstants.setDashPattern(edgeAttributes, dashpattern);
                } else {
                    edgeAttributes.remove("dashPattern");
                }
                if (tcar.getValue() == 0) {
                    if (rel.getOptional(0).booleanValue()) {
                        DiagramConstants.setLineEnd(edgeAttributes, 19);
                    } else {
                        DiagramConstants.setLineEnd(edgeAttributes, 17);
                    }
                } else if (rel.getOptional(0).booleanValue()) {
                    DiagramConstants.setLineEnd(edgeAttributes, 18);
                } else {
                    DiagramConstants.setLineEnd(edgeAttributes, 8);
                }
                if (scar.getValue() == 0) {
                    if (rel.getOptional(1).booleanValue()) {
                        DiagramConstants.setLineBegin(edgeAttributes, 19);
                    } else {
                        DiagramConstants.setLineBegin(edgeAttributes, 17);
                    }
                } else if (rel.getOptional(1).booleanValue()) {
                    DiagramConstants.setLineBegin(edgeAttributes, 18);
                } else {
                    DiagramConstants.setLineBegin(edgeAttributes, 8);
                }
            }
            if (this.getDesignPartView().getNotation() == 1) {
                if (rel.isSourceTransferable()) {
                    DiagramConstants.setTransferableSource(edgeAttributes, true);
                } else {
                    DiagramConstants.setTransferableSource(edgeAttributes, false);
                }
                if (rel.isTargetTransferable()) {
                    DiagramConstants.setTransferableTarget(edgeAttributes, true);
                } else {
                    DiagramConstants.setTransferableTarget(edgeAttributes, false);
                }
            } else {
                DiagramConstants.setTransferableTarget(edgeAttributes, true);
                DiagramConstants.setTransferableSource(edgeAttributes, true);
            }
            edge.setAttributes(edgeAttributes);
        }
        if ((cv = (EdgeView)edge.getDiagram().getDiagramLayoutCache().getMapping(edge, false)) != null) {
            cv.update();
            if (repaint) {
                cv.getDiagram().repaint();
            }
        }
        this.updateParents();
    }

    public boolean isSelected() {
        return this.selectionWrapper == this.getDesignPartView().getCurrentSelection();
    }

    @Override
    public SelectableObject getSelectableObject() {
        return this.selectionWrapper;
    }

    @Override
    public Object getLayerConstraint() {
        return RELATION_LAYER;
    }

    protected void setPathColorNormal(Color color) {
        this.pathColorNormal = color;
    }

    protected void setPathColorSelected(Color color) {
        this.pathColorSelected = color;
    }

    protected Color getPathColorNormal() {
        return this.pathColorNormal;
    }

    protected Color getPathColorSelected() {
        return this.pathColorSelected;
    }

    @Override
    public String toString() {
        return this.getModel().getName();
    }

    public void oneClick(MouseEvent e) {
        this.getDesignPartView().setCurrentSelection(this.selectionWrapper, this);
    }

    @Override
    public Color getDefaultLineColor() {
        return this.getModel().getDesign().getDesignLevelSettings().getDefaultLWCObject("Logical Relation").getColor();
    }

    @Override
    public int getDefaultLineWidth() {
        return this.getModel().getDesign().getDesignLevelSettings().getDefaultLWCObject("Logical Relation").getWidth();
    }

    public Relation.RelationEndsDescription getRelationEndsDescription() {
        Relation rel = (Relation)this.getModel();
        int notation = this.getApplicationView().getSettings().getNotation();
        notation = this.getDesignPartView().getNotation();
        return rel.getRelationEndsDescription(notation);
    }

    @Override
    public boolean isCanGoBack() {
        if (this.getDesignPartView().isBoxInBox()) {
            Relation rel = (Relation)this.getModel();
            if (rel instanceof InheritanceRelation) {
                return true;
            }
            Entity ent = rel.getSourceEntity();
            if (ent != null && ent.isHierarchicalEntityType()) {
                return false;
            }
            ent = rel.getTargetEntity();
            if (ent != null && ent.isHierarchicalEntityType()) {
                return false;
            }
        }
        return true;
    }

    class RelationSelection
    implements SelectableObject {
        RelationSelection() {
        }

        @Override
        public Object[] getSelectedContainedObject() {
            return null;
        }

        @Override
        public Object getSelectedObject() {
            return this.getSelectedDesignObject();
        }

        @Override
        public DesignObject getSelectedDesignObject() {
            return TVRelation.this.getModel();
        }

        @Override
        public boolean hasContainedArray() {
            return false;
        }

        @Override
        public boolean isMultiple() {
            return false;
        }

        @Override
        public SelectableObjectMultiple asMultiple() {
            throw new ClassCastException("Not a SelectableObjectMultiple");
        }
    }
}

