/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.viewbuilder;

import com.adbs.ast.KeywordFormat;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.ParsingException;
import com.adbs.querybuilder.ActiveSubQueryChangedEvent;
import com.adbs.querybuilder.ActiveSubQueryChangedEventListener;
import com.adbs.querybuilder.ActiveUnionSubQueryChangedEvent;
import com.adbs.querybuilder.ActiveUnionSubQueryChangedEventListener;
import com.adbs.querybuilder.CriteriaList;
import com.adbs.querybuilder.CriteriaListControl;
import com.adbs.querybuilder.CriteriaListOptions;
import com.adbs.querybuilder.CustomExpressionBuilderColumns;
import com.adbs.querybuilder.CustomExpressionBuilderEvent;
import com.adbs.querybuilder.CustomExpressionBuilderEventListener;
import com.adbs.querybuilder.DataSource;
import com.adbs.querybuilder.Link;
import com.adbs.querybuilder.LinkPlace;
import com.adbs.querybuilder.LinkSideType;
import com.adbs.querybuilder.ObjectsGroupingType;
import com.adbs.querybuilder.PlainTextSQLBuilder;
import com.adbs.querybuilder.QueryBuilder;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.querybuilder.QueryPart;
import com.adbs.querybuilder.SQLUpdatedEvent;
import com.adbs.querybuilder.SQLUpdatedEventListener;
import com.adbs.querybuilder.UnionSubQuery;
import com.adbs.querybuilder.UnionSubQueryPanel;
import com.adbs.syntax.BaseSyntaxProvider;
import com.adbs.syntax.OracleSyntaxProvider;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.imports.DBConnectionStamp;
import oracle.dbtools.crest.imports.metadata.DBMOConstants;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.editor.StringEditor;
import oracle.dbtools.crest.swingui.editor.viewbuilder.Messages;
import oracle.dbtools.crest.swingui.editor.viewbuilder.QBUtils;
import oracle.dbtools.crest.swingui.editor.viewbuilder.tester.DMSQLQueryTester;
import oracle.dbtools.crest.swingui.editor.viewbuilder.tester.ResultTesterComponent;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.SQLSyntaxTextArea;
import oracle.dbtools.crest.util.options.Settings;
import oracle.ide.Ide;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.jdeveloper.db.DatabaseConnections;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

public class QueryBuilderPanel
extends JPanel
implements DBMOConstants {
    private ContainerObject contObject;
    protected JDialog dialog;
    protected JPanel buttonPanel;
    protected JPanel general;
    private QueryBuilder queryBuilder;
    private ApplicationView applView;
    private PlainTextSQLBuilder plainTextSQLBuilder;
    private RSyntaxTextArea jTextPane;
    private FKContainer tableView;
    private static GUIConfiguration conf = GUIConfiguration.getInstance();
    private boolean includeSchema = false;
    private boolean autoJoin = false;
    private DesignPartView usedDPV = null;
    private JComboBox cbFilter;
    private boolean isOpened = false;
    private JCheckBox chbShowCurrentQuerySQLOnly;
    private boolean loaded = false;
    private JComboBox cbSyntaxProviders;
    private JCheckBox chbJoins;
    private JButton bnANSIJoins;
    private JButton bnOracleJoins;
    private static final GUIConfiguration configuration = GUIConfiguration.getInstance();
    private Action escapeAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            QueryBuilderPanel.this.close();
        }
    };

    public QueryBuilderPanel(ContainerObject object) {
        this.contObject = object;
    }

    public void initProperties(ContainerObject object) {
        if (this.contObject instanceof FKContainer) {
            this.tableView = (FKContainer)this.contObject;
            this.cbSyntaxProviders.setSelectedItem(this.tableView.getSyntaxProvider());
            this.cbFilter.removeAllItems();
            if (this.usedDPV == null) {
                this.cbFilter.setEnabled(true);
                this.cbFilter.addItem(this.tableView.getDesignPart().getMainView());
                Iterator svit = this.tableView.getDesignPart().getDesignSubviews().iterator();
                while (svit.hasNext()) {
                    DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)svit.next();
                    DesignPartView dpv = ph.getDesignPartView();
                    this.cbFilter.addItem(dpv);
                }
            } else {
                this.cbFilter.setEnabled(false);
            }
            QBUtils.initProperties(this.tableView, this.queryBuilder, this.plainTextSQLBuilder, this.jTextPane, this.usedDPV, this.includeSchema, this.autoJoin);
        }
    }

    private void updateJoinsControls() {
        BaseSyntaxProvider sp = this.queryBuilder.getSyntaxProvider();
        if (sp instanceof OracleSyntaxProvider) {
            OracleSyntaxProvider osp = (OracleSyntaxProvider)sp;
            this.chbJoins.setSelected(osp.isCreateWhereJoinsByDefault());
            this.chbJoins.setEnabled(!this.hasLinks());
            this.bnANSIJoins.setEnabled(this.hasJoins(false));
            this.bnOracleJoins.setEnabled(this.hasJoins(true) && !this.hasFullOuterJoin());
        } else {
            this.chbJoins.setEnabled(false);
            this.bnANSIJoins.setEnabled(false);
            this.bnOracleJoins.setEnabled(false);
        }
    }

    private void setCreateOracleJoins(boolean value) {
        BaseSyntaxProvider sp = this.queryBuilder.getSyntaxProvider();
        if (sp instanceof OracleSyntaxProvider) {
            OracleSyntaxProvider osp = (OracleSyntaxProvider)sp;
            osp.setCreateWhereJoinsByDefault(value);
        }
    }

    private boolean hasLinks() {
        for (UnionSubQuery usq : this.queryBuilder.getUnionSubQueryList()) {
            ArrayList links = new ArrayList();
            usq.getFromClause().getLinksRecursive(links);
            if (links.size() <= 0) continue;
            return true;
        }
        return false;
    }

    private boolean hasJoins(boolean oracleJoins) {
        for (UnionSubQuery usq : this.queryBuilder.getUnionSubQueryList()) {
            ArrayList links = new ArrayList();
            usq.getFromClause().getLinksRecursive(links);
            for (int i = links.size() - 1; i >= 0; --i) {
                Link link = (Link)links.get(i);
                LinkPlace place = oracleJoins ? LinkPlace.From : LinkPlace.Where;
                if (link.getPlace() != place) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasFullOuterJoin() {
        for (UnionSubQuery usq : this.queryBuilder.getUnionSubQueryList()) {
            ArrayList links = new ArrayList();
            usq.getFromClause().getLinksRecursive(links);
            for (int i = links.size() - 1; i >= 0; --i) {
                Link link = (Link)links.get(i);
                if (link.getLeftType() != LinkSideType.Outer || link.getRightType() != LinkSideType.Outer) continue;
                return true;
            }
        }
        return false;
    }

    protected static int getIntValue(String string) {
        if (string != null && !"".equalsIgnoreCase(string)) {
            try {
                String[] parts_n = string.split(" ");
                if (parts_n.length == 2) {
                    string = parts_n[0].trim();
                }
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    private void setProperties() {
        this.updateSQL();
        this.tableView.setSyntaxProvider((String)this.cbSyntaxProviders.getSelectedItem());
        if (this.tableView instanceof AbstractView) {
            AbstractView view = (AbstractView)this.tableView;
            if (!QBUtils.isIncorrectSQL) {
                if (!this.tableView.isBST()) {
                    QBUtils.updateColumns(view, this.queryBuilder);
                }
                QBUtils.setViewSQL(view, this.queryBuilder, this.plainTextSQLBuilder, true);
                this.tableView.setValidSQL(true);
                this.tableView.setParsed(true);
            } else {
                QBUtils.incorrectSQL = this.jTextPane.getText();
                QBUtils.setViewSQL(view, this.queryBuilder, this.plainTextSQLBuilder, false);
                this.tableView.setParsed(false);
            }
        } else if (this.tableView instanceof Table) {
            Table table = (Table)this.tableView;
            if (!QBUtils.isIncorrectSQL) {
                boolean columnCountMismatch = false;
                if (!table.isBST()) {
                    QBUtils.createTableColumns(table, this.queryBuilder);
                    if (this.queryBuilder.getQueryStatistics().getOutputColumns().getCount() != table.getElementsCollection().size()) {
                        columnCountMismatch = true;
                        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("QueryBuilderPanel.ColumnCountNotCompatibleWithQuery"), Messages.getString("QueryBuilderPanel.IncompatibleDefinitions"), 2);
                    }
                }
                QBUtils.setTableSQL(table, this.queryBuilder, this.plainTextSQLBuilder, true);
                if (columnCountMismatch) {
                    table.setIncorrectSQL(true);
                }
                table.setValidSQL(true);
                table.setParsed(true);
            } else {
                QBUtils.incorrectSQL = this.jTextPane.getText();
                QBUtils.setTableSQL(table, this.queryBuilder, this.plainTextSQLBuilder, false);
                table.setParsed(false);
            }
        }
    }

    protected int getMinimumWidth() {
        return 920;
    }

    protected int getMinimumHeight() {
        return 600;
    }

    private void close() {
        Rectangle rectangle = new Rectangle(this.dialog.getLocation(), this.dialog.getSize());
        this.applView.getSettings().setDialogSettings(this.getClass().getName(), rectangle);
        this.dialog.dispose();
    }

    public JDialog getDialog(ApplicationView applView, boolean includeSchema, DesignPartView usedDPV, boolean autoJoin) {
        this.includeSchema = includeSchema;
        this.usedDPV = usedDPV;
        this.autoJoin = autoJoin;
        return this.getDialog(applView);
    }

    public JDialog getDialog(ApplicationView applView) {
        JSplitPane splitPane = null;
        this.loaded = false;
        if (this.dialog == null) {
            this.isOpened = false;
            this.applView = applView;
            this.dialog = new JDialog((Frame)applView.getFrame(), Messages.getString("QueryBuilder.QueryBuilder"));
            this.general = new JPanel(new BorderLayout());
            this.dialog.getContentPane().add((Component)this.general, "Center");
            this.dialog.getContentPane().add((Component)this.getButtonPanel(), "South");
            this.dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent e) {
                    if (QBUtils.isIncorrectSQL) {
                        QBUtils.setSQL(QueryBuilderPanel.this.queryBuilder, QBUtils.incorrectSQL);
                    }
                    QueryBuilderPanel.this.isOpened = true;
                    QueryBuilderPanel.this.queryBuilder.getMetadataTree().updateUI();
                }
            });
            JPanel pnToolbar = new JPanel(new BorderLayout());
            this.dialog.getContentPane().add((Component)pnToolbar, "North");
            JPanel pnOptions = new JPanel();
            final JCheckBox cbShowStructureTree = new JCheckBox(Messages.getString("QueryBuilderPanel.ShowStructureTree"));
            cbShowStructureTree.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    QueryBuilderPanel.this.queryBuilder.getQueryStructureTreeOptions().setTreeVisible(cbShowStructureTree.isSelected());
                }
            });
            pnOptions.add(cbShowStructureTree);
            pnToolbar.add((Component)pnOptions, "West");
            pnOptions.add(new JPanel());
            final JCheckBox cbShowCriteriaList = new JCheckBox(Messages.getString("QueryBuilderPanel.ShowCriteriaList"));
            cbShowCriteriaList.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    QueryBuilderPanel.this.queryBuilder.getCriteriaListOptions().setCriteriaListVisible(cbShowCriteriaList.isSelected());
                    if (cbShowCriteriaList.isSelected()) {
                        QueryBuilderPanel.this.addCriteriaListToolbar();
                    }
                }
            });
            pnOptions.add(cbShowCriteriaList);
            cbShowCriteriaList.setSelected(true);
            JPanel spPanel = new JPanel();
            JLabel lbProvider = new JLabel(Messages.getString("QueryBuilderPanel.SyntaxProvider"));
            spPanel.add(lbProvider);
            this.cbSyntaxProviders = new JComboBox<Object>(QBUtils.SYNTAX_PROVIDERS.keySet().toArray());
            this.cbSyntaxProviders.setPreferredSize(new Dimension(150, 20));
            this.cbSyntaxProviders.setMaximumRowCount(QBUtils.SYNTAX_PROVIDERS.size());
            this.cbSyntaxProviders.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String sql = QueryBuilderPanel.this.jTextPane.getText();
                    QueryBuilderPanel.this.queryBuilder.setSyntaxProvider(QBUtils.SYNTAX_PROVIDERS.get(QueryBuilderPanel.this.cbSyntaxProviders.getSelectedItem()));
                    QueryBuilderPanel.this.jTextPane.setText(sql);
                    QueryBuilderPanel.this.jTextPane.setCaretPosition(0);
                    QueryBuilderPanel.this.updateSQL();
                }
            });
            spPanel.add(this.cbSyntaxProviders);
            pnOptions.add((Component)spPanel, "East");
            this.chbJoins = new JCheckBox(Messages.getString("QueryBuilderPanel.CreateOracleJoins"));
            this.chbJoins.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    QueryBuilderPanel.this.setCreateOracleJoins(QueryBuilderPanel.this.chbJoins.isSelected());
                }
            });
            pnOptions.add(this.chbJoins);
            JPanel pnFilter = new JPanel(new BorderLayout());
            JLabel lbFilter = new JLabel(Messages.getString("QueryBuilderPanel.FilterMetadataObjectsByDiagram"));
            this.cbFilter = new JComboBox();
            this.cbFilter.setPreferredSize(new Dimension(200, 20));
            JPanel jpanel = new JPanel(new BorderLayout(0, 3));
            jpanel.add((Component)lbFilter, "West");
            jpanel.add((Component)this.cbFilter, "South");
            JPanel jpanel2 = new JPanel();
            jpanel2.add(jpanel);
            pnFilter.add((Component)jpanel2, "North");
            this.cbFilter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (QueryBuilderPanel.this.loaded) {
                        int idx = QueryBuilderPanel.this.cbFilter.getSelectedIndex();
                        DesignPartView dpv = (DesignPartView)QueryBuilderPanel.this.cbFilter.getSelectedItem();
                        for (int i = QueryBuilderPanel.this.queryBuilder.getMetadataContainer().getCount() - 1; i >= 0; --i) {
                            MetadataObject mo = QueryBuilderPanel.this.queryBuilder.getMetadataContainer().get(i);
                            if (idx == 0) {
                                mo.setVisible(true);
                                continue;
                            }
                            DesignObject desObj = QueryBuilderPanel.this.tableView.getDesign().getDesignObject(mo.getShortDescription());
                            if (desObj == null) continue;
                            TopView tv = desObj.getTopViewByID(dpv, desObj.getObjectID());
                            if (tv != null) {
                                mo.setVisible(true);
                                continue;
                            }
                            mo.setVisible(false);
                        }
                        QueryBuilderPanel.this.queryBuilder.getMetadataTree().reloadNodes(true);
                    }
                }
            });
            pnToolbar.add((Component)pnFilter, "East");
            this.queryBuilder = new QueryBuilder();
            this.queryBuilder.getQueryStructureTreeOptions().beginUpdate();
            this.queryBuilder.getQueryStructureTreeOptions().setTreeVisible(false);
            this.queryBuilder.getQueryStructureTreeOptions().endUpdate();
            this.queryBuilder.getMetadataTreeOptions().beginUpdate();
            this.queryBuilder.getMetadataTreeOptions().setGroupingType(ObjectsGroupingType.DatabaseSchemaType);
            this.queryBuilder.getMetadataTreeOptions().setSchemaIcon(conf.getIcon("SCHEMA_ICON", 16));
            this.queryBuilder.getMetadataTreeOptions().setTablesNodeIcon(conf.getIcon("TABLE_FOLDER_ICON", 16));
            this.queryBuilder.getMetadataTreeOptions().setUserTablesIcon(conf.getIcon("TABLE_ICON", 16));
            this.queryBuilder.getMetadataTreeOptions().setViewsNodeIcon(conf.getIcon("VIEW_FOLDER_ICON", 16));
            this.queryBuilder.getMetadataTreeOptions().setUserViewsIcon(conf.getIcon("VIEW_ICON", 16));
            if (this.contObject instanceof EntityView) {
                this.queryBuilder.getMetadataTreeOptions().setTablesNodeText("Entities");
                this.queryBuilder.getMetadataTreeOptions().setViewsNodeText("Entity Views");
            }
            this.queryBuilder.getMetadataTreeOptions().endUpdate();
            CriteriaListOptions clo = this.queryBuilder.getCriteriaListOptions();
            clo.beginUpdate();
            clo.setExpressionColumnWidth(200);
            clo.setAggregateColumnWidth(100);
            clo.setAliasColumnWidth(100);
            clo.setConditionColumnWidth(100);
            clo.setRowControllerVisible(false);
            clo.setUseCustomExpressionBuilderFor(EnumSet.of(CustomExpressionBuilderColumns.Expression, CustomExpressionBuilderColumns.Conditions));
            clo.endUpdate();
            this.queryBuilder.addCustomExpressionBuilderEventListener(new CustomExpressionBuilderEventListener(){

                public void customExpressionBuilderEventOccurred(CustomExpressionBuilderEvent event) {
                    QueryBuilderPanel.this.showConditionEditor(event);
                }
            });
            this.jTextPane = new SQLSyntaxTextArea(false);
            this.jTextPane.setSyntaxEditingStyle("text/sql");
            this.jTextPane.setAntiAliasingEnabled(true);
            this.jTextPane.setCurrentLineHighlightColor(new Color(225, 236, 255));
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            JButton bnCut = new JButton(conf.getIcon("CUT_ICON", 16));
            bnCut.setToolTipText(Messages.getString("QueryBuilderPanel.Cut"));
            bnCut.addActionListener(new CutAction());
            toolBar.add(bnCut);
            JButton bnCopy = new JButton(conf.getIcon("COPY_ICON", 16));
            bnCopy.setToolTipText(Messages.getString("QueryBuilderPanel.Copy"));
            bnCopy.addActionListener(new CopyAction());
            toolBar.add(bnCopy);
            JButton bnPaste = new JButton(conf.getIcon("PASTE_ICON", 16));
            bnPaste.setToolTipText(Messages.getString("QueryBuilderPanel.Paste"));
            bnPaste.addActionListener(new PasteAction());
            toolBar.add(bnPaste);
            toolBar.addSeparator();
            JButton bnUpdate = new JButton(conf.getIcon("REFRESH_ICON", 16));
            bnUpdate.setToolTipText(Messages.getString("QueryBuilderPanel.UpdateDiagram"));
            bnUpdate.addActionListener(new UpdateAction());
            toolBar.add(bnUpdate);
            toolBar.addSeparator();
            this.chbShowCurrentQuerySQLOnly = new JCheckBox(Messages.getString("QueryBuilderPanel.ShowCurrentQuerySQLOnly"));
            this.chbShowCurrentQuerySQLOnly.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (QueryBuilderPanel.this.chbShowCurrentQuerySQLOnly.isSelected()) {
                        QueryBuilderPanel.this.queryChangedEventOccurred();
                    } else {
                        QueryBuilderPanel.this.queryBuilder.setFilterTabsByActiveQueryPart(QueryPart.Query);
                        QueryBuilderPanel.this.plainTextSQLBuilder.setTargetQueryPart(QueryPart.Query);
                        QueryBuilderPanel.this.updatedSQLEventOccurred();
                    }
                }
            });
            toolBar.add(this.chbShowCurrentQuerySQLOnly);
            if (this.contObject instanceof TableView || this.contObject instanceof Table) {
                toolBar.addSeparator();
                JButton bnTestQuery = new JButton(conf.getIcon("CHECKOUT_ICON", 16));
                bnTestQuery.setToolTipText(Messages.getString("QueryBuilderPanel.TestQuery"));
                bnTestQuery.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String query = QueryBuilderPanel.this.jTextPane.getSelectedText();
                        if (query == null) {
                            query = QueryBuilderPanel.this.jTextPane.getText();
                        }
                        DMSQLQueryTester.registerComponent(ResultTesterComponent.class);
                        DMSQLQueryTester qt = new DMSQLQueryTester(QueryBuilderPanel.this.getDatabase());
                        qt.showDialog(QueryBuilderPanel.this, query);
                    }
                });
                toolBar.add(bnTestQuery);
            }
            this.bnANSIJoins = new JButton(Messages.getString("QueryBuilderPanel.ConvertToANSIJoins"));
            this.bnANSIJoins.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    QueryBuilderPanel.this.convertJoins(false);
                }
            });
            toolBar.addSeparator();
            toolBar.add(this.bnANSIJoins);
            this.bnOracleJoins = new JButton(Messages.getString("QueryBuilderPanel.ConvertToOracleJoins"));
            this.bnOracleJoins.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    QueryBuilderPanel.this.convertJoins(true);
                }
            });
            toolBar.addSeparator();
            toolBar.add(this.bnOracleJoins);
            JPanel sqlPanel = new JPanel(new BorderLayout());
            sqlPanel.add((Component)toolBar, "North");
            sqlPanel.add((Component)new RTextScrollPane((RTextArea)this.jTextPane), "Center");
            splitPane = new JSplitPane(0, (Component)this.queryBuilder, sqlPanel);
            splitPane.setDividerLocation(400);
            this.general.add((Component)splitPane, "Center");
            this.plainTextSQLBuilder = new PlainTextSQLBuilder();
            this.plainTextSQLBuilder.setKeywordFormat(KeywordFormat.UpperCase);
            this.plainTextSQLBuilder.setQueryBuilder(this.queryBuilder);
            this.plainTextSQLBuilder.addSQLUpdatedEventListener(new SQLUpdatedEventListener(){

                public void sqlUpdatedEventOccurred(SQLUpdatedEvent arg0) {
                    if (QueryBuilderPanel.this.chbShowCurrentQuerySQLOnly.isSelected()) {
                        QueryBuilderPanel.this.queryChangedEventOccurred();
                    } else {
                        QueryBuilderPanel.this.updatedSQLEventOccurred();
                    }
                    QueryBuilderPanel.this.updateJoinsControls();
                }
            });
            this.queryBuilder.addActiveSubQueryChangedEventListener(new ActiveSubQueryChangedEventListener(){

                public void activeSubQueryChangedEventOccurred(ActiveSubQueryChangedEvent event) {
                    QueryBuilderPanel.this.queryChangedEventOccurred();
                }
            });
            this.queryBuilder.addActiveUnionSubQueryChangedEventListener(new ActiveUnionSubQueryChangedEventListener(){

                public void activeUnionSubQueryChangedEventOccurred(ActiveUnionSubQueryChangedEvent arg0) {
                    QueryBuilderPanel.this.queryChangedEventOccurred();
                }
            });
            this.dialog.setModal(true);
            int condition = 1;
            JComponent c = (JComponent)this.dialog.getContentPane();
            c.getInputMap(condition).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
            c.getActionMap().put("ESCAPE", this.escapeAction);
            this.dialog.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    int w = QueryBuilderPanel.this.dialog.getWidth();
                    int h = QueryBuilderPanel.this.dialog.getHeight();
                    w = Math.max(QueryBuilderPanel.this.getMinimumWidth(), w);
                    h = Math.max(QueryBuilderPanel.this.getMinimumHeight(), h);
                    QueryBuilderPanel.this.dialog.setSize(w, h);
                }
            });
        }
        int mb = 0x100000;
        Runtime runtime = Runtime.getRuntime();
        System.out.println("memory  total  " + runtime.totalMemory() / (long)mb + "  /memory  fre  " + runtime.freeMemory() / (long)mb + "  /used memory  " + (runtime.totalMemory() - runtime.freeMemory()) / (long)mb);
        System.out.println("init  start  " + System.currentTimeMillis());
        this.initProperties(this.contObject);
        if (!this.tableView.isValidSQL()) {
            System.out.println("update start  " + System.currentTimeMillis());
            QBUtils.updateMetadata(this.tableView, this.queryBuilder, this.plainTextSQLBuilder, this.includeSchema);
            System.out.println("update end  " + System.currentTimeMillis());
        } else {
            long l = System.currentTimeMillis();
            QBUtils.setIncludeSchema(this.tableView, this.queryBuilder, this.plainTextSQLBuilder, this.includeSchema);
            System.out.println("setIncludeSchema  " + (System.currentTimeMillis() - l));
            QBUtils.updateDSPositions(this.queryBuilder);
        }
        System.out.println("END memory  total  " + runtime.totalMemory() / (long)mb + "  /memory  fre  " + runtime.freeMemory() / (long)mb + "  /used memory  " + (runtime.totalMemory() - runtime.freeMemory()) / (long)mb);
        this.dialog.pack();
        Settings.DialogSettings ds = applView.getSettings().getDialogSettings(this.getClass().getName());
        if (ds == null) {
            this.dialog.setSize(this.getMinimumWidth(), this.getMinimumHeight());
            CommonUtil.centerOnScreen(this.dialog);
        } else {
            this.dialog.setSize(ds.rec.getSize());
            this.dialog.setLocation(ds.rec.getLocation());
            splitPane.setDividerLocation((int)(ds.rec.getHeight() - 250.0));
        }
        this.loaded = true;
        return this.dialog;
    }

    private Database getDatabase() {
        Object[] sourceStamps = this.tableView.getRelationalModel().getImportConnectionStamps().toArray();
        for (int i = 0; i < sourceStamps.length; ++i) {
            DBConnectionStamp dbStamp = (DBConnectionStamp)sourceStamps[i];
            try {
                Database db = DatabaseConnections.getInstance().getDatabase(dbStamp.getConnName());
                if (db == null) continue;
                return db;
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return null;
    }

    private void queryChangedEventOccurred() {
        if (this.isOpened && this.chbShowCurrentQuerySQLOnly.isSelected() && this.jTextPane != null && this.queryBuilder.getActiveSubquery() != null && this.queryBuilder.getActiveSubquery().getActiveUnionSubquery() != null) {
            this.queryBuilder.setFilterTabsByActiveQueryPart(QueryPart.UnionSubQuery);
            this.plainTextSQLBuilder.setTargetQueryPart(QueryPart.UnionSubQuery);
            this.jTextPane.setText(QBUtils.formatSQL(this.queryBuilder.getActiveSubquery().getResultSQL(), this.queryBuilder.getSyntaxProvider()));
            this.jTextPane.setCaretPosition(0);
        }
        this.addCriteriaListToolbar();
    }

    private void updatedSQLEventOccurred() {
        if (!QBUtils.isIncorrectSQL) {
            try {
                this.jTextPane.setText(QBUtils.formatSQL(this.plainTextSQLBuilder.getSQL(), this.queryBuilder.getSyntaxProvider()));
                this.jTextPane.setCaretPosition(0);
            }
            catch (QueryBuilderException queryBuilderException) {
                // empty catch block
            }
        }
        this.addCriteriaListToolbar();
    }

    private void showConditionEditor(CustomExpressionBuilderEvent evt) {
        StringEditor editor = new StringEditor(ApplicationView.getInstance(), QBUtils.formatSQL(evt.value, this.queryBuilder.getSyntaxProvider()), "Condition Editor", 600, 400, true);
        editor.show();
        if (!editor.cancel) {
            evt.value = editor.getText();
        }
    }

    private void updateSQL() {
        block12: {
            String sql = this.jTextPane.getText();
            QBUtils.isIncorrectSQL = false;
            try {
                if (this.chbShowCurrentQuerySQLOnly.isSelected()) {
                    this.queryBuilder.getActiveSubquery().getActiveUnionSubquery().setSQL(sql);
                } else {
                    this.plainTextSQLBuilder.setSQL(sql);
                }
            }
            catch (Exception e) {
                QBUtils.isIncorrectSQL = true;
                QBUtils.incorrectSQL = sql;
                this.queryBuilder.setSQL("");
                if (this.jTextPane == null) break block12;
                boolean parseError = false;
                int pos = -1;
                for (Throwable cause = e; cause != null; cause = cause.getCause()) {
                    if (cause instanceof ParsingException) {
                        pos = ((ParsingException)cause).errorPos.pos;
                        parseError = true;
                        break;
                    }
                    if (cause.getCause() == cause) break;
                }
                if (parseError) {
                    MessageDialogs.showWarningMessage(e.getMessage());
                } else {
                    MessageDialogs.showErrorMessage(e.getMessage());
                }
                if (pos > -1) {
                    try {
                        this.jTextPane.requestFocus();
                        this.jTextPane.setCaretPosition(pos);
                        this.jTextPane.setSelectionStart(pos);
                        int end = sql.indexOf(" ", pos);
                        if (end == -1) {
                            end = sql.length();
                        }
                        this.jTextPane.setSelectionEnd(end);
                    }
                    catch (Exception exception) {}
                }
                this.jTextPane.setCaretPosition(0);
            }
        }
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel(new FlowLayout(2));
            JButton ok = new JButton(Messages.getString("ViewBuilder.OK"));
            ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (QueryBuilderPanel.this.canExit()) {
                        QueryBuilderPanel.this.setProperties();
                        QueryBuilderPanel.this.close();
                    }
                }
            });
            ok.setCursor(Cursor.getPredefinedCursor(12));
            ok.setMnemonic(79);
            JButton apply = new JButton(Messages.getString("ViewBuilder.Apply"));
            apply.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (QueryBuilderPanel.this.canExit()) {
                        QueryBuilderPanel.this.setProperties();
                    }
                }
            });
            apply.setCursor(Cursor.getPredefinedCursor(12));
            apply.setMnemonic(65);
            JButton cancel = new JButton(Messages.getString("ViewBuilder.Cancel"));
            cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    QueryBuilderPanel.this.close();
                }
            });
            cancel.setMnemonic(67);
            cancel.setCursor(Cursor.getPredefinedCursor(12));
            ok.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            apply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            cancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.buttonPanel.add(ok);
            this.buttonPanel.add(apply);
            this.buttonPanel.add(cancel);
        }
        return this.buttonPanel;
    }

    protected boolean canExit() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertJoins(boolean oracleJoins) {
        this.queryBuilder.beginUpdate();
        try {
            this.setCreateOracleJoins(oracleJoins);
            for (UnionSubQuery usq : this.queryBuilder.getUnionSubQueryList()) {
                ArrayList links = new ArrayList();
                ArrayList<Object[]> storedLinks = new ArrayList<Object[]>();
                usq.getFromClause().getLinksRecursive(links);
                for (int i = links.size() - 1; i >= 0; --i) {
                    Link link = (Link)links.get(i);
                    LinkPlace place = oracleJoins ? LinkPlace.From : LinkPlace.Where;
                    if (link.getPlace() != place) continue;
                    storedLinks.add(new Object[]{link.getLeftDatasource(), link.getRightDatasource(), link.getLinkExpressionString(), link.getLeftType(), link.getRightType()});
                    link.dispose();
                }
                LinkPlace place = oracleJoins ? LinkPlace.Where : LinkPlace.From;
                for (int i = storedLinks.size() - 1; i >= 0; --i) {
                    Object[] sl = (Object[])storedLinks.get(i);
                    String expr = (String)sl[2];
                    Link link = usq.addLink((DataSource)sl[0], (DataSource)sl[1], expr, place);
                    link.beginUpdate();
                    link.setLeftType((LinkSideType)sl[3]);
                    link.setRightType((LinkSideType)sl[4]);
                    link.endUpdate();
                }
            }
        }
        finally {
            this.queryBuilder.endUpdate();
        }
    }

    private JScrollPane getCriteriaListControlScrollPane(CriteriaList criteriaList) {
        if (criteriaList.getControlsCount() >= 1) {
            Container parent;
            for (parent = criteriaList.getControl(0).getParent(); parent != null && !(parent instanceof JScrollPane); parent = parent.getParent()) {
            }
            return (JScrollPane)parent;
        }
        return null;
    }

    private void addCriteriaListToolbar() {
        try {
            UnionSubQueryPanel panel;
            if (this.queryBuilder.getActiveSubquery() != null && this.queryBuilder.getActiveSubquery().getActiveUnionSubquery() != null && this.queryBuilder.getActiveSubquery().getActiveUnionSubquery().getControlsCount() > 0 && (panel = (UnionSubQueryPanel)this.queryBuilder.getActiveSubquery().getActiveUnionSubquery().getControl(0)) != null && panel.getBottomComponent() instanceof JScrollPane) {
                final CriteriaList criteriaList = this.queryBuilder.getActiveSubquery().getActiveUnionSubquery().getCriteriaList();
                JScrollPane sp = this.getCriteriaListControlScrollPane(criteriaList);
                JPanel jpanel = new JPanel(new BorderLayout());
                JToolBar toolbar = new JToolBar();
                jpanel.add((Component)toolbar, "North");
                jpanel.add((Component)sp, "Center");
                final JButton bnAdd = new JButton(configuration.getIcon("ADD_ICON", 16));
                final JButton bnRemove = new JButton(configuration.getIcon("REMOVE_ICON", 16));
                final JButton bnUp = new JButton(configuration.getIcon("MOVE_UP_ICON", 16));
                final JButton bnDown = new JButton(configuration.getIcon("MOVE_DOWN_ICON", 16));
                toolbar.add(bnAdd);
                toolbar.add(bnRemove);
                toolbar.add(bnUp);
                toolbar.add(bnDown);
                final CriteriaListControl table = criteriaList.getCriteriaListControl();
                table.setRowSelectionAllowed(true);
                table.setSelectionMode(2);
                int[] rows = table.getSelectedRows();
                if (rows.length > 0) {
                    bnAdd.setEnabled(true);
                    bnRemove.setEnabled(true);
                    bnUp.setEnabled(rows[0] > 0);
                    bnDown.setEnabled(rows[rows.length - 1] < criteriaList.getCount() - 2);
                } else {
                    bnAdd.setEnabled(false);
                    bnRemove.setEnabled(false);
                    bnUp.setEnabled(false);
                    bnDown.setEnabled(false);
                }
                table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e) {
                        int[] rows = table.getSelectedRows();
                        if (rows.length > 0) {
                            bnAdd.setEnabled(true);
                            bnRemove.setEnabled(true);
                            bnUp.setEnabled(rows[0] > 0);
                            bnDown.setEnabled(rows[rows.length - 1] < criteriaList.getCount() - 2);
                        } else {
                            bnAdd.setEnabled(false);
                            bnRemove.setEnabled(false);
                            bnUp.setEnabled(false);
                            bnDown.setEnabled(false);
                        }
                    }
                });
                bnAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int row = table.getSelectedRow();
                        if (row >= 0 && row < criteriaList.getCount() - 1) {
                            criteriaList.get(row).actionPerformed(new ActionEvent(table, 0, "insert"));
                        }
                    }
                });
                bnRemove.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int[] rows = table.getSelectedRows();
                        for (int i = rows.length - 1; i >= 0; --i) {
                            int row = rows[i];
                            if (row < 0 || row >= criteriaList.getCount() - 1) continue;
                            criteriaList.get(row).dispose();
                        }
                    }
                });
                bnUp.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int[] rows;
                        for (int row : rows = table.getSelectedRows()) {
                            if (row <= 0 || row >= criteriaList.getCount() - 1) continue;
                            criteriaList.moveRow(row, row - 1);
                        }
                        for (int row : rows) {
                            table.getSelectionModel().addSelectionInterval(row - 1, row - 1);
                        }
                    }
                });
                bnDown.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int[] rows = table.getSelectedRows();
                        for (int i = rows.length - 1; i >= 0; --i) {
                            int row = rows[i];
                            if (row < 0 || row >= criteriaList.getCount() - 2) continue;
                            criteriaList.moveRow(row, row + 1);
                        }
                        for (int row : rows) {
                            table.getSelectionModel().addSelectionInterval(row + 1, row + 1);
                        }
                    }
                });
                panel.setBottomComponent((JComponent)jpanel);
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    private class UpdateAction
    extends AbstractAction {
        private UpdateAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            QueryBuilderPanel.this.updateSQL();
        }
    }

    private class PasteAction
    extends AbstractAction {
        private PasteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            QueryBuilderPanel.this.jTextPane.paste();
        }
    }

    private class CopyAction
    extends AbstractAction {
        private CopyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            QueryBuilderPanel.this.jTextPane.copy();
        }
    }

    private class CutAction
    extends AbstractAction {
        private CutAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            QueryBuilderPanel.this.jTextPane.cut();
            QBUtils.setSQL(QueryBuilderPanel.this.queryBuilder, QueryBuilderPanel.this.jTextPane.getText());
        }
    }
}

