/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb.v81;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.Trigger;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.TriggerUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.SchemaUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TriggerUDBv81;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.udb.AbstractUDBPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class TriggerPropertyDialogUDBv81
extends AbstractUDBPropertyDialog {
    private TriggerUDBv81 trigger;
    private JComboBox cbScheme;
    private JComboBox cbAction;
    private JComboBox cbTriggeringTime;
    private JComboBox cbScope;
    private JTextField tfOwner;
    private JTextField tfCondition;
    private JTextField tfRef_OLD_AS;
    private JTextField tfRef_NEW_AS;
    private JTextField tfOLD_TABLE_AS;
    private JTextField tfNEW_TABLE_AS;
    private JIntegerField ifOrder;
    private JPanel panelColumns;
    private JPanel panelBody = new JPanel(new SpringLayout());
    private JList allColumnsList;
    private JList selectedColumnsList;
    private DefaultListModel allColumnsModel;
    private DefaultListModel selectedColumnsModel;
    private JButton bnAddColumns;
    private JButton bnRemoveColumns;
    private JTextArea bodyArea;

    public TriggerPropertyDialogUDBv81(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.trigger = (TriggerUDBv81)object;
        this.setHeight(420);
        this.initCommentsView(155);
        this.initCommentsInRDBMS(155);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("TriggerPropertyDialogUDBv81.TriggerProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initOwner();
        this.initScheme();
        this.initAction();
        this.initTriggeringTime();
        this.initScope();
        this.initRef_OLD_AS();
        this.initRef_NEW_AS();
        this.initOLD_TABLE_AS();
        this.initNEW_TABLE_AS();
        this.initCondition();
        this.initOrder();
    }

    @Override
    protected void addTabs() {
        this.initColumnsView();
        this.initBodyView();
    }

    private void initColumnsView() {
        this.panelColumns = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TriggerPropertyDialogUDBv81.UpdateColumns"), this.panelColumns);
        this.initColumns();
    }

    private void initColumns() {
        this.initAllColumnsList();
        this.initSelectedColumnsList();
        this.initColumnsButtons();
    }

    private void initAllColumnsList() {
        JLabel label = new JLabel(Messages.getString("TriggerPropertyDialogUDBv81.AllColumns"));
        this.panelColumns.add(label);
        this.allColumnsModel = new DefaultListModel();
        this.allColumnsList = new JList(this.allColumnsModel);
        ListSelectionModel listSelectionModel = this.allColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllColumnsListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allColumnsList);
        sp.setPreferredSize(new Dimension(144, 300));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.panelColumns.add(sp);
        this.setLabelConstraints(this.getColumnsLayout(), label, 12, 20);
        this.setObjectConstraints(this.getColumnsLayout(), sp, 10, 38);
    }

    private void initSelectedColumnsList() {
        JLabel label = new JLabel(Messages.getString("TriggerPropertyDialogUDBv81.SelectedColumns"));
        this.panelColumns.add(label);
        this.selectedColumnsModel = new DefaultListModel();
        this.selectedColumnsList = new JList(this.selectedColumnsModel);
        ListSelectionModel listSelectionModel = this.selectedColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedColumnsListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedColumnsList);
        sp.setPreferredSize(new Dimension(145, 300));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.panelColumns.add(sp);
        this.setLabelConstraints(this.getColumnsLayout(), label, 292, 20);
        this.setObjectConstraints(this.getColumnsLayout(), sp, 290, 38);
    }

    private void initColumnsButtons() {
        this.bnAddColumns = new JButton(Messages.getString("TriggerPropertyDialogUDBv81.Add"));
        this.bnAddColumns.addActionListener(new AddColumnsActionListener());
        this.bnAddColumns.setEnabled(false);
        this.panelColumns.add(this.bnAddColumns);
        this.setObjectConstraints(this.getColumnsLayout(), this.bnAddColumns, 175, 155);
        this.bnRemoveColumns = new JButton(Messages.getString("TriggerPropertyDialogUDBv81.Remove"));
        this.bnRemoveColumns.setEnabled(false);
        this.bnRemoveColumns.addActionListener(new RemoveColumnsActionListener());
        this.panelColumns.add(this.bnRemoveColumns);
        this.setObjectConstraints(this.getColumnsLayout(), this.bnRemoveColumns, 175, 185);
        TriggerPropertyDialogUDBv81.equalizeButtonSizes(this.bnAddColumns, this.bnRemoveColumns);
    }

    protected SpringLayout getColumnsLayout() {
        return (SpringLayout)this.panelColumns.getLayout();
    }

    protected SpringLayout getBodyLayout() {
        return (SpringLayout)this.panelBody.getLayout();
    }

    private void initBodyView() {
        this.panelBody = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TriggerPropertyDialogUDBv81.TriggerBody"), this.panelBody);
        this.initBody();
    }

    private void initBody() {
        this.bodyArea = new JTextArea();
        JScrollPane sp = new JScrollPane(this.bodyArea);
        sp.setPreferredSize(new Dimension(395, 330));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.bodyArea.setLineWrap(true);
        this.panelBody.add(sp);
        this.setObjectConstraints(this.getBodyLayout(), sp, 10, 12);
    }

    private void initOwner() {
        JLabel label = new JLabel(Messages.getString("TriggerPropertyDialogUDBv81.Owner"));
        this.general.add(label);
        this.tfOwner = new JTextField("", 26);
        this.setBG(this.tfOwner);
        this.tfOwner.setEditable(false);
        this.tfOwner.setEnabled(false);
        this.tfOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.tfOwner);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.tfOwner, 80);
    }

    private void initScheme() {
        JLabel label = new JLabel(Messages.getString("TriggerPropertyDialogUDBv81.Scheme"));
        this.general.add(label);
        this.cbScheme = new JComboBox();
        this.setBG(this.cbScheme);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSchemaSet().toArray(), this.cbScheme);
        }
        this.cbScheme.addActionListener(new SchemeListener());
        this.cbScheme.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbScheme);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbScheme, 50);
    }

    private void initAction() {
        JLabel label = new JLabel(Messages.getString("TriggerPropertyDialogUDBv81.Action"));
        this.general.add(label);
        this.cbAction = new JComboBox<String>(Trigger.ACTION_TYPES);
        this.setBG(this.cbAction);
        this.cbAction.setPreferredSize(this.tfName.getPreferredSize());
        this.cbAction.addActionListener(new ActivationListener());
        this.cbAction.addActionListener(new TriggeringTimeListener());
        this.cbAction.addActionListener(new ScopeListener());
        this.general.add(this.cbAction);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.cbAction, 110);
    }

    private void initTriggeringTime() {
        JLabel label = new JLabel(Messages.getString("TriggerPropertyDialogUDBv81.TriggeringTime"));
        this.general.add(label);
        this.cbTriggeringTime = new JComboBox();
        this.setBG(this.cbTriggeringTime);
        this.cbTriggeringTime.setPreferredSize(this.tfName.getPreferredSize());
        this.cbTriggeringTime.addActionListener(new TriggeringTimeListener());
        this.cbTriggeringTime.addActionListener(new ScopeListener());
        this.cbTriggeringTime.addActionListener(new ActivationListener());
        this.general.add(this.cbTriggeringTime);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.cbTriggeringTime, 140);
    }

    private void initScope() {
        JLabel label = new JLabel(Messages.getString("TriggerPropertyDialogUDBv81.Scope"));
        this.general.add(label);
        this.cbScope = new JComboBox<String>(TriggerUDB.SCOPE_TYPES);
        this.setBG(this.cbScope);
        this.cbScope.setPreferredSize(this.tfName.getPreferredSize());
        this.cbScope.addActionListener(new ScopeListener());
        this.cbScope.addActionListener(new TriggeringTimeListener());
        this.cbScope.addActionListener(new ActivationListener());
        this.general.add(this.cbScope);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.cbScope, 170);
    }

    private void initRef_OLD_AS() {
        JLabel label = new JLabel(Messages.getString("TriggerPropertyDialogUDBv81.RefOLDAS"));
        this.general.add(label);
        this.tfRef_OLD_AS = new JTextField("", 26);
        this.general.add(this.tfRef_OLD_AS);
        this.setLabelConstraints(label, 200);
        this.setObjectConstraints(this.tfRef_OLD_AS, 200);
    }

    private void initRef_NEW_AS() {
        JLabel label = new JLabel(Messages.getString("TriggerPropertyDialogUDBv81.RefNEWAS"));
        this.general.add(label);
        this.tfRef_NEW_AS = new JTextField("", 26);
        this.general.add(this.tfRef_NEW_AS);
        this.setLabelConstraints(label, 230);
        this.setObjectConstraints(this.tfRef_NEW_AS, 230);
    }

    private void initOLD_TABLE_AS() {
        JLabel label = new JLabel("OLD TABLE AS:");
        this.general.add(label);
        this.tfOLD_TABLE_AS = new JTextField("", 26);
        this.general.add(this.tfOLD_TABLE_AS);
        this.setLabelConstraints(label, 260);
        this.setObjectConstraints(this.tfOLD_TABLE_AS, 260);
    }

    private void initNEW_TABLE_AS() {
        JLabel label = new JLabel("NEW TABLE AS:");
        this.general.add(label);
        this.tfNEW_TABLE_AS = new JTextField("", 26);
        this.general.add(this.tfNEW_TABLE_AS);
        this.setLabelConstraints(label, 290);
        this.setObjectConstraints(this.tfNEW_TABLE_AS, 290);
    }

    private void initCondition() {
        JLabel label = new JLabel(Messages.getString("TriggerPropertyDialogUDBv81.Condition"));
        this.general.add(label);
        this.tfCondition = new JTextField("", 26);
        this.general.add(this.tfCondition);
        this.setLabelConstraints(label, 320);
        this.setObjectConstraints(this.tfCondition, 320);
    }

    private void initOrder() {
        JLabel label = new JLabel(Messages.getString("TriggerPropertyDialogUDBv81.DefinitionOrder"));
        this.general.add(label);
        this.ifOrder = new JIntegerField(0, 26);
        this.general.add(this.ifOrder);
        this.setLabelConstraints(label, 350);
        this.setObjectConstraints(this.ifOrder, 350);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.trigger.getName());
        this.tfName.setText(this.trigger.getName());
        this.selectObject(this.cbScheme, this.trigger.getSchema());
        this.cbAction.setSelectedItem(this.trigger.getActions());
        this.fillComboItems(this.trigger.getTriggerTimes(), this.cbTriggeringTime);
        this.cbTriggeringTime.setSelectedItem(this.trigger.getTriggerTime());
        this.cbScope.setSelectedItem(this.trigger.getScope());
        if (this.trigger.getView() != null) {
            this.cbTriggeringTime.setEnabled(false);
        }
        this.tfRef_OLD_AS.setText(this.trigger.getRef_OLD_AS());
        this.tfRef_NEW_AS.setText(this.trigger.getRef_NEW_AS());
        this.tfOLD_TABLE_AS.setText(this.trigger.getOLD_TABLE_AS());
        this.tfNEW_TABLE_AS.setText(this.trigger.getNEW_TABLE_AS());
        this.tfCondition.setText(this.trigger.getCondition());
        this.ifOrder.setValue((long)this.trigger.getOrder());
        this.bodyArea.setText(this.trigger.getBody());
        if (this.trigger.getTable() != null) {
            ColumnProxy[] columnSet = this.trigger.getTable().getColumnProxies();
            for (int i = 0; i < columnSet.length; ++i) {
                ColumnProxy column = columnSet[i];
                if (this.trigger.getColumnSet().contains(column.getName())) {
                    this.selectedColumnsModel.addElement(column);
                    continue;
                }
                this.allColumnsModel.addElement(column);
            }
        } else if (this.trigger.getView() != null) {
            TableView tv = (TableView)this.trigger.getView().getObject();
            ContainedObject[] colSet = tv.getColumns();
            for (int i = 0; i < colSet.length; ++i) {
                ContainedObject column = colSet[i];
                if (this.trigger.getColumnSet().contains(column.getName())) {
                    this.selectedColumnsModel.addElement(column);
                    continue;
                }
                this.allColumnsModel.addElement(column);
            }
        }
        this.getCommentsList().insert(this.trigger.getComment(), 0);
        this.getCommentsInRDBMSList().insert(this.trigger.getCommentInRDBMS(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.trigger != null) {
            Object selected = this.cbScheme.getSelectedItem();
            if (selected instanceof SchemaUDBv81) {
                this.trigger.setSchema((SchemaUDBv81)selected);
                this.trigger.setOwner(((SchemaUDBv81)selected).getOwner());
            } else {
                this.trigger.setSchema(null);
                this.trigger.setOwner(null);
            }
            this.trigger.setName(this.tfName.getText());
            this.trigger.setActions((String)this.cbAction.getSelectedItem());
            this.trigger.setTriggerTime((String)this.cbTriggeringTime.getSelectedItem());
            this.trigger.setScope((String)this.cbScope.getSelectedItem());
            this.trigger.setRef_OLD_AS(this.tfRef_OLD_AS.getText());
            this.trigger.setRef_NEW_AS(this.tfRef_NEW_AS.getText());
            this.trigger.setOLD_TABLE_AS(this.tfOLD_TABLE_AS.getText());
            this.trigger.setNEW_TABLE_AS(this.tfNEW_TABLE_AS.getText());
            this.trigger.setCondition(this.tfCondition.getText());
            try {
                this.trigger.setOrder(this.ifOrder.getIntValue());
            }
            catch (NumberFormatException e) {
                this.trigger.setOrder(0);
            }
            this.trigger.setBody(this.bodyArea.getText());
            Object[] columnSet = this.selectedColumnsModel.toArray();
            this.trigger.clear();
            for (int i = 0; i < columnSet.length; ++i) {
                ModelIDObject ob = (ModelIDObject)columnSet[i];
                this.trigger.setColumns(ob.getName());
            }
            this.trigger.setComment(this.getCommentsList().getText());
            this.trigger.setCommentInRDBMS(this.getCommentsInRDBMSList().getText());
        }
    }

    @Override
    protected boolean allowName(String newName) {
        Object selectedSchema = this.cbScheme.getSelectedItem();
        if (selectedSchema instanceof SchemaUDB) {
            newName = ((SchemaUDB)selectedSchema).getName() + "." + (String)newName;
        }
        return this.getStorageObject().allowName((String)newName, true);
    }

    public class SchemeListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            SchemaUDBv81 schema = (SchemaUDBv81)TriggerPropertyDialogUDBv81.this.cbScheme.getSelectedItem();
            try {
                if (schema != null) {
                    TriggerPropertyDialogUDBv81.this.tfOwner.setText(schema.getOwner().toString());
                }
            }
            catch (NullPointerException e1) {
                TriggerPropertyDialogUDBv81.this.tfOwner.setText("");
            }
        }
    }

    public class TriggeringTimeListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            String trTime = (String)TriggerPropertyDialogUDBv81.this.cbTriggeringTime.getSelectedItem();
            if (trTime != null) {
                if (trTime.equalsIgnoreCase("AFTER")) {
                    TriggerPropertyDialogUDBv81.this.tfOLD_TABLE_AS.setEnabled(true);
                    TriggerPropertyDialogUDBv81.this.tfRef_OLD_AS.setEnabled(true);
                } else {
                    TriggerPropertyDialogUDBv81.this.tfOLD_TABLE_AS.setEnabled(false);
                    TriggerPropertyDialogUDBv81.this.tfRef_OLD_AS.setEnabled(false);
                }
            }
        }
    }

    public class ScopeListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            String scope = (String)TriggerPropertyDialogUDBv81.this.cbScope.getSelectedItem();
            if (scope.equalsIgnoreCase(TriggerUDB.SCOPE_TYPES[1])) {
                TriggerPropertyDialogUDBv81.this.tfRef_NEW_AS.setEnabled(false);
                TriggerPropertyDialogUDBv81.this.tfRef_OLD_AS.setEnabled(false);
            } else {
                TriggerPropertyDialogUDBv81.this.tfRef_NEW_AS.setEnabled(true);
                TriggerPropertyDialogUDBv81.this.tfRef_OLD_AS.setEnabled(true);
            }
        }
    }

    public class ActivationListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            String action = (String)TriggerPropertyDialogUDBv81.this.cbAction.getSelectedItem();
            boolean isUpdate = false;
            if (action.equalsIgnoreCase(Trigger.ACTION_TYPES[1])) {
                isUpdate = true;
            }
            TriggerPropertyDialogUDBv81.this.allColumnsList.setEnabled(isUpdate);
            TriggerPropertyDialogUDBv81.this.selectedColumnsList.setEnabled(isUpdate);
            if (!isUpdate) {
                TriggerPropertyDialogUDBv81.this.allColumnsList.setSelectedIndices(new int[0]);
                TriggerPropertyDialogUDBv81.this.selectedColumnsList.setSelectedIndices(new int[0]);
            }
            if (action.equalsIgnoreCase(Trigger.ACTION_TYPES[0])) {
                TriggerPropertyDialogUDBv81.this.tfOLD_TABLE_AS.setEnabled(false);
                TriggerPropertyDialogUDBv81.this.tfRef_OLD_AS.setEnabled(false);
                TriggerPropertyDialogUDBv81.this.tfNEW_TABLE_AS.setEnabled(true);
                TriggerPropertyDialogUDBv81.this.tfRef_NEW_AS.setEnabled(true);
            } else if (action.equalsIgnoreCase(Trigger.ACTION_TYPES[1])) {
                TriggerPropertyDialogUDBv81.this.tfOLD_TABLE_AS.setEnabled(true);
                TriggerPropertyDialogUDBv81.this.tfRef_OLD_AS.setEnabled(true);
                TriggerPropertyDialogUDBv81.this.tfNEW_TABLE_AS.setEnabled(true);
                TriggerPropertyDialogUDBv81.this.tfRef_NEW_AS.setEnabled(true);
            } else {
                TriggerPropertyDialogUDBv81.this.tfOLD_TABLE_AS.setEnabled(true);
                TriggerPropertyDialogUDBv81.this.tfRef_OLD_AS.setEnabled(true);
                TriggerPropertyDialogUDBv81.this.tfNEW_TABLE_AS.setEnabled(false);
                TriggerPropertyDialogUDBv81.this.tfRef_NEW_AS.setEnabled(false);
            }
        }
    }

    private class SelectedColumnsListSelectionHandler
    implements ListSelectionListener {
        private SelectedColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (TriggerPropertyDialogUDBv81.this.isEditable() && !e.getValueIsAdjusting()) {
                if (TriggerPropertyDialogUDBv81.this.selectedColumnsList.getSelectedIndex() == -1) {
                    TriggerPropertyDialogUDBv81.this.bnRemoveColumns.setEnabled(false);
                } else {
                    TriggerPropertyDialogUDBv81.this.bnRemoveColumns.setEnabled(true);
                }
            }
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TriggerPropertyDialogUDBv81.this.selectedColumnsModel.isEmpty()) {
                Object[] selectedObjects = TriggerPropertyDialogUDBv81.this.selectedColumnsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (TriggerPropertyDialogUDBv81.this.allColumnsModel.contains(ob)) continue;
                    TriggerPropertyDialogUDBv81.this.allColumnsModel.addElement(ob);
                    TriggerPropertyDialogUDBv81.this.selectedColumnsModel.removeElement(ob);
                }
            }
        }
    }

    private class AllColumnsListSelectionHandler
    implements ListSelectionListener {
        private AllColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (TriggerPropertyDialogUDBv81.this.isEditable() && !e.getValueIsAdjusting()) {
                if (TriggerPropertyDialogUDBv81.this.allColumnsList.getSelectedIndex() == -1) {
                    TriggerPropertyDialogUDBv81.this.bnAddColumns.setEnabled(false);
                } else {
                    TriggerPropertyDialogUDBv81.this.bnAddColumns.setEnabled(true);
                }
            }
        }
    }

    private class AddColumnsActionListener
    implements ActionListener {
        private AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TriggerPropertyDialogUDBv81.this.allColumnsModel.isEmpty()) {
                Object[] selectedObjects = TriggerPropertyDialogUDBv81.this.allColumnsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (TriggerPropertyDialogUDBv81.this.selectedColumnsModel.contains(ob)) continue;
                    TriggerPropertyDialogUDBv81.this.selectedColumnsModel.addElement(ob);
                    TriggerPropertyDialogUDBv81.this.allColumnsModel.removeElement(ob);
                }
            }
        }
    }
}

