/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb.v81;

import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.ContainerUDB;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.udb.AbstractUDBPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class ContainerPropertyDialogUDBv81
extends AbstractUDBPropertyDialog {
    private ContainerUDB container;
    private JTextField tfTableSpace;
    private JTextField tfOnDBPartitions;
    private JTextField tfContainers;

    public ContainerPropertyDialogUDBv81(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.container = (ContainerUDB)object;
        this.setHeight(200);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("ContainerPropertyDialogUDBv81.ContainerProperties");
    }

    @Override
    public void initProperties() {
        this.initCaption(this.container.getName());
        this.tfName.setText(this.container.getName());
        this.tfTableSpace.setText(this.container.getTableSpace().getName());
        this.tfContainers.setText(this.container.getContainers());
        this.tfOnDBPartitions.setText(this.container.getOnNodes());
        this.getCommentsList().insert(this.container.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.container != null) {
            this.container.setName(this.tfName.getText());
            this.container.setContainers(this.tfContainers.getText());
            this.container.setOnNodes(this.tfOnDBPartitions.getText());
            this.container.setComment(this.getCommentsList().getText());
        }
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initTableSpace();
        this.initContainers();
        this.initOnDBPartitions();
    }

    private void initTableSpace() {
        JLabel lbTableSpace = new JLabel(Messages.getString("ContainerPropertyDialogUDBv81.TableSpace"));
        this.general.add(lbTableSpace);
        this.tfTableSpace = new JTextField("", 26);
        this.tfTableSpace.setPreferredSize(this.tfName.getPreferredSize());
        this.tfTableSpace.setEnabled(false);
        this.general.add(this.tfTableSpace);
        this.setLabelConstraints(lbTableSpace, 50);
        this.setObjectConstraints(this.tfTableSpace, 50);
    }

    private void initContainers() {
        JLabel label = new JLabel(Messages.getString("ContainerPropertyDialogUDBv81.Containers"));
        this.general.add(label);
        this.tfContainers = new JTextField("", 26);
        this.general.add(this.tfContainers);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.tfContainers, 80);
    }

    private void initOnDBPartitions() {
        JLabel label = new JLabel(Messages.getString("ContainerPropertyDialogUDBv81.OnDBPartitions"));
        this.general.add(label);
        this.tfOnDBPartitions = new JTextField("", 26);
        this.general.add(this.tfOnDBPartitions);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.tfOnDBPartitions, 110);
    }
}

