/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver.v2k5;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.miginfocom.layout.CC;
import net.miginfocom.swing.MigLayout;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.SchemaSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StoredProcedureSqlServer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.AbstractSqlServerPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.options.Settings;

public class StoredProcedurePropertyDialogSqlServerv2k5
extends AbstractSqlServerPropertyDialog {
    private StoredProcedureSqlServer proc;
    private JComboBox cbOwner;
    private JTextField tfDatabase;
    private JTextArea bodyArea;
    private JPanel gPanel;
    private int mMinHeight = 400;
    private int minWidth = 500;

    public StoredProcedurePropertyDialogSqlServerv2k5(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.proc = (StoredProcedureSqlServer)object;
        super.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int w = StoredProcedurePropertyDialogSqlServerv2k5.this.getWidth();
                int h = StoredProcedurePropertyDialogSqlServerv2k5.this.getHeight();
                w = Math.max(StoredProcedurePropertyDialogSqlServerv2k5.this.getMinimumWidth(), w);
                h = Math.max(StoredProcedurePropertyDialogSqlServerv2k5.this.getMinimumHeight(), h);
                StoredProcedurePropertyDialogSqlServerv2k5.this.setSize(new Dimension(w, h));
            }
        });
        Settings.DialogSettings ds = view.getSettings().getDialogSettings(this.getClass().getName());
        if (ds == null) {
            int w = this.getMinimumWidth();
            int h = this.getMinimumHeight();
            this.setSize(w, h);
            CommonUtil.centerOnScreen(this);
        } else {
            int w = Math.max(this.getMinimumWidth(), (int)ds.rec.getSize().getWidth());
            int h = Math.max(this.getMinimumHeight(), (int)ds.rec.getSize().getHeight());
            this.setSize(w, h);
            this.setLocation(ds.rec.getLocation());
        }
        this.initComments();
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("StoredProcedurePropertyDialogSqlServerv2k5.StoredProcedureProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.general.removeAll();
        this.general.setLayout((LayoutManager)new MigLayout("fill", "grow"));
        this.gPanel = new JPanel((LayoutManager)new MigLayout("fill", "5[100!]0[]5", "5[30!]0[30!]0[30!]5[]5"));
        this.general.add((Component)this.gPanel, new CC().grow());
        this.gPanel.add(this.lbName);
        this.gPanel.add((Component)this.tfName, new CC().growX().wrap());
        this.initDatabase();
        this.initOwner();
        this.initBody();
    }

    private void initDatabase() {
        JLabel dbLabel = new JLabel(Messages.getString("StoredProcedurePropertyDialogSqlServerv2k5.Database"));
        this.tfDatabase = new JTextField("");
        this.tfDatabase.setEnabled(false);
        this.gPanel.add(dbLabel);
        this.gPanel.add((Component)this.tfDatabase, new CC().growX().wrap());
    }

    private void initOwner() {
        JLabel label = new JLabel(Messages.getString("StoredProcedurePropertyDialogSqlServerv2k5.Owner"));
        this.cbOwner = new JComboBox();
        this.setBG(this.cbOwner);
        this.cbOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.gPanel.add(label);
        this.gPanel.add((Component)this.cbOwner, new CC().growX().wrap());
    }

    private void initBody() {
        JLabel bodyLabel = new JLabel(Messages.getString("StoredProcedurePropertyDialogSqlServerv2k5.Body"));
        this.bodyArea = new JTextArea();
        JScrollPane sp = new JScrollPane(this.bodyArea);
        this.bodyArea.setLineWrap(true);
        this.gPanel.add((Component)bodyLabel, new CC().alignY("top"));
        this.gPanel.add((Component)sp, new CC().grow());
    }

    @Override
    public void initProperties() {
        this.initCaption(this.proc.getName());
        this.tfName.setText(this.proc.getName());
        for (SchemaSqlServer schema : this.proc.getDatabase().getSchemas()) {
            this.cbOwner.addItem(schema);
        }
        this.tfDatabase.setText(this.proc.getDatabase().getName());
        this.cbOwner.setSelectedItem(this.proc.getSchema());
        this.bodyArea.setText(this.proc.getBody());
        this.bodyArea.setCaretPosition(0);
        this.getCommentsList().insert(this.proc.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.proc != null) {
            this.proc.setName(this.tfName.getText());
            this.proc.setSchema((SchemaSqlServer)this.cbOwner.getSelectedItem());
            this.proc.setBody(this.bodyArea.getText());
            this.proc.setComment(this.getCommentsList().getText());
        }
    }

    private void initComments() {
        this.comments.removeAll();
        this.comments.setLayout((LayoutManager)new MigLayout("fill, flowy", "[grow]", "[grow]"));
        this.taComments = new JTextArea();
        this.spComments = new JScrollPane(this.taComments);
        this.taComments.setLineWrap(true);
        this.comments.add((Component)this.spComments, new CC().grow());
    }

    protected int getMinimumWidth() {
        return this.minWidth;
    }

    protected int getMinimumHeight() {
        return this.mMinHeight;
    }
}

