/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver.v2k5;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DefaultSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.SchemaSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DataBaseSqlServerv2k5;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.AbstractSqlServerPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class DefaultPropertyDialogSqlServerv2k5
extends AbstractSqlServerPropertyDialog {
    private DefaultSqlServer defaultSqlServer;
    private JComboBox cbDatabase;
    private JComboBox cbOwner;
    private JTextField tfConstant;

    public DefaultPropertyDialogSqlServerv2k5(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.defaultSqlServer = (DefaultSqlServer)object;
        this.setHeight(180);
        this.initCommentsView(55);
        this.initCommentsInRDBMS(55);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("DefaultPropertyDialogSqlServerv2k5.DefaultsProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initDatabase();
        this.initOwner();
        this.initConstant();
    }

    @Override
    public void initProperties() {
        this.initCaption(this.defaultSqlServer.getName());
        this.tfName.setText(this.defaultSqlServer.getName());
        this.cbDatabase.setSelectedItem(this.defaultSqlServer.getDataBase());
        this.cbOwner.removeAllItems();
        if (this.defaultSqlServer.getDataBase() != null) {
            this.fillComboItems(((DataBaseSqlServerv2k5)this.defaultSqlServer.getDataBase()).getSchemas().toArray(), this.cbOwner);
        }
        this.cbOwner.setSelectedItem(this.defaultSqlServer.getSchema());
        this.tfConstant.setText(this.defaultSqlServer.getConstant());
        this.getCommentsList().insert(this.defaultSqlServer.getComment(), 0);
        this.taCommentsInRDBMS.insert(this.defaultSqlServer.getCommentInRDBMS(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.defaultSqlServer != null) {
            this.defaultSqlServer.setSchema((SchemaSqlServer)this.cbOwner.getSelectedItem());
            this.defaultSqlServer.setName(this.tfName.getText());
            this.defaultSqlServer.setDataBase((DataBaseSqlServer)this.cbDatabase.getSelectedItem());
            this.defaultSqlServer.setConstant(this.tfConstant.getText());
            this.defaultSqlServer.setComment(this.getCommentsList().getText());
            this.defaultSqlServer.setCommentInRDBMS(this.taCommentsInRDBMS.getText());
        }
    }

    @Override
    protected boolean allowName(String newName) {
        Object selectedSchema = this.cbOwner.getSelectedItem();
        if (selectedSchema instanceof SchemaSqlServer) {
            newName = ((SchemaSqlServer)selectedSchema).getName() + "." + (String)newName;
        }
        return this.getStorageObject().allowName((String)newName, true);
    }

    private void initDatabase() {
        JLabel label = new JLabel(Messages.getString("DefaultPropertyDialogSqlServerv2k5.Database"));
        this.general.add(label);
        this.cbDatabase = new JComboBox<Object>(this.getStorageDesign().getDataBaseSet().toArray());
        this.setBG(this.cbDatabase);
        this.cbDatabase.setPreferredSize(this.tfName.getPreferredSize());
        this.cbDatabase.setEnabled(false);
        this.general.add(this.cbDatabase);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbDatabase, 50);
    }

    private void initOwner() {
        JLabel label = new JLabel(Messages.getString("DefaultPropertyDialogSqlServerv2k5.Schema"));
        this.general.add(label);
        this.cbOwner = new JComboBox();
        this.setBG(this.cbOwner);
        this.cbOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOwner);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.cbOwner, 80);
    }

    private void initConstant() {
        JLabel label = new JLabel(Messages.getString("DefaultPropertyDialogSqlServerv2k5.Constant"));
        this.general.add(label);
        this.tfConstant = new JTextField("", 26);
        this.general.add(this.tfConstant);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.tfConstant, 110);
    }
}

