/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver.v2k5;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataFileSqlServer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.AbstractSqlServerPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class DataFilePropertyDialogSqlServerv2k5
extends AbstractSqlServerPropertyDialog {
    private DataFileSqlServer datafile;
    private JIntegerField ifSize;
    private JIntegerField ifGrowthValue;
    private JIntegerField ifMaxSize;
    private JTextField tfFileName;
    private JComboBox cbGrowth;
    private JCheckBox chbUnlimited;
    private JComboBox cbSize;
    private JComboBox cbMaxSize;

    public DataFilePropertyDialogSqlServerv2k5(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.datafile = (DataFileSqlServer)object;
        this.setHeight(280);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("DataFilePropertyDialogSqlServerv2k5.DatafileProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initFileName();
        this.initSize();
        this.initSizeInUnit();
        this.initGrowthMethod();
        this.initGrowthValue();
        this.initUseUnlimited();
        this.initMaxSize();
        this.initMaxSizeInUnit();
    }

    private void initFileName() {
        JLabel label = new JLabel(Messages.getString("DataFilePropertyDialogSqlServerv2k5.FileName"));
        this.general.add(label);
        this.tfFileName = new JTextField("", 26);
        this.general.add(this.tfFileName);
        this.setLabelConstraints(label, 45);
        this.setObjectConstraints(this.tfFileName, 45);
    }

    private void initSize() {
        JLabel label = new JLabel(Messages.getString("DataFilePropertyDialogSqlServerv2k5.InitialSize"));
        this.general.add(label);
        this.ifSize = new JIntegerField(0, 26);
        this.general.add(this.ifSize);
        this.setLabelConstraints(label, 70);
        this.setObjectConstraints(this.ifSize, 70);
    }

    private void initSizeInUnit() {
        JLabel label = new JLabel(Messages.getString("DataFilePropertyDialogSqlServer.InitialSizeUnit"));
        this.general.add(label);
        this.cbSize = new JComboBox<String>(DataFileSqlServer.getSizeInUnits());
        this.setBG(this.cbSize);
        this.cbSize.setPreferredSize(this.ifSize.getPreferredSize());
        this.general.add(this.cbSize);
        this.setLabelConstraints(label, 95);
        this.setObjectConstraints(this.cbSize, 95);
    }

    private void initGrowthMethod() {
        JLabel label = new JLabel(Messages.getString("DataFilePropertyDialogSqlServerv2k5.GrowthMethod"));
        this.general.add(label);
        this.cbGrowth = new JComboBox<String>(DataFileSqlServer.getGrowthChoices());
        this.setBG(this.cbGrowth);
        this.cbGrowth.setPreferredSize(this.ifSize.getPreferredSize());
        this.general.add(this.cbGrowth);
        this.setLabelConstraints(label, 145);
        this.setObjectConstraints(this.cbGrowth, 145);
    }

    private void initGrowthValue() {
        JLabel label = new JLabel(Messages.getString("DataFilePropertyDialogSqlServerv2k5.GrowthValue"));
        this.general.add(label);
        this.ifGrowthValue = new JIntegerField(0, 26);
        this.general.add(this.ifGrowthValue);
        this.setLabelConstraints(label, 120);
        this.setObjectConstraints(this.ifGrowthValue, 120);
    }

    private void initMaxSize() {
        JLabel label = new JLabel(Messages.getString("DataFilePropertyDialogSqlServerv2k5.MaxSize"));
        this.general.add(label);
        this.ifMaxSize = new JIntegerField(0, 26);
        this.general.add(this.ifMaxSize);
        this.setLabelConstraints(label, 200);
        this.setObjectConstraints(this.ifMaxSize, 200);
    }

    private void initMaxSizeInUnit() {
        JLabel label = new JLabel(Messages.getString("DataFilePropertyDialogSqlServer.MaxSizeUnit"));
        this.general.add(label);
        this.cbMaxSize = new JComboBox<String>(DataFileSqlServer.getSizeInUnits());
        this.setBG(this.cbMaxSize);
        this.cbMaxSize.setPreferredSize(this.ifMaxSize.getPreferredSize());
        this.general.add(this.cbMaxSize);
        this.setLabelConstraints(label, 225);
        this.setObjectConstraints(this.cbMaxSize, 225);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.datafile.getName());
        this.tfName.setText(this.datafile.getName());
        this.tfFileName.setText(this.datafile.getFileName());
        this.ifSize.setValue((long)this.datafile.getInitialSize());
        this.cbSize.setSelectedItem(this.datafile.getInitialSizeInUnit());
        this.ifMaxSize.setValue((long)this.datafile.getMaxSize());
        this.cbMaxSize.setSelectedItem(this.datafile.getMaxSizeInUnit());
        this.cbGrowth.setSelectedItem(this.datafile.getGrowthMethod());
        this.ifGrowthValue.setValue((long)this.datafile.getGrowthValue());
        this.chbUnlimited.setSelected(this.datafile.getIsUnlimited());
        this.setUnlimited(this.datafile.getIsUnlimited());
        this.ifMaxSize.setEnabled(!this.datafile.getIsUnlimited());
        this.cbMaxSize.setEnabled(!this.datafile.getIsUnlimited());
        this.getCommentsList().insert(this.datafile.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.datafile != null) {
            this.datafile.setName(this.tfName.getText());
            this.datafile.setFileName(this.tfFileName.getText());
            this.datafile.setInitialSize(this.ifSize.getIntValue());
            this.ifSize.setValue((long)this.datafile.getInitialSize());
            this.datafile.setInitialSizeInUnit((String)this.cbSize.getSelectedItem());
            this.datafile.setMaxSize(this.ifMaxSize.getIntValue());
            this.ifMaxSize.setValue((long)this.datafile.getMaxSize());
            this.datafile.setMaxSizeInUnit((String)this.cbMaxSize.getSelectedItem());
            this.datafile.setGrowthMethod((String)this.cbGrowth.getSelectedItem());
            this.datafile.setGrowthValue(this.ifGrowthValue.getIntValue());
            this.ifGrowthValue.setValue((long)this.datafile.getGrowthValue());
            this.datafile.setIsUnlimited(this.chbUnlimited.isSelected());
            this.datafile.setComment(this.getCommentsList().getText());
        }
    }

    private void setUnlimited(boolean use) {
        this.ifMaxSize.setEnabled(!use);
        this.cbMaxSize.setEnabled(!use);
    }

    private void initUseUnlimited() {
        this.chbUnlimited = new JCheckBox(Messages.getString("DataFilePropertyDialogSqlServerv2k5.UnlimitedMaxSize"));
        this.chbUnlimited.addActionListener(new CheckBoxListener());
        this.general.add(this.chbUnlimited);
        this.setObjectConstraints(this.chbUnlimited, 8, 175);
    }

    private class CheckBoxListener
    implements ActionListener {
        private CheckBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DataFilePropertyDialogSqlServerv2k5.this.setUnlimited(DataFilePropertyDialogSqlServerv2k5.this.chbUnlimited.isSelected());
        }
    }
}

