/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.datatypes.MethodParam;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.MethodParamProxyOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class MethodParamPropertyDialogOracle
extends AbstractOraclePropertyDialog {
    private MethodParamProxyOracle param;
    private JTextField tfDatatype;
    private JComboBox cbDirectionType;
    private JComboBox cbCopyArg;
    private JTextField tfDefaultValue;

    public MethodParamPropertyDialogOracle(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.param = (MethodParamProxyOracle)object;
        this.setHeight(200);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("MethodParamPropertyDialogOracle.MethodParamProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initDatatype();
        this.initDirectionType();
        this.initCopyClause();
        this.initDefaultValue();
    }

    private void initDatatype() {
        JLabel label = new JLabel(Messages.getString("MethodParamPropertyDialogOracle.Datatype"));
        this.general.add(label);
        this.tfDatatype = new JTextField("", 26);
        this.tfDatatype.setEnabled(false);
        this.general.add(this.tfDatatype);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.tfDatatype, 50);
    }

    private void initDirectionType() {
        JLabel label = new JLabel(Messages.getString("MethodParamPropertyDialogOracle.DirectionType"));
        this.general.add(label);
        this.cbDirectionType = new JComboBox<String>(MethodParamProxyOracle.DIRECTION_TYPE_CHOICES);
        this.setBG(this.cbDirectionType);
        this.cbDirectionType.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDirectionType);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.cbDirectionType, 80);
    }

    private void initCopyClause() {
        JLabel label = new JLabel(Messages.getString("MethodParamPropertyDialogOracle.CopyArgument"));
        this.general.add(label);
        this.cbCopyArg = new JComboBox<String>(YES_NO);
        this.setBG(this.cbCopyArg);
        this.cbCopyArg.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCopyArg);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.cbCopyArg, 110);
    }

    private void initDefaultValue() {
        JLabel label = new JLabel(Messages.getString("MethodParamPropertyDialogOracle.DefaultValue"));
        this.general.add(label);
        this.tfDefaultValue = new JTextField("", 26);
        this.general.add(this.tfDefaultValue);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.tfDefaultValue, 140);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.param.getName());
        this.tfName.setText(this.param.getName());
        this.tfDatatype.setText(((MethodParam)this.param.getObject()).getDataType());
        this.cbDirectionType.setSelectedItem(this.param.getDirectionType());
        this.cbCopyArg.setSelectedItem(MethodParamPropertyDialogOracle.translateYesNoForDisplay(this.param.getCopyArgument()));
        this.tfDefaultValue.setText(this.param.getDefaultValue());
        this.getCommentsList().insert(this.param.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.param != null) {
            this.param.setName(this.tfName.getText());
            this.param.setDirectionType((String)this.cbDirectionType.getSelectedItem());
            this.param.setCopyArgument(MethodParamPropertyDialogOracle.translateYesNoForStorage((String)this.cbCopyArg.getSelectedItem()));
            this.param.setDefaultValue(this.tfDefaultValue.getText());
            this.param.setComment(this.getCommentsList().getText());
        }
    }
}

