/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.db2;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.IndexPartitionDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.db2.AbstractDB2PropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.db2.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class IndexPartitionPropertyDialogDB2
extends AbstractDB2PropertyDialog {
    private IndexPartitionDB2 partition;
    private JComboBox cbIndex;
    private JIntegerField ifPartNumber;
    private JTextField tfPartConstants;
    private JComboBox cbStorageTemplate;

    public IndexPartitionPropertyDialogDB2(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.partition = (IndexPartitionDB2)object;
        this.setHeight(200);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("IndexPartitionPropertyDialogDB2.IndexPartitionProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initIndex();
        this.initPartNumber();
        this.initPartConstants();
        this.initStorageTemplate();
    }

    private void initIndex() {
        JLabel label = new JLabel(Messages.getString("IndexPartitionPropertyDialogDB2.Index"));
        this.general.add(label);
        this.cbIndex = new JComboBox();
        this.setBG(this.cbIndex);
        this.cbIndex.setEnabled(false);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getIndexProxySet().toArray(), this.cbIndex);
        }
        this.cbIndex.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbIndex);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbIndex, 50);
    }

    private void initPartNumber() {
        JLabel label = new JLabel(Messages.getString("IndexPartitionPropertyDialogDB2.PartitionNumber"));
        this.general.add(label);
        this.ifPartNumber = new JIntegerField(0, 26);
        this.ifPartNumber.setEnabled(false);
        this.general.add(this.ifPartNumber);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.ifPartNumber, 80);
    }

    private void initPartConstants() {
        JLabel label = new JLabel(Messages.getString("IndexPartitionPropertyDialogDB2.PartConstants"));
        this.general.add(label);
        this.tfPartConstants = new JTextField("", 26);
        this.general.add(this.tfPartConstants);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.tfPartConstants, 110);
    }

    private void initStorageTemplate() {
        JLabel label = new JLabel(Messages.getString("IndexPartitionPropertyDialogDB2.StorageTemplate"));
        this.general.add(label);
        this.cbStorageTemplate = new JComboBox();
        this.setBG(this.cbStorageTemplate);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getStorageTemplateSet().toArray(), this.cbStorageTemplate);
        }
        this.cbStorageTemplate.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbStorageTemplate);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.cbStorageTemplate, 140);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.partition.getName());
        this.tfName.setText(this.partition.getName());
        this.selectObject(this.cbIndex, this.partition.getIndex());
        this.ifPartNumber.setValue((long)this.partition.getPartNumber());
        this.tfPartConstants.setText(this.partition.getPartConstants());
        this.selectObject(this.cbStorageTemplate, this.partition.getStorageTemplate());
        this.getCommentsList().insert(this.partition.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.partition != null) {
            this.partition.setName(this.tfName.getText());
            this.partition.setPartConstants(this.tfPartConstants.getText());
            Object selected = this.cbStorageTemplate.getSelectedItem();
            if (selected instanceof StorageTemplateDB2) {
                this.partition.setStorageTemplate((StorageTemplateDB2)selected);
            } else {
                this.partition.setStorageTemplate(null);
            }
            this.partition.setComment(this.getCommentsList().getText());
        }
    }
}

