/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.relational;

import java.awt.Component;
import java.util.List;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.undo.relational.memento.IndexMemento;
import oracle.dbtools.crest.swingui.editor.relational.IndexesTableModel;
import oracle.dbtools.crest.swingui.editor.relational.Messages;

public class UniqueKeysTableModel
extends IndexesTableModel {
    private static final long serialVersionUID = -1820718436909505273L;
    List<Index> indexes;
    protected static final String[] COLUMN_NAMES = new String[]{" ", Messages.getString("IndexesTable.Name"), Messages.getString("IndexesTable.Generate"), Messages.getString("IndexesTable.Engineer"), Messages.getString("IndexesTable.Deprecated")};

    public UniqueKeysTableModel(List<Index> indexesList, List<Index> indexes, Component parent) {
        super(indexesList, parent);
        this.indexes = indexes;
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public String[] getColumnNames() {
        return COLUMN_NAMES;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        Index index = (Index)this.indexesList.get(rowIndex);
        return !index.isDialogVisible() && (columnIndex == 1 && !index.isNameFixed() || columnIndex == 2 || columnIndex == 3 || columnIndex == 4 || columnIndex == 5);
    }

    @Override
    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public Object getValueAt(int row, int col) {
        IndexMemento indexMemento = (IndexMemento)((Index)this.indexesList.get(row)).getIndexMemento();
        if (col == 0) {
            return new Integer(row + 1);
        }
        if (col == 1) {
            return indexMemento.name;
        }
        if (col == 2) {
            return indexMemento.generate_in_DDL;
        }
        if (col == 3) {
            return indexMemento.engineer;
        }
        if (col == 4) {
            return indexMemento.deprecated;
        }
        if (col == 5) {
            return this.getIndxByID(indexMemento.supportingIndexID);
        }
        return new Integer(row * col);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        IndexMemento indexMemento = (IndexMemento)((Index)this.indexesList.get(rowIndex)).getIndexMemento();
        if (columnIndex == 1) {
            indexMemento.name = (String)aValue;
            indexMemento.index.setName(indexMemento.name);
            indexMemento.name = indexMemento.index.getName();
        } else if (columnIndex == 2) {
            indexMemento.generate_in_DDL = (Boolean)aValue;
        } else if (columnIndex == 3) {
            indexMemento.engineer = (Boolean)aValue;
        } else if (columnIndex == 4) {
            indexMemento.deprecated = (Boolean)aValue;
        } else if (columnIndex == 5) {
            indexMemento.supportingIndexID = aValue instanceof Index ? ((Index)aValue).getObjectID() : null;
        }
    }

    @Override
    Index getIndxByID(String id) {
        if (id != null && this.indexes != null) {
            for (Index ind : this.indexes) {
                if (!id.equals(ind.getObjectID())) continue;
                return ind;
            }
        }
        return null;
    }
}

