/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.relational;

import javax.swing.JCheckBox;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.swingui.editor.relational.Messages;

public class FKColumnsTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -3606942481591565508L;
    final String[] COL_NAMES = new String[]{Messages.getString("FKColumnsTableModel.ReferencedColumn"), Messages.getString("FKColumnsTableModel.Column"), Messages.getString("TablePropertiesDialogEx.Mandatory")};
    private FKElement[] fkColumns;
    private KeyObject currentKey;
    private JCheckBox mandCheckBox;

    public FKColumnsTableModel() {
        this(null, null);
    }

    public FKElement[] getFkColumns() {
        return this.fkColumns;
    }

    public FKColumnsTableModel(FKElement[] fkColumns, KeyObject currentKey) {
        this.fkColumns = fkColumns;
        this.currentKey = currentKey;
    }

    public void init(KeyObject currentKey) {
        this.currentKey = currentKey;
    }

    public void init(FKElement[] fkColumns, KeyObject currentKey, JCheckBox mandCheckBox) {
        this.fkColumns = fkColumns;
        this.currentKey = currentKey;
        this.mandCheckBox = mandCheckBox;
        if (fkColumns != null) {
            for (FKElement fe : fkColumns) {
                if (fe == null) continue;
                fe.setTempMandatory(fe.isMandatory());
            }
        }
    }

    @Override
    public int getColumnCount() {
        return this.COL_NAMES.length;
    }

    @Override
    public int getRowCount() {
        if (this.currentKey != null && this.currentKey.getElements() != null) {
            return this.currentKey.getElements().length;
        }
        return 0;
    }

    public void dataChanged() {
        this.fireTableDataChanged();
    }

    @Override
    public String getColumnName(int col) {
        return this.COL_NAMES[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (col == 0) {
            return this.currentKey.getElements()[row];
        }
        if (col == 1) {
            if (this.fkColumns != null && this.fkColumns.length > 0 && row < this.fkColumns.length) {
                return this.fkColumns[row];
            }
            return null;
        }
        if (this.fkColumns != null && this.fkColumns.length > 0 && row < this.fkColumns.length && this.fkColumns[row] != null) {
            if (this.fkColumns[row].getContainer().isBackup()) {
                return this.fkColumns[row].isMandatory();
            }
            if (this.fkColumns[row].getTempMandatory() == null) {
                return this.fkColumns[row].isMandatory();
            }
            return this.fkColumns[row].getTempMandatory();
        }
        return false;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (col == 1) {
            return true;
        }
        return col == 2 && this.mandCheckBox != null && !this.mandCheckBox.isSelected();
    }

    public Class getColumnClass(int col) {
        if (col == 2) {
            return Boolean.class;
        }
        return FKElement.class;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 1) {
            this.fkColumns[row] = (FKElement)value;
        } else if (col == 2 && value instanceof Boolean && this.fkColumns != null && this.fkColumns.length > 0 && row < this.fkColumns.length && this.fkColumns[row] != null) {
            boolean mand = (Boolean)value;
            if (this.fkColumns[row].getContainer().isBackup()) {
                this.fkColumns[row].setMandatory(mand);
                return;
            }
            this.fkColumns[row].setTempMandatory((Boolean)value);
        }
    }
}

