/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.process;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.ExternalData;
import oracle.dbtools.crest.model.design.process.RecordStructure;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.process.Messages;

public class RecordStructurePropertiesDialogEx
extends AbstractPropertiesDialog {
    private List edList;
    private RecordStructure recordStructure;
    private JTable edTable;
    private JPanel pnDataElements;
    private List newExtDatas = new ArrayList();
    private JButton btnDataElementProperties;
    private JButton btnRemoveDataElement;

    public RecordStructurePropertiesDialogEx(ApplicationView view, DesignObject object) {
        super(view, object);
    }

    @Override
    public String getCaption() {
        return Messages.getString("RecordStructurePropertiesDialogEx.RecordStructureProperties");
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof RecordStructure) {
            this.recordStructure = (RecordStructure)object;
            this.initDefaults(false);
            this.edList.addAll(this.recordStructure.getExtDatas());
            this.initMeasurements();
            this.initChangeRequests();
            this.initResponsibleParties();
            this.initDocuments();
            this.initDynamicProperties();
        }
    }

    @Override
    protected void setProperties() {
        this.recordStructure.setName(this.tfName.getText());
        this.recordStructure.setNotes(this.taNotes.getText());
        this.recordStructure.setComment(this.taComments.getText());
        for (ExternalData data : this.recordStructure.getExtDatas()) {
            if (this.edList.contains(data)) continue;
            data.remove();
        }
        this.recordStructure.getExtDatas().clear();
        for (ExternalData extData : this.edList) {
            this.recordStructure.addExtData(extData);
        }
        this.newExtDatas.clear();
        this.setMeasurements();
        this.setChangeRequests();
        this.setResponsibleParties();
        this.setDocuments();
        RecordStructurePropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.recordStructure.clearProperties();
        for (DynamicProperty dp : this.dynamicPropertiesList) {
            this.recordStructure.setProperty(dp.getName(), dp.getValue());
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.addToTree(root, this.getGeneralPanel());
        this.addToTree(root, this.getDataElementsPanel());
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getNotesPanel());
        this.addToTree(root, this.getMeasurementsPanel());
        this.addToTree(root, this.getChangeRequestsPanel());
        this.addToTree(root, this.getResPartiesPanel());
        this.addToTree(root, this.getDocumentsPanel());
        this.addToTree(root, this.getDynamicPropertiesPanel());
        this.addToTree(root, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "RECORD_STRUCTURE_PROPERTIES_DIALOG";
    }

    private JPanel getDataElementsPanel() {
        if (this.pnDataElements == null) {
            this.pnDataElements = this.createPage(Messages.getString("RecordStructurePropertiesDialogEx.DataElements"));
            this.edList = new ArrayList();
            this.edTable = new JTable(new ExternalDataModel());
            this.edTable.setSelectionMode(0);
            this.edTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row = RecordStructurePropertiesDialogEx.this.edTable.getSelectedRow();
                    if (row > -1) {
                        if (e.getClickCount() == 2 && RecordStructurePropertiesDialogEx.this.edList.size() > 0 && row < RecordStructurePropertiesDialogEx.this.edList.size()) {
                            ExternalData extData = (ExternalData)RecordStructurePropertiesDialogEx.this.edList.get(row);
                            extData.showModal = RecordStructurePropertiesDialogEx.this.recordStructure.showModal || RecordStructurePropertiesDialogEx.this.recordStructure.showForFirstTime();
                            extData.showPropertyDialog();
                        }
                        RecordStructurePropertiesDialogEx.this.btnDataElementProperties.setEnabled(true);
                        RecordStructurePropertiesDialogEx.this.btnRemoveDataElement.setEnabled(true);
                    } else {
                        RecordStructurePropertiesDialogEx.this.btnDataElementProperties.setEnabled(false);
                        RecordStructurePropertiesDialogEx.this.btnRemoveDataElement.setEnabled(false);
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.edTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            this.btnDataElementProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.btnDataElementProperties.setEnabled(false);
            this.btnDataElementProperties.setToolTipText(BTN_PROPERTIES);
            this.btnDataElementProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = RecordStructurePropertiesDialogEx.this.edTable.getSelectedRow();
                    if (row > -1 && RecordStructurePropertiesDialogEx.this.edList.size() > 0 && row < RecordStructurePropertiesDialogEx.this.edList.size()) {
                        ExternalData extData = (ExternalData)RecordStructurePropertiesDialogEx.this.edList.get(row);
                        extData.showModal = RecordStructurePropertiesDialogEx.this.recordStructure.showModal || RecordStructurePropertiesDialogEx.this.recordStructure.showForFirstTime();
                        extData.showPropertyDialog();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(this.btnDataElementProperties);
            if (this.isEditable()) {
                JButton btnAdd = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                btnAdd.setToolTipText(BTN_ADD);
                btnAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ExternalData extData = RecordStructurePropertiesDialogEx.this.recordStructure.getDesign().getProcessModel().createExternalData();
                        extData.setType(RecordStructurePropertiesDialogEx.this.recordStructure.getDesign().getDomainSet().getDefaultDomain().getLogicalDatatype());
                        extData.setOwner(RecordStructurePropertiesDialogEx.this.recordStructure);
                        RecordStructurePropertiesDialogEx.this.newExtDatas.add(extData);
                        RecordStructurePropertiesDialogEx.this.edList.add(extData);
                        RecordStructurePropertiesDialogEx.this.edTable.updateUI();
                    }
                });
                this.btnRemoveDataElement = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                this.btnRemoveDataElement.setEnabled(false);
                this.btnRemoveDataElement.setToolTipText(BTN_REMOVE);
                this.btnRemoveDataElement.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int objectNumber = RecordStructurePropertiesDialogEx.this.edTable.getSelectedRow();
                        if (objectNumber != -1 && RecordStructurePropertiesDialogEx.this.edList.size() > 0 && objectNumber < RecordStructurePropertiesDialogEx.this.edList.size()) {
                            RecordStructurePropertiesDialogEx.this.edList.remove(objectNumber);
                            RecordStructurePropertiesDialogEx.this.edTable.updateUI();
                        }
                    }
                });
                toolBar.addSeparator();
                toolBar.add(btnAdd);
                toolBar.add(this.btnRemoveDataElement);
            }
            buttonGeneral.add(toolBar);
            scrollpane.setPreferredSize(new Dimension(325, 175));
            JPanel aPanel = new JPanel(new BorderLayout());
            aPanel.add((Component)buttonGeneral, "North");
            aPanel.add(scrollpane);
            this.pnDataElements.add(aPanel);
        }
        return this.pnDataElements;
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    private class ExternalDataModel
    extends AbstractTableModel {
        private ExternalDataModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return RecordStructurePropertiesDialogEx.this.edList.size();
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return Messages.getString("RecordStructurePropertiesDialogEx.ExternalDatas");
                }
                case 1: {
                    return Messages.getString("RecordStructurePropertiesDialogEx.Type");
                }
                case 2: {
                    return Messages.getString("RecordStructurePropertiesDialogEx.StartingPosition");
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            ExternalData extData = (ExternalData)RecordStructurePropertiesDialogEx.this.edList.get(row);
            switch (col) {
                case 0: {
                    return extData.getName();
                }
                case 1: {
                    if (extData.isStructured()) {
                        return extData.getRecordStructure() != null ? extData.getRecordStructure().getName() : "";
                    }
                    return extData.getType();
                }
                case 2: {
                    return Integer.toString(extData.getStartingPos());
                }
            }
            return new Integer(row * col);
        }
    }
}

