/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.multidimensional;

import java.awt.GridLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractEditor;
import oracle.dbtools.crest.swingui.editor.multidimensional.Messages;

public abstract class AbstractMultidimensionalEditor
extends AbstractEditor {
    protected String description = "";
    protected String commentField = "";
    protected String notesField = "";
    protected JLabel lbdescription;
    protected JLabel lbNotes;
    public JButton btnDescription;
    private JTextField tfOraShortName;
    private JTextField tfOraLongName;
    private JTextField tfOraPluralName;

    public AbstractMultidimensionalEditor(ApplicationView view, DesignObject object) {
        super(view, object);
    }

    protected abstract AbstractMDObject getMDObject();

    public String getDescriptionField() {
        if (this.description.equalsIgnoreCase("")) {
            this.description = this.getMDObject().getDescription();
        }
        return this.description;
    }

    public void setDescriptionField(String description) {
        this.description = description;
        this.btnDescription.setText(description);
    }

    protected void initOracleNamesTab(AbstractMDObject mdo) {
        JPanel oraNamesPanel = new JPanel(new GridLayout(0, 1));
        JLabel lbOraShortName = new JLabel(Messages.getString("AbstractMultidimensionalEditor.ShortName"));
        lbOraShortName.setPreferredSize(this.lbName.getPreferredSize());
        this.tfOraShortName = new JTextField(mdo.getOracleShortName());
        this.tfOraShortName.setPreferredSize(this.lbName.getPreferredSize());
        this.tfOraShortName.setCaretPosition(0);
        JPanel row = this.newRow(lbOraShortName, this.tfOraShortName);
        oraNamesPanel.add(row);
        JLabel lbOraLongName = new JLabel(Messages.getString("AbstractMultidimensionalEditor.LongName"));
        lbOraLongName.setPreferredSize(this.lbName.getPreferredSize());
        this.tfOraLongName = new JTextField(mdo.getOracleLongName());
        this.tfOraLongName.setPreferredSize(this.lbName.getPreferredSize());
        this.tfOraLongName.setCaretPosition(0);
        row = this.newRow(lbOraLongName, this.tfOraLongName);
        oraNamesPanel.add(row);
        JLabel lbOraPluralName = new JLabel(Messages.getString("AbstractMultidimensionalEditor.PluralName"));
        lbOraPluralName.setPreferredSize(this.lbName.getPreferredSize());
        this.tfOraPluralName = new JTextField(mdo.getOraclePluralName());
        this.tfOraPluralName.setPreferredSize(this.lbName.getPreferredSize());
        this.tfOraPluralName.setCaretPosition(0);
        row = this.newRow(lbOraPluralName, this.tfOraPluralName);
        oraNamesPanel.add(row);
        this.prepareTab(this.getPane(), oraNamesPanel, Messages.getString("AbstractMultidimensionalEditor.OracleNames"), Messages.getString("AbstractMultidimensionalEditor.ShortNameLongNamePluralName"));
    }

    protected void setOracleNames(AbstractMDObject mdo) {
        mdo.setOracleShortName(this.tfOraShortName.getText());
        mdo.setOracleLongName(this.tfOraLongName.getText());
        mdo.setOraclePluralName(this.tfOraPluralName.getText());
    }
}

