/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.logical;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.compare.CompareTreeNavigationDesign;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.impact.ImpA_KeyObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.logical.LogicalObjectPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.logical.Messages;
import oracle.dbtools.crest.swingui.impact.ImpactTreeRenderer;
import oracle.ide.Ide;

public class KeyPropertiesDialogEx
extends LogicalObjectPropertiesDialog {
    private static final String ATTRIBUTES_AND_RELATIONS_TAB_NAME = Messages.getString("KeyPropertiesDialogEx.AttributesAndRelations");
    private CandidateKey key;
    private List<Attribute> attributesList;
    private JTextField tfSynonym;
    private JTextField tfLongName;
    private JComboBox cbState;
    private JPanel pnAttributes;
    private JButton btnAddAttributes;
    private JButton btnRemoveAttributes;
    private AllAttributesModel allAttributesModel;
    private DefaultListModel selectedAttributesModel;
    private JPanel panelAttributes;
    private JList selectedAttributesList;
    private JList allAttributesList;
    private JButton btnUp;
    private JButton btnDown;
    private JTree tree;
    private JCheckBox chbDeprecated;

    public KeyPropertiesDialogEx(ApplicationView view, DesignObject object) {
        super(view, object);
        this.initGeneral();
    }

    public KeyPropertiesDialogEx(Dialog owner, ApplicationView view, DesignObject object) {
        super(owner, view, object);
        this.initGeneral();
    }

    @Override
    public String getCaption() {
        return Messages.getString("KeyPropertiesDialogEx.KeyProperties");
    }

    @Override
    protected int getMinimumWidth() {
        return 630;
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof CandidateKey) {
            this.key = (CandidateKey)object;
            this.initDefaults(false);
            this.tfSynonym.setText(this.key.getSynonym());
            this.tfLongName.setText(this.key.getLongName());
            this.cbState.setSelectedItem(this.translate(this.key.getKeyState(), KEY_STATES_INTERNAL, KEY_STATES_DISPLAY));
            this.chbDeprecated.setSelected(this.key.isDeprecated());
            Entity entity = (Entity)this.key.getContainerObject();
            if (entity != null) {
                List rels = entity.getPKProviderRelations();
                Object[] elems = this.key.getNewElementsCollection().toArray();
                for (int k = 0; k < elems.length; ++k) {
                    DesignObject rel;
                    Attribute attr;
                    if (elems[k] instanceof Relation && rels.contains(elems[k])) {
                        if (this.selectedAttributesModel.contains(elems[k])) continue;
                        this.selectedAttributesModel.addElement(elems[k]);
                        continue;
                    }
                    Object elem = elems[k];
                    if (elem instanceof Attribute && (attr = (Attribute)elem).isFKAttribute() && (rel = attr.getGenerator()) != null && rel instanceof Relation) {
                        elem = rel;
                    }
                    if (this.selectedAttributesModel.contains(elem)) continue;
                    this.selectedAttributesModel.addElement(elems[k]);
                }
                this.updateAllattributes(rels);
                this.cbState.setEnabled(!this.isIdentifying(entity));
                if (entity.getHierarchicalParent() != null) {
                    this.cbState.setSelectedItem(UNIQUE_KEY);
                    this.cbState.setEnabled(false);
                }
            }
            this.initMeasurements();
            this.initChangeRequests();
            this.initResponsibleParties();
            this.initDocuments();
            this.initDynamicProperties();
        }
    }

    private void updateAllattributes(List rels) {
        Object obj = this.cbState.getSelectedItem();
        boolean pk = false;
        if (PRIMARY_KEY.equals(obj)) {
            pk = true;
        }
        this.allAttributesModel.removeAllElements();
        for (Attribute attribute : this.attributesList) {
            if (this.selectedAttributesModel.contains(attribute)) continue;
            if (pk) {
                if (attribute.getNullsAllowed()) continue;
                this.allAttributesModel.addElement(attribute);
                continue;
            }
            this.allAttributesModel.addElement(attribute);
        }
        for (int i = 0; i < rels.size(); ++i) {
            Relation rel = (Relation)rels.get(i);
            if (this.selectedAttributesModel.contains(rel) || this.allAttributesModel.contains(rel)) continue;
            int[] ends = rel.getPKProviderEndPoint();
            for (int j = 0; j < ends.length; ++j) {
                Entity ent = rel.getEntity(ends[j]);
                if (ent == this.key.getContainerWithKeyObject() && rel.getSourceEntity() != rel.getTargetEntity()) continue;
                this.allAttributesModel.addElement(rel);
            }
        }
    }

    public boolean isIdentifying(Entity entity) {
        if (entity.hasPK() && entity.getPK().hasFKAttribute()) {
            Attribute attribute = entity.getPK().getFKAttribute();
            return attribute.getRelation().isIdentifying();
        }
        return false;
    }

    @Override
    protected void setProperties() {
        Object ob;
        int i;
        ArrayList elems_copy = new ArrayList(this.key.getNewElementsCollection());
        this.key.setName(this.tfName.getText());
        this.key.setComment(this.taComments.getText());
        this.key.setNotes(this.taNotes.getText());
        this.key.setSynonym(this.tfSynonym.getText());
        this.key.setNewElementsIDsProcessed(true);
        Object[] attributesSet = this.selectedAttributesModel.toArray();
        this.key.setColumnsState(false);
        ArrayList list = new ArrayList();
        list.addAll(this.key.getNewElementsCollection());
        for (int i2 = 0; i2 < attributesSet.length; ++i2) {
            Object ob2 = attributesSet[i2];
            list.remove(ob2);
        }
        for (Object ob2 : list) {
            if (!(ob2 instanceof DesignObject)) continue;
            this.key.removeElement((DesignObject)ob2);
        }
        for (i = 0; i < attributesSet.length; ++i) {
            ob = attributesSet[i];
            if (!(ob instanceof DesignObject)) continue;
            this.key.addElement((DesignObject)ob);
        }
        for (i = 0; i < attributesSet.length; ++i) {
            ob = attributesSet[i];
            if (!(ob instanceof DesignObject)) continue;
            this.key.moveElementToIndex((DesignObject)ob, i);
        }
        this.key.setKeyState(this.translate((String)this.cbState.getSelectedItem(), KEY_STATES_DISPLAY, KEY_STATES_INTERNAL));
        this.key.setDeprecated(this.chbDeprecated.isSelected());
        if (!elems_copy.equals(this.key.getNewElementsCollection())) {
            this.key.updateElementsCollection();
        }
        this.setEngineering();
        this.setMeasurements();
        this.setChangeRequests();
        this.setResponsibleParties();
        this.setDocuments();
        this.tfLongName.setText(this.key.getLongName());
        KeyPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.key.clearProperties();
        for (DynamicProperty dp : this.dynamicPropertiesList) {
            this.key.setProperty(dp.getName(), dp.getValue());
        }
        this.getAppView().getCurrentDPV().getWorkSpace().repaint();
    }

    public void setAttributesList(List attributesList) {
        this.attributesList = attributesList;
    }

    public List getAttributesList() {
        return this.attributesList;
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.addToTree(root, this.getGeneralPanel());
        this.addToTree(root, this.getAttributesPanel());
        this.addToTree(root, this.getEngineeringPanel());
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getNotesPanel());
        this.addToTree(root, this.getImpactAnalysisPanel());
        this.addToTree(root, this.getMeasurementsPanel());
        this.addToTree(root, this.getChangeRequestsPanel());
        this.addToTree(root, this.getResPartiesPanel());
        this.addToTree(root, this.getDocumentsPanel());
        this.addToTree(root, this.getDynamicPropertiesPanel());
        this.addToTree(root, this.getSummaryPanel());
        this.getTree().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                String newSelectedTabName;
                TreePath newLeadSelectionPath = e.getNewLeadSelectionPath();
                if (newLeadSelectionPath != null && (newSelectedTabName = ((JPanel)((DefaultMutableTreeNode)newLeadSelectionPath.getLastPathComponent()).getUserObject()).getName()).equals(ATTRIBUTES_AND_RELATIONS_TAB_NAME)) {
                    KeyPropertiesDialogEx.this.allAttributesModel.filter();
                }
            }
        });
    }

    @Override
    protected String getHelpIndex() {
        return "KEY_PROPERTIES_DIALOG";
    }

    private void initGeneral() {
        JLabel lbSynonym = new JLabel(LB_SYNOMYM);
        lbSynonym.setPreferredSize(this.getDefaultSize());
        this.tfSynonym = new JTextField();
        this.tfSynonym.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbSynonym, this.tfSynonym));
        JLabel lbLongName = new JLabel(LB_LONG_NAME);
        lbLongName.setPreferredSize(this.getDefaultSize());
        this.tfLongName = new JTextField();
        this.tfLongName.setPreferredSize(this.getDefaultSize());
        this.tfLongName.setEditable(false);
        this.addRowToGeneralPanel(this.createRow(lbLongName, this.tfLongName));
        JLabel lbState = new JLabel(LB_STATE);
        lbState.setPreferredSize(this.getDefaultSize());
        this.cbState = new JComboBox<String>(KEY_STATES_DISPLAY);
        this.cbState.setPreferredSize(this.getDefaultSize());
        this.cbState.setMaximumRowCount(8);
        this.cbState.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Entity entity = (Entity)KeyPropertiesDialogEx.this.key.getContainerObject();
                if (entity != null) {
                    List rels = entity.getPKProviderRelations();
                    KeyPropertiesDialogEx.this.updateAllattributes(rels);
                }
            }
        });
        this.addRowToGeneralPanel(this.createRow(lbState, this.cbState));
        JLabel lbDeprecated = new JLabel(LB_DEPRECATED);
        lbDeprecated.setPreferredSize(this.getDefaultSize());
        this.chbDeprecated = new JCheckBox();
        this.chbDeprecated.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbDeprecated, this.chbDeprecated));
    }

    protected JPanel getAttributesPanel() {
        if (this.pnAttributes == null) {
            this.pnAttributes = this.createPage(ATTRIBUTES_AND_RELATIONS_TAB_NAME);
            this.panelAttributes = new JPanel();
            BoxLayout bl = new BoxLayout(this.panelAttributes, 2);
            this.panelAttributes.setLayout(bl);
            this.pnAttributes.add(this.panelAttributes);
            this.initAllAttributesList();
            this.initAttributesButtons();
            this.initSelectedAttributesList();
        }
        return this.pnAttributes;
    }

    private void initAllAttributesList() {
        JPanel pnAttributes = new JPanel(new BorderLayout());
        this.allAttributesModel = new AllAttributesModel();
        this.allAttributesList = new JList(this.allAttributesModel);
        this.allAttributesList.setCellRenderer(new AllAttributesRelationsRenderer());
        ListSelectionModel listSelectionModel = this.allAttributesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllColumnsListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allAttributesList);
        sp.setPreferredSize(new Dimension(145, 220));
        pnAttributes.add(sp);
        this.panelAttributes.add(pnAttributes);
    }

    private void initSelectedAttributesList() {
        JPanel pnSelected = new JPanel(new BorderLayout());
        this.selectedAttributesModel = new DefaultListModel();
        this.selectedAttributesList = new JList(this.selectedAttributesModel);
        ListSelectionModel listSelectionModel = this.selectedAttributesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedColumnsListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedAttributesList);
        sp.setPreferredSize(new Dimension(145, 220));
        pnSelected.add(sp);
        this.panelAttributes.add(pnSelected);
    }

    private void initAttributesButtons() {
        JPanel buttonsPanel = new JPanel();
        JToolBar toolBar = new JToolBar(1);
        toolBar.setFloatable(false);
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        this.btnAddAttributes = new JButton(configuration.getIcon("MOVE_RIGHT_ICON", this.getPreferredIconSize()));
        this.btnAddAttributes.addActionListener(new AddColumnsActionListener());
        this.btnAddAttributes.setEnabled(false);
        this.btnAddAttributes.setToolTipText(BTN_ADD);
        this.btnRemoveAttributes = new JButton(configuration.getIcon("MOVE_LEFT_ICON", this.getPreferredIconSize()));
        this.btnRemoveAttributes.setEnabled(false);
        this.btnRemoveAttributes.addActionListener(new RemoveColumnsActionListener());
        this.btnRemoveAttributes.setToolTipText(BTN_REMOVE);
        this.btnUp = new JButton(configuration.getIcon("MOVE_UP_ICON", this.getPreferredIconSize()));
        this.btnUp.setToolTipText(Messages.getString("KeyPropertiesDialogEx.MoveUp"));
        this.btnUp.addActionListener(new MoveUpAction());
        this.btnDown = new JButton(configuration.getIcon("MOVE_DOWN_ICON", this.getPreferredIconSize()));
        this.btnDown.setToolTipText(Messages.getString("KeyPropertiesDialogEx.MoveDown"));
        this.btnDown.addActionListener(new MoveDownAction());
        this.btnUp.setEnabled(false);
        this.btnDown.setEnabled(false);
        toolBar.add(this.btnAddAttributes);
        toolBar.add(this.btnRemoveAttributes);
        toolBar.add(this.btnUp);
        toolBar.add(this.btnDown);
        buttonsPanel.add(toolBar);
        this.panelAttributes.add(buttonsPanel);
    }

    public boolean moveToIndex(Object object, int index) {
        if (this.selectedAttributesModel.contains(object) && this.selectedAttributesModel.size() > index && index >= 0) {
            this.selectedAttributesModel.removeElement(object);
            this.selectedAttributesModel.add(index, object);
            return true;
        }
        return false;
    }

    private boolean couldBeCyclic(Relation rel) {
        if (rel.getSourceEntity() == rel.getTargetEntity()) {
            return true;
        }
        if (this.key.getContainerWithKeyObject() == rel.getSourceEntity()) {
            return rel.getTargetEntity().hasFK_Rel_PathTo(rel.getSourceEntity());
        }
        return rel.getSourceEntity().hasFK_Rel_PathTo(rel.getTargetEntity());
    }

    private JPanel getImpactAnalysisPanel() {
        JPanel pnImpact = this.createPage(IMPACT_ANALYSIS);
        this.tree = new JTree();
        this.tree.setToggleClickCount(50);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TreePath path;
                Object last;
                if (e.getClickCount() == 2 && (last = (path = KeyPropertiesDialogEx.this.tree.getClosestPathForLocation(e.getPoint().x, e.getPoint().y)).getLastPathComponent()) instanceof ModelIdObjectSelection) {
                    ModelIDObject obj = ((ModelIdObjectSelection)last).getObject();
                    if (obj != null) {
                        e.consume();
                        obj.showPropertyDialog();
                    } else {
                        if (KeyPropertiesDialogEx.this.tree.isCollapsed(path)) {
                            KeyPropertiesDialogEx.this.tree.expandPath(path);
                        } else {
                            KeyPropertiesDialogEx.this.tree.collapsePath(path);
                        }
                        e.consume();
                    }
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.tree);
        pnImpact.add((Component)scrollPane, "Center");
        return pnImpact;
    }

    @Override
    protected JTree initImpactAnalysisTreeModel() {
        this.tree.addTreeWillExpandListener(this);
        CompareTreeNavigationDesign treeDesign = new CompareTreeNavigationDesign(new ImpA_KeyObject(this.key, null, true), false);
        ImpactTreeRenderer renderer = new ImpactTreeRenderer();
        this.tree.setModel(treeDesign);
        this.tree.setCellRenderer(renderer);
        return this.tree;
    }

    @Override
    protected boolean canExit() {
        if (super.canExit()) {
            return this.checkRequiredProperties();
        }
        return false;
    }

    protected boolean checkRequiredProperties() {
        if (this.selectedAttributesModel.isEmpty()) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("EntityPropertiesDialogEx.IncompleteUIDdefinition"), this.key.getName()), Messages.getString("EntityPropertiesDialogEx.UIDColumnsAssignment"), 0);
            return false;
        }
        return true;
    }

    protected boolean canBeUsed(Attribute attribute) {
        if (attribute.isOid()) {
            return true;
        }
        Datatype attributeDataType = attribute.getDataType();
        return !(attributeDataType instanceof StructuredType) && !(attributeDataType instanceof CollectionType) && LogicalDatatype.canBeUsedForPK(attributeDataType.getName());
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    private class AllAttributesModel
    extends DefaultListModel {
        private AllAttributesModel() {
        }

        public void filter() {
            for (Attribute attribute : KeyPropertiesDialogEx.this.getAttributesList()) {
                if (KeyPropertiesDialogEx.this.canBeUsed(attribute)) continue;
                super.removeElement(attribute);
            }
        }
    }

    class AllAttributesRelationsRenderer
    extends JLabel
    implements ListCellRenderer {
        AllAttributesRelationsRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value.toString());
            this.setOpaque(true);
            if (isSelected) {
                this.setBackground(KeyPropertiesDialogEx.this.selectedAttributesList.getSelectionBackground());
                if (value instanceof Relation) {
                    if (KeyPropertiesDialogEx.this.key.isPK() && KeyPropertiesDialogEx.this.couldBeCyclic((Relation)value)) {
                        this.setForeground(Color.RED);
                    } else {
                        this.setForeground(Color.WHITE);
                    }
                } else {
                    this.setForeground(Color.WHITE);
                }
            } else {
                this.setBackground(KeyPropertiesDialogEx.this.selectedAttributesList.getBackground());
                if (value instanceof Relation) {
                    if (KeyPropertiesDialogEx.this.key.isPK() && KeyPropertiesDialogEx.this.couldBeCyclic((Relation)value)) {
                        this.setForeground(Color.RED);
                    } else {
                        this.setForeground(KeyPropertiesDialogEx.this.selectedAttributesList.getForeground());
                    }
                } else {
                    this.setForeground(KeyPropertiesDialogEx.this.selectedAttributesList.getForeground());
                }
            }
            return this;
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!KeyPropertiesDialogEx.this.selectedAttributesModel.isEmpty()) {
                Object[] selectedObjects = KeyPropertiesDialogEx.this.selectedAttributesList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (KeyPropertiesDialogEx.this.allAttributesModel.contains(ob)) continue;
                    KeyPropertiesDialogEx.this.allAttributesModel.addElement(ob);
                    KeyPropertiesDialogEx.this.selectedAttributesModel.removeElement(ob);
                }
            }
        }
    }

    private class AddColumnsActionListener
    implements ActionListener {
        private AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!KeyPropertiesDialogEx.this.allAttributesModel.isEmpty()) {
                Object[] selectedObjects = KeyPropertiesDialogEx.this.allAttributesList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (KeyPropertiesDialogEx.this.selectedAttributesModel.contains(ob)) continue;
                    KeyPropertiesDialogEx.this.selectedAttributesModel.addElement(ob);
                    KeyPropertiesDialogEx.this.allAttributesModel.removeElement(ob);
                }
            }
        }
    }

    private class SelectedColumnsListSelectionHandler
    implements ListSelectionListener {
        private SelectedColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (KeyPropertiesDialogEx.this.isEditable() && !e.getValueIsAdjusting()) {
                if (KeyPropertiesDialogEx.this.selectedAttributesList.getSelectedIndex() == -1) {
                    KeyPropertiesDialogEx.this.btnRemoveAttributes.setEnabled(false);
                    KeyPropertiesDialogEx.this.btnUp.setEnabled(false);
                    KeyPropertiesDialogEx.this.btnDown.setEnabled(false);
                } else {
                    KeyPropertiesDialogEx.this.btnRemoveAttributes.setEnabled(true);
                    KeyPropertiesDialogEx.this.btnUp.setEnabled(true);
                    KeyPropertiesDialogEx.this.btnDown.setEnabled(true);
                }
            }
        }
    }

    private class AllColumnsListSelectionHandler
    implements ListSelectionListener {
        private AllColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (KeyPropertiesDialogEx.this.isEditable()) {
                Object selected = KeyPropertiesDialogEx.this.allAttributesList.getSelectedValue();
                if (!e.getValueIsAdjusting()) {
                    if (KeyPropertiesDialogEx.this.allAttributesList.getSelectedIndex() == -1) {
                        KeyPropertiesDialogEx.this.btnAddAttributes.setEnabled(false);
                    } else if (!(selected instanceof Relation) || KeyPropertiesDialogEx.this.key.isPK() && selected instanceof Relation && !KeyPropertiesDialogEx.this.couldBeCyclic((Relation)selected) || !KeyPropertiesDialogEx.this.key.isPK()) {
                        KeyPropertiesDialogEx.this.btnAddAttributes.setEnabled(true);
                    } else {
                        KeyPropertiesDialogEx.this.btnAddAttributes.setEnabled(false);
                    }
                }
            }
        }
    }

    private class MoveDownAction
    implements ActionListener {
        private MoveDownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int objectNumber;
            int[] selection = KeyPropertiesDialogEx.this.selectedAttributesList.getSelectedIndices();
            if (selection.length > 0 && (objectNumber = selection[selection.length - 1]) < KeyPropertiesDialogEx.this.selectedAttributesModel.size() - 1) {
                for (int i = selection.length - 1; i > -1; --i) {
                    objectNumber = selection[i];
                    Object obj = KeyPropertiesDialogEx.this.selectedAttributesModel.get(objectNumber);
                    KeyPropertiesDialogEx.this.moveToIndex(obj, objectNumber + 1);
                    selection[i] = objectNumber + 1;
                }
                KeyPropertiesDialogEx.this.selectedAttributesList.setSelectedIndices(selection);
                KeyPropertiesDialogEx.this.selectedAttributesList.updateUI();
            }
        }
    }

    private class MoveUpAction
    implements ActionListener {
        private MoveUpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int objectNumber;
            int[] selection = KeyPropertiesDialogEx.this.selectedAttributesList.getSelectedIndices();
            if (selection.length > 0 && (objectNumber = selection[0]) > 0) {
                for (int i = 0; i < selection.length; ++i) {
                    objectNumber = selection[i];
                    Object obj = KeyPropertiesDialogEx.this.selectedAttributesModel.get(objectNumber);
                    KeyPropertiesDialogEx.this.moveToIndex(obj, objectNumber - 1);
                    selection[i] = objectNumber - 1;
                }
                KeyPropertiesDialogEx.this.selectedAttributesList.setSelectedIndices(selection);
                KeyPropertiesDialogEx.this.selectedAttributesList.updateUI();
            }
        }
    }
}

