/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.WindowsTableHeader;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;

public class LegendPropertiesDialog
extends CustomDialog {
    private static final Dimension defaultSize = new Dimension(280, 20);
    private GUIConfiguration configuration = GUIConfiguration.getInstance();
    public static final String BTN_ADD = Messages.getString("AbstractPropertiesDialog.Add");
    public static final String BTN_REMOVE = Messages.getString("AbstractPropertiesDialog.Remove");
    private DesignPartView dpv;
    private JDialog dialog;
    private JPanel buttonPanel;
    private JTextField tfAuthor;
    private JTextField tfChangedBy;
    private JCheckBox chbAuthor;
    private JCheckBox chbCreatedOn;
    private JCheckBox chbModifiedOn;
    private JCheckBox chbChangedBy;
    private JCheckBox chbDesign;
    private JCheckBox chbModel;
    private JCheckBox chbApplyToAll;
    protected List<DynamicProperty> userDefinedPropertiesList;
    protected JTable userDefinedPropertiesTable;
    private int cgCounter = 0;
    private static final Logger LOGGER = new Logger(LegendPropertiesDialog.class);

    public LegendPropertiesDialog(ApplicationView appView, DesignPartView dpv) {
        super(appView);
        this.dpv = dpv;
        JPanel jpanel = new JPanel();
        jpanel.setBorder(BorderFactory.createEtchedBorder());
        jpanel.add(this.initGeneral());
        this.add((Component)jpanel, "Center");
        JPanel bottomPanel = this.getButtonPanel();
        this.add((Component)bottomPanel, "South");
        this.initProperties();
    }

    private JPanel initGeneral() {
        JPanel jpanel = new JPanel(new BorderLayout());
        JPanel pnGrid = new JPanel(new GridLayout(0, 1, 10, 10));
        jpanel.add((Component)pnGrid, "North");
        JLabel lbAuthor = new JLabel(Messages.getString("LegendPropertiesDialog.Author"));
        lbAuthor.setPreferredSize(defaultSize);
        this.tfAuthor = new JTextField();
        this.tfAuthor.setPreferredSize(defaultSize);
        pnGrid.add(this.createRow(lbAuthor, this.tfAuthor));
        JLabel lbChangedBy = new JLabel(Messages.getString("LegendPropertiesDialog.ModifiedBy"));
        lbChangedBy.setPreferredSize(defaultSize);
        this.tfChangedBy = new JTextField();
        this.tfChangedBy.setPreferredSize(defaultSize);
        pnGrid.add(this.createRow(lbChangedBy, this.tfChangedBy));
        JLabel lbShowAuthor = new JLabel(Messages.getString("LegendPropertiesDialog.ShowAuthor"));
        lbShowAuthor.setPreferredSize(defaultSize);
        this.chbAuthor = new JCheckBox();
        this.chbAuthor.setPreferredSize(defaultSize);
        pnGrid.add(this.createRow(lbShowAuthor, this.chbAuthor));
        JLabel lbShowCreatedOn = new JLabel(Messages.getString("LegendPropertiesDialog.ShowCreatedOn"));
        lbShowCreatedOn.setPreferredSize(defaultSize);
        this.chbCreatedOn = new JCheckBox();
        this.chbCreatedOn.setPreferredSize(defaultSize);
        pnGrid.add(this.createRow(lbShowCreatedOn, this.chbCreatedOn));
        JLabel lbShowModifiedOn = new JLabel(Messages.getString("LegendPropertiesDialog.ShowModifiedOn"));
        lbShowModifiedOn.setPreferredSize(defaultSize);
        this.chbModifiedOn = new JCheckBox();
        this.chbModifiedOn.setPreferredSize(defaultSize);
        pnGrid.add(this.createRow(lbShowModifiedOn, this.chbModifiedOn));
        JLabel lbShowChangedBy = new JLabel(Messages.getString("LegendPropertiesDialog.ShowModifiedBy"));
        lbShowChangedBy.setPreferredSize(defaultSize);
        this.chbChangedBy = new JCheckBox();
        this.chbChangedBy.setPreferredSize(defaultSize);
        pnGrid.add(this.createRow(lbShowChangedBy, this.chbChangedBy));
        JLabel lbShowDesignName = new JLabel(Messages.getString("LegendPropertiesDialog.ShowDesignName"));
        lbShowDesignName.setPreferredSize(defaultSize);
        this.chbDesign = new JCheckBox();
        this.chbDesign.setPreferredSize(defaultSize);
        pnGrid.add(this.createRow(lbShowDesignName, this.chbDesign));
        JLabel lbShowModelName = new JLabel(Messages.getString("LegendPropertiesDialog.ShowModelName"));
        lbShowModelName.setPreferredSize(defaultSize);
        this.chbModel = new JCheckBox();
        this.chbModel.setPreferredSize(defaultSize);
        pnGrid.add(this.createRow(lbShowModelName, this.chbModel));
        pnGrid.add(new JPanel());
        JPanel jpProps = new JPanel(new BorderLayout());
        jpProps.setBorder(BorderFactory.createTitledBorder(Messages.getString("LegendPropertiesDialog.UserDefinedProperties")));
        JButton btnAdd = new JButton(this.configuration.getIcon("ADD_ICON", 16));
        final JButton btnRemove = new JButton(this.configuration.getIcon("REMOVE_ICON", 16));
        btnRemove.setEnabled(false);
        this.userDefinedPropertiesList = new ArrayList<DynamicProperty>();
        this.userDefinedPropertiesTable = new JTable(new DynamicPropertiesModel()){

            @Override
            public void changeSelection(int row, int column, boolean toggle, boolean extend) {
                super.changeSelection(row, column, toggle, extend);
                if (this.editCellAt(row, column)) {
                    Component editor = this.getEditorComponent();
                    editor.requestFocusInWindow();
                }
            }
        };
        this.userDefinedPropertiesTable.setSelectionMode(0);
        this.userDefinedPropertiesTable.getTableHeader().setReorderingAllowed(false);
        this.userDefinedPropertiesTable.setCellSelectionEnabled(true);
        ListSelectionModel cellSelectionModel = this.userDefinedPropertiesTable.getSelectionModel();
        cellSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                String selectedData = null;
                int[] selectedRow = LegendPropertiesDialog.this.userDefinedPropertiesTable.getSelectedRows();
                int[] selectedColumns = LegendPropertiesDialog.this.userDefinedPropertiesTable.getSelectedColumns();
                for (int i = 0; i < selectedRow.length; ++i) {
                    for (int j = 0; j < selectedColumns.length; ++j) {
                        selectedData = (String)LegendPropertiesDialog.this.userDefinedPropertiesTable.getValueAt(selectedRow[i], selectedColumns[j]);
                        if (selectedData != null) {
                            btnRemove.setEnabled(true);
                            continue;
                        }
                        btnRemove.setEnabled(false);
                    }
                }
            }
        });
        JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
        buttonGeneral.setPreferredSize(new Dimension(325, 35));
        btnAdd.setToolTipText(BTN_ADD);
        btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LegendPropertiesDialog.this.userDefinedPropertiesTable.getRowSorter() != null) {
                    LegendPropertiesDialog.this.userDefinedPropertiesTable.getRowSorter().setSortKeys(null);
                }
                LegendPropertiesDialog.this.createAndAddDynamicProperty(LegendPropertiesDialog.this.generateDynamicProperyName(), "");
                if (LegendPropertiesDialog.this.userDefinedPropertiesList.size() == 1) {
                    LegendPropertiesDialog.this.initDynamicPropertiesTableSorter();
                }
                WindowsTableHeader.setSortedHeader(LegendPropertiesDialog.this.userDefinedPropertiesTable, 0);
                int lastRow = LegendPropertiesDialog.this.userDefinedPropertiesTable.convertRowIndexToView(LegendPropertiesDialog.this.userDefinedPropertiesList.size() - 1);
                LegendPropertiesDialog.this.userDefinedPropertiesTable.setRowSelectionInterval(lastRow, lastRow);
                LegendPropertiesDialog.this.userDefinedPropertiesTable.updateUI();
            }
        });
        btnRemove.setToolTipText(BTN_REMOVE);
        btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LegendPropertiesDialog.stopCellEditing(LegendPropertiesDialog.this.userDefinedPropertiesTable);
                int objectNumber = LegendPropertiesDialog.this.userDefinedPropertiesTable.convertRowIndexToModel(LegendPropertiesDialog.this.userDefinedPropertiesTable.getSelectedRow());
                if (objectNumber != -1) {
                    LegendPropertiesDialog.this.userDefinedPropertiesList.remove(objectNumber);
                    if (LegendPropertiesDialog.this.userDefinedPropertiesTable.getRowSorter() != null) {
                        if (LegendPropertiesDialog.this.userDefinedPropertiesList.size() >= 1) {
                            LegendPropertiesDialog.this.userDefinedPropertiesTable.getRowSorter().setSortKeys(null);
                        } else {
                            LegendPropertiesDialog.this.userDefinedPropertiesTable.setAutoCreateRowSorter(false);
                            LegendPropertiesDialog.this.userDefinedPropertiesTable.setRowSorter(null);
                            btnRemove.setEnabled(false);
                        }
                    }
                    LegendPropertiesDialog.this.userDefinedPropertiesTable.updateUI();
                }
                if (LegendPropertiesDialog.this.userDefinedPropertiesList.size() >= 1) {
                    WindowsTableHeader.setSortedHeader(LegendPropertiesDialog.this.userDefinedPropertiesTable, 0);
                }
            }
        });
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        if (this.isEditable()) {
            toolBar.add(btnAdd);
            toolBar.add(btnRemove);
        }
        buttonGeneral.add(toolBar);
        jpProps.add((Component)buttonGeneral, "North");
        jpProps.add((Component)new JScrollPane(this.userDefinedPropertiesTable), "Center");
        jpanel.add((Component)jpProps, "Center");
        jpanel.setPreferredSize(new Dimension(500, 480));
        return jpanel;
    }

    private void initDynamicPropertiesTableSorter() {
        if (this.userDefinedPropertiesList.size() > 0) {
            TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.userDefinedPropertiesTable.getModel());
            sorter.setSortsOnUpdates(true);
            this.userDefinedPropertiesTable.setRowSorter(sorter);
            this.userDefinedPropertiesTable.setAutoCreateRowSorter(true);
            WindowsTableHeader.setSortedHeader(this.userDefinedPropertiesTable, 0);
        }
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    private DynamicProperty createAndAddDynamicProperty(String name, String value) {
        DynamicProperty dp = new DynamicProperty("", "");
        dp.setName(name);
        dp.setValue(value);
        this.getDynamicPropertiesList().add(dp);
        return dp;
    }

    public List getDynamicPropertiesList() {
        if (this.userDefinedPropertiesList == null) {
            this.userDefinedPropertiesList = new ArrayList<DynamicProperty>();
        }
        return this.userDefinedPropertiesList;
    }

    protected String generateDynamicProperyName() {
        String name = "DynamicProperty";
        int newNumber = 0;
        int lastNumber = this.userDefinedPropertiesList.size();
        if (lastNumber != 0) {
            newNumber = this.cgCounter = lastNumber + 1;
        } else {
            ++this.cgCounter;
            newNumber = this.cgCounter;
        }
        String dpName = name.concat("_").concat(Integer.toString(newNumber));
        while (this.dynamicProperyExists(dpName)) {
            newNumber = ++this.cgCounter;
            dpName = name.concat("_").concat(Integer.toString(newNumber));
        }
        return dpName;
    }

    private boolean dynamicProperyExists(String name) {
        for (int i = 0; i < this.userDefinedPropertiesList.size(); ++i) {
            DynamicProperty dp = this.userDefinedPropertiesList.get(i);
            if (!name.equalsIgnoreCase(dp.getName())) continue;
            return true;
        }
        return false;
    }

    public void initProperties() {
        this.tfAuthor.setText(this.dpv.getCreatedBy());
        this.tfChangedBy.setText(this.dpv.getModifiedBy());
        this.chbAuthor.setSelected((this.dpv.getLegendAttributes() & 2) != 0);
        this.chbCreatedOn.setSelected((this.dpv.getLegendAttributes() & 4) != 0);
        this.chbModifiedOn.setSelected((this.dpv.getLegendAttributes() & 8) != 0);
        this.chbChangedBy.setSelected((this.dpv.getLegendAttributes() & 0x10) != 0);
        this.chbDesign.setSelected((this.dpv.getLegendAttributes() & 0x20) != 0);
        this.chbModel.setSelected((this.dpv.getLegendAttributes() & 0x40) != 0);
        this.initUserDefinedProperties();
    }

    private void setProperties() {
        if (this.chbApplyToAll.isSelected()) {
            Iterator it = this.dpv.getDesign().getAllDPVs().iterator();
            while (it.hasNext()) {
                this.setLegendProperties((DesignPartView)it.next());
            }
        } else {
            this.setLegendProperties(this.dpv);
        }
    }

    private void setLegendProperties(DesignPartView designPartView) {
        LegendPropertiesDialog.stopCellEditing(this.userDefinedPropertiesTable);
        designPartView.setDirty(true);
        designPartView.setCreatedBy(this.tfAuthor.getText());
        designPartView.setModifiedBy(this.tfChangedBy.getText());
        int attributes = 0;
        if (this.chbAuthor.isSelected()) {
            attributes |= 2;
        }
        if (this.chbCreatedOn.isSelected()) {
            attributes |= 4;
        }
        if (this.chbModifiedOn.isSelected()) {
            attributes |= 8;
        }
        if (this.chbChangedBy.isSelected()) {
            attributes |= 0x10;
        }
        if (this.chbDesign.isSelected()) {
            attributes |= 0x20;
        }
        if (this.chbModel.isSelected()) {
            attributes |= 0x40;
        }
        designPartView.setLegendAttributes(attributes);
        designPartView.clearProperties();
        for (DynamicProperty dp : this.userDefinedPropertiesList) {
            designPartView.setProperty(dp.getName(), dp.getValue());
        }
        designPartView.updateLegendSize();
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel(new BorderLayout());
            JPanel jpLeft = new JPanel();
            JPanel jpRight = new JPanel(new FlowLayout(2));
            JButton ok = new JButton(Messages.getString("LegendPropertiesDialog.OK"));
            ok.setMnemonic(79);
            ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LegendPropertiesDialog.this.setProperties();
                    LegendPropertiesDialog.this.close();
                }
            });
            JButton cancel = new JButton(Messages.getString("LegendPropertiesDialog.Cancel"));
            cancel.setMnemonic(67);
            cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LegendPropertiesDialog.this.close();
                }
            });
            ok.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            cancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            jpRight.add(ok);
            jpRight.add(cancel);
            this.chbApplyToAll = new JCheckBox(Messages.getString("LegendPropertiesDialog.ApplyToAllDiagrams"));
            jpLeft.add(this.chbApplyToAll);
            this.buttonPanel.add((Component)jpLeft, "West");
            this.buttonPanel.add(jpRight);
        }
        return this.buttonPanel;
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)Ide.getMainWindow(), Messages.getString("LegendPropertiesDialog.LegendProperties"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setResizable(false);
            this.dialog.setModal(true);
        }
        return this.dialog;
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected String getHelpIndex() {
        return null;
    }

    public void initUserDefinedProperties() {
        try {
            this.userDefinedPropertiesList.clear();
            Iterator it = this.dpv.getPropertyNames();
            while (it.hasNext()) {
                String propName = (String)it.next();
                String value = this.dpv.getProperty(propName);
                DynamicProperty dp = new DynamicProperty(propName, value);
                this.userDefinedPropertiesList.add(dp);
            }
            this.userDefinedPropertiesTable.updateUI();
            this.initDynamicPropertiesTableSorter();
        }
        catch (Exception e) {
            LOGGER.error("LegendPropertiesDialog: Unable to init user defined properties for : " + this.dpv.getName(), e);
        }
    }

    private class DynamicPropertiesModel
    extends AbstractTableModel {
        private DynamicPropertiesModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return LegendPropertiesDialog.this.userDefinedPropertiesList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("AbstractPropertiesDialog.PropertyName");
            }
            return Messages.getString("AbstractPropertiesDialog.PropertyValue");
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            DynamicProperty object = LegendPropertiesDialog.this.userDefinedPropertiesList.get(row);
            if (col == 0) {
                return object.getName();
            }
            if (col == 1) {
                return object.getValue();
            }
            return "";
        }

        @Override
        public void setValueAt(Object obj, int rowIndex, int columnIndex) {
            DynamicProperty dp = LegendPropertiesDialog.this.userDefinedPropertiesList.get(rowIndex);
            if (columnIndex == 0) {
                dp.setName(obj.toString());
            } else if (columnIndex == 1) {
                dp.setValue(obj.toString());
            }
        }
    }
}

