/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.CommonEditor;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class AbstractFieldEditor
extends JDialog
implements AbstractEditorConstants {
    private JTextArea editorPane;
    private JPanel buttonPanel;
    private ModelIDObject desObject;
    private int fieldId;
    private CommonEditor editor;

    public AbstractFieldEditor(Dialog owner, ApplicationView view, ModelIDObject object, int fieldId, CommonEditor editor) {
        super(owner);
        this.init(view, object, fieldId, editor);
    }

    public AbstractFieldEditor(ApplicationView view, ModelIDObject object, int fieldId, CommonEditor editor) {
        super(view.getFrame());
        this.init(view, object, fieldId, editor);
    }

    private void init(ApplicationView view, ModelIDObject object, int fieldId, CommonEditor editor) {
        this.desObject = object;
        this.fieldId = fieldId;
        this.editor = editor;
        this.setTitle(this.getCaption());
        JScrollPane scrollPane = new JScrollPane(this.getEditorPane());
        scrollPane.setPreferredSize(new Dimension(550, 450));
        this.getContentPane().add((Component)scrollPane, "Center");
        this.initProperties();
        this.setDefaultCloseOperation(2);
        JPanel bottomPanel = this.getButtonPanel();
        this.getContentPane().add((Component)bottomPanel, "South");
        this.pack();
        CommonUtil.centerOnScreen(this);
    }

    private void initProperties() {
        switch (this.fieldId) {
            case 1: {
                this.editorPane.setText(this.editor.getCommentField());
                this.editorPane.setCaretPosition(0);
                break;
            }
            case 2: {
                this.editorPane.setText(this.editor.getNotesField());
                this.editorPane.setCaretPosition(0);
                break;
            }
            case 4: {
                this.editorPane.setText(this.editor.getSynonymField());
                this.editorPane.setCaretPosition(0);
                break;
            }
        }
    }

    public String getCaption() {
        return Messages.getString("AbstractFieldEditor.Edit");
    }

    private void setProperties() {
        switch (this.fieldId) {
            case 1: {
                this.editor.setCommentField(this.editorPane.getText());
                break;
            }
            case 2: {
                this.editor.setNotesField(this.editorPane.getText());
                break;
            }
            case 4: {
                this.editor.setSynonymField(this.editorPane.getText());
                break;
            }
        }
    }

    protected JTextArea getEditorPane() {
        if (this.editorPane == null) {
            this.editorPane = new JTextArea();
            this.editorPane.setEnabled(this.isEditable());
        }
        return this.editorPane;
    }

    public void initProperties(Note note) {
        this.editorPane.setText(note.getText());
    }

    protected boolean isEditable() {
        if (ApplicationView.IS_VIEWER) {
            return false;
        }
        if (ApplicationView.LOGICAL_MODEL_ONLY) {
            if (this.desObject instanceof DesignObject) {
                return ((DesignObject)this.desObject).getDesignPart() instanceof LogicalDesign;
            }
            return false;
        }
        return true;
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            String cancelStr = Messages.getString("AbstractFieldEditor.Close");
            if (this.isEditable()) {
                JButton ok = new JButton(Messages.getString("AbstractFieldEditor.OK"));
                ok.setMnemonic(79);
                ok.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AbstractFieldEditor.this.setProperties();
                        AbstractFieldEditor.this.dispose();
                    }
                });
                ok.setPreferredSize(MessageDialogs.BUTTON_SIZE);
                this.buttonPanel.add(ok);
                cancelStr = Messages.getString("AbstractFieldEditor.Cancel");
            }
            JButton cancel = new JButton(cancelStr);
            cancel.setMnemonic(67);
            cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractFieldEditor.this.dispose();
                }
            });
            cancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.buttonPanel.add(cancel);
        }
        return this.buttonPanel;
    }
}

