/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.model.ChangeRequest;
import oracle.dbtools.crest.model.businessinfo.BIDocument;
import oracle.dbtools.crest.model.businessinfo.BIResponsibleParty;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Measurement;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.AddChangeRequestDialog;
import oracle.dbtools.crest.swingui.editor.ChangeRequestPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.CommonEditor;
import oracle.dbtools.crest.swingui.editor.MeasurementPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.swingui.editor.businessinfo.AddDocumentDialog;
import oracle.dbtools.crest.swingui.editor.businessinfo.AddPartyDialog;
import oracle.dbtools.crest.util.HelpManager;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.ide.Ide;

public abstract class AbstractEditor
extends JDialog
implements AbstractEditorConstants,
CommonEditor {
    public static final String BTN_PROPERTIES = Messages.getString("AbstractEditor.Properties");
    public static final String BTN_ADD = Messages.getString("AbstractEditor.Add");
    public static final String BTN_REMOVE = Messages.getString("AbstractEditor.Remove");
    private ApplicationView appView;
    private JTabbedPane tpane;
    protected JPanel generalPanel = new JPanel(new GridLayout(0, 1));
    protected JPanel summaryPanel = new JPanel(new GridLayout(0, 1));
    protected JPanel mPanel = new JPanel();
    protected JPanel reqPanel = new JPanel();
    protected JPanel rpPanel = new JPanel();
    protected JPanel docPanel = new JPanel();
    protected JLabel lbName;
    protected JTextField tfName;
    protected static final int FIELD_WIDTH = 150;
    protected static final int FIELD_HEIGHT = 20;
    protected StorageDesign storageDesign;
    protected JLabel lbComment;
    protected JLabel lbObjectID;
    protected JLabel lbCreator;
    protected JLabel lbCreationTime;
    protected JLabel lbLastChangedBy;
    protected JLabel lbLastChangedTime;
    protected JLabel lbGeneratorName;
    protected JLabel lbDesign;
    protected JTextField tfComment;
    protected JTextField tfObjectID;
    protected JTextField tfCreator;
    protected JTextField tfCreationTime;
    protected JTextField tfLastChangedBy;
    protected JTextField tfLastChangedTime;
    protected JTextField tfGeneratorName;
    protected JTextField tfDesign;
    protected JButton btnComment;
    protected JButton btnCommentInRDBMS;
    protected JButton btnDefaultValue;
    protected JButton btnNotes;
    protected JButton btnSynonym;
    private DesignObject desObject;
    private JButton bnCancel;
    protected JTable mtable;
    protected List mList = new ArrayList();
    protected JScrollPane mpane;
    private int counter = 0;
    protected JTable reqTable;
    protected List reqList = new ArrayList();
    protected JScrollPane reqPane;
    public String commentField = "";
    public String notesField = "";
    public String synonymField = "";
    protected JTable docTable;
    protected List docList = new ArrayList();
    protected JTable rpTable;
    protected List rpList = new ArrayList();
    protected JScrollPane rpPane;
    protected JScrollPane docPane;
    protected boolean canExit = true;
    private Action escape = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractEditor.this.bnCancel.doClick();
        }
    };
    private Action actF1 = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractEditor.this.showHelp();
        }
    };

    public AbstractEditor(Dialog owner, ApplicationView view, DesignObject object) {
        super(owner);
        this.init(view, object);
    }

    public AbstractEditor(ApplicationView view, DesignObject object) {
        super(view.getFrame());
        this.init(view, object);
    }

    private void init(ApplicationView view, DesignObject object) {
        this.desObject = object;
        this.appView = view;
        this.setTitle(this.getCaption());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                AbstractEditor.this.desObject.setDialogVisible(false, null);
            }

            @Override
            public void windowClosing(WindowEvent e) {
                AbstractEditor.this.desObject.setDialogVisible(false, null);
            }
        });
        this.tpane = new JTabbedPane();
        this.prepareTab(this.tpane, this.generalPanel, Messages.getString("AbstractEditor.General"), Messages.getString("AbstractEditor.GeneraPpropertiesForObject"));
        this.initGeneralView();
        this.initSummaryView();
        this.getContentPane().add((Component)this.tpane, "Center");
        JPanel bottomPanel = new JPanel();
        String cancelStr = Messages.getString("AbstractEditor.Close");
        if (this.isEditable()) {
            JButton bnOK = new JButton(BTN_OK);
            bnOK.addActionListener(new OKAction());
            bnOK.setMnemonic(79);
            this.getRootPane().setDefaultButton(bnOK);
            JButton btnApply = new JButton(BTN_APPLY);
            btnApply.addActionListener(new ApplyAction());
            btnApply.setMnemonic(65);
            bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            btnApply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            bottomPanel.add(bnOK);
            bottomPanel.add(btnApply);
            cancelStr = Messages.getString("AbstractEditor.Cancel");
        }
        this.bnCancel = new JButton(cancelStr);
        this.bnCancel.setMnemonic(67);
        this.bnCancel.addActionListener(new CancelAction());
        this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bottomPanel.add(this.bnCancel);
        JButton bnHelp = new JButton(new AbstractAction(Messages.getString("AbstractEditor.Help")){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractEditor.this.showHelp();
            }
        });
        bnHelp.setMnemonic(72);
        bnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bottomPanel.add(bnHelp);
        int condition = 1;
        JComponent c = (JComponent)this.getContentPane();
        c.getInputMap(condition).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        c.getActionMap().put("ESCAPE", this.escape);
        KeyStroke ksF1 = KeyStroke.getKeyStroke(112, 0, false);
        c.getInputMap(condition).put(ksF1, "KEY_F1");
        c.getActionMap().put("KEY_F1", this.actF1);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.setResizable(false);
    }

    public DesignObject getDesignObject() {
        return this.desObject;
    }

    protected void showHelp() {
        HelpManager.showTopic((Component)Ide.getMainWindow(), this.getHelpIndex());
    }

    protected String getHelpIndex() {
        return "";
    }

    protected void initTabs() {
    }

    private void initSummaryView() {
        this.lbObjectID = new JLabel(LB_OBJECT_ID);
        this.lbObjectID.setPreferredSize(new Dimension(150, 20));
        this.tfObjectID = new JTextField();
        this.tfObjectID.setPreferredSize(this.lbObjectID.getPreferredSize());
        JPanel row = this.newRow(this.lbObjectID, this.tfObjectID);
        this.tfObjectID.setEditable(false);
        this.summaryPanel.add(row);
        this.lbCreator = new JLabel(LB_CREATOR);
        this.lbCreator.setPreferredSize(this.lbObjectID.getPreferredSize());
        this.tfCreator = new JTextField();
        this.tfCreator.setPreferredSize(this.lbObjectID.getPreferredSize());
        row = this.newRow(this.lbCreator, this.tfCreator);
        this.tfCreator.setEditable(false);
        this.summaryPanel.add(row);
        this.lbCreationTime = new JLabel(LB_CREATION_TIME);
        this.lbCreationTime.setPreferredSize(this.lbObjectID.getPreferredSize());
        this.tfCreationTime = new JTextField();
        this.tfCreationTime.setPreferredSize(this.lbObjectID.getPreferredSize());
        row = this.newRow(this.lbCreationTime, this.tfCreationTime);
        this.tfCreationTime.setEditable(false);
        this.summaryPanel.add(row);
        this.lbLastChangedBy = new JLabel(LB_LAST_CHANGED_BY);
        this.lbLastChangedBy.setPreferredSize(this.lbObjectID.getPreferredSize());
        this.tfLastChangedBy = new JTextField();
        this.tfLastChangedBy.setPreferredSize(this.lbObjectID.getPreferredSize());
        row = this.newRow(this.lbLastChangedBy, this.tfLastChangedBy);
        this.tfLastChangedBy.setEditable(false);
        this.summaryPanel.add(row);
        this.lbLastChangedTime = new JLabel(LB_LAST_CHANGED_TIME);
        this.lbLastChangedTime.setPreferredSize(this.lbObjectID.getPreferredSize());
        this.tfLastChangedTime = new JTextField();
        this.tfLastChangedTime.setPreferredSize(this.lbObjectID.getPreferredSize());
        row = this.newRow(this.lbLastChangedTime, this.tfLastChangedTime);
        this.tfLastChangedTime.setEditable(false);
        this.summaryPanel.add(row);
        this.lbGeneratorName = new JLabel(LB_GENERATOR_NAME);
        this.lbGeneratorName.setPreferredSize(this.lbObjectID.getPreferredSize());
        this.tfGeneratorName = new JTextField();
        this.tfGeneratorName.setPreferredSize(this.lbObjectID.getPreferredSize());
        row = this.newRow(this.lbGeneratorName, this.tfGeneratorName);
        this.tfGeneratorName.setEditable(false);
        this.summaryPanel.add(row);
        this.lbDesign = new JLabel(LB_DESIGN);
        this.lbDesign.setPreferredSize(this.lbObjectID.getPreferredSize());
        this.tfDesign = new JTextField();
        this.tfDesign.setPreferredSize(this.lbObjectID.getPreferredSize());
        row = this.newRow(this.lbDesign, this.tfDesign);
        this.tfDesign.setEditable(false);
        this.summaryPanel.add(row);
    }

    private void initMeasurementsView() {
        MeasurementModel mModel = new MeasurementModel();
        this.mtable = new JTable(mModel);
        this.mtable.setSelectionMode(0);
        this.mtable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Measurement m;
                int row;
                if (e.getClickCount() == 2 && (row = AbstractEditor.this.mtable.getSelectedRow()) != -1 && AbstractEditor.this.mList.size() > 0 && row < AbstractEditor.this.mList.size() && !(m = (Measurement)AbstractEditor.this.mList.get(row)).isDialogVisible()) {
                    MeasurementPropertiesDialog dialog = new MeasurementPropertiesDialog(AbstractEditor.this.getAppView(), m);
                    dialog.initProperties(m);
                    dialog.show();
                    AbstractEditor.this.mtable.updateUI();
                }
            }
        });
        this.mpane = new JScrollPane(this.mtable);
        JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
        buttonGeneral.setPreferredSize(new Dimension(325, 35));
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        JButton btnProperties = new JButton(configuration.getIcon("PROPERTIES_ICON", this.getPreferredIconSize()));
        btnProperties.setToolTipText(BTN_PROPERTIES);
        btnProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Measurement m;
                int row = AbstractEditor.this.mtable.getSelectedRow();
                if (row != -1 && AbstractEditor.this.mList.size() > 0 && row < AbstractEditor.this.mList.size() && !(m = (Measurement)AbstractEditor.this.mList.get(row)).isDialogVisible()) {
                    MeasurementPropertiesDialog dialog = new MeasurementPropertiesDialog(AbstractEditor.this.getAppView(), m);
                    dialog.initProperties(m);
                    dialog.show();
                    AbstractEditor.this.mtable.updateUI();
                }
            }
        });
        JButton btnAdd = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
        btnAdd.setToolTipText(BTN_ADD);
        btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Measurement m = new Measurement(AbstractEditor.this.desObject.getDesignPart());
                m.setName(AbstractEditor.this.generateMeasurementName());
                m.setDesign(AbstractEditor.this.desObject.getDesign());
                m.setObject(AbstractEditor.this.desObject);
                AbstractEditor.this.mList.add(m);
                AbstractEditor.this.mtable.updateUI();
            }
        });
        JButton btnRemove = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
        btnRemove.setToolTipText(BTN_REMOVE);
        btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int objectNumber = AbstractEditor.this.mtable.getSelectedRow();
                if (objectNumber != -1 && AbstractEditor.this.mList.size() > 0 && objectNumber < AbstractEditor.this.mList.size()) {
                    AbstractEditor.this.mList.remove(objectNumber);
                    AbstractEditor.this.mtable.updateUI();
                }
            }
        });
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.add(btnProperties);
        toolBar.addSeparator();
        toolBar.add(btnAdd);
        toolBar.add(btnRemove);
        buttonGeneral.add(toolBar);
        this.mPanel.add((Component)buttonGeneral, "North");
        this.mPanel.add(this.mpane);
    }

    protected String generateMeasurementName() {
        String m = "Measurement";
        int newNumber = 0;
        int lastNumber = this.mList.size();
        if (lastNumber != 0) {
            newNumber = this.counter = lastNumber + 1;
        } else {
            ++this.counter;
            newNumber = this.counter;
        }
        String mName = m.concat("_").concat(Integer.toString(newNumber));
        while (this.measurementExists(mName)) {
            newNumber = ++this.counter;
            mName = m.concat("_").concat(Integer.toString(newNumber));
        }
        return mName;
    }

    private boolean measurementExists(String name) {
        for (int i = 0; i < this.mList.size(); ++i) {
            Measurement m = (Measurement)this.mList.get(i);
            if (!name.equalsIgnoreCase(m.getName())) continue;
            return true;
        }
        return false;
    }

    public String getCaption() {
        return Messages.getString("AbstractEditor.Properties");
    }

    private void initChangeRequestsView() {
        this.reqList.addAll(this.desObject.getRequests());
        this.reqTable = new JTable(new ChangeRequestModel());
        this.reqTable.setSelectionMode(0);
        this.reqTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row;
                if (e.getClickCount() == 2 && (row = AbstractEditor.this.reqTable.getSelectedRow()) != -1 && AbstractEditor.this.reqList.size() > 0 && row < AbstractEditor.this.reqList.size()) {
                    ChangeRequest request = (ChangeRequest)AbstractEditor.this.reqList.get(row);
                    ChangeRequestPropertiesDialog dialog = new ChangeRequestPropertiesDialog(AbstractEditor.this.getAppView(), request);
                    dialog.initProperties(request);
                    dialog.show();
                    AbstractEditor.this.reqTable.updateUI();
                }
            }
        });
        this.reqPane = new JScrollPane(this.reqTable);
        JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
        buttonGeneral.setPreferredSize(new Dimension(325, 35));
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        JButton btnProperties = new JButton(configuration.getIcon("PROPERTIES_ICON", this.getPreferredIconSize()));
        btnProperties.setToolTipText(Messages.getString("AbstractEditor.Properties"));
        btnProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = AbstractEditor.this.reqTable.getSelectedRow();
                if (row != -1 && AbstractEditor.this.reqList.size() > 0 && row < AbstractEditor.this.reqList.size()) {
                    ChangeRequest request = (ChangeRequest)AbstractEditor.this.reqList.get(row);
                    ChangeRequestPropertiesDialog dialog = new ChangeRequestPropertiesDialog(AbstractEditor.this.getAppView(), request);
                    dialog.initProperties(request);
                    dialog.show();
                    AbstractEditor.this.reqTable.updateUI();
                }
            }
        });
        JButton btnAdd = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
        btnAdd.setToolTipText(Messages.getString("AbstractEditor.Add"));
        btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddChangeRequestDialog dialog = new AddChangeRequestDialog(AbstractEditor.this.getAppView(), AbstractEditor.this.desObject, AbstractEditor.this.reqList);
                dialog.showDialog();
                AbstractEditor.this.reqTable.updateUI();
            }
        });
        JButton btnRemove = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
        btnRemove.setToolTipText(Messages.getString("AbstractEditor.Remove"));
        btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int objectNumber = AbstractEditor.this.reqTable.getSelectedRow();
                if (objectNumber != -1 && AbstractEditor.this.reqList.size() > 0 && objectNumber < AbstractEditor.this.reqList.size()) {
                    AbstractEditor.this.reqList.remove(objectNumber);
                    AbstractEditor.this.reqTable.updateUI();
                }
            }
        });
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.add(btnProperties);
        toolBar.addSeparator();
        toolBar.add(btnAdd);
        toolBar.add(btnRemove);
        buttonGeneral.add(toolBar);
        this.reqPanel.add((Component)buttonGeneral, "North");
        this.reqPanel.add(this.reqPane);
    }

    private void initResPartiesView() {
        this.rpList.addAll(this.desObject.getResponsibleParties());
        this.rpTable = new JTable(new ResPartyModel());
        this.rpTable.setSelectionMode(0);
        this.rpTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row;
                if (e.getClickCount() == 2 && (row = AbstractEditor.this.rpTable.getSelectedRow()) != -1 && AbstractEditor.this.rpList.size() > 0 && row < AbstractEditor.this.rpList.size()) {
                    DesignObject object = (DesignObject)AbstractEditor.this.rpList.get(row);
                    object.showPropertyDialog();
                }
            }
        });
        this.rpPane = new JScrollPane(this.rpTable);
        JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
        buttonGeneral.setPreferredSize(new Dimension(325, 35));
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        JButton btnProperties = new JButton(configuration.getIcon("PROPERTIES_ICON", this.getPreferredIconSize()));
        btnProperties.setToolTipText(Messages.getString("AbstractEditor.Properties"));
        btnProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = AbstractEditor.this.rpTable.getSelectedRow();
                if (row != -1 && AbstractEditor.this.rpList.size() > 0 && row < AbstractEditor.this.rpList.size()) {
                    DesignObject object = (DesignObject)AbstractEditor.this.rpList.get(row);
                    object.showPropertyDialog();
                }
            }
        });
        JButton btnAdd = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
        btnAdd.setToolTipText(Messages.getString("AbstractEditor.Add"));
        btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddPartyDialog dialog = new AddPartyDialog(AbstractEditor.this.getAppView(), AbstractEditor.this.desObject.getDesign(), AbstractEditor.this.rpList);
                dialog.setVisible(true);
                AbstractEditor.this.rpTable.updateUI();
            }
        });
        JButton btnRemove = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
        btnRemove.setToolTipText(Messages.getString("AbstractEditor.Remove"));
        btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int objectNumber = AbstractEditor.this.rpTable.getSelectedRow();
                if (objectNumber != -1 && AbstractEditor.this.rpList.size() > 0 && objectNumber < AbstractEditor.this.rpList.size()) {
                    AbstractEditor.this.rpList.remove(objectNumber);
                    AbstractEditor.this.rpTable.updateUI();
                }
            }
        });
        this.rpPanel = new JPanel();
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.add(btnProperties);
        toolBar.addSeparator();
        toolBar.add(btnAdd);
        toolBar.add(btnRemove);
        buttonGeneral.add(toolBar);
        this.rpPanel.add((Component)buttonGeneral, "North");
        this.rpPanel.add(this.rpPane);
    }

    private void initDocumentsTab() {
        this.docList.addAll(this.desObject.getDocuments());
        this.docTable = new JTable(new DocumentTableModel());
        this.docTable.setSelectionMode(0);
        this.docTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row;
                if (e.getClickCount() == 2 && (row = AbstractEditor.this.docTable.getSelectedRow()) != -1 && AbstractEditor.this.docList.size() > 0 && row < AbstractEditor.this.docList.size()) {
                    DesignObject object = (DesignObject)AbstractEditor.this.docList.get(row);
                    object.showPropertyDialog();
                }
            }
        });
        this.docPane = new JScrollPane(this.docTable);
        JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
        buttonGeneral.setPreferredSize(new Dimension(325, 35));
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        JButton btnProperties = new JButton(configuration.getIcon("PROPERTIES_ICON", this.getPreferredIconSize()));
        btnProperties.setToolTipText(Messages.getString("AbstractEditor.Properties"));
        btnProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = AbstractEditor.this.docTable.getSelectedRow();
                if (row != -1 && AbstractEditor.this.docList.size() > 0 && row < AbstractEditor.this.docList.size()) {
                    DesignObject object = (DesignObject)AbstractEditor.this.docList.get(row);
                    object.showPropertyDialog();
                }
            }
        });
        JButton btnAdd = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
        btnAdd.setToolTipText(Messages.getString("AbstractEditor.Add"));
        btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddDocumentDialog dialog = new AddDocumentDialog(AbstractEditor.this.getAppView(), AbstractEditor.this.desObject.getDesign(), AbstractEditor.this.docList);
                dialog.setVisible(true);
                AbstractEditor.this.docTable.updateUI();
            }
        });
        JButton btnRemove = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
        btnRemove.setToolTipText(Messages.getString("AbstractEditor.Remove"));
        btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int objectNumber = AbstractEditor.this.docTable.getSelectedRow();
                if (objectNumber != -1 && AbstractEditor.this.docList.size() > 0 && objectNumber < AbstractEditor.this.docList.size()) {
                    AbstractEditor.this.docList.remove(objectNumber);
                    AbstractEditor.this.docTable.updateUI();
                }
            }
        });
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.add(btnProperties);
        toolBar.addSeparator();
        toolBar.add(btnAdd);
        toolBar.add(btnRemove);
        buttonGeneral.add(toolBar);
        this.docPane.setPreferredSize(new Dimension(325, 180));
        this.docPanel = new JPanel();
        this.docPanel.add((Component)buttonGeneral, "North");
        this.docPanel.add(this.docPane);
        this.getPane().addTab(Messages.getString("AbstractEditor.Documents"), this.docPanel);
    }

    public abstract void initProperties(DesignObject var1);

    protected abstract void setProperties();

    protected void removeIndexElements() {
    }

    protected void initGeneralView() {
        this.lbName = new JLabel(LB_NAME);
        this.lbName.setPreferredSize(new Dimension(150, 20));
        this.tfName = new JTextField();
        this.tfName.setPreferredSize(this.lbName.getPreferredSize());
        this.tfName.setEnabled(this.isEditable());
        JPanel row = this.newRow(this.lbName, this.tfName);
        this.generalPanel.add(row);
        this.lbComment = new JLabel(LB_COMMENT);
        this.lbComment.setPreferredSize(this.lbName.getPreferredSize());
        this.btnComment = new JButton();
        this.btnComment.setPreferredSize(this.lbName.getPreferredSize());
        this.btnComment.setHorizontalAlignment(2);
        this.btnComment.setFont(new Font(this.btnComment.getFont().getName(), 0, this.btnComment.getFont().getSize()));
        row = this.newRow(this.lbComment, this.btnComment);
        this.generalPanel.add(row);
    }

    protected JPanel newRow(JLabel lbName, Component field) {
        JPanel newRow = new JPanel();
        newRow.add(lbName);
        newRow.add(field);
        return newRow;
    }

    public JTabbedPane getPane() {
        return this.tpane;
    }

    public ApplicationView getAppView() {
        return this.appView;
    }

    public void fillComboItems(Object[] items, JComboBox comboBox) {
        comboBox.addItem(null);
        for (int i = 0; i < items.length; ++i) {
            comboBox.addItem(items[i]);
        }
    }

    public void fillComboItems(Object[] items, JComboBox comboBox, Object exclude) {
        comboBox.addItem(null);
        for (int i = 0; i < items.length; ++i) {
            Object object = items[i];
            if (object.equals(exclude)) continue;
            comboBox.addItem(items[i]);
        }
    }

    public void setBG(Component c) {
        c.setBackground(Color.WHITE);
        if (!c.getFont().isPlain()) {
            c.setFont(new Font(c.getFont().getName(), 0, c.getFont().getSize()));
        }
    }

    public void selectObject(JComboBox combo, StorageObject storageObject) {
        combo.setSelectedItem(storageObject);
    }

    protected void initCaption(String name) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getCaption()).append(" - ").append(name);
        this.setTitle(buffer.toString());
    }

    protected void setHeight(int height) {
        this.getPane().setPreferredSize(new Dimension(350, height));
    }

    protected void prepareTab(JTabbedPane tpane, JPanel tabPanel, String label, String tooltip) {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridwidth = 0;
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 0;
        panel.add((Component)tabPanel, gbc);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = -1;
        gbc.gridy = -1;
        panel.add((Component)new JPanel(), gbc);
        tpane.addTab(label, null, new JScrollPane(panel), tooltip);
    }

    protected int getPreferredIconSize() {
        return 16;
    }

    public void addSummaryTab() {
        this.prepareTab(this.tpane, this.summaryPanel, Messages.getString("AbstractEditor.Summary"), Messages.getString("AbstractEditor.SummaryPropertiesForObject"));
    }

    public void addMeasurementTab(Dimension dim) {
        this.initMeasurementsView();
        this.mpane.setPreferredSize(dim);
        this.getPane().addTab(Messages.getString("AbstractEditor.Measurements"), this.mPanel);
    }

    public void addChangeRequestsTab(Dimension dim) {
        this.initChangeRequestsView();
        this.reqPane.setPreferredSize(dim);
        this.getPane().addTab(Messages.getString("AbstractEditor.ChangeRequests"), this.reqPanel);
    }

    protected void setChangeRequests() {
        this.desObject.clearRequests();
        for (ChangeRequest request : this.reqList) {
            this.desObject.addRequest(request);
        }
    }

    public void addResPartyTab(Dimension dim) {
        this.initResPartiesView();
        this.rpPane.setPreferredSize(dim);
        this.getPane().addTab(Messages.getString("AbstractEditor.ResponsibleParties"), this.rpPanel);
    }

    protected void setResParties() {
        this.desObject.clearResponsibleParties();
        for (BIResponsibleParty party : this.rpList) {
            this.desObject.addResponsibleParty(party);
        }
    }

    public void addDocumentsTab(Dimension dim) {
        this.initDocumentsTab();
        this.docPane.setPreferredSize(dim);
        this.getPane().addTab(Messages.getString("AbstractEditor.Documents"), this.docPanel);
    }

    protected void setDocuments() {
        this.desObject.clearDocuments();
        for (BIDocument doc : this.docList) {
            this.desObject.addDocument(doc);
        }
    }

    @Override
    public String getCommentField() {
        if (this.commentField.equalsIgnoreCase("")) {
            this.commentField = this.desObject.getComment();
        }
        return this.commentField;
    }

    @Override
    public void setCommentField(String commentField) {
        this.commentField = commentField;
        this.btnComment.setText(commentField);
    }

    @Override
    public String getNotesField() {
        if (this.notesField.equalsIgnoreCase("")) {
            this.notesField = this.desObject.getNotes();
        }
        return this.notesField;
    }

    @Override
    public void setNotesField(String notesField) {
        this.notesField = notesField;
        this.btnNotes.setText(notesField);
    }

    @Override
    public String getSynonymField() {
        if (this.synonymField.equalsIgnoreCase("")) {
            if (this.desObject instanceof AbstractProcessObject) {
                this.synonymField = ((AbstractProcessObject)this.desObject).getSynonym();
            } else if (this.desObject instanceof Entity) {
                this.synonymField = ((Entity)this.desObject).getSynonym();
            }
        }
        return this.synonymField;
    }

    @Override
    public void setSynonymField(String synonymField) {
        this.synonymField = synonymField;
        this.btnSynonym.setText(synonymField);
    }

    protected void cleanGenerated() {
    }

    protected void selectName() {
        this.tfName.requestFocus();
        this.tfName.selectAll();
    }

    @Override
    public void show() {
        if (this.desObject.showModal) {
            this.setModal(true);
        }
        super.show();
        this.selectName();
        this.desObject.setDialogVisible(true, this);
    }

    protected boolean isEditable() {
        if (this.getDesignObject().getDesign().isHidden()) {
            return false;
        }
        if (this.desObject.isReadOnly()) {
            return false;
        }
        if (ApplicationView.IS_VIEWER) {
            return false;
        }
        if (ApplicationView.LOGICAL_MODEL_ONLY) {
            return this.desObject.getDesignPart() instanceof LogicalDesign;
        }
        return true;
    }

    protected String translate(String value, String[] inputValues, String[] outputValues) {
        for (int i = 0; i < inputValues.length; ++i) {
            if (!inputValues[i].equals(value)) continue;
            return outputValues[i];
        }
        return "";
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractEditor.this.removeIndexElements();
            AbstractEditor.this.cleanGenerated();
            AbstractEditor.this.dispose();
        }
    }

    private class ApplyAction
    implements ActionListener {
        private ApplyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractEditor.this.setProperties();
            AbstractEditor.this.desObject.setDirty(true);
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractEditor.this.setProperties();
            if (AbstractEditor.this.canExit) {
                AbstractEditor.this.desObject.setDirty(true);
                AbstractEditor.this.dispose();
            }
        }
    }

    private class DocumentTableModel
    extends AbstractTableModel {
        private DocumentTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return AbstractEditor.this.docList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("AbstractEditor.Documents");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            DesignObject object = (DesignObject)AbstractEditor.this.docList.get(row);
            if (col == 0) {
                return object.getName();
            }
            return new Integer(row * col);
        }
    }

    private class ResPartyModel
    extends AbstractTableModel {
        private ResPartyModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return AbstractEditor.this.rpList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("AbstractEditor.ResponsibleParties");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            DesignObject object = (DesignObject)AbstractEditor.this.rpList.get(row);
            if (col == 0) {
                return object.getName();
            }
            return new Integer(row * col);
        }
    }

    private class ChangeRequestModel
    extends AbstractTableModel {
        private ChangeRequestModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return AbstractEditor.this.reqList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("AbstractEditor.ChangeRequest");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            ChangeRequest request = (ChangeRequest)AbstractEditor.this.reqList.get(row);
            if (col == 0) {
                return request.getName();
            }
            return new Integer(row * col);
        }
    }

    public class MeasurementModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return AbstractEditor.this.mList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("AbstractEditor.Measurement");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            Measurement m = (Measurement)AbstractEditor.this.mList.get(row);
            if (col == 0) {
                return m.getName();
            }
            return null;
        }
    }
}

