/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.dmw;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.regex.PatternSyntaxException;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Screen;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultRowSorter;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.imports.DBConnectionStamp;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.ImpliedForeignKey;
import oracle.dbtools.crest.model.design.relational.Join;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.Messages;
import oracle.dbtools.crest.swingui.WindowsTableHeader;
import oracle.dbtools.crest.swingui.engineeringcompare.CompareTabularViewReportDialog;
import oracle.dbtools.crest.swingui.relational.DPVRelational;
import oracle.dbtools.crest.swingui.wizards.metadata.AbstractDBMExtractionWizardImpl;
import oracle.dbtools.crest.swingui.wizards.metadata.connection.ConnectionInfo;
import oracle.dbtools.crest.swingui.wizards.reports.ReportUtils;
import oracle.dbtools.crest.util.HelpManager;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.dmweb.DiagramProcessor;
import oracle.dbtools.crest.util.dmweb.DiagramToJSON;
import oracle.dbtools.crest.util.dmweb.DiagramToSVG;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.Settings;
import oracle.dbtools.util.Closeables;
import oracle.ide.Ide;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnections;

public class CompareDBDiagramsDialog
extends JDialog {
    private JPanel tabularView = new JPanel();
    private List<SelectionPair> listedObects = new ArrayList<SelectionPair>();
    private Map objectTypes = new TreeMap();
    private List<String> objectTypesList_ALL = new ArrayList<String>();
    private List<SelectionPair> allObjects = new ArrayList<SelectionPair>();
    public static String UNCHANGED = oracle.dbtools.crest.swingui.engineeringcompare.Messages.getString("EngineeringCompareDialog.Unchanged");
    public static String MODIFIED = oracle.dbtools.crest.swingui.engineeringcompare.Messages.getString("EngineeringCompareDialog.Modified");
    public static String NEW = oracle.dbtools.crest.swingui.engineeringcompare.Messages.getString("EngineeringCompareDialog.New");
    public static String DELETED = oracle.dbtools.crest.swingui.engineeringcompare.Messages.getString("EngineeringCompareDialog.Deleted");
    private String STATUS = oracle.dbtools.crest.swingui.engineeringcompare.Messages.getString("EngineeringCompareDialog.Status");
    private String TYPE = oracle.dbtools.crest.swingui.engineeringcompare.Messages.getString("EngineeringCompareDialog.Type");
    private String DIAGRAM_TYPE = oracle.dbtools.crest.swingui.engineeringcompare.Messages.getString("EngineeringCompareDialog.DiagramType2");
    private String DESIGN = oracle.dbtools.crest.swingui.engineeringcompare.Messages.getString("EngineeringCompareDialog.Design");
    private String SELECTED = oracle.dbtools.crest.swingui.engineeringcompare.Messages.getString("EngineeringCompareDialog.Selected");
    private String FILTER_BY_STATUS = oracle.dbtools.crest.swingui.engineeringcompare.Messages.getString("EngineeringCompareDialog.FilterByStatus");
    private String FILTER_BY_TYPE = oracle.dbtools.crest.swingui.engineeringcompare.Messages.getString("EngineeringCompareDialog.FilterByType");
    private String FILTER_BY_MODEL = oracle.dbtools.crest.swingui.engineeringcompare.Messages.getString("EngineeringCompareDialog.FilterByModel");
    private String MODEL = oracle.dbtools.crest.swingui.engineeringcompare.Messages.getString("EngineeringCompareDialog.Model2");
    private String LOCAL_DIAGRAM = oracle.dbtools.crest.swingui.engineeringcompare.Messages.getString("CompareDBDiagramsDialog.LocalDiagram");
    private String REMOTE_DIAGRAM = oracle.dbtools.crest.swingui.engineeringcompare.Messages.getString("CompareDBDiagramsDialog.RemoteDiagram");
    private String DESCRIPTION = oracle.dbtools.crest.swingui.compare.Messages.getString("CompareModelsDialog.Description");
    private static String EMPTY = "";
    private static String MAIN_PRIMARY = "Main Primary";
    private static String MAIN_DISPLAY = "Main Display";
    private static String SV_PRIMARY = "Sibview Primary";
    private static String SV_DISPLAY = "Subview Display";
    private static String DMW_DIAGRAM = "DM Web";
    private static String DMW_DIAGRAM_TYPE = "DMW";
    private static HashMap<String, String> DTYPE_TO_NAME = new HashMap();
    private static HashMap<String, String> DNAME_TO_TYPE = new HashMap();
    private JToolBar toolBar;
    private JButton selectAll;
    private JButton deselectAll;
    private JTable table;
    private JTextField filterText;
    private static String ALL;
    private static String ALL_;
    public static String[] STATUSES;
    private JComboBox cbTypes;
    private JComboBox cbStatuses;
    private List models = new ArrayList();
    boolean useModels = false;
    boolean allDiagrams = false;
    private ApplicationView appView;
    private boolean compareModels = false;
    private boolean dmdImport = false;
    private String reportCaption = "";
    private DPVRelational dpv;
    private RelationalDesign rm;
    private List<DPVRelational> diagrams;
    private List<DiagramHelper> rdiagrams = new ArrayList<DiagramHelper>();
    private CompareHTMLPanel compareHTMLPanel;
    private boolean importing = false;
    private static final Logger LOGGER;
    JSplitPane split;
    JButton bnOK;
    private JComboBox cbConn;

    public CompareDBDiagramsDialog(Window w, final DPVRelational dpv, final List<DPVRelational> diagrams, boolean allDiagrams, final boolean importing) {
        super(w, importing ? DPVRelational.IMPORT_DIAGRAMS_FROM_DATABASE : (diagrams.size() == 1 ? DPVRelational.EXPORT_DIAGRAM_TO_DATABASE : DPVRelational.EXPORT_ALL_DIAGRAMS_TO_DATABASE));
        this.appView = dpv.getApplicationView();
        this.allDiagrams = allDiagrams;
        this.dpv = dpv;
        this.rm = (RelationalDesign)dpv.getDesignPart();
        this.diagrams = diagrams;
        this.importing = importing;
        this.buildInitialTabularModel(dpv);
        this.initTabularView();
        JPanel panel = new JPanel(new BorderLayout());
        JToolBar tb = new JToolBar();
        tb.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        JLabel lbConn = new JLabel(oracle.dbtools.crest.exports.Messages.getString("AWExportOptions.JDBCConnection") + ":");
        lbConn.setPreferredSize(new Dimension(150, MessageDialogs.BUTTON_SIZE_EX.height - 2));
        lbConn.setMinimumSize(new Dimension(150, MessageDialogs.BUTTON_SIZE_EX.height - 2));
        tb.add(lbConn);
        this.cbConn = new JComboBox();
        this.cbConn.setPreferredSize(new Dimension(120, MessageDialogs.BUTTON_SIZE_EX.height - 2));
        this.cbConn.setMaximumSize(new Dimension(150, MessageDialogs.BUTTON_SIZE_EX.height - 2));
        this.cbConn.setRenderer(new ComboBoxRenderer());
        CompareDBDiagramsDialog.updateConnections(this.cbConn, dpv.getDesignPart());
        tb.add(this.cbConn);
        this.cbConn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompareDBDiagramsDialog.this.setSelectedColor();
            }
        });
        JButton but = new JButton("Get Diagrams");
        but.setMinimumSize(MessageDialogs.BUTTON_SIZE);
        but.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        Border b = BorderFactory.createBevelBorder(1);
        b = BorderFactory.createLineBorder(Color.black, 3);
        but.setBorder(b);
        but.setBorderPainted(true);
        tb.add(but);
        but.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean error;
                block6: {
                    error = false;
                    try {
                        Properties pr = (Properties)CompareDBDiagramsDialog.this.cbConn.getSelectedItem();
                        if (pr == null) break block6;
                        String cname = ConnectionInfo.getConnectionName(pr);
                        try {
                            Connection conn = DatabaseConnections.getInstance().getUniqueConnection(cname);
                            if (conn != null) {
                                CompareDBDiagramsDialog.this.rdiagrams = importing ? CompareDBDiagramsDialog.this.getRemoteDiagrams(conn, dpv.getDesign().getObjectID(), null, null, Collections.EMPTY_LIST) : (diagrams.size() == 1 ? CompareDBDiagramsDialog.this.getRemoteDiagrams(conn, dpv.getDesign().getObjectID(), dpv.getDesignPart().getObjectID(), dpv.getDPVId(), diagrams) : CompareDBDiagramsDialog.this.getRemoteDiagrams(conn, dpv.getDesign().getObjectID(), dpv.getDesignPart().getObjectID(), null, diagrams));
                                CompareDBDiagramsDialog.this.bnOK.setEnabled(true);
                                CompareDBDiagramsDialog.this.updateTabularModel(dpv);
                                CompareDBDiagramsDialog.this.updateCompareTable(null);
                            }
                        }
                        catch (Exception e1) {
                            error = true;
                            LOGGER.error("Import of diagrams", e1);
                            String err = e1.getMessage();
                            JOptionPane.showMessageDialog(null, err, "Connection error", 0);
                            e1.printStackTrace();
                        }
                    }
                    catch (Throwable e1) {
                        error = true;
                        LOGGER.error("Import of diagrams", e1);
                        e1.printStackTrace();
                    }
                }
                if (error) {
                    MessageDialogs.showErrorMessage((Component)Ide.getMainWindow(), oracle.dbtools.crest.swingui.engineeringcompare.Messages.getString("CompareDBDiagramsDialog.ImportFailed"), true);
                }
            }
        });
        int prefw = 1000;
        int minw = 900;
        int prefh = 800;
        int minh = 700;
        int divloc = 0;
        int locx = 100;
        int locy = 100;
        Point location = new Point(locx, locy);
        Settings.DialogSettings ds = this.appView.getSettings().getDialogSettings(this.getClass().getName());
        if (ds != null) {
            prefw = Math.max(minw, (int)ds.rec.getSize().getWidth());
            prefh = Math.max(minh, (int)ds.rec.getSize().getHeight());
            this.setSize(prefw, prefh);
            location = ds.rec.getLocation();
            divloc = ds.dividerLocation;
        }
        this.setPreferredSize(new Dimension(prefw, prefh));
        this.setMinimumSize(new Dimension(minw, minh));
        panel.add((Component)tb, "North");
        this.split = new JSplitPane(0);
        this.split.setTopComponent(this.tabularView);
        try {
            this.compareHTMLPanel = new CompareHTMLPanel(null, null, 600, 300);
            JPanel dpanel = new JPanel(new BorderLayout());
            dpanel.add((Component)this.compareHTMLPanel, "Center");
            this.split.setBottomComponent(dpanel);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        panel.add((Component)this.split, "Center");
        FlowLayout flowLayout = new FlowLayout(2);
        JPanel pnButtons = new JPanel(flowLayout);
        this.bnOK = new JButton(new AbstractAction(oracle.dbtools.crest.swingui.editor.Messages.getString("ModelPropertiesDialogEx.OK")){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (importing) {
                        CompareDBDiagramsDialog.this.processDiagramsForImport();
                    } else {
                        CompareDBDiagramsDialog.this.processDiagramsToExport();
                    }
                    CompareDBDiagramsDialog.this.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnOK.setEnabled(false);
        JButton bnCancel = new JButton(new AbstractAction(oracle.dbtools.crest.swingui.editor.Messages.getString("ModelPropertiesDialogEx.Cancel")){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    CompareDBDiagramsDialog.this.close();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        JButton bnHelp = new JButton(new AbstractAction(oracle.dbtools.crest.swingui.editor.Messages.getString("ModelPropertiesDialogEx.Help")){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompareDBDiagramsDialog.this.showHelp();
            }
        });
        bnHelp.setMnemonic(72);
        bnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        pnButtons.add(this.bnOK);
        pnButtons.add(bnCancel);
        pnButtons.add(bnHelp);
        panel.add((Component)pnButtons, "South");
        this.add(panel);
        this.pack();
        try {
            int h = (int)(this.split.getSize().getHeight() * 0.6);
            if (divloc > 0) {
                this.split.setDividerLocation(divloc);
            } else {
                this.split.setDividerLocation(h);
            }
            h = (int)(this.compareHTMLPanel.getSize().getWidth() / 2.0);
            this.compareHTMLPanel.setDivide4rLocation(h);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        this.setLocation(location);
    }

    Connection getConnection() {
        block5: {
            try {
                Properties pr = (Properties)this.cbConn.getSelectedItem();
                if (pr == null) break block5;
                String cname = ConnectionInfo.getConnectionName(pr);
                try {
                    Connection conn = DatabaseConnections.getInstance().getUniqueConnection(cname);
                    if (conn != null) {
                        return conn;
                    }
                }
                catch (Exception e1) {
                    String err = e1.getMessage();
                    JOptionPane.showMessageDialog(null, err, "Connection error", 0);
                    e1.printStackTrace();
                }
            }
            catch (Throwable e1) {
                e1.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDiagramsForImport() {
        ArrayList insert = new ArrayList();
        ArrayList update = new ArrayList();
        ArrayList delete = new ArrayList();
        try {
            ApplicationView.loading = true;
            ArrayList<DiagramToSVG.ObjectHelper> toimport = new ArrayList<DiagramToSVG.ObjectHelper>();
            HashMap<String, DiagramToSVG.ObjectHelper> map = new HashMap<String, DiagramToSVG.ObjectHelper>();
            for (SelectionPair sp : this.listedObects) {
                if (!sp.selected || !NEW.equalsIgnoreCase(sp.status) && (!MODIFIED.equalsIgnoreCase(sp.status) || sp.dpv == null) || sp.missingObjects == null) continue;
                for (DiagramToSVG.ObjectHelper oh : sp.missingObjects) {
                    String key = oh.getLongName();
                    if (map.get(key) != null) continue;
                    map.put(key, oh);
                    toimport.add(oh);
                }
            }
            if (toimport.size() > 0) {
                try {
                    Connection con = this.getConnection();
                    if (con != null) {
                        DiagramProcessor.importMissingObjects(con, toimport, this.rm);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LOGGER.error("CompareDBDiagrams - error during import o mising objects ", e);
                }
            }
            Hashtable<String, DiagramProcessor.JoinsHolder> jholders = new Hashtable<String, DiagramProcessor.JoinsHolder>();
            for (SelectionPair sp : this.listedObects) {
                if (!sp.selected) continue;
                if (NEW.equalsIgnoreCase(sp.status)) {
                    DPVRelational dpv = (DPVRelational)this.rm.createDesignPartSubView();
                    dpv.setName(sp.rdiagram.name);
                    DiagramToSVG.DiagramThumbnailModel dm = DiagramToSVG.createDiagramThumbnailModel(sp.rdiagram.layout);
                    Rectangle2D dim = dm.getBounds();
                    int dx = 0;
                    int dy = 0;
                    if (dim != null) {
                        dx = 20 - (int)dim.getX();
                        dy = 20 - (int)dim.getY();
                    }
                    DiagramProcessor.buildNewDiagram(dpv, sp.rdiagram.layout, jholders, dx, dy);
                    if (sp.rdiagram.globalID != null) {
                        dpv.setImportedId(sp.rdiagram.globalID);
                    } else if (sp.rdiagram.swID != null) {
                        if (this.rm.getObjectID().equalsIgnoreCase(sp.rdiagram.modelID) && this.rm.getDesign().getObjectID().equalsIgnoreCase(sp.rdiagram.designID)) {
                            dpv.setDPVId(sp.rdiagram.swID);
                        } else {
                            dpv.setImportedId(sp.rdiagram.swID);
                        }
                    }
                    dpv.getPlaceHolder().setVisible(true);
                    dpv.setDirty(true);
                    continue;
                }
                if (MODIFIED.equalsIgnoreCase(sp.status) && sp.dpv != null) {
                    DiagramToSVG.DiagramThumbnailModel dm = DiagramToSVG.createDiagramThumbnailModel(sp.rdiagram.layout);
                    Rectangle2D dim = dm.getBounds();
                    int dx = 0;
                    int dy = 0;
                    if (dim != null) {
                        dx = 20 - (int)dim.getX();
                        dy = 20 - (int)dim.getY();
                    }
                    DiagramProcessor.buildNewDiagram(sp.dpv, sp.rdiagram.layout, jholders, dx, dy);
                    sp.dpv.setDirty(true);
                    continue;
                }
                if (!DELETED.equalsIgnoreCase(sp.status)) continue;
            }
            ApplicationView.loading = false;
            for (DiagramProcessor.JoinsHolder jh : jholders.values()) {
                FKContainer cont = jh.container;
                for (Join join : jh.joins) {
                    ImpliedForeignKey ifk = cont.getEquivalentImpliedFKey(join);
                    if (ifk != null) {
                        for (String source : join.getDiscoverySourcesAslist()) {
                            ifk.addDiscoverySource(source);
                        }
                        continue;
                    }
                    ifk = ImpliedForeignKey.createImpliedFK(this.rm, cont, join, null, null, false);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            ApplicationView.loading = false;
        }
    }

    private void processDiagramsToExport() {
        ArrayList<DPVRelational> insert = new ArrayList<DPVRelational>();
        ArrayList<DPVRelational> update = new ArrayList<DPVRelational>();
        ArrayList<DPVRelational> global = new ArrayList<DPVRelational>();
        ArrayList<SelectionPair> delete = new ArrayList<SelectionPair>();
        for (SelectionPair sp : this.listedObects) {
            if (!sp.selected) continue;
            if (NEW.equalsIgnoreCase(sp.status) && sp.dpv != null) {
                insert.add(sp.dpv);
                continue;
            }
            if (MODIFIED.equalsIgnoreCase(sp.status) && sp.dpv != null) {
                if (sp.rdiagram.swID == null && sp.rdiagram.globalID != null && sp.dpv.getImportedId() != null) {
                    global.add(sp.dpv);
                    continue;
                }
                update.add(sp.dpv);
                continue;
            }
            if (!DELETED.equalsIgnoreCase(sp.status)) continue;
            delete.add(sp);
        }
        Connection conn = this.getConnection();
        if (conn != null) {
            DiagramToJSON.wriiteDiagramsToCloud(conn, null, insert, update, global);
            DiagramToJSON.deleteDiagramsFromCloud(conn, delete);
        }
    }

    private void close() {
        Rectangle rectangle = new Rectangle(this.getLocation(), this.getSize());
        String treePath = "none";
        this.appView.getSettings().setDialogSettings(this.getClass().getName(), rectangle, treePath, this.split.getDividerLocation());
        this.dispose();
    }

    protected void showHelp() {
        HelpManager.showTopic((Component)Ide.getMainWindow(), this.getHelpIndex());
    }

    protected String getHelpIndex() {
        return "EXPORT_IMPORT_DIARAMS_TO_DATABASE";
    }

    public static String getConnectionName(ModelIDObject obj) {
        RelationalDesign rd;
        List<DBConnectionStamp> list;
        String cname = obj.getSourceConnName();
        if (cname != null && cname.isEmpty() && obj instanceof RelationalDesign && (list = (rd = (RelationalDesign)obj).getImportConnectionStamps()).size() > 0) {
            cname = list.get(0).getConnName();
        }
        return cname;
    }

    public static Properties getConnectionProperties(ModelIDObject obj) {
        RelationalDesign rd;
        List<DBConnectionStamp> list;
        String cname = obj.getSourceConnName();
        if (cname != null && cname.isEmpty() && obj instanceof RelationalDesign && (list = (rd = (RelationalDesign)obj).getImportConnectionStamps()).size() > 0) {
            cname = list.get(0).getConnName();
        }
        if (cname != null && !cname.isEmpty()) {
            try {
                return DatabaseConnections.getInstance().getProperties(cname);
            }
            catch (ConnectionException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static void updateConnections(JComboBox cbConn, DesignPart dp) {
        ArrayList<Properties> clist = new ArrayList<Properties>();
        Properties selected = null;
        List<Properties> allConnections = ConnectionInfo.getAllConnections(DatabaseConnections.getInstance(), true);
        String cname = CompareDBDiagramsDialog.getConnectionName(dp);
        for (Properties cd : allConnections) {
            if (ConnectionInfo.getConnectionType(cd) != 1) continue;
            if (cname != null && cname.equals(ConnectionInfo.getConnectionName(cd))) {
                selected = cd;
            }
            clist.add(cd);
        }
        cbConn.setModel(new DefaultComboBoxModel<Object>(clist.toArray()));
        if (selected != null) {
            cbConn.setSelectedItem(selected);
        }
    }

    protected void setSelectedColor() {
        block7: {
            try {
                Object selected = this.cbConn.getSelectedItem();
                if (selected == null) break block7;
                Properties cd = (Properties)selected;
                String sColor = cd.getProperty("Connection-Color-For-Editors");
                if (sColor != null) {
                    Color color = null;
                    try {
                        color = new Color(Integer.parseInt(sColor));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (color != null) {
                        this.cbConn.setForeground(color);
                    } else {
                        this.cbConn.setForeground(UIManager.getColor("ComboBox.foreground"));
                    }
                    break block7;
                }
                this.cbConn.setForeground(UIManager.getColor("ComboBox.foreground"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void initTabularView() {
        this.tabularView.setLayout(new BorderLayout());
        this.toolBar = new JToolBar();
        this.selectAll = AbstractDBMExtractionWizardImpl.createSelectAllButton();
        this.deselectAll = AbstractDBMExtractionWizardImpl.createDeselectAllButton();
        this.toolBar.add(this.selectAll);
        this.toolBar.add(this.deselectAll);
        this.table = new JTable(new TabularViewModel(this.importing));
        this.table.setSelectionMode(0);
        TableColumn col = this.table.getColumnModel().getColumn(0);
        col.setMaxWidth(70);
        col.setPreferredWidth(60);
        col = this.table.getColumnModel().getColumn(1);
        col.setCellRenderer(new TabularViewCellRenderer());
        this.initFiltering(this.table);
        this.tabularView.add((Component)this.toolBar, "North");
        this.table.setAutoCreateRowSorter(true);
        WindowsTableHeader.setSortedHeader(this.table);
        this.tabularView.add((Component)new JScrollPane(this.table), "Center");
        this.selectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompareDBDiagramsDialog.this.checkAll(CompareDBDiagramsDialog.this.table, true);
            }
        });
        this.deselectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompareDBDiagramsDialog.this.checkAll(CompareDBDiagramsDialog.this.table, false);
            }
        });
        this.initStatusCombo();
        this.initTypeCombo();
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int row = CompareDBDiagramsDialog.this.table.getSelectedRow();
                if (row > -1 && row < CompareDBDiagramsDialog.this.listedObects.size()) {
                    row = CompareDBDiagramsDialog.this.table.getRowSorter().convertRowIndexToModel(row);
                    SelectionPair sp = CompareDBDiagramsDialog.this.listedObects.get(row);
                    try {
                        CompareDBDiagramsDialog.this.updateCompareTable(sp);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
    }

    private void updateCompareTable(SelectionPair sp) {
        String left = null;
        String right = null;
        if (sp != null) {
            if (this.importing) {
                if (sp.rdiagram != null && (left = sp.rdiagram.layout) != null) {
                    left = DiagramToSVG.getCompareThumbnail(left, "1", 450, 300, false);
                }
                if (sp.dpv != null && sp.dpv instanceof DPVRelational) {
                    right = DiagramToSVG.getCompareThumbnail(sp.dpv, 450, 300);
                }
            } else {
                if (sp.rdiagram != null && (right = sp.rdiagram.layout) != null) {
                    right = DiagramToSVG.getCompareThumbnail(right, "1", 450, 300, false);
                }
                if (sp.dpv != null && sp.dpv instanceof DPVRelational) {
                    left = DiagramToSVG.getCompareThumbnail(sp.dpv, 450, 300);
                }
            }
        }
        this.compareHTMLPanel.loadContent(left, right);
    }

    private void initStatusCombo() {
        JLabel label = new JLabel(this.STATUS);
        label.setToolTipText(this.FILTER_BY_STATUS);
        this.cbStatuses = new JComboBox<String>(STATUSES);
        this.cbStatuses.setPreferredSize(new Dimension(80, MessageDialogs.BUTTON_SIZE_EX.height - 2));
        this.cbStatuses.setMaximumSize(new Dimension(100, MessageDialogs.BUTTON_SIZE_EX.height - 2));
        this.cbStatuses.setToolTipText(this.FILTER_BY_STATUS);
        label.setLabelFor(this.cbStatuses);
        this.toolBar.addSeparator();
        this.toolBar.add(label);
        this.toolBar.add(this.cbStatuses);
        this.cbStatuses.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String status = (String)CompareDBDiagramsDialog.this.cbStatuses.getSelectedItem();
                String typeName = (String)CompareDBDiagramsDialog.this.cbTypes.getSelectedItem();
                if (typeName != null) {
                    String type = typeName.equalsIgnoreCase(ALL_) ? ALL_ : CompareDBDiagramsDialog.getDiagramType(typeName);
                    CompareDBDiagramsDialog.this.filterByStatusAndType(type, status);
                }
            }
        });
    }

    private void initTypeCombo() {
        JLabel label = new JLabel(this.TYPE);
        label.setToolTipText(this.FILTER_BY_TYPE);
        this.cbTypes = new JComboBox<Object>(this.objectTypesList_ALL.toArray());
        this.cbTypes.setPreferredSize(new Dimension(100, MessageDialogs.BUTTON_SIZE_EX.height - 2));
        this.cbTypes.setMaximumSize(new Dimension(120, MessageDialogs.BUTTON_SIZE_EX.height - 2));
        this.cbTypes.setToolTipText(this.FILTER_BY_TYPE);
        label.setLabelFor(this.cbTypes);
        this.toolBar.addSeparator();
        this.toolBar.add(label);
        this.toolBar.add(this.cbTypes);
        this.cbTypes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String typeName = (String)CompareDBDiagramsDialog.this.cbTypes.getSelectedItem();
                String type = typeName.equalsIgnoreCase(ALL_) ? ALL_ : CompareDBDiagramsDialog.getDiagramType(typeName);
                String status = (String)CompareDBDiagramsDialog.this.cbStatuses.getSelectedItem();
                CompareDBDiagramsDialog.this.filterByStatusAndType(type, status);
            }
        });
    }

    private void filterByStatusAndType(String type, String status) {
        this.listedObects.clear();
        ArrayList<SelectionPair> temp = new ArrayList<SelectionPair>();
        if (ALL_.equalsIgnoreCase(status)) {
            for (SelectionPair sp : this.allObjects) {
                temp.add(sp);
            }
        } else {
            for (SelectionPair sp : this.allObjects) {
                if (!sp.getStatus().equalsIgnoreCase(status)) continue;
                temp.add(sp);
            }
        }
        if (type != null) {
            if (ALL_.equals(type)) {
                this.listedObects.addAll(temp);
            } else {
                for (SelectionPair sp : temp) {
                    if (!sp.getType().equalsIgnoreCase(type)) continue;
                    this.listedObects.add(sp);
                }
            }
        } else {
            this.listedObects.addAll(temp);
        }
        ((TabularViewModel)this.table.getModel()).fireTableDataChanged();
    }

    private void initFiltering(final JTable tableForFiltering) {
        JLabel flabel = new JLabel(oracle.dbtools.crest.swingui.wizards.Messages.getString("AbstractDBMExtractionWizardImpl.Filter"));
        this.filterText = new JTextField();
        this.filterText.setPreferredSize(new Dimension(130, MessageDialogs.BUTTON_SIZE_EX.height));
        this.filterText.setMaximumSize(new Dimension(180, MessageDialogs.BUTTON_SIZE_EX.height));
        this.filterText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                CompareDBDiagramsDialog.this.newFilter(CompareDBDiagramsDialog.this.filterText, tableForFiltering);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                CompareDBDiagramsDialog.this.newFilter(CompareDBDiagramsDialog.this.filterText, tableForFiltering);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CompareDBDiagramsDialog.this.newFilter(CompareDBDiagramsDialog.this.filterText, tableForFiltering);
            }
        });
        flabel.setLabelFor(this.filterText);
        this.toolBar.add(flabel);
        this.toolBar.add(this.filterText);
    }

    private void changeAll(JTable table, boolean select) {
        if (table != null && table.getRowCount() != table.getModel().getRowCount()) {
            int count = table.getRowCount();
            for (int i = 0; i < count; ++i) {
                int index = table.convertRowIndexToModel(i);
                if (index <= -1 || index >= this.listedObects.size()) continue;
                SelectionPair sp = this.listedObects.get(index);
                sp.selected = select;
            }
        } else {
            for (int i = 0; i < this.listedObects.size(); ++i) {
                SelectionPair sp = this.listedObects.get(i);
                sp.selected = select;
            }
        }
    }

    protected void checkAll(JTable table, boolean checked) {
        ListSelectionModel selectionModel = table.getSelectionModel();
        this.changeAll(table, checked);
        if (selectionModel.isSelectionEmpty()) {
            this.changeAll(table, checked);
        } else {
            for (int i = 0; i < this.listedObects.size(); ++i) {
                if (!selectionModel.isSelectedIndex(i)) continue;
                SelectionPair sp = this.listedObects.get(i);
                sp.selected = true;
            }
        }
        table.updateUI();
    }

    private void newFilter(JTextField filterText, JTable currentTable) {
        RowFilter rf = null;
        if (currentTable != null) {
            if (!"".equals(filterText.getText())) {
                try {
                    rf = RowFilter.regexFilter("(?i)" + filterText.getText(), currentTable.convertColumnIndexToModel(1));
                    this.cbTypes.setEnabled(false);
                    this.cbStatuses.setEnabled(false);
                }
                catch (PatternSyntaxException e) {
                    return;
                }
                ((DefaultRowSorter)currentTable.getRowSorter()).setRowFilter(rf);
            } else {
                ((DefaultRowSorter)currentTable.getRowSorter()).setRowFilter(null);
                currentTable.clearSelection();
                this.cbTypes.setEnabled(true);
                this.cbStatuses.setEnabled(true);
            }
        }
    }

    public void buildInitialTabularModel(DesignPartView dpv) {
        this.listedObects.clear();
        this.allObjects.clear();
        if (!this.importing) {
            this.buildPairs(this.allObjects);
            this.buildTypes(this.allObjects);
            this.buildModels(this.allObjects);
            this.listedObects.addAll(this.allObjects);
        }
    }

    public void updateTabularModel(DesignPartView dpv) {
        this.listedObects.clear();
        ((DefaultRowSorter)this.table.getRowSorter()).setRowFilter(null);
        this.table.clearSelection();
        this.filterText.setText("");
        if (this.importing) {
            this.buildePairsByRemote(this.allObjects, dpv != null ? (RelationalDesign)dpv.getDesignPart() : null);
        } else {
            this.updatePairs(this.allObjects);
        }
        this.buildTypes(this.allObjects);
        this.listedObects.addAll(this.allObjects);
        this.cbTypes.setModel(new DefaultComboBoxModel<Object>(this.objectTypesList_ALL.toArray()));
        this.cbTypes.setEnabled(true);
        this.cbStatuses.setEnabled(true);
        ((AbstractTableModel)this.table.getModel()).fireTableDataChanged();
        this.cbStatuses.setSelectedItem(ALL);
        this.cbTypes.setSelectedItem(ALL_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DiagramHelper> getRemoteDiagrams(Connection con, String designID, String modelID, String diagramID, List<DPVRelational> diagrams) {
        ArrayList<DiagramHelper> list = new ArrayList<DiagramHelper>();
        Object globalIDSQL = "";
        for (DPVRelational dpv : diagrams) {
            if (dpv.getImportedId() == null || dpv.getImportedId().isEmpty()) continue;
            if (((String)globalIDSQL).isEmpty()) {
                globalIDSQL = "'" + dpv.getImportedId() + "'";
                continue;
            }
            globalIDSQL = (String)globalIDSQL + ",'" + dpv.getImportedId() + "'";
        }
        if (!((String)globalIDSQL).isEmpty()) {
            globalIDSQL = " OR (GLOBAL_ID is not null AND GLOBAL_ID IN (" + (String)globalIDSQL + "))";
        }
        Statement statement = null;
        ResultSet rs = null;
        try {
            if (DiagramToJSON.diagramsTableExists(con)) {
                Object sql = "SELECT ID,NAME,DESCRIPTION,LAST_UPDATE,GLOBAL_ID,DESIGN_ID,DESIGN_NAME,MODEL_ID,MODEL_NAME,SUBVIEW_ID,SUBVIEW_NAME,PARENT_ID,DIAGRAM_TYPE,LAYOUT FROM OSDDMW_DIAGRAMS";
                if (diagramID != null && !diagramID.isEmpty() && modelID != null && !modelID.isEmpty()) {
                    sql = "SELECT ID,NAME,DESCRIPTION,LAST_UPDATE,GLOBAL_ID,DESIGN_ID,DESIGN_NAME,MODEL_ID,MODEL_NAME,SUBVIEW_ID,SUBVIEW_NAME,PARENT_ID,DIAGRAM_TYPE,LAYOUT FROM OSDDMW_DIAGRAMS where DESIGN_ID = ? AND MODEL_ID = ? AND SUBVIEW_ID = ? " + (String)globalIDSQL;
                    statement = con.prepareStatement((String)sql);
                    statement.setString(1, designID);
                    statement.setString(2, modelID);
                    statement.setString(3, diagramID);
                } else if (modelID != null && !modelID.isEmpty()) {
                    sql = "SELECT ID,NAME,DESCRIPTION,LAST_UPDATE,GLOBAL_ID,DESIGN_ID,DESIGN_NAME,MODEL_ID,MODEL_NAME,SUBVIEW_ID,SUBVIEW_NAME,PARENT_ID,DIAGRAM_TYPE,LAYOUT FROM OSDDMW_DIAGRAMS where DESIGN_ID = ? AND MODEL_ID = ? " + (String)globalIDSQL;
                    statement = con.prepareStatement((String)sql);
                    statement.setString(1, designID);
                    statement.setString(2, modelID);
                } else {
                    statement = con.prepareStatement((String)sql);
                }
                rs = statement.executeQuery();
                if (rs != null) {
                    while (rs.next()) {
                        DiagramHelper dh = new DiagramHelper();
                        dh.remoteID = rs.getString(1);
                        dh.name = rs.getString(2);
                        dh.description = rs.getString(3);
                        dh.lastUpdate = rs.getString(4);
                        dh.globalID = rs.getString(5);
                        dh.designID = rs.getString(6);
                        dh.designName = rs.getString(7);
                        dh.modelID = rs.getString(8);
                        dh.modelName = rs.getString(9);
                        dh.swID = rs.getString(10);
                        dh.swName = rs.getString(11);
                        dh.parentID = rs.getString(12);
                        dh.diagramType = rs.getString(13);
                        Blob blob = rs.getBlob(14);
                        dh.layout = DiagramToJSON.blobToString(blob);
                        list.add(dh);
                        dh.layoutLoaded = true;
                    }
                    rs.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            Closeables.close(rs);
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return list;
    }

    private void buildPairs(List<SelectionPair> list) {
        for (DPVRelational d : this.diagrams) {
            SelectionPair sp = new SelectionPair();
            sp.dpv = d;
            sp.importOperation = this.importing;
            sp.dpvLayout = DiagramToSVG.layoutDPV_ToJSON(d);
            sp.dpvModel = DiagramToSVG.createDiagramThumbnailModel(sp.dpvLayout);
            list.add(sp);
        }
    }

    private void updatePairs(List<SelectionPair> list) {
        String modelID = this.dpv.getDesignPart().getObjectID();
        HashMap<String, SelectionPair> spMap = new HashMap<String, SelectionPair>();
        HashMap<String, SelectionPair> remote = new HashMap<String, SelectionPair>();
        HashMap<String, DPVRelational> global = new HashMap<String, DPVRelational>();
        for (DPVRelational d : this.diagrams) {
            if (d.getImportedId() == null) continue;
            global.put(d.getImportedId(), d);
        }
        for (SelectionPair sp : list) {
            if (sp.dpv != null) {
                spMap.put(sp.dpv.getDPVId(), sp);
                if (sp.dpv.getImportedId() == null || sp.rdiagram == null) continue;
                global.remove(sp.dpv.getImportedId());
                continue;
            }
            if (sp.rdiagram.swID == null) continue;
            remote.put(sp.rdiagram.swID, sp);
        }
        ArrayList<DiagramHelper> toDelete = new ArrayList<DiagramHelper>();
        HashMap<String, DiagramHelper> map = new HashMap<String, DiagramHelper>();
        for (DiagramHelper rd : this.rdiagrams) {
            DPVRelational d;
            if (rd.swID != null) {
                map.put(rd.swID, rd);
                if (spMap.get(rd.swID) != null || !modelID.equalsIgnoreCase(rd.modelID)) continue;
                toDelete.add(rd);
                continue;
            }
            if (rd.globalID == null || (d = (DPVRelational)global.get(rd.globalID)) == null) continue;
            SelectionPair sp = this.getPairByDPV(list, d);
            if (sp == null) {
                sp = new SelectionPair();
                list.add(sp);
            }
            sp.importOperation = this.importing;
            sp.rdiagram = rd;
            sp.dpv = d;
        }
        for (SelectionPair sp : list) {
            if (sp.dpv == null) continue;
            DiagramHelper dh = sp.rdiagram;
            if (dh == null) {
                dh = (DiagramHelper)map.get(sp.dpv.getDPVId());
            }
            if (dh != null) {
                sp.rdiagram = dh;
                if (sp.dpv != null && sp.dpvLayout == null) {
                    sp.dpvLayout = DiagramToSVG.layoutDPV_ToJSON(sp.dpv);
                }
                if (sp.dpvLayout != null && sp.dpvModel == null) {
                    sp.dpvModel = DiagramToSVG.createDiagramThumbnailModel(sp.dpvLayout);
                }
                if (dh.layout != null) {
                    sp.rdModel = DiagramToSVG.createDiagramThumbnailModel(dh.layout);
                }
                if (sp.dpvLayout == null || dh.layout == null) continue;
                if (!sp.dpvModel.equals(sp.rdModel)) {
                    sp.setStatus(MODIFIED);
                    continue;
                }
                sp.setStatus(UNCHANGED);
                continue;
            }
            sp.setStatus(NEW);
        }
        for (DiagramHelper rd : toDelete) {
            SelectionPair sp = new SelectionPair();
            sp.importOperation = this.importing;
            sp.rdiagram = rd;
            sp.setStatus(DELETED);
            if (remote.get(sp.rdiagram.swID) != null) continue;
            list.add(sp);
        }
    }

    SelectionPair getPairByDPV(List<SelectionPair> list, DPVRelational dpv) {
        for (SelectionPair sp : list) {
            if (sp.dpv == null || sp.dpv != dpv) continue;
            return sp;
        }
        return null;
    }

    private void buildePairsByRemote(List<SelectionPair> list, RelationalDesign model) {
        list.clear();
        String modelID = this.dpv.getDesignPart().getObjectID();
        HashMap<String, DPVRelational> dpvMap = new HashMap<String, DPVRelational>();
        HashMap<String, DPVRelational> global = new HashMap<String, DPVRelational>();
        for (DPVRelational d : this.diagrams) {
            dpvMap.put(d.getDPVId(), d);
            if (d.getImportedId() == null) continue;
            global.put(d.getImportedId(), d);
        }
        for (DiagramHelper rd : this.rdiagrams) {
            DPVRelational d;
            SelectionPair sp = new SelectionPair();
            list.add(sp);
            sp.importOperation = this.importing;
            sp.rdiagram = rd;
            if (rd.layout != null && !rd.layout.isEmpty()) {
                DiagramProcessor.setMissingObjectsAndHTML(sp, model);
            }
            sp.setStatus(NEW);
            if (rd.swID != null && modelID.equalsIgnoreCase(rd.modelID)) {
                d = (DPVRelational)dpvMap.get(rd.swID);
                if (d != null) {
                    sp.dpv = d;
                    sp.dpvLayout = DiagramToSVG.layoutDPV_ToJSON(d);
                    sp.dpvModel = DiagramToSVG.createDiagramThumbnailModel(sp.dpvLayout);
                    if (rd.layout != null) {
                        sp.rdModel = DiagramToSVG.createDiagramThumbnailModel(rd.layout);
                    }
                    if (sp.dpvLayout == null || rd.layout == null) continue;
                    if (!sp.dpvModel.equals(sp.rdModel)) {
                        sp.setStatus(MODIFIED);
                        continue;
                    }
                    sp.setStatus(UNCHANGED);
                    continue;
                }
                sp.setStatus(NEW);
                continue;
            }
            if (rd.globalID == null || (d = (DPVRelational)global.get(rd.globalID)) == null) continue;
            sp.dpv = d;
            sp.dpvLayout = DiagramToSVG.layoutDPV_ToJSON(d);
            sp.dpvModel = DiagramToSVG.createDiagramThumbnailModel(sp.dpvLayout);
            if (rd.layout != null) {
                sp.rdModel = DiagramToSVG.createDiagramThumbnailModel(rd.layout);
            }
            if (sp.dpvLayout == null || rd.layout == null) continue;
            if (!sp.dpvModel.equals(sp.rdModel)) {
                sp.setStatus(MODIFIED);
                continue;
            }
            sp.setStatus(UNCHANGED);
        }
    }

    private void buildTypes(List<SelectionPair> list) {
        this.objectTypes.clear();
        this.objectTypesList_ALL.clear();
        for (SelectionPair sp : list) {
            if (this.objectTypes.containsKey(sp.getType())) continue;
            this.objectTypes.put(sp.getType(), CompareDBDiagramsDialog.getDiagramTypeName(sp.getType()));
        }
        this.objectTypesList_ALL.add(ALL_);
        ArrayList types = new ArrayList(this.objectTypes.values());
        Collections.sort(types);
        this.objectTypesList_ALL.addAll(types);
    }

    private void buildModels(List<SelectionPair> list) {
    }

    public JTable getTable() {
        return this.table;
    }

    public JPanel getTabularView() {
        return this.tabularView;
    }

    public void setCompareModels(boolean compareModels) {
        this.compareModels = compareModels;
    }

    public boolean isCompareModels() {
        return this.compareModels;
    }

    public String getReportCaption() {
        return this.reportCaption;
    }

    public void setReportCaption(String reportCaption) {
        this.reportCaption = reportCaption;
    }

    public boolean isDmdImport() {
        return this.dmdImport;
    }

    public void setDmdImport(boolean dmdImport) {
        this.dmdImport = dmdImport;
    }

    protected void generateReport() {
    }

    public boolean isHasNewObjects() {
        for (SelectionPair sp : this.listedObects) {
            if (sp.rdiagram != null && sp.dpv != null) continue;
            return true;
        }
        return false;
    }

    static String getDiagramType(String dname) {
        String str = DNAME_TO_TYPE.get(dname);
        if (str == null) {
            return EMPTY;
        }
        return str;
    }

    static String getDiagramTypeName(String dtype) {
        String str = DTYPE_TO_NAME.get(dtype);
        if (str == null) {
            return EMPTY;
        }
        return str;
    }

    static String getDiagramType(DesignPartView dpv) {
        return DiagramToJSON.getDiagramType(dpv);
    }

    static String getDiagramTypeName(DesignPartView dpv) {
        String dtype = DiagramToJSON.getDiagramType(dpv);
        String str = DTYPE_TO_NAME.get(dtype);
        if (str == null) {
            return EMPTY;
        }
        return str;
    }

    static {
        DTYPE_TO_NAME.put(DMW_DIAGRAM_TYPE, DMW_DIAGRAM);
        DTYPE_TO_NAME.put(DiagramToJSON.DIAGRAM_TYPE_MAIN_PRIMARY, MAIN_PRIMARY);
        DTYPE_TO_NAME.put(DiagramToJSON.DIAGRAM_TYPE_MAIN_DISPLAY, MAIN_DISPLAY);
        DTYPE_TO_NAME.put(DiagramToJSON.DIAGRAM_TYPE_SUBVIEW_PRIMARY, SV_PRIMARY);
        DTYPE_TO_NAME.put(DiagramToJSON.DIAGRAM_TYPE_SUBVIEW_DISPLAY, SV_DISPLAY);
        DNAME_TO_TYPE.put(DMW_DIAGRAM, DMW_DIAGRAM_TYPE);
        DNAME_TO_TYPE.put(MAIN_PRIMARY, DiagramToJSON.DIAGRAM_TYPE_MAIN_PRIMARY);
        DNAME_TO_TYPE.put(MAIN_DISPLAY, DiagramToJSON.DIAGRAM_TYPE_MAIN_DISPLAY);
        DNAME_TO_TYPE.put(SV_PRIMARY, DiagramToJSON.DIAGRAM_TYPE_SUBVIEW_PRIMARY);
        DNAME_TO_TYPE.put(SV_DISPLAY, DiagramToJSON.DIAGRAM_TYPE_SUBVIEW_DISPLAY);
        ALL = Messages.getString("SelectNeighborsDialog.All");
        ALL_ = "ALL";
        STATUSES = new String[]{ALL, UNCHANGED, MODIFIED, NEW, DELETED};
        LOGGER = new Logger(CompareDBDiagramsDialog.class);
    }

    class CompareHTMLPanel
    extends JPanel {
        private final JPanel lpanel = new JPanel(new BorderLayout());
        private final JPanel rpanel = new JPanel(new BorderLayout());
        private final JFXPanel ljfxPanel = new JFXPanel();
        private final JFXPanel rjfxPanel = new JFXPanel();
        private WebEngine lengine;
        private WebEngine rengine;
        WebView lview;
        WebView rview;
        private String url;
        private double ZOOMF = 1.2;
        String leftContent;
        String rightContent;
        JSplitPane splitPane;

        CompareHTMLPanel(final String leftContent, final String rightContent, int width, int height) {
            this.setLayout(new BorderLayout());
            this.leftContent = leftContent;
            this.rightContent = rightContent;
            this.lpanel.add((Component)this.ljfxPanel);
            this.rpanel.add((Component)this.rjfxPanel);
            int half = width / 2;
            this.lpanel.setPreferredSize(new Dimension(width / 2, height));
            this.rpanel.setPreferredSize(new Dimension(width / 2, height));
            this.splitPane = new JSplitPane(1, this.lpanel, this.rpanel);
            this.splitPane.setOneTouchExpandable(true);
            this.splitPane.setDividerLocation(half);
            this.add(this.splitPane);
            this.setPreferredSize(new Dimension(width, height));
            Platform.setImplicitExit((boolean)false);
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        CompareHTMLPanel.this.lview = new WebView();
                        CompareHTMLPanel.this.lengine = CompareHTMLPanel.this.lview.getEngine();
                        CompareHTMLPanel.this.ljfxPanel.setScene(new Scene((Parent)CompareHTMLPanel.this.lview));
                        if (leftContent != null) {
                            CompareHTMLPanel.this.lengine.loadContent(leftContent);
                        }
                        CompareHTMLPanel.this.lview.setZoom(Screen.getPrimary().getDpi() / 96.0);
                        CompareHTMLPanel.this.addZoom(CompareHTMLPanel.this.lview);
                        CompareHTMLPanel.this.rview = new WebView();
                        CompareHTMLPanel.this.rengine = CompareHTMLPanel.this.rview.getEngine();
                        CompareHTMLPanel.this.rjfxPanel.setScene(new Scene((Parent)CompareHTMLPanel.this.rview));
                        if (rightContent != null) {
                            CompareHTMLPanel.this.rengine.loadContent(rightContent);
                        }
                        CompareHTMLPanel.this.rview.setZoom(Screen.getPrimary().getDpi() / 96.0);
                        CompareHTMLPanel.this.addZoom(CompareHTMLPanel.this.rview);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }

        void setDivide4rLocation(int points) {
            this.splitPane.setDividerLocation(points);
        }

        void addZoom(WebView view) {
            view.setOnScroll(event -> {
                if (event.isControlDown()) {
                    double zoomFactor = this.ZOOMF;
                    double deltaY = event.getDeltaY();
                    if (deltaY < 0.0) {
                        zoomFactor = 2.0 - zoomFactor;
                    }
                    view.setZoom(view.getZoom() * zoomFactor);
                    event.consume();
                }
            });
        }

        void loadContent(final String left, final String right) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        CompareHTMLPanel.this.lview.setZoom(1.0);
                        CompareHTMLPanel.this.rview.setZoom(Screen.getPrimary().getDpi() / 96.0);
                        if (left != null) {
                            CompareHTMLPanel.this.lengine.loadContent(left);
                        } else {
                            CompareHTMLPanel.this.lengine.loadContent("");
                        }
                        if (right != null) {
                            CompareHTMLPanel.this.rengine.loadContent(right);
                        } else {
                            CompareHTMLPanel.this.rengine.loadContent("");
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    public class DiagramHelper {
        public String remoteID;
        public String globalID;
        public String name;
        public String description;
        public String lastUpdate;
        public String designID;
        public String designName;
        public String modelID;
        public String modelName;
        public String swName;
        public String parentID;
        public String diagramType;
        public String swID;
        public String layout;
        public boolean layoutLoaded = false;
    }

    private class PrintReportAction
    implements ActionListener {
        private PrintReportAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HashMap<String, Object> extraParams = new HashMap<String, Object>();
            extraParams.put("compareModels", CompareDBDiagramsDialog.this.isCompareModels());
            extraParams.put("DMDImport", CompareDBDiagramsDialog.this.isDmdImport());
            extraParams.put("reportCaption", CompareDBDiagramsDialog.this.getReportCaption());
            extraParams.put("reportCustomFilenName", ReportUtils.getReportFileName(ReportUtils.getReportsPath(CompareDBDiagramsDialog.this.appView), "ObjectsComparison"));
            CompareTabularViewReportDialog reportsDialog = new CompareTabularViewReportDialog(CompareDBDiagramsDialog.this.appView, CompareDBDiagramsDialog.this.listedObects, extraParams);
            reportsDialog.showDialog();
        }
    }

    public static class SelectionPair {
        public DiagramHelper rdiagram;
        DPVRelational dpv;
        String dpvLayout;
        boolean selected;
        String status = UNCHANGED;
        boolean importOperation = false;
        public String toolTip;
        public List<DiagramToSVG.ObjectHelper> missingObjects;
        DiagramToSVG.DiagramThumbnailModel dpvModel;
        DiagramToSVG.DiagramThumbnailModel rdModel;

        SelectionPair() {
        }

        SelectionPair(boolean importOperation) {
            this.importOperation = importOperation;
        }

        String getType() {
            if (this.dpv != null) {
                return DiagramToJSON.getDiagramType(this.dpv);
            }
            if (this.rdiagram != null) {
                if (this.rdiagram.diagramType != null) {
                    return this.rdiagram.diagramType;
                }
                return DMW_DIAGRAM_TYPE;
            }
            return "";
        }

        String getRemoteModel() {
            if (this.rdiagram != null && this.rdiagram.modelName != null) {
                return this.rdiagram.modelName;
            }
            return "";
        }

        String getRemoteDesign() {
            if (this.rdiagram != null && this.rdiagram.designName != null) {
                return this.rdiagram.designName;
            }
            return "";
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String toString() {
            if (!this.importOperation) {
                if (this.dpv != null) {
                    return this.dpv.getName();
                }
                if (this.rdiagram != null) {
                    return this.rdiagram.name;
                }
                return EMPTY;
            }
            if (this.rdiagram != null) {
                return this.rdiagram.name;
            }
            return EMPTY;
        }

        Icon getStatusIcon() {
            Icon icon = null;
            GUIConfiguration conf = GUIConfiguration.getInstance();
            if (MODIFIED.equalsIgnoreCase(this.status)) {
                icon = conf.getIcon("WARNING_ICON", this.getPreferredIconSize());
            } else if (DELETED.equalsIgnoreCase(this.status)) {
                icon = conf.getIcon("OBJECT_DELETED", this.getPreferredIconSize());
            } else if (NEW.equalsIgnoreCase(this.status)) {
                icon = GUIConfiguration.getInstance().getIcon("OBJECT_ADDED", this.getPreferredIconSize());
            }
            return icon;
        }

        private int getPreferredIconSize() {
            return 16;
        }
    }

    class TabularViewCellRenderer
    extends JLabel
    implements TableCellRenderer {
        TabularViewCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            TabularViewModel tm = (TabularViewModel)table.getModel();
            String cname = tm.getColumnName(1);
            int k = this.getColumnIndex(table, cname);
            if (value instanceof SelectionPair && col == k) {
                SelectionPair sp = (SelectionPair)value;
                Icon icon = sp.getStatusIcon();
                this.setIcon(icon);
                this.setOpaque(true);
                this.setText(sp.toString());
                boolean hasTollTip = false;
                if (sp.toolTip != null && !sp.toolTip.isEmpty()) {
                    hasTollTip = true;
                    this.setToolTipText(sp.toolTip);
                } else {
                    this.setToolTipText(null);
                }
                if (isSelected) {
                    this.setBackground(table.getSelectionBackground());
                    this.setForeground(hasTollTip ? Color.RED : table.getSelectionForeground());
                } else {
                    this.setBackground(table.getBackground());
                    this.setForeground(hasTollTip ? Color.RED : table.getForeground());
                }
            }
            this.setHorizontalAlignment(2);
            return this;
        }

        int getColumnIndex(JTable table, String columnTitle) {
            int columnCount = table.getColumnCount();
            for (int column = 0; column < columnCount; ++column) {
                if (!table.getColumnName(column).equalsIgnoreCase(columnTitle)) continue;
                return column;
            }
            return -1;
        }

        private int getPreferredIconSize() {
            return 16;
        }
    }

    public class TabularViewModel
    extends AbstractTableModel {
        String[] expNames;
        String[] impNames;
        String[] names;
        boolean importing;

        TabularViewModel(boolean importing) {
            this.expNames = new String[]{CompareDBDiagramsDialog.this.SELECTED, CompareDBDiagramsDialog.this.LOCAL_DIAGRAM, CompareDBDiagramsDialog.this.DESCRIPTION, CompareDBDiagramsDialog.this.DIAGRAM_TYPE, CompareDBDiagramsDialog.this.REMOTE_DIAGRAM, CompareDBDiagramsDialog.this.DESCRIPTION};
            this.impNames = new String[]{CompareDBDiagramsDialog.this.SELECTED, CompareDBDiagramsDialog.this.REMOTE_DIAGRAM, CompareDBDiagramsDialog.this.DESCRIPTION, CompareDBDiagramsDialog.this.DIAGRAM_TYPE, CompareDBDiagramsDialog.this.DESIGN, CompareDBDiagramsDialog.this.MODEL, CompareDBDiagramsDialog.this.LOCAL_DIAGRAM, CompareDBDiagramsDialog.this.DESCRIPTION};
            this.names = this.expNames;
            this.importing = false;
            this.importing = importing;
            if (importing) {
                this.names = this.impNames;
            }
        }

        @Override
        public int getRowCount() {
            return CompareDBDiagramsDialog.this.listedObects.size();
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            if (columnIndex == 1) {
                return SelectionPair.class;
            }
            return String.class;
        }

        @Override
        public String getColumnName(int column) {
            return this.names[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row < CompareDBDiagramsDialog.this.listedObects.size()) {
                SelectionPair sp = CompareDBDiagramsDialog.this.listedObects.get(row);
                if (col == 0) {
                    return sp.selected;
                }
                if (this.importing) {
                    if (col == 6) {
                        if (sp.dpv != null) {
                            return sp.dpv.getName();
                        }
                        return EMPTY;
                    }
                    if (col == 7) {
                        if (sp.dpv != null) {
                            return DiagramToJSON.getDiagramComment(sp.dpv);
                        }
                        return EMPTY;
                    }
                    if (col == 3) {
                        if (sp.dpv != null) {
                            return CompareDBDiagramsDialog.getDiagramTypeName(sp.dpv);
                        }
                        if (sp.getType() != null) {
                            return CompareDBDiagramsDialog.getDiagramTypeName(sp.getType());
                        }
                        return EMPTY;
                    }
                    if (col == 1) {
                        return sp;
                    }
                    if (col == 2) {
                        if (sp.rdiagram != null) {
                            return sp.rdiagram.description == null ? "" : sp.rdiagram.description;
                        }
                        return EMPTY;
                    }
                    if (col == 4) {
                        return sp.getRemoteDesign();
                    }
                    if (col == 5) {
                        return sp.getRemoteModel();
                    }
                } else {
                    if (col == 1) {
                        return sp;
                    }
                    if (col == 2) {
                        if (sp.dpv != null) {
                            return DiagramToJSON.getDiagramComment(sp.dpv);
                        }
                        return EMPTY;
                    }
                    if (col == 3) {
                        if (sp.dpv != null) {
                            return CompareDBDiagramsDialog.getDiagramTypeName(sp.dpv);
                        }
                        if (sp.rdiagram != null && sp.rdiagram.diagramType != null) {
                            return CompareDBDiagramsDialog.getDiagramTypeName(sp.rdiagram.diagramType);
                        }
                        return EMPTY;
                    }
                    if (col == 4) {
                        if (sp.rdiagram != null) {
                            return sp.rdiagram.name;
                        }
                        return EMPTY;
                    }
                    if (col == 5) {
                        if (sp.rdiagram != null) {
                            return sp.rdiagram.description == null ? "" : sp.rdiagram.description;
                        }
                        return EMPTY;
                    }
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0 && aValue instanceof Boolean) {
                SelectionPair sp = CompareDBDiagramsDialog.this.listedObects.get(rowIndex);
                sp.selected = (Boolean)aValue;
            }
        }

        @Override
        public int getColumnCount() {
            return this.names.length;
        }
    }

    public static class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        public ComboBoxRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            Properties cd = (Properties)value;
            if (cd != null) {
                this.setText(ConnectionInfo.getConnectionName(cd));
                if (!isSelected) {
                    String sColor = cd.getProperty("Connection-Color-For-Editors");
                    if (sColor != null) {
                        Color color = null;
                        try {
                            color = new Color(Integer.parseInt(sColor));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (color != null) {
                            this.setForeground(color);
                        } else {
                            this.setForeground(UIManager.getColor("Label.foreground"));
                        }
                    } else {
                        this.setForeground(UIManager.getColor("Label.foreground"));
                    }
                }
            }
            return this;
        }
    }
}

