/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.util;

import java.awt.geom.Point2D;
import oracle.dbtools.crest.swingui.diagram.Messages;
import oracle.dbtools.crest.swingui.diagram.util.Spline;

public class Spline2D {
    private double[] t;
    private Spline splineX;
    private Spline splineY;
    private double length;

    public Spline2D(Point2D[] points) {
        double[] x = new double[points.length];
        double[] y = new double[points.length];
        for (int i = 0; i < points.length; ++i) {
            x[i] = points[i].getX();
            y[i] = points[i].getY();
        }
        this.init(x, y);
    }

    public Spline2D(double[] x, double[] y) {
        this.init(x, y);
    }

    private void init(double[] x, double[] y) {
        int i;
        if (x.length != y.length) {
            throw new IllegalArgumentException(Messages.getString("Spline2D.ArraysMustHaveTheSameLength"));
        }
        this.t = new double[x.length];
        for (i = 0; i < this.t.length; ++i) {
            if (i == 0) {
                this.t[0] = 0.0;
                continue;
            }
            double lx = x[i] - x[i - 1];
            double ly = y[i] - y[i - 1];
            this.t[i] = Math.sqrt(lx * lx + ly * ly);
            this.length += this.t[i];
            int n = i;
            this.t[n] = this.t[n] + this.t[i - 1];
        }
        for (i = 0; i < this.t.length; ++i) {
            this.t[i] = this.t[i] / this.length;
        }
        this.splineX = new Spline(this.t, x);
        this.splineY = new Spline(this.t, y);
    }

    public double[] getPoint(double t) {
        double[] result = new double[]{this.splineX.getValue(t), this.splineY.getValue(t)};
        return result;
    }

    public double getDx(double t) {
        return this.splineX.getDx(t);
    }

    public double getDy(double t) {
        return this.splineY.getDx(t);
    }

    public double getLength() {
        return this.length;
    }
}

