/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.multidimensional;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.diagram.Messages;
import oracle.dbtools.crest.swingui.diagram.multidimensional.MDDiagramCell;
import oracle.dbtools.crest.swingui.multidimensional.TVLevel;

public class LevelDiagramCell
extends MDDiagramCell {
    private JPopupMenu menu;
    private JMenuItem miPaste;

    public LevelDiagramCell(AbstractMDObject mdObject) {
        super(mdObject);
    }

    public LevelDiagramCell(AbstractMDObject mdObject, Map attributeMap) {
        super(mdObject, attributeMap);
    }

    private void showProperty() {
        this.getMDObject().showPropertyDialog();
    }

    @Override
    public void doubleClick() {
        this.showProperty();
    }

    @Override
    public void showPopupMenu(Point pt) {
        JPopupMenu menu = this.getPopupMenu();
        menu.show(this.getDiagram(), pt.x, pt.y);
    }

    public JPopupMenu getPopupMenu() {
        if (this.menu == null) {
            this.menu = new JPopupMenu();
            if (this.isEditable()) {
                this.menu.add(new AbstractAction(COPY){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LevelDiagramCell.this.getDiagram().getAppView().clearCopiedObjects();
                        LevelDiagramCell.this.getTopView().getDesignPartView().addSelectedToCopied();
                    }
                });
                this.miPaste = this.menu.add(new AbstractAction(PASTE){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LevelDiagramCell.access$002(LevelDiagramCell.this, LevelDiagramCell.this.getTopView().getDesignPartView().getSelectedObjects());
                        for (int i = 0; i < LevelDiagramCell.this.selectedObjects.length; ++i) {
                            ((ContainerObject)LevelDiagramCell.this.selectedObjects[i]).paste();
                        }
                    }
                });
                this.menu.add(new AbstractAction(DELETE){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LevelDiagramCell.this.deleteLevel();
                    }
                });
                this.menu.addSeparator();
                this.menu.add(new AbstractAction(FORMAT){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LevelDiagramCell.this.format();
                    }
                });
                this.menu.addSeparator();
                this.menu.add(new AbstractAction(SEND_TO_BACK){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LevelDiagramCell.this.getTopView().sendToBack();
                    }
                });
                this.menu.addSeparator();
            }
            this.menu.add(new AbstractAction(PROPERTIES){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LevelDiagramCell.this.showProperty();
                }
            });
        }
        return this.menu;
    }

    public void deleteLevel() {
        ApplicationView.log(MessageFormat.format(Messages.getString("LevelDiagramCell.DeleteLevel"), this.getMDObject().getName()));
        TVLevel tv = (TVLevel)this.getTopView();
        tv.remove(true);
    }

    @Override
    public void deleteSelected() {
        this.deleteLevel();
    }

    static /* synthetic */ Object[] access$002(LevelDiagramCell x0, Object[] x1) {
        x0.selectedObjects = x1;
        return x1;
    }
}

