/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.multidimensional;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.diagram.Messages;
import oracle.dbtools.crest.swingui.diagram.multidimensional.MDDiagramCell;
import oracle.dbtools.crest.swingui.multidimensional.TVDimension;

public class DimensionDiagramCell
extends MDDiagramCell {
    private JPopupMenu menu;
    private JMenuItem miPaste;

    public DimensionDiagramCell(AbstractMDObject mdObject) {
        super(mdObject);
    }

    public DimensionDiagramCell(AbstractMDObject mdObject, Map attributeMap) {
        super(mdObject, attributeMap);
    }

    private void showProperty() {
        this.getMDObject().showPropertyDialog();
    }

    @Override
    public void doubleClick() {
        this.showProperty();
    }

    @Override
    public void showPopupMenu(Point pt) {
        JPopupMenu menu = this.getPopupMenu();
        menu.show(this.getDiagram(), pt.x, pt.y);
    }

    public JPopupMenu getPopupMenu() {
        if (this.menu == null) {
            this.menu = new JPopupMenu();
            if (this.isEditable()) {
                this.menu.add(new AbstractAction(COPY){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DimensionDiagramCell.this.getDiagram().getAppView().clearCopiedObjects();
                        DimensionDiagramCell.this.getTopView().getDesignPartView().addSelectedToCopied();
                    }
                });
                this.miPaste = this.menu.add(new AbstractAction(PASTE){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DimensionDiagramCell.access$002(DimensionDiagramCell.this, DimensionDiagramCell.this.getTopView().getDesignPartView().getSelectedObjects());
                        for (int i = 0; i < DimensionDiagramCell.this.selectedObjects.length; ++i) {
                            ((ContainerObject)DimensionDiagramCell.this.selectedObjects[i]).paste();
                        }
                    }
                });
                this.menu.add(new AbstractAction(DELETE){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DimensionDiagramCell.this.deleteDimension();
                    }
                });
                this.menu.addSeparator();
                this.menu.add(new AbstractAction(FORMAT){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DimensionDiagramCell.this.format();
                    }
                });
                this.menu.addSeparator();
                this.menu.add(new AbstractAction(SEND_TO_BACK){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DimensionDiagramCell.this.getTopView().sendToBack();
                    }
                });
                this.menu.addSeparator();
            }
            this.menu.add(new AbstractAction(PROPERTIES){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DimensionDiagramCell.this.showProperty();
                }
            });
        }
        return this.menu;
    }

    public void deleteDimension() {
        Diagram d = this.getDiagram();
        ApplicationView view = d.getAppView();
        ApplicationView.log(MessageFormat.format(Messages.getString("DimensionDiagramCell.DeleteDimension"), this.getMDObject().getName()));
        TVDimension tv = (TVDimension)this.getTopView();
        tv.remove(true);
    }

    @Override
    public void deleteSelected() {
        this.deleteDimension();
    }

    static /* synthetic */ Object[] access$002(DimensionDiagramCell x0, Object[] x1) {
        x0.selectedObjects = x1;
        return x1;
    }
}

