/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.logical;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.List;
import oracle.dbtools.crest.model.ClassificationType;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.ContainerRenderer;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;

public class EntityRenderer
extends ContainerRenderer {
    public static final Color DEFAULT_FOREGROUND = Color.BLACK;
    public static final Color DEFAULT_BACKGROUND = new Color(164, 225, 255);
    public static final Color DEFAULT_DATATYPE_COLOR = new Color(0, 0, 128);
    public static final Color DEFAULT_ALLOW_NULL_COLOR = Color.RED;

    public EntityRenderer() {
        this.defaultForeground = DEFAULT_FOREGROUND;
        this.defaultBackground = DEFAULT_BACKGROUND;
        this.datatypeColor = DEFAULT_DATATYPE_COLOR;
        this.allowNullColor = DEFAULT_ALLOW_NULL_COLOR;
    }

    private ClassificationType getClassificationType() {
        Entity entity = (Entity)this.container;
        return entity.getDesign().getDesignLevelSettings().getClassificationTypeByID(entity.getTypeID());
    }

    @Override
    protected Color getBackgroundColor() {
        if (this.container instanceof Entity) {
            if (this.getTopView().useDefaultColor() || this.getTopView().getBackgroundColor() == null) {
                ClassificationType cf = this.getClassificationType();
                if (cf != null) {
                    return cf.getTypeColor();
                }
                DefaultFontAndColor dfc = this.container.getDesign().getDesignLevelSettings().getDefaultFCObject("Entity");
                if (dfc != null) {
                    return dfc.getBackgroundColor();
                }
            } else {
                return this.getTopView().getBackgroundColor();
            }
        }
        return this.defaultBackground;
    }

    @Override
    public Color getForegroundColor() {
        if (this.getTopView().useDefaultColor() || this.getTopView().getForegroundColor() == null) {
            ClassificationType cf = this.getClassificationType();
            if (cf != null) {
                return cf.getForegroundColor();
            }
            DefaultFontAndColor dfc = this.container.getDesign().getDesignLevelSettings().getDefaultFCObject("Entity");
            if (dfc != null) {
                return dfc.getForegroundColor();
            }
            return this.getForeground();
        }
        return this.getTopView().getForegroundColor();
    }

    @Override
    protected Color getTitleColor() {
        if (this.getTopView() != null) {
            ClassificationType cf;
            if (this.getTopView().useDefaultColor() && (cf = this.getClassificationType()) != null) {
                return cf.getDefaultFCObject().getFontObject(EditableFonts.FO_TITLE).getColor();
            }
            return this.getTopView().getFontObject(EditableFonts.FO_TITLE).getColor();
        }
        return super.getTitleColor();
    }

    @Override
    protected Font getTitleFont() {
        if (this.getTopView() != null) {
            ClassificationType cf;
            if (this.getTopView().useDefaultColor() && (cf = this.getClassificationType()) != null) {
                return cf.getDefaultFCObject().getFontObject(EditableFonts.FO_TITLE).getFont();
            }
            return this.getTopView().getFontObject(EditableFonts.FO_TITLE).getFont();
        }
        return super.getTitleFont();
    }

    @Override
    protected Color getElementsColor() {
        if (this.getTopView() != null) {
            ClassificationType cf;
            if (this.getTopView().useDefaultColor() && (cf = this.getClassificationType()) != null) {
                return cf.getDefaultFCObject().getFontObject(EditableFonts.FO_ELEMENT).getColor();
            }
            return this.getTopView().getFontObject(EditableFonts.FO_ATTRIBUTE).getColor();
        }
        return super.getElementsColor();
    }

    @Override
    protected Font getElementsFont() {
        if (this.getTopView() != null) {
            ClassificationType cf;
            if (this.getTopView().useDefaultColor() && (cf = this.getClassificationType()) != null) {
                return cf.getDefaultFCObject().getFontObject(EditableFonts.FO_ELEMENT).getFont();
            }
            return this.getTopView().getFontObject(EditableFonts.FO_ATTRIBUTE).getFont();
        }
        return super.getElementsFont();
    }

    @Override
    protected Color getDatatypeColor() {
        if (this.getTopView() != null) {
            ClassificationType cf;
            if (this.getTopView().useDefaultColor() && (cf = this.getClassificationType()) != null) {
                return cf.getDefaultFCObject().getFontObject(EditableFonts.FO_DATATYPE).getColor();
            }
            return this.getTopView().getFontObject(EditableFonts.FO_DATATYPE).getColor();
        }
        return super.getDatatypeColor();
    }

    @Override
    protected Color getPKColor() {
        if (this.getTopView() != null) {
            ClassificationType cf;
            if (this.getTopView().useDefaultColor() && (cf = this.getClassificationType()) != null) {
                return cf.getDefaultFCObject().getFontObject(EditableFonts.FO_PK).getColor();
            }
            return this.getTopView().getFontObject(EditableFonts.FO_PK).getColor();
        }
        return super.getPKColor();
    }

    @Override
    protected Color getUKColor() {
        if (this.getTopView() != null) {
            ClassificationType cf;
            if (this.getTopView().useDefaultColor() && (cf = this.getClassificationType()) != null) {
                return cf.getDefaultFCObject().getFontObject(EditableFonts.FO_UK).getColor();
            }
            return this.getTopView().getFontObject(EditableFonts.FO_UK).getColor();
        }
        return super.getUKColor();
    }

    @Override
    protected Color getFKColor() {
        if (this.getTopView() != null) {
            ClassificationType cf;
            if (this.getTopView().useDefaultColor() && (cf = this.getClassificationType()) != null) {
                return cf.getDefaultFCObject().getFontObject(EditableFonts.FO_FK).getColor();
            }
            return this.getTopView().getFontObject(EditableFonts.FO_FK).getColor();
        }
        return super.getFKColor();
    }

    @Override
    protected Color getNotNullColor() {
        if (this.getTopView() != null) {
            ClassificationType cf;
            if (this.getTopView().useDefaultColor() && (cf = this.getClassificationType()) != null) {
                return cf.getDefaultFCObject().getFontObject(EditableFonts.FO_NOT_NULL).getColor();
            }
            return this.getTopView().getFontObject(EditableFonts.FO_NOT_NULL).getColor();
        }
        return super.getNotNullColor();
    }

    @Override
    protected Font getKeysFont() {
        if (this.getTopView() != null) {
            ClassificationType cf;
            if (this.getTopView().useDefaultColor() && (cf = this.getClassificationType()) != null) {
                return cf.getDefaultFCObject().getFontObject(EditableFonts.FO_KEY).getFont();
            }
            return this.getTopView().getFontObject(EditableFonts.FO_KEY).getFont();
        }
        return super.getKeysFont();
    }

    @Override
    protected Color getKeyColor() {
        if (this.getTopView() != null) {
            ClassificationType cf;
            if (this.getTopView().useDefaultColor() && (cf = this.getClassificationType()) != null) {
                return cf.getDefaultFCObject().getFontObject(EditableFonts.FO_KEY).getColor();
            }
            return this.getTopView().getFontObject(EditableFonts.FO_KEY).getColor();
        }
        return super.getKeyColor();
    }

    @Override
    protected Font getCommentsFont() {
        if (this.getTopView() != null) {
            ClassificationType cf;
            if (this.getTopView().useDefaultColor() && (cf = this.getClassificationType()) != null) {
                return cf.getDefaultFCObject().getFontObject(EditableFonts.FO_COMMENTS).getFont();
            }
            return this.getTopView().getFontObject(EditableFonts.FO_COMMENTS).getFont();
        }
        return super.getCommentsFont();
    }

    @Override
    protected Color getCommentsColor() {
        if (this.getTopView() != null) {
            ClassificationType cf;
            if (this.getTopView().useDefaultColor() && (cf = this.getClassificationType()) != null) {
                return cf.getDefaultFCObject().getFontObject(EditableFonts.FO_COMMENTS).getColor();
            }
            return this.getTopView().getFontObject(EditableFonts.FO_COMMENTS).getColor();
        }
        return super.getKeyColor();
    }

    @Override
    protected String getType() {
        String typeName;
        if (this.container instanceof Entity && (typeName = ((Entity)this.container).getDesign().getDesignLevelSettings().getClassificationTypeNameByID(((Entity)this.container).getTypeID())) != null && typeName.length() > 0) {
            return typeName.substring(0, 1);
        }
        return null;
    }

    private void paintUsingBarkerNotation(Graphics g) {
        DesignPartView dpv;
        String contType;
        Graphics2D g2 = (Graphics2D)g;
        Dimension dim = this.getSize();
        int width = dim.width;
        int height = dim.height;
        TopView efo = this.getTopView();
        g2.setPaint(this.getBackgroundColor());
        g.fillRoundRect(0, 0, width - 1, height - 1, 20, 20);
        g.setColor(this.getBorderColor());
        g.drawRoundRect(0, 0, width - 1, height - 1, 20, 20);
        if (this.container.isRemoteObject()) {
            REMOTE_TABLE_ICON.paintIcon(this, g2, 2, 2);
        }
        String entityName = this.title;
        Font titleFont = this.getTitleFont();
        g.setFont(titleFont);
        FontMetrics fm = g.getFontMetrics();
        int colTextHeight = fm.getMaxAscent() - fm.getMaxDescent() + 3;
        int yCursor = Math.max(colTextHeight, titleFont.getSize());
        int xCursor = (width - fm.stringWidth(this.title)) / 2;
        if (xCursor < 20) {
            xCursor = 20;
        }
        BasicStroke lineStroke = new BasicStroke(this.borderWidth);
        BasicStroke textStroke = new BasicStroke(1.0f);
        g2.setStroke(textStroke);
        g.setColor(this.getBorderColor());
        g.setColor(this.getTitleColor());
        String[] wrappedTitle = EntityRenderer.wrapText(entityName, EntityRenderer.getMaxChars(entityName, fm, width - 20 - 5));
        for (int t = 0; t < wrappedTitle.length; ++t) {
            String text = wrappedTitle[t];
            g.drawString(text, xCursor, yCursor);
            if (this.container.isDeprecated()) {
                this.strikeThrough(g2, text, xCursor, yCursor);
            }
            yCursor += colTextHeight;
        }
        yCursor -= colTextHeight;
        if (efo.getHiddenElements().size() > 0) {
            g.setColor(this.getBorderColor());
            int right = width - 4;
            int left = right - 8;
            int center = right - 4;
            int[] xPts = new int[]{center, left, right};
            int[] yPts = new int[]{2, 10, 10};
            g.fillPolygon(xPts, yPts, 3);
        }
        if ((contType = this.getType()) != null && contType.length() > 0) {
            g.drawString(contType, 5, yCursor);
        }
        if ((dpv = this.getDesignPartView()) != null && !dpv.clearDetails()) {
            if (!dpv.isShowNamesOnly() && !dpv.showKeys()) {
                String longestName;
                DesignObject[] elements;
                yCursor += 3 + this.borderWidth;
                if (dpv.isShowClassificationTypes() && this.container instanceof ContainerWithKeyObject) {
                    ContainerWithKeyObject cwk = (ContainerWithKeyObject)this.container;
                    String clname = "";
                    ClassificationType ct = cwk.getClassificationType();
                    if (ct != null) {
                        clname = ct.getTypeName();
                    }
                    Object clnames = "";
                    List<String> list = cwk.getAdd_ClassificationTypeNames();
                    for (int k = 0; k < list.size(); ++k) {
                        clnames = k > 0 ? (String)clnames + ", " + list.get(k) : list.get(0);
                    }
                    if (!"".equals(clname) || !"".equals(clnames)) {
                        g2.setStroke(lineStroke);
                        g.setColor(this.getBorderColor());
                        g.drawLine(0, yCursor, width - 2, yCursor);
                        Object types = !"".equals(clname) ? clname + " / " : "- / ";
                        types = !"".equals(clnames) ? (String)types + (String)clnames : (String)types + "-";
                        xCursor = (width - fm.stringWidth((String)types)) / 2;
                        if (xCursor < 20) {
                            xCursor = 20;
                        }
                        g.setFont(titleFont);
                        g.drawString((String)types, xCursor, yCursor += colTextHeight);
                        g2.setStroke(lineStroke);
                        g.setColor(this.getBorderColor());
                        g.drawLine(0, yCursor += 3 + this.borderWidth, width - 2, yCursor);
                    }
                }
                if (this.container.isBST() && this.container.getTypeSubstitution() != null) {
                    StructuredType st = this.container.getBasedOnStructuredType();
                    if (st != null) {
                        elements = st.getElements();
                        longestName = this.getLongestTypeName((TypeElement[])elements);
                        g.setFont(this.getElementsFont());
                        fm = g.getFontMetrics();
                        colTextHeight = fm.getMaxAscent() - fm.getMaxDescent() + 3;
                        for (int i = 0; i < elements.length; ++i) {
                            DesignObject elm = elements[i];
                            g.setColor(this.getElementsColor());
                            g.setFont(this.getElementsFont());
                            g.drawString(elm.getName(), 25, yCursor += 3 + fm.getMaxAscent());
                            fm = g.getFontMetrics();
                            int anLeft = fm.stringWidth(longestName) + 50;
                            g.setColor(this.getDatatypeColor());
                            g.setFont(this.getElementsFont());
                            g.drawString(((TypeElement)elm).getDataType(), anLeft, yCursor);
                            g.setColor(this.getForeground());
                        }
                    }
                } else {
                    Font elmFont = this.getElementsFont();
                    g.setFont(elmFont);
                    g2.setStroke(textStroke);
                    elements = this.container.getElements();
                    longestName = EntityRenderer.getLongestName((ContainedObject[])elements, dpv.isExpandComplexTypes());
                    fm = g.getFontMetrics();
                    colTextHeight = fm.getMaxAscent() - fm.getMaxDescent() + 3;
                    int nameSize = this.getMaxSize(longestName, elmFont, g2);
                    int namePos = this.getMaxSize("#O", elmFont, g2);
                    int cPos = 20 + nameSize + namePos;
                    for (int i = 0; i < elements.length; ++i) {
                        ContainedObjectWithDomain element = (ContainedObjectWithDomain)elements[i];
                        if (efo.getHiddenElements().contains(element) || element.isFKElement()) continue;
                        yCursor += 3 + fm.getMaxAscent();
                        String type = " ";
                        if (element.isPKElement()) {
                            type = "#";
                            g.setColor(this.getPKColor());
                            g.setFont(this.getElementsFont());
                        } else if (element.isUnique()) {
                            type = "U";
                            g.setColor(this.getUKColor());
                            g.setFont(this.getElementsFont());
                        }
                        g.drawString(type, 5, yCursor);
                        fm = g.getFontMetrics();
                        int anLeft = fm.stringWidth("AU");
                        g.setColor(this.getNotNullColor());
                        g.setFont(this.getElementsFont());
                        if (!element.getNullsAllowed()) {
                            g.setColor(this.getNotNullColor());
                            g.drawString("*", anLeft, yCursor);
                        } else {
                            g.drawString("o", anLeft, yCursor);
                        }
                        fm = g.getFontMetrics();
                        g.setFont(elmFont);
                        g.setColor(this.getElementsColor());
                        g.drawString(element.getName(), anLeft += fm.stringWidth("*") + 3, yCursor);
                        if (element.isDeprecated()) {
                            this.strikeThrough(g2, element.getName(), anLeft, yCursor);
                        }
                        if (dpv.showComments()) {
                            g.setColor(this.getCommentsColor());
                            g.setFont(this.getCommentsFont());
                            anLeft = cPos;
                            g.drawString(element.getCommentInRDBMS(), anLeft, yCursor);
                        }
                        if (yCursor <= height) continue;
                        g.setColor(this.getBorderColor());
                        int right = width - 4;
                        int left = right - 8;
                        int center = right - 4;
                        int bottom = height - 4;
                        int top = bottom - 8;
                        int[] xPts = new int[]{center, left, right};
                        int[] yPts = new int[]{bottom, top, top};
                        g.fillPolygon(xPts, yPts, 3);
                        break;
                    }
                }
            }
            String comments = this.container.getCommentInRDBMS().trim();
            if (dpv.showComments() && !"".equalsIgnoreCase(comments)) {
                g.setColor(this.getBorderColor());
                g2.setStroke(lineStroke);
                g.drawLine(0, yCursor += 6, width - 2, yCursor);
                g.setColor(this.getCommentsColor());
                g.setFont(this.getCommentsFont());
                fm = g.getFontMetrics();
                yCursor += fm.getHeight();
                String[] wrappedComments = EntityRenderer.wrapText(comments, EntityRenderer.getMaxChars(comments, fm, width - fm.stringWidth("WWW")));
                for (int t = 0; t < wrappedComments.length; ++t) {
                    String text = wrappedComments[t];
                    g.drawString(text, 5, yCursor);
                    yCursor += fm.getHeight();
                }
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        int not = this.container.getDesign().getAppView().getSettings().getNotation();
        if (this.getDesignPartView() != null) {
            not = this.getDesignPartView().getNotation();
        }
        switch (not) {
            case 0: {
                super.paint(g);
                break;
            }
            case 1: {
                this.paintUsingBarkerNotation(g);
                break;
            }
            default: {
                super.paint(g);
            }
        }
    }
}

