/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.graph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramModel;

public class ParentMap
implements Serializable {
    protected ArrayList entries = new ArrayList();
    protected Set changedNodes = new HashSet();
    protected Map childCount = new Hashtable();

    public static ParentMap create(DiagramModel m, Object[] c, boolean remove, boolean strict) {
        HashSet<Object> cellSet = new HashSet<Object>();
        for (int i = 0; i < c.length; ++i) {
            cellSet.add(c[i]);
        }
        ParentMap parentMap = new ParentMap();
        for (int i = c.length - 1; i >= 0; --i) {
            Object parent = m.getParent(c[i]);
            if (parent != null && (!strict || !remove && cellSet.contains(parent))) {
                parentMap.addEntry(c[i], remove ? null : parent);
            }
            if (!remove) continue;
            while (cellSet.contains(parent)) {
                parent = m.getParent(parent);
            }
            for (int j = 0; j < m.getChildCount(c[i]); ++j) {
                Object child = m.getChild(c[i], j);
                if (cellSet.contains(child)) continue;
                parentMap.addEntry(child, parent);
            }
        }
        return parentMap;
    }

    public void addEntry(Object child, Object parent) {
        if (child != null) {
            this.entries.add(new Entry(child, parent));
            this.changedNodes.add(child);
            if (parent != null) {
                this.changedNodes.add(parent);
            }
        }
    }

    public int size() {
        return this.entries.size();
    }

    public Iterator entries() {
        return this.entries.iterator();
    }

    public Set getChangedNodes() {
        return this.changedNodes;
    }

    public ParentMap clone(Map map) {
        ParentMap pm = new ParentMap();
        Iterator it = this.entries();
        while (it.hasNext()) {
            Entry e = (Entry)it.next();
            Object child = map.get(e.getChild());
            Object parent = map.get(e.getParent());
            if (child == null) {
                child = e.getChild();
            }
            if (parent == null) {
                parent = e.getParent();
            }
            if (child == null || parent == null) continue;
            pm.addEntry(child, parent);
        }
        return pm;
    }

    public String toString() {
        String s = super.toString() + "\n";
        Iterator it = this.entries();
        while (it.hasNext()) {
            Entry entry = (Entry)it.next();
            s = s + " child=" + entry.getChild() + " parent=" + entry.getParent() + "\n";
        }
        return s;
    }

    public class Entry
    implements Serializable {
        protected Object child;
        protected Object parent;

        public Entry(Object child, Object parent) {
            this.child = child;
            this.parent = parent;
        }

        public Object getChild() {
            return this.child;
        }

        public Object getParent() {
            return this.parent;
        }
    }
}

