/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.graph;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import oracle.dbtools.crest.swingui.diagram.AbstractDiagram;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.PortView;

public class BasicMarqueeHandler {
    protected Point start;
    protected Point current;
    protected Rectangle bounds;
    protected PortView port;
    protected PortView firstPort;
    protected PortView lastPort;
    protected transient Cursor previousCursor = null;
    protected Rectangle2D marqueeBounds;
    protected Point2D startPoint;
    protected Point2D currentPoint;

    public boolean isForceMarqueeEvent(MouseEvent event) {
        return event.isAltDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseReleased(MouseEvent e) {
        try {
            if (e != null && this.marqueeBounds != null) {
                if (!(e.getSource() instanceof AbstractDiagram)) {
                    throw new IllegalArgumentException("MarqueeHandler cannot handle event from unknown source: " + e);
                }
                AbstractDiagram diagram = (AbstractDiagram)e.getSource();
                Rectangle2D bounds = diagram.fromScreen(DiagramConstants.createRect(this.marqueeBounds));
                CellView[] views = diagram.getDiagramLayoutCache().getRoots(bounds);
                ArrayList<Object> list = new ArrayList<Object>();
                for (int i = 0; i < views.length; ++i) {
                    if (!bounds.contains(views[i].getBounds())) continue;
                    list.add(views[i].getCell());
                }
                Object[] cells = list.toArray();
                diagram.getUI().selectCellsForEvent(diagram, cells, e);
                diagram.setCursor(this.previousCursor);
                Rectangle dirty = new Rectangle((int)this.marqueeBounds.getX(), (int)this.marqueeBounds.getY(), (int)this.marqueeBounds.getWidth() + 1, (int)this.marqueeBounds.getHeight() + 1);
                ++dirty.width;
                ++dirty.height;
                diagram.repaint(dirty);
                if (diagram instanceof Diagram) {
                    ((Diagram)diagram).getAppView().getCurrentDPV().fireSelectionChanged();
                }
            }
        }
        finally {
            this.currentPoint = null;
            this.startPoint = null;
            this.marqueeBounds = null;
            this.previousCursor = null;
        }
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
    }

    private boolean drawLine(Diagram d) {
        return d.getDrawnObjectID() == 1 || d.getDrawnObjectID() == 3 || d.getDrawnObjectID() == 18 || d.getDrawnObjectID() == 26;
    }

    public void mouseDragged(MouseEvent e) {
        if (this.startPoint != null && !this.drawLine((Diagram)e.getSource())) {
            if (!(e.getSource() instanceof AbstractDiagram)) {
                throw new IllegalArgumentException("MarqueeHandler cannot handle event from unknown source: " + e);
            }
            AbstractDiagram diagram = (AbstractDiagram)e.getSource();
            Graphics g = diagram.getGraphics();
            Color bg = diagram.getBackground();
            Color fg = diagram.getMarqueeColor();
            g.setColor(fg);
            g.setXORMode(bg);
            this.overlay(g);
            this.currentPoint = e.getPoint();
            this.marqueeBounds = DiagramConstants.createRect(this.startPoint);
            this.marqueeBounds.add(this.currentPoint);
            g.setColor(bg);
            g.setXORMode(fg);
            this.overlay(g);
        }
    }

    public void paint(Graphics g) {
        this.overlay(g);
    }

    public void overlay(Graphics g) {
        if (this.marqueeBounds != null) {
            g.drawRect((int)this.marqueeBounds.getX(), (int)this.marqueeBounds.getY(), (int)this.marqueeBounds.getWidth(), (int)this.marqueeBounds.getHeight());
        }
    }

    public void mousePressed(MouseEvent e) {
        if (!(e.getSource() instanceof AbstractDiagram)) {
            throw new IllegalArgumentException("MarqueeHandler cannot handle event from unknown source: " + e);
        }
        AbstractDiagram diagram = (AbstractDiagram)e.getSource();
        this.startPoint = e.getPoint();
        this.marqueeBounds = DiagramConstants.createRect(this.startPoint);
        this.previousCursor = diagram.getCursor();
    }

    public void mouseMoved(MouseEvent e) {
    }

    public Point2D getCurrentPoint() {
        return this.currentPoint;
    }

    public Rectangle2D getMarqueeBounds() {
        return this.marqueeBounds;
    }

    public Cursor getPreviousCursor() {
        return this.previousCursor;
    }

    public Point2D getStartPoint() {
        return this.startPoint;
    }

    public void setCurrentPoint(Point2D currentPoint) {
        this.currentPoint = currentPoint;
    }

    public void setMarqueeBounds(Rectangle2D marqueeBounds) {
        this.marqueeBounds = marqueeBounds;
    }

    public void setPreviousCursor(Cursor previousCursor) {
        this.previousCursor = previousCursor;
    }

    public void setStartPoint(Point2D startPoint) {
        this.startPoint = startPoint;
    }
}

